/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.gift;

import com.tcbj.crm.aplfine.AplfineCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Gift;
import com.tcbj.crm.entity.GiftBalance;
import com.tcbj.crm.entity.GiftHis;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.RebateArea;
import com.tcbj.crm.gift.GiftCondition;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="giftService")
public class GiftService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    PactMainService pactMainService;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderApplyService orderApplyService;

    public Gift get(String id) {
        return (Gift)this.baseDao.get(Gift.class, (Serializable)((Object)id));
    }

    public void save(Gift obj) {
        this.baseDao.save((Object)obj);
    }

    public Product getById(String id) {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)id));
    }

    public Product getByNo(String no) throws Exception {
        String hql = "from Product p where p.no = ?";
        List pds = this.baseDao.findEntity(hql, new Object[]{no}, Product.class);
        return pds.size() == 0 ? null : (Product)pds.get(0);
    }

    public Product getPD(String id) throws Exception {
        return (Product)this.baseDao.get(Product.class, (Serializable)((Object)id));
    }

    public List<Product> getPDS() throws Exception {
        String hql = "from Product ";
        return this.baseDao.findEntity(hql, Product.class);
    }

    List<Product> getZP() throws Exception {
        String hql = "from Product ";
        return this.baseDao.findEntity(hql, new Object[0], Product.class);
    }

    public boolean isGift(String orgId, String giftId) {
        boolean isexist = false;
        String hql = "from Gift f where f.organizationId = ? and f.giftId = ?";
        List gts = this.baseDao.findEntity(hql, new Object[]{orgId, giftId}, Gift.class);
        if (gts.size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    public Page getList(int pageno, GiftCondition condition) {
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Gift o,Customer e where ( e.areaCode in (" + regionids + ") or e.bigAreaCode in (" + regionids + ") ) and o.clientId=e.applyerId and e.supplierId='" + condition.getEm().getCurrentPartner().getId() + "' ");
        ArrayList<Object> args = new ArrayList<Object>();
        if (StringUtils.isNotEmpty(condition.getClientId())) {
            HQL.append(" and o.clientId= ? ");
            args.add(condition.getClientId());
        }
        if (StringUtils.isNotEmpty(condition.getActivity())) {
            HQL.append(" and o.activity like ? ");
            args.add("%" + condition.getActivity() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getGiftId())) {
            HQL.append(" and o.giftId = ? ");
            args.add(condition.getGiftId());
        }
        if (StringUtils.isNotEmpty(condition.getOrgId())) {
            HQL.append(" and o.organizationId = ? ");
            args.add(condition.getOrgId());
        }
        if (StringUtils.isNotEmpty(condition.getGiftSource())) {
            HQL.append(" and o.giftSource = ? ");
            args.add(condition.getGiftSource());
        }
        if (StringUtils.isNotEmpty(condition.getInspectProduct())) {
            HQL.append(" and o.inspectProduct = ? ");
            args.add(condition.getInspectProduct());
        }
        if (StringUtils.isNotEmpty(condition.getInspectType())) {
            HQL.append(" and o.inspectType = ? ");
            args.add(condition.getInspectType());
        }
        if (StringUtils.isNotEmpty(condition.getTestMode())) {
            HQL.append(" and o.testMode = ? ");
            args.add(condition.getTestMode());
        }
        if (condition.getStartDate() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStartDate());
        }
        if (condition.getEndDateHQL() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(condition.getEndDateHQL());
        }
        HQL.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), pageno);
        ArrayList<Gift> list = new ArrayList<Gift>();
        for (Object[] obj : page.getList()) {
            Gift gift = (Gift)obj[0];
            list.add(gift);
        }
        page.setList(list);
        return page;
    }

    public void update(Gift obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Gift.class, (Serializable)((Object)id));
    }

    public void update(List<Gift> gifts, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    this.baseDao.executeHQL("delete Gift where id= ?", args);
                }
                ++n2;
            }
            for (Gift gift : gifts) {
                gift.fillInitData(me);
                gift.setOrganizationId(me.getCurrentPartner().getId());
                if (StringUtils.isEmpty(gift.getId())) {
                    this.baseDao.save((Object)gift);
                    continue;
                }
                this.baseDao.update((Object)gift);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateRebateArea(List<RebateArea> gifts, String delIds, Employee me) {
        try {
            String[] ids;
            String[] stringArray = ids = delIds.split(",");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty(id)) {
                    Object[] args = new Object[]{id};
                    this.baseDao.executeHQL("delete RebateArea where id= ?", args);
                }
                ++n2;
            }
            for (RebateArea gift : gifts) {
                gift.fillInitData(me);
                gift.setPartnerId(me.getCurrentPartner().getId());
                if (StringUtils.isEmpty(gift.getId())) {
                    this.baseDao.save((Object)gift);
                    continue;
                }
                this.baseDao.update((Object)gift);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Page getgiftremainder(GiftCondition con, int pageno) {
        String regionids = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        args.add(con.getEm().getCurrentPartner().getId());
        hql.append("from GiftBalance a,Customer b where( b.areaCode in (" + regionids + ") or b.bigAreaCode in (" + regionids + ") ) and a.applyerId=b.applyerId and a.supplierId=? ");
        if (StringUtils.isNotEmpty(con.getClientId())) {
            hql.append(" and a.applyerId = ? ");
            args.add(con.getClientId());
        }
        if (StringUtils.isNotEmpty(con.getInspectType())) {
            hql.append(" and a.giftType = ? ");
            args.add(con.getInspectType());
        }
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public String saveGiftRemainder(GiftBalance giftBalance) {
        List list = this.baseDao.findEntity("from GiftBalance a where a.applyerId=? ", new Object[]{giftBalance.getApplyerId()});
        if (list.size() > 0) {
            return "repeat";
        }
        this.baseDao.save((Object)giftBalance);
        return "true";
    }

    public GiftBalance getGiftRemainder(String id) {
        return (GiftBalance)this.baseDao.get(GiftBalance.class, (Serializable)((Object)id));
    }

    public void updateGiftRemainder(GiftBalance giftBalance) {
        GiftBalance entity = (GiftBalance)this.baseDao.get(GiftBalance.class, (Serializable)((Object)giftBalance.getId()));
        entity.setGiftType(giftBalance.getGiftType());
        entity.setAllCount(giftBalance.getAllCount());
        this.baseDao.update((Object)entity);
    }

    public List<Object[]> getserialList(AplfineCondition condition) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("from GiftHis a,GiftBalance b where a.giftBalanceId=b.id and b.id=? order by a.useDate");
        return this.baseDao.findEntity(HQL.toString(), new Object[]{condition.getId()}, Object[].class);
    }

    private List<Gift> getGiftRuleList(String applyerId, String supplierId, Date orderDate) {
        List giftRuleList = this.baseDao.findEntity(" from Gift g where g.clientId = ? and g.organizationId = ? and g.startDate <= ? and nvl(g.endDate,?) >= ? ", new Object[]{applyerId, supplierId, orderDate, DateUtils.getEndTime(), orderDate}, Gift.class);
        return giftRuleList;
    }

    private List<GiftWarp> getGiftRuleList(String applyerId, String supplierId, Date orderDate, Map<String, List<OrderApplyItem>> list) {
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        ArrayList<GiftWarp> giftWarpList = new ArrayList<GiftWarp>();
        HashMap histroyQuantityMap = new HashMap();
        HashMap histroyAmountMap = new HashMap();
        HashMap<String, Gift> giftMap = new HashMap<String, Gift>();
        for (Gift gift : giftRuleList) {
            giftMap.put(gift.getId(), gift);
        }
        Set<String> giftIds = list.keySet();
        for (String giftId : giftIds) {
            List<OrderApplyItem> itemList = list.get(giftId);
            for (OrderApplyItem item : itemList) {
                Double historyAmount;
                Double historyQuantity;
                HashMap<String, Double> hqm = (HashMap<String, Double>)histroyQuantityMap.get(giftId);
                if (hqm == null) {
                    hqm = new HashMap<String, Double>();
                    histroyQuantityMap.put(giftId, hqm);
                }
                if ((historyQuantity = (Double)hqm.get(item.getProductId())) == null) {
                    historyQuantity = 0.0;
                    hqm.put(item.getProductId(), historyQuantity);
                }
                historyQuantity = MathUtils.add((Double)historyQuantity, (Double)(item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity()));
                hqm.put(item.getProductId(), historyQuantity);
                HashMap<String, Double> ham = (HashMap<String, Double>)histroyAmountMap.get(giftId);
                if (ham == null) {
                    ham = new HashMap<String, Double>();
                    histroyAmountMap.put(giftId, ham);
                }
                if ((historyAmount = (Double)ham.get(item.getProductId())) == null) {
                    historyAmount = 0.0;
                    ham.put(item.getProductId(), historyAmount);
                }
                double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
                double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
                historyAmount = MathUtils.add((Double)historyAmount, (Double)MathUtils.mul((Double)quantity, (Double)price));
                ham.put(item.getProductId(), historyAmount);
            }
        }
        for (Gift giftRule : giftRuleList) {
            Double giftQuantity;
            HashMap amountMap;
            HashMap quantityMap = (HashMap)histroyQuantityMap.get(giftRule.getId());
            if (quantityMap == null) {
                quantityMap = new HashMap();
                histroyQuantityMap.put(giftRule.getId(), quantityMap);
            }
            if ((amountMap = (HashMap)histroyAmountMap.get(giftRule.getId())) == null) {
                amountMap = new HashMap();
                histroyAmountMap.put(giftRule.getId(), amountMap);
            }
            giftQuantity = (giftQuantity = (Double)quantityMap.get(giftRule.getGiftId())) == null ? 0.0 : giftQuantity;
            Double checkNum = Double.parseDouble(giftRule.getCheckNm());
            Double giftNum = Double.parseDouble(giftRule.getGiftNm());
            Double productQuantity = null;
            productQuantity = "AMOUNT".equals(giftRule.getInspectType()) ? (Double)amountMap.get(giftRule.getInspectProduct()) : (Double)quantityMap.get(giftRule.getInspectProduct());
            productQuantity = productQuantity == null ? 0.0 : productQuantity;
            Double times = MathUtils.getInt((Double)(productQuantity / checkNum));
            Double allGiftNum = MathUtils.mul((Double)times, (Double)giftNum);
            Double available = MathUtils.sub((Double)allGiftNum, (Double)giftQuantity);
            GiftWarp giftWarp = new GiftWarp(giftRule, available);
            giftWarpList.add(giftWarp);
        }
        return giftWarpList;
    }

    private Map<String, List<OrderApplyItem>> getHistoryOrderItemList(String applyerId, String supplierId, Date orderDate) {
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        if (giftRuleList.size() == 0) {
            return new HashMap<String, List<OrderApplyItem>>();
        }
        Date ruleStartDate = null;
        Date ruleEndDate = null;
        HashMap<String, List<OrderApplyItem>> resultMap = new HashMap<String, List<OrderApplyItem>>();
        for (Gift giftRule : giftRuleList) {
            HashMap<String, OrderApplyItem> historyMap = new HashMap<String, OrderApplyItem>();
            ArrayList historyOrderItemList = new ArrayList();
            ruleStartDate = giftRule.getStartDate();
            ruleEndDate = giftRule.getEndDate();
            if (ruleEndDate == null) {
                ruleEndDate = DateUtils.getEndTime();
            }
            List items = this.baseDao.findEntity("select o from OrderApplyItem o,OrderApply a where o.orderApplyId = a.id and a.applyerId = ? and a.supplierId = ? and a.dt > ? and a.dt < ? and a.state in ('2','3','4','5','6') ", new Object[]{applyerId, supplierId, ruleStartDate, ruleEndDate}, OrderApplyItem.class);
            for (OrderApplyItem item : items) {
                historyMap.put(item.getId(), item);
            }
            historyOrderItemList.addAll(historyMap.values());
            resultMap.put(giftRule.getId(), historyOrderItemList);
        }
        return resultMap;
    }

    public List<GiftWarp> getGiftRuleAvailableList(String applyerId, String supplierId, Date orderDate, List<OrderApplyItem> currentList, String orderId) {
        Map<String, List<OrderApplyItem>> historyList = this.getHistoryOrderItemList(applyerId, supplierId, orderDate);
        List<Gift> giftRuleList = this.getGiftRuleList(applyerId, supplierId, orderDate);
        for (Gift gift : giftRuleList) {
            List<OrderApplyItem> list = historyList.get(gift.getId());
            if (list == null) {
                list = new ArrayList<OrderApplyItem>();
                historyList.put(gift.getId(), list);
            }
            list.addAll(currentList);
        }
        if (orderId != null) {
            for (String key : historyList.keySet()) {
                List<OrderApplyItem> items = historyList.get(key);
                Iterator<OrderApplyItem> it = items.iterator();
                while (it.hasNext()) {
                    OrderApplyItem item = it.next();
                    if (item.getOrderApplyId() == null || !item.getOrderApplyId().equals(orderId)) continue;
                    it.remove();
                }
            }
        }
        return this.getGiftRuleList(applyerId, supplierId, orderDate, historyList);
    }

    public Double getGiftBalance(String applyerId, String supplierId) {
        Integer precision = 2;
        GiftBalance gb = (GiftBalance)this.baseDao.findFirstEntity(" from GiftBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{applyerId, supplierId}, GiftBalance.class);
        if (gb == null) {
            return 0.0;
        }
        Double result = MathUtils.sub((Double)gb.getAllCount(), (Double)gb.getUseCount());
        if (result == null) {
            return 0.0;
        }
        if (precision != null) {
            switch (precision) {
                case 0: {
                    result = MathUtils.getInt((Double)result);
                    break;
                }
                case 1: {
                    result = MathUtils.getPrecision1((Double)result);
                    break;
                }
                case 2: {
                    result = MathUtils.getPrecision2((Double)result);
                    break;
                }
            }
        }
        return result;
    }

    public Double getCurrentGiftBalance(OrderApply order) {
        Integer precision = 2;
        Date orderDate = order.getDt() == null ? new Date() : order.getDt();
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDate);
        List<OrderApplyItem> list = order.getOrderApplyItems();
        Double totalAmount = 0.0;
        Double totalQuantity = 0.0;
        Double currentQuantity = 0.0;
        for (OrderApplyItem item : list) {
            if (!"PRODUCT".equals(item.getProductType()) || "1".equals(item.getActivityFlag())) continue;
            double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
            double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
            totalAmount = totalAmount + MathUtils.mul((Double)quantity, (Double)price);
            totalQuantity = totalQuantity + (item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity());
        }
        Double scale = pactMain.getScale();
        if (scale == null) {
            scale = 0.0;
        }
        currentQuantity = "QUANTITY".equals(pactMain.getScaleType()) ? MathUtils.div((Double)MathUtils.mul((Double)totalQuantity, (Double)scale), (Double)100.0) : MathUtils.div((Double)MathUtils.mul((Double)totalAmount, (Double)scale), (Double)100.0);
        if (precision != null) {
            switch (precision) {
                case 0: {
                    currentQuantity = MathUtils.getInt((Double)currentQuantity);
                    break;
                }
                case 1: {
                    currentQuantity = MathUtils.getPrecision1((Double)currentQuantity);
                    break;
                }
                case 2: {
                    currentQuantity = MathUtils.getPrecision2((Double)currentQuantity);
                    break;
                }
            }
        }
        return currentQuantity;
    }

    public boolean validate(OrderApply order, Double actGiftQuantity) throws Exception {
        Date orderDt = order.getDt() == null ? DateUtils.now() : order.getDt();
        List<OrderApplyItem> currentList = order.getOrderApplyItems();
        List<GiftWarp> list = this.getGiftRuleAvailableList(order.getApplyerId(), order.getSupplierId(), orderDt, currentList, order.getId());
        if (list != null && list.size() > 0) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (GiftWarp gw : list) {
                map.put(gw.getGift().getGiftId(), gw.getAvailable());
            }
            for (OrderApplyItem item : currentList) {
                Double available = (Double)map.get(item.getProductId());
                if (available == null || !(0.0 > available)) continue;
                throw new Exception(String.valueOf(item.getProductName()) + "\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8d2d\u4e70\u6570\u91cf");
            }
        }
        Double balance = this.getGiftBalance(order.getApplyerId(), order.getSupplierId());
        Double currentBalance = this.getCurrentGiftBalance(order);
        double totalBalance = MathUtils.add((Double)currentBalance, (Double)balance);
        double totalQuantity = 0.0;
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), orderDt);
        if ("QUANTITY".equals(pactMain.getScaleType())) {
            for (OrderApplyItem item : currentList) {
                if (!"GIFT".equals(item.getProductType())) continue;
                totalQuantity += (item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity()).doubleValue();
            }
        } else {
            for (OrderApplyItem item : currentList) {
                if (!"GIFT".equals(item.getProductType())) continue;
                double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
                double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
                totalQuantity += MathUtils.mul((Double)quantity, (Double)price).doubleValue();
            }
        }
        Customer customer = this.clientService.getCustomer(order.getSupplierId(), order.getApplyerId());
        if (!"-1000000".equals(customer.getGiftCtrlMode())) {
            if ("-0.2".equals(customer.getGiftCtrlMode())) {
                if (actGiftQuantity != null && actGiftQuantity > totalBalance * 1.2) {
                    throw new Exception("\u5ba1\u6279\u7684\u8d60\u54c1\u4f7f\u7528\u91cf" + actGiftQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\u5e76\u8ba9\u6b650.2\uff01");
                }
                if (totalQuantity > totalBalance * 1.2) {
                    throw new Exception("\u8d2d\u4e70\u7684\u8d60\u54c1\u6570\u91cf" + totalQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\u5e76\u8ba9\u6b650.2\uff01");
                }
            } else if ("-0.1".equals(customer.getGiftCtrlMode())) {
                if (actGiftQuantity != null && actGiftQuantity > totalBalance * 1.1) {
                    throw new Exception("\u5ba1\u6279\u7684\u8d60\u54c1\u4f7f\u7528\u91cf" + actGiftQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\u5e76\u8ba9\u6b650.1\uff01");
                }
                if (totalQuantity > totalBalance * 1.1) {
                    throw new Exception("\u8d2d\u4e70\u7684\u8d60\u54c1\u6570\u91cf" + totalQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\u5e76\u8ba9\u6b650.1\uff01");
                }
            } else {
                if (actGiftQuantity != null && actGiftQuantity > totalBalance) {
                    throw new Exception("\u5ba1\u6279\u7684\u8d60\u54c1\u4f7f\u7528\u91cf" + actGiftQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\uff01");
                }
                if (totalQuantity > totalBalance) {
                    throw new Exception("\u8d2d\u4e70\u7684\u8d60\u54c1\u6570\u91cf" + totalQuantity + "\u5df2\u7ecf\u8d85\u51fa\u4e86\u53ef\u7528\u8d60\u54c1\u4f59\u989d" + totalBalance + "\uff01");
                }
            }
        }
        return true;
    }

    public void use(OrderApply order, Double actGiftQuantity) {
        PactMain pactMain = this.pactMainService.getPactMain(order.getApplyerId(), order.getSupplierId(), order.getDt());
        GiftBalance gb = (GiftBalance)this.baseDao.findFirstEntity(" from GiftBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, GiftBalance.class);
        if (gb == null) {
            gb = new GiftBalance();
            gb.setGiftType(pactMain.getScaleType());
            gb.setAllCount(0.0);
            gb.setUseCount(0.0);
            gb.setApplyerId(order.getApplyerId());
            gb.setSupplierId(order.getSupplierId());
            gb.setCreateDt(DateUtils.now());
            gb.setLastUpdateDt(gb.getCreateDt());
            gb.setCreatorId(order.getApproverId());
            gb.setLastUpdatorId(gb.getCreatorId());
            this.baseDao.save((Object)gb);
        }
        List<OrderApplyItem> currentList = order.getOrderApplyItems();
        Double currentBalance = this.getCurrentGiftBalance(order);
        double totalQuantity = 0.0;
        if (actGiftQuantity == null) {
            if ("QUANTITY".equals(pactMain.getScaleType())) {
                for (OrderApplyItem item : currentList) {
                    if (!"GIFT".equals(item.getProductType())) continue;
                    totalQuantity += (item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity()).doubleValue();
                }
            } else {
                for (OrderApplyItem item : currentList) {
                    if (!"GIFT".equals(item.getProductType())) continue;
                    double quantity = item.getActQuantity() == null || item.getActQuantity() == 0.0 ? item.getQuantity() : item.getActQuantity();
                    double price = item.getActPrice() == null || item.getActPrice() == 0.0 ? item.getPrice() : item.getActPrice();
                    totalQuantity += MathUtils.mul((Double)quantity, (Double)price).doubleValue();
                }
            }
        } else {
            totalQuantity = actGiftQuantity;
        }
        gb.setAllCount(MathUtils.add((Double)gb.getAllCount(), (Double)currentBalance));
        gb.setUseCount(MathUtils.add((Double)gb.getUseCount(), (Double)totalQuantity));
        this.baseDao.update((Object)gb);
        if (totalQuantity != 0.0 || currentBalance != null && currentBalance != 0.0) {
            GiftHis giftHis = new GiftHis();
            giftHis.setGiftBalanceId(gb.getId());
            giftHis.setGiftType(gb.getGiftType());
            giftHis.setUseCount(totalQuantity);
            giftHis.setOrderId(order.getId());
            giftHis.setOrderNo(order.getNo());
            giftHis.setCreatorId(order.getApproverId());
            giftHis.setLastupdatorId(order.getApproverId());
            giftHis.setOrderGetCount(currentBalance);
            giftHis.setType("gift");
            this.baseDao.save((Object)giftHis);
        }
    }

    public void unuse(String orderId) {
        GiftHis gh = (GiftHis)this.baseDao.findFirstEntity("from GiftHis g where g.orderId = ? and state = '1' and type='gift' order by useDate desc ", new Object[]{orderId}, GiftHis.class);
        if (gh == null) {
            return;
        }
        OrderApply order = this.orderApplyService.getOrderApply(orderId);
        GiftBalance gb = (GiftBalance)this.baseDao.findFirstEntity(" from GiftBalance g where g.applyerId = ? and g.supplierId = ? ", new Object[]{order.getApplyerId(), order.getSupplierId()}, GiftBalance.class);
        double allCount = MathUtils.sub((Double)gb.getAllCount(), (Double)gh.getOrderGetCount());
        double useCount = MathUtils.sub((Double)gb.getUseCount(), (Double)gh.getUseCount());
        this.baseDao.executeHQL(" update GiftBalance set allCount = ? ,useCount = ?  where id = ?", new Object[]{allCount, useCount, gb.getId()});
        this.baseDao.executeHQL(" update GiftHis set state = ? where id = ?", new Object[]{0, gh.getId()});
    }

    public Page getFastSelect(String supplierId, ProductCondition con, int pageno) {
        ArrayList<Object> args = new ArrayList<Object>();
        String regions = this.personnelService.getFRegionsByUserId(con.getEm().getId());
        args.add(supplierId);
        StringBuffer sf = new StringBuffer();
        sf.append("from Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and a.supplierId=? ");
        if (StringUtils.isNotEmpty(con.getProdname())) {
            sf.append(" and a.applyerName like ? ");
            args.add("%" + con.getProdname() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            sf.append(" and a.applyerCode like ? ");
            args.add("%" + con.getNo() + "%");
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            sf.append(" and a.partnerChnlType = ? ");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            sf.append(" and a.areaCode = ? ");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            sf.append(" and a.bigAreaCode = ? ");
            args.add(con.getBigAreaCode());
        }
        sf.append(" and a.startdate <= ? and nvl(a.enddate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sf.append(" order by a.bigAreaCode,a.areaCode ");
        Page page = this.baseDao.search(sf.toString(), args.toArray(), 500, pageno);
        return page;
    }

    public void updateProduct(String[] sr, int pageno, Gift gift) {
        int i = 0;
        while (sr.length > i) {
            gift = new Gift(gift);
            gift.setClientId(sr[i]);
            this.save(gift);
            ++i;
        }
    }

    public Page getRebateAreaList(int pageno, GiftCondition condition) {
        String regionids = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from RebateArea o where o.areaId in(" + regionids + ")");
        ArrayList args = new ArrayList();
        HQL.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), pageno);
        return page;
    }

    public static class GiftWarp {
        Gift gift = null;
        double available = 0.0;

        public GiftWarp(Gift gift, double available) {
            this.gift = gift;
            this.available = available;
        }

        public Gift getGift() {
            return this.gift;
        }

        public void setGift(Gift gift) {
            this.gift = gift;
        }

        public double getAvailable() {
            return this.available;
        }

        public void setAvailable(double available) {
            this.available = available;
        }
    }
}

