/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.iface;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.AuditService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.EmployeeService;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyLocus;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.iface.EsbIfaceService;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.OrderApplyLocusService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.Log;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/esbIface"})
public class EsbIfaceController
extends BaseController {
    @Autowired
    private EsbIfaceService esbIfaceService;
    @Autowired
    private OrderApplyService orderApplyService;
    @Autowired
    private OrderApplyLocusService orderApplyLocusService;
    @Autowired
    protected AuditService auditService;
    @Autowired
    protected EmployeeService employeeService;

    @RequestMapping(value={"/updateOrderApplyState.do"})
    @ResponseBody
    public Result updateOrderApplyState(@RequestParam(value="jsonStr", required=true) String jsonStr) {
        block6: {
            Log.info((String)(" esb interface updateOrderApplyState ,param: " + jsonStr));
            try {
                Disposition dis = Cache.getDispositionFirst("YXY_CALL_IFACE_EMP");
                Employee me = this.esbIfaceService.findEmployeeById(dis.getVal());
                Map param = (Map)Jsons.toBean((String)jsonStr, Map.class);
                String orderApplyNo = (String)this.getValue(param, "orderApplyNo");
                String state = (String)this.getValue(param, "state");
                OrderApply order = this.orderApplyService.getOrderApplyByNo(orderApplyNo);
                if (order == null) {
                    throw new AppException("2023");
                }
                if (TCBJEnum.AuditState.balancePass.getValue().equals(state)) {
                    this.esbIfaceService.updateOrderApplyState(order.getId(), TCBJEnum.AuditState.balancePass.getValue());
                    this.addAuditInfo(order.getId(), "OrderApply", TCBJEnum.AuditState.balancePass.getValue(), order.getRemark(), me);
                    this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), me, OrderApplyLocus.LocusType.balancePass.getValue(), "\u8ba2\u5355\u8d22\u52a1\u5ba1\u6279\u901a\u8fc7");
                    break block6;
                }
                if (TCBJEnum.AuditState.sended.getValue().equals(state)) {
                    this.esbIfaceService.updateOrderApplyState(order.getId(), TCBJEnum.AuditState.sended.getValue());
                    this.addAuditInfo(order.getId(), "OrderApply", TCBJEnum.AuditState.sended.getValue(), order.getRemark(), me);
                    this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), me, OrderApplyLocus.LocusType.sended.getValue(), "\u8ba2\u5355\u5df2\u53d1\u8d27");
                    break block6;
                }
                if (TCBJEnum.AuditState.received.getValue().equals(TCBJEnum.AuditState.received.getValue())) {
                    this.esbIfaceService.updateOrderApplyState(order.getId(), TCBJEnum.AuditState.received.getValue());
                    this.addAuditInfo(order.getId(), "OrderApply", TCBJEnum.AuditState.received.getValue(), order.getRemark(), me);
                    this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), me, OrderApplyLocus.LocusType.received.getValue(), "\u8ba2\u5355\u5df2\u6536\u8d27");
                    break block6;
                }
                throw new AppException("3087");
            }
            catch (Exception e) {
                Log.info((String)" esb interface error ", (Throwable)e);
                return this.getErrorResult("\u7cfb\u7edf\u9519\u8bef");
            }
        }
        return this.getSuccessResult(null);
    }

    private void addAuditInfo(String businessId, String BusinessType, String opinion, String remark, Employee me) {
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessId(businessId);
        auditInfo.setBusinessType(BusinessType);
        auditInfo.setOpinion(opinion);
        auditInfo.setRemark(remark);
        this.auditService.add(auditInfo);
    }

    @RequestMapping(value={"/orderApplyUnApprove.do"})
    @ResponseBody
    public Result orderApplyUnApprove(@RequestParam(value="jsonStr", required=true) String jsonStr) {
        Log.info((String)(" esb interface orderApplyUnApprove ,param: " + jsonStr));
        try {
            Disposition dis = Cache.getDispositionFirst("YXY_CALL_IFACE_EMP");
            Employee me = this.esbIfaceService.findEmployeeById(dis.getVal());
            Map param = (Map)Jsons.toBean((String)jsonStr, Map.class);
            String orderApplyNo = (String)this.getValue(param, "orderApplyNo");
            OrderApply order = this.orderApplyService.getOrderApplyByNo(orderApplyNo);
            if (order == null) {
                throw new AppException("3061");
            }
            this.esbIfaceService.orderApplyUnApprove(order.getId());
            ActivityHandler.submit(order, order.getState());
            this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), me, OrderApplyLocus.LocusType.approveInvert.getValue(), "\u8ba2\u5355\u53cd\u5ba1\u6279");
        }
        catch (Exception e) {
            Log.info((String)" esb interface error ", (Throwable)e);
            return this.getErrorResult("\u7cfb\u7edf\u9519\u8bef");
        }
        return this.getSuccessResult(null);
    }

    protected <T> T getValue(Map<String, Object> param, String key) {
        Object o = param.get(key);
        if (Beans.isEmpty((Object)o)) {
            return null;
        }
        return (T)o;
    }
}

