/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.iface;

import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.fgift.FGiftFacadeService;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="esbIfaceService")
public class EsbIfaceService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private OrderApplyService orderApplyService;
    @Autowired
    protected IntRebatemgFacadeService intRebatemgService;
    @Autowired
    protected GiftIntRebatemgService giftIntRebatemgService;
    @Autowired
    protected AplfineService aplfineService;
    @Autowired
    protected GiftService giftService;
    @Autowired
    protected FGiftFacadeService fGiftService;

    public void updateOrderApplyState(String orderApplyId, String state) {
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ? ", new Object[]{state, orderApplyId});
    }

    public void orderApplyUnApprove(String orderApplyId) {
        OrderApply orderApply = this.orderApplyService.getOrderApply(orderApplyId);
        if (orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
            this.updateBuyUnApprove(orderApplyId);
        } else {
            this.updateRtnUnApprove(orderApplyId);
        }
    }

    public void updateBuyUnApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        if ("N".equals(rtn)) {
            throw new AppException("3019");
        }
        objs = this.baseDao.callExecute("cx_sale_order_iface_pub.reapprove_process_btn", new Object[]{orderId, "T"}, new Integer[]{12, 12});
        rtn = (String)objs[0];
        String msg = (String)objs[1];
        if ("E".equals(rtn)) {
            throw new AppException("3020", msg);
        }
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
        this.intRebatemgService.unuse(orderId);
        this.giftIntRebatemgService.unuse(orderId);
        this.aplfineService.unuse(orderId);
        this.giftService.unuse(orderId);
        this.fGiftService.unuse(orderId);
    }

    public void updateRtnUnApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        if ("N".equals(rtn)) {
            throw new AppException("3019");
        }
        objs = this.baseDao.callExecute("cx_sale_order_iface_pub.reapprove_process_btn", new Object[]{orderId, "T"}, new Integer[]{12, 12});
        rtn = (String)objs[0];
        String msg = (String)objs[1];
        if ("E".equals(rtn)) {
            throw new AppException("3020", msg);
        }
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
    }

    public Employee findEmployeeById(String val) {
        return (Employee)this.baseDao.findFirstEntity(" from Employee where id = ? ", new Object[]{val}, Employee.class);
    }
}

