/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intRule;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.intRule.IntRuleCondition;
import com.tcbj.crm.intRule.IntRuleService;
import com.tcbj.crm.product.ProductCondition;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/intRule"})
public class IntRuleController
extends BaseController {
    @Autowired
    IntRuleService intruleservice;
    @Autowired
    ProductService productService;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        IntRule intrule = new IntRule();
        model.addAttribute("master", (Object)intrule);
        return "intrule/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody IntRule intrule, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        if (!StringUtils.isEmpty(intrule.getProductIds())) {
            intrule.setProductId(intrule.getProductIds());
        }
        intrule.fillInitData(e);
        intrule.setSupplierId(e.getCurrentPartner().getId());
        this.intruleservice.save(intrule);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRuleCondition condition, Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        condition.setEm(this.getCurrentEmployee());
        model.addAttribute("page", (Object)this.intruleservice.getList(e.getCurrentPartner().getId(), pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        return "intrule/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRule intrule = this.intruleservice.get(id);
        model.addAttribute("master", (Object)intrule);
        return "intrule/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody IntRule intrule, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        intrule.fillInitData(e);
        this.intruleservice.update(intrule);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model, HttpServletRequest request) throws Exception {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRule intrule = this.intruleservice.get(id);
        model.addAttribute("master", (Object)intrule);
        return "intrule/look.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.intruleservice.delete(id);
        return "redirect:/intRule/list.do";
    }

    @RequestMapping(value={"batchedit.do"}, method={RequestMethod.GET})
    public String editsGet() {
        return "intrule/batchedit.ftl";
    }

    @RequestMapping(value={"/editIntRule.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public Page editGifts(IntRuleCondition condition, int pageno) {
        Employee e = this.getCurrentEmployee();
        condition.setEm(e);
        return this.intruleservice.getList(e.getCurrentPartner().getId(), pageno, condition);
    }

    @RequestMapping(value={"/editintrule.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPostGrd(@Valid @RequestBody IntRuleCondition wrap) throws Exception {
        Employee me = this.getCurrentEmployee();
        String delIds = wrap.getDelIds();
        List<IntRule> intRules = wrap.getIntRules();
        this.intruleservice.update(intRules, delIds, me);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/getProducts.do"})
    public String getProducts(ProductCondition con, Model model) {
        con.setEm(this.getCurrentEmployee());
        List<Product> products = this.productService.getProducts(con);
        model.addAttribute("products", products);
        model.addAttribute("condition", (Object)con);
        return "intRule/selectProducts.ftl";
    }
}

