/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intRuleControl;

import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.IntRuleControl;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component(value="intRuleControlJob")
public class IntRuleControlJob {
    @Autowired
    BaseDao baseDao;

    public void updateControlValue() {
        block13: {
            JobLog log = new JobLog(null, DateUtils.now(), null, "updateControlValue");
            long startDate = System.currentTimeMillis();
            try {
                try {
                    List<IntRuleControl> ircList = this.getValidIntRuleControlList();
                    List<IntRule> irList = this.getValidIntRuleList();
                    ArrayList<IntRule> updateList = new ArrayList<IntRule>();
                    for (IntRuleControl intRuleControl : ircList) {
                        for (IntRule intRule : irList) {
                            if (!intRuleControl.getLocusOfControl().equals(intRule.getLocusOfControl()) || !intRuleControl.getControlContent().equals(intRule.getControlContent()) || !intRuleControl.getCustomerId().equals(intRule.getApplyerId())) continue;
                            String controllingValue = this.getCurrentMonthControllingValue(intRuleControl);
                            intRule.setControllingValue(controllingValue);
                            updateList.add(intRule);
                        }
                    }
                    this.baseDao.update(updateList);
                    log.setState(1);
                    log.setRemark("\u66f4\u65b0\u5f53\u524d\u6708\u8ba2\u5355\u89c4\u5219\u63a7\u5236\u503c,\u6210\u529f" + updateList.size() + "\u6761.");
                }
                catch (Exception e) {
                    log.setState(9);
                    log.setRemark("\u66f4\u65b0\u5f53\u524d\u6708\u8ba2\u5355\u89c4\u5219\u63a7\u5236\u503c\u5931\u8d25,\u539f\u56e0\u4e3a:" + e.getMessage());
                    long endDate = System.currentTimeMillis();
                    log.setUseTime(endDate - startDate);
                    log.setRunType(2);
                    try {
                        RequestContextHolder.getRequestAttributes().getClass();
                    }
                    catch (Exception exception) {
                        log.setRunType(1);
                    }
                    log.setOrgId(StringUtils.getOrgId());
                    this.baseDao.save((Object)log);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                long endDate = System.currentTimeMillis();
                log.setUseTime(endDate - startDate);
                log.setRunType(2);
                try {
                    RequestContextHolder.getRequestAttributes().getClass();
                }
                catch (Exception exception) {
                    log.setRunType(1);
                }
                log.setOrgId(StringUtils.getOrgId());
                this.baseDao.save((Object)log);
                throw throwable;
            }
            long endDate = System.currentTimeMillis();
            log.setUseTime(endDate - startDate);
            log.setRunType(2);
            try {
                RequestContextHolder.getRequestAttributes().getClass();
            }
            catch (Exception exception) {
                log.setRunType(1);
            }
            log.setOrgId(StringUtils.getOrgId());
            this.baseDao.save((Object)log);
        }
    }

    public List<IntRuleControl> getValidIntRuleControlList() {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from IntRuleControl where state = ? ");
        args.add("0");
        hql.append(" and year = ?");
        args.add(String.valueOf(Calendar.getInstance().get(1)));
        hql.append(" and organizationId = ? ");
        args.add(StringUtils.getOrgId());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), IntRuleControl.class);
    }

    public List<IntRule> getValidIntRuleList() {
        StringBuffer hql = new StringBuffer();
        ArrayList<Date> args = new ArrayList<Date>();
        hql.append("select o from IntRule o, Customer a ");
        hql.append(" where o.applyerId = a.applyerId and o.supplierId = a.supplierId");
        hql.append(" and (o.endDate is null or o.endDate = ''  or o.endDate > ?)");
        args.add(new Date());
        return this.baseDao.findEntity(hql.toString(), args.toArray(), IntRule.class);
    }

    public String getCurrentMonthControllingValue(IntRuleControl intRuleControl) {
        try {
            int i = Calendar.getInstance().get(2) + 1;
            String fieldName = "m" + i;
            Field field = intRuleControl.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            String controllingValue = (String)field.get(intRuleControl);
            return controllingValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }
}

