/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intRuleControl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.IntRuleControl;
import com.tcbj.crm.intRule.IntRuleCondition;
import com.tcbj.crm.intRuleControl.IntRuleControlCondition;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="intRuleControlService")
public class IntRuleControlService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;

    public Page getPage(String orgid, int pageno, IntRuleCondition condition) {
        String regions = this.personnelService.getFRegionsByUserId(condition.getEm().getId());
        StringBuffer hql = new StringBuffer();
        hql.append(" from IntRule o,Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and o.applyerId=a.applyerId and o.supplierId=a.supplierId and o.supplierId = ?");
        ArrayList<String> args = new ArrayList<String>();
        args.add(orgid);
        hql.append(" and o.locusOfControl like ? ");
        args.add("%ORDER%");
        hql.append(" and o.controlContent = ? ");
        args.add(condition.getControlContent());
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            hql.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        hql.append(" order by o.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize() == null ? Constant.DEFAULT_ROWS : condition.getRowsize(), pageno);
        List list = page.getList();
        ArrayList<IntRule> intRules = new ArrayList<IntRule>();
        for (Object[] obj : list) {
            intRules.add((IntRule)obj[0]);
        }
        page.setList(intRules);
        return page;
    }

    public List<Object[]> getList(Employee employee) {
        String regions = this.personnelService.getFRegionsByUserId(employee.getId());
        StringBuffer hql = new StringBuffer();
        hql.append(" from IntRule o,Customer a where ( a.areaCode in (" + regions + ") or a.bigAreaCode in (" + regions + ") ) and o.applyerId=a.applyerId and o.supplierId=a.supplierId and o.supplierId = ?");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(employee.getCurrentPartner().getId());
        hql.append(" and o.locusOfControl like ? ");
        args.add("%ORDER%");
        hql.append(" and o.controlContent = ? ");
        args.add("MON_AMT_HIGH");
        hql.append(" and (o.endDate is null or o.endDate = ''  or o.endDate > ?)");
        args.add(new Date());
        List list = this.baseDao.findEntity(hql.toString(), args.toArray());
        ArrayList<Object[]> objList = new ArrayList<Object[]>();
        for (Object object : list) {
            Object[] objArr = (Object[])object;
            objList.add(objArr);
        }
        return objList;
    }

    public List<IntRuleControl> getIntRuleControlList(IntRuleControlCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from IntRuleControl where organizationId = ? ");
        args.add(condition.getEm().getCurrentPartner().getOrganizationid());
        hql.append(" and locusOfControl like ? ");
        args.add("%ORDER%");
        hql.append(" and controlContent = ? ");
        args.add("MON_AMT_HIGH");
        hql.append(" and state = ?");
        args.add("0");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), IntRuleControl.class);
        return list;
    }

    public List<String> saveOrUpdate2(List<List<Object>> datas, IntRuleControlCondition condition, List<Object[]> list2) {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<IntRule> intRuleList = new ArrayList<IntRule>();
        ArrayList<Customer> customerList = new ArrayList<Customer>();
        this.getIntRuleControlList(condition);
        for (Object[] objects : list2) {
            IntRule intRule = (IntRule)objects[0];
            intRuleList.add(intRule);
            Customer customer = (Customer)objects[1];
            customerList.add(customer);
        }
        int line = 1;
        int messagesCount = messages.size();
        ArrayList<IntRule> saveIntRuleList = new ArrayList<IntRule>();
        for (List<Object> rows : datas) {
            IntRule intRule = new IntRule();
            Partner partner = null;
            Customer customer = null;
            String applyerCode = String.valueOf(rows.get(0));
            if (StringUtils.isEmpty(applyerCode)) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u5ba2\u6237\u52a9\u8bb0\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                partner = Cache.getPartnerByNo(applyerCode);
                if (partner == null) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u5ba2\u6237\u52a9\u8bb0\u7801\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u627e\u5230\u8be5\u5ba2\u6237!");
                } else {
                    customer = Cache.getCustomer(String.valueOf(condition.getEm().getCurrentPartner().getId()) + "_" + partner.getId());
                    if (customer == null) {
                        messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u586b\u5199\u7684\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u8be5\u7ec4\u7ec7\u7684\u5ba2\u6237!");
                    }
                }
            }
            String startValue = (String)rows.get(1);
            if (StringUtils.isEmpty(startValue)) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (DateUtils.formDate((String)String.valueOf(startValue), (String)"yyyy-MM-dd") == null) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
            }
            String endValue = (String)rows.get(2);
            if (StringUtils.isEmpty(endValue)) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (DateUtils.formDate((String)String.valueOf(endValue), (String)"yyyy-MM-dd") == null) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
            }
            String controlContent = "";
            try {
                controlContent = this.disposeMoth((String)rows.get(3));
            }
            catch (Exception exception) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u503c\u6570\u636e\u683c\u5f0f\u6709\u9519\u8bef!");
            }
            String controllingScope = (String)rows.get(4);
            if (StringUtils.isEmpty(controllingScope)) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                String[] css = controllingScope.split(",");
                String msg = "";
                String controllingScopes = "";
                String[] stringArray = css;
                int n = css.length;
                int n2 = 0;
                while (n2 < n) {
                    String srt = stringArray[n2];
                    Constant.OrderProductType[] values = Constant.OrderProductType.values();
                    String cs = "";
                    Constant.OrderProductType[] orderProductTypeArray = values;
                    int n3 = values.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Constant.OrderProductType orderProductType = orderProductTypeArray[n4];
                        if (orderProductType.value.equals(srt)) {
                            cs = orderProductType.name();
                        }
                        ++n4;
                    }
                    if (StringUtils.isEmpty(cs)) {
                        msg = String.valueOf(msg) + controllingScope + ",";
                    } else {
                        controllingScopes = String.valueOf(controllingScopes) + cs.toUpperCase() + ",";
                    }
                    ++n2;
                }
                if (StringUtils.isEmpty(msg)) {
                    controllingScope = controllingScopes.substring(0, controllingScopes.length() - 1);
                } else {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u63a7\u5236\u8303\u56f4\u4e0d\u6b63\u786e!");
                }
            }
            Date startDate = null;
            if (StringUtils.isEmpty((String)rows.get(5))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                startDate = DateUtils.formDate((String)String.valueOf(rows.get(5)), (String)"yyyy-MM-dd");
                if (startDate == null) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
                }
            }
            Date endDate = null;
            if (!StringUtils.isEmpty((String)rows.get(6)) && (endDate = DateUtils.formDate((String)String.valueOf(rows.get(6)), (String)"yyyy-MM-dd")) == null) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
            }
            if (messagesCount == messages.size()) {
                if (intRule != null) {
                    intRule.setId(UUIDUtils.getId());
                    intRule.setLocusOfControl(condition.getLocusOfControl());
                    intRule.setControlContent(condition.getControlContent());
                    intRule.setApplyerId(partner.getId());
                    intRule.setStartDate(startDate);
                    intRule.setEndDate(endDate);
                    intRule.fillInitData(condition.getEm());
                    intRule.setSupplierId(condition.getEm().getCurrentPartner().getId());
                    intRule.setControllingValue(String.valueOf(startValue) + "," + endValue + "," + controlContent);
                    intRule.setControllingScope(controllingScope);
                    saveIntRuleList.add(intRule);
                }
            } else {
                messagesCount = messages.size();
            }
            ++line;
        }
        if (messages.size() == 0) {
            this.baseDao.save(saveIntRuleList);
        }
        return messages;
    }

    public List<String> saveOrUpdate(List<List<Object>> datas, IntRuleControlCondition condition, List<Object[]> list2) {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<IntRule> intRuleList = new ArrayList<IntRule>();
        ArrayList<Customer> customerList = new ArrayList<Customer>();
        List<IntRuleControl> intRuleControlList = this.getIntRuleControlList(condition);
        for (Object[] objects : list2) {
            IntRule intRule = (IntRule)objects[0];
            intRuleList.add(intRule);
            Customer customer = (Customer)objects[1];
            customerList.add(customer);
        }
        int line = 1;
        int messagesCount = messages.size();
        ArrayList<IntRuleControl> saveList = new ArrayList<IntRuleControl>();
        ArrayList<IntRuleControl> updateList = new ArrayList<IntRuleControl>();
        ArrayList<IntRule> updateIntRuleList = new ArrayList<IntRule>();
        ArrayList<IntRule> saveIntRuleList = new ArrayList<IntRule>();
        for (List<Object> rows : datas) {
            IntRuleControl irc = null;
            IntRule intRule = null;
            Customer customer = null;
            String applyerCode = String.valueOf(rows.get(0));
            if (StringUtils.isEmpty(applyerCode)) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d,\u5ba2\u6237\u52a9\u8bb0\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                Partner partner = Cache.getPartnerByNo(applyerCode);
                if (partner == null) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u5ba2\u6237\u52a9\u8bb0\u7801\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u627e\u5230\u8be5\u5ba2\u6237!");
                } else {
                    customer = Cache.getCustomer(String.valueOf(condition.getEm().getCurrentPartner().getId()) + "-" + partner.getId());
                    if (customer == null) {
                        messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u586b\u5199\u7684\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u8be5\u7ec4\u7ec7\u7684\u5ba2\u6237!");
                    } else {
                        boolean exists = false;
                        int i = 0;
                        while (i < customerList.size()) {
                            if (((Customer)customerList.get(i)).getApplyerCode().equals(applyerCode)) {
                                exists = true;
                                break;
                            }
                            ++i;
                        }
                        for (IntRuleControl intRuleControl : intRuleControlList) {
                            if (!partner.getId().equals(intRuleControl.getCustomerId()) || !condition.getYear().equals(intRuleControl.getYear())) continue;
                            irc = intRuleControl;
                        }
                        if (irc == null) {
                            irc = new IntRuleControl();
                            irc.setCustomerId(partner.getId());
                        }
                        if (!exists) {
                            intRule = new IntRule();
                        }
                    }
                }
            }
            if (irc != null) {
                try {
                    irc.setM1(this.disposeMoth((String)rows.get(1)));
                    irc.setM2(this.disposeMoth((String)rows.get(2)));
                    irc.setM3(this.disposeMoth((String)rows.get(3)));
                    irc.setM4(this.disposeMoth((String)rows.get(4)));
                    irc.setM5(this.disposeMoth((String)rows.get(5)));
                    irc.setM6(this.disposeMoth((String)rows.get(6)));
                    irc.setM7(this.disposeMoth((String)rows.get(7)));
                    irc.setM8(this.disposeMoth((String)rows.get(8)));
                    irc.setM9(this.disposeMoth((String)rows.get(9)));
                    irc.setM10(this.disposeMoth((String)rows.get(10)));
                    irc.setM11(this.disposeMoth((String)rows.get(11)));
                    irc.setM12(this.disposeMoth((String)rows.get(12)));
                }
                catch (Exception exception) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u6708\u4efd\u63a7\u5236\u503c\u6570\u636e\u683c\u5f0f\u6709\u9519\u8bef!");
                }
            }
            Date startDate = null;
            if (StringUtils.isEmpty((String)rows.get(13))) {
                messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
            } else {
                try {
                    startDate = DateUtils.formDate((String)String.valueOf(rows.get(13)), (String)"yyyy-MM-dd");
                    if (startDate == null) {
                        startDate = new SimpleDateFormat("yyyy/MM/dd").parse(String.valueOf(rows.get(13)));
                    }
                }
                catch (Exception exception) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
                }
            }
            Date endDate = null;
            if (!StringUtils.isEmpty((String)rows.get(14))) {
                try {
                    endDate = DateUtils.formDate((String)String.valueOf(rows.get(14)), (String)"yyyy-MM-dd");
                    if (endDate == null) {
                        endDate = new SimpleDateFormat("yyyy/MM/dd").parse(String.valueOf(rows.get(14)));
                    }
                }
                catch (Exception exception) {
                    messages.add("\u7b2c" + line + "\u884c\u6570\u636e\u4e2d\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u9519\u8bef!");
                }
            }
            if (messagesCount == messages.size()) {
                if (StringUtils.isEmpty(irc.getId())) {
                    irc.setId(UUIDUtils.getId());
                    irc.setControlContent(condition.getControlContent());
                    irc.setLocusOfControl(condition.getLocusOfControl());
                    irc.setOrganizationId(condition.getEm().getCurrentPartner().getOrganizationid());
                    irc.setYear(condition.getYear());
                    irc.setCreatorId(condition.getEm().getId());
                    irc.setState("0");
                    intRuleControlList.add(irc);
                    saveList.add(irc);
                } else {
                    updateList.add(irc);
                }
                for (IntRule ir : intRuleList) {
                    if (!irc.getCustomerId().equals(ir.getApplyerId())) continue;
                    ir.setStartDate(startDate);
                    ir.setEndDate(endDate);
                    if (String.valueOf(Calendar.getInstance().get(1)).equals(irc.getYear())) {
                        try {
                            int i = Calendar.getInstance().get(2) + 1;
                            String fieldName = "m" + i;
                            Field field = irc.getClass().getDeclaredField(fieldName);
                            field.setAccessible(true);
                            String controllingValue = (String)field.get(irc);
                            ir.setControllingValue(controllingValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    updateIntRuleList.add(ir);
                }
                if (intRule != null) {
                    intRule.setId(UUIDUtils.getId());
                    intRule.setLocusOfControl(condition.getLocusOfControl());
                    intRule.setControlContent(condition.getControlContent());
                    intRule.setApplyerId(irc.getCustomerId());
                    intRule.setStartDate(startDate);
                    intRule.setEndDate(endDate);
                    intRule.fillInitData(condition.getEm());
                    intRule.setSupplierId(condition.getEm().getCurrentPartner().getId());
                    intRule.setControllingValue("0");
                    try {
                        Calendar calendar = Calendar.getInstance();
                        int nowYear = calendar.get(1);
                        calendar.setTime(startDate);
                        int startYear = calendar.get(1);
                        if (nowYear == startYear && nowYear == Integer.valueOf(irc.getYear())) {
                            Field field = irc.getClass().getDeclaredField("m" + (Calendar.getInstance().get(2) + 1));
                            field.setAccessible(true);
                            String controllingValue = (String)field.get(irc);
                            intRule.setControllingValue(controllingValue);
                        }
                    }
                    catch (Exception exception) {}
                    saveIntRuleList.add(intRule);
                    updateIntRuleList.add(intRule);
                }
            } else {
                messagesCount = messages.size();
            }
            ++line;
        }
        this.baseDao.save(saveList);
        this.baseDao.update(updateList);
        this.baseDao.save(saveIntRuleList);
        this.baseDao.update(updateIntRuleList);
        return messages;
    }

    private String vaildata(String data) {
        if (StringUtils.isEmpty(data)) {
            return "0";
        }
        return data;
    }

    private String disposeMoth(String moth) {
        return String.valueOf(new BigDecimal(moth));
    }

    public List<IntRuleControl> getListByIntRule(IntRule intRule, String organizationId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from IntRuleControl where organizationId = ? ");
        args.add(organizationId);
        hql.append(" and controlContent = ? ");
        args.add(intRule.getControlContent());
        hql.append(" and locusOfControl = ? ");
        args.add(intRule.getLocusOfControl());
        hql.append(" and customerId = ? ");
        args.add(intRule.getApplyerId());
        hql.append(" order by year desc ");
        return this.baseDao.findEntity(hql.toString(), args.toArray(), IntRuleControl.class);
    }
}

