/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemg;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.intrebatemg.IntRebatemgService;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.MathUtils;
import com.tcbj.util.SessionUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="intrebatemgFacadeService")
public class IntRebatemgFacadeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    IntRebatemgService intRebatemgService;

    public Double[] getDiscount(String supplierId, String applyerId, Date date, Double[] _productMoney, Double[] _giftMoney, Integer precision) {
        List<IntRebatemg> list = this.intRebatemgService.getlist(supplierId, applyerId, date);
        double productCanuse = 0.0;
        double giftCanuse = 0.0;
        double productTotal = 0.0;
        double giftTotal = 0.0;
        double fullTotal = 0.0;
        double fullProductCanuse = 0.0;
        double fullGiftCanuse = 0.0;
        double productMoney = _productMoney[0] == null ? 0.0 : _productMoney[0];
        double freezeProductMoney = _productMoney[1] == null ? 0.0 : _productMoney[1];
        double freezeFullProductMoney = _productMoney[2] == null ? 0.0 : _productMoney[2];
        double giftMoney = _giftMoney[0] == null ? 0.0 : _giftMoney[0];
        double freezeGiftMoney = _giftMoney[1] == null ? 0.0 : _giftMoney[1];
        double freezeFullGiftMoney = _giftMoney[2] == null ? 0.0 : _giftMoney[2];
        for (IntRebatemg r : list) {
            double canuse;
            if ("PRODUCT".equals(r.getProducttype())) {
                canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
                productTotal = MathUtils.add((Double)productTotal, (Double)canuse);
                continue;
            }
            if ("GIFT".equals(r.getProducttype())) {
                canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
                giftTotal = MathUtils.add((Double)giftTotal, (Double)canuse);
                continue;
            }
            if (!"FULL".equals(r.getProducttype())) continue;
            canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            fullTotal = MathUtils.add((Double)fullTotal, (Double)canuse);
        }
        productTotal = MathUtils.sub((Double)productTotal, (Double)freezeProductMoney);
        giftTotal = MathUtils.sub((Double)giftTotal, (Double)freezeGiftMoney);
        fullTotal = MathUtils.sub((Double)fullTotal, (Double)freezeFullProductMoney);
        fullTotal = MathUtils.sub((Double)fullTotal, (Double)freezeFullGiftMoney);
        productTotal = productTotal > 0.0 ? productTotal : 0.0;
        giftTotal = giftTotal > 0.0 ? giftTotal : 0.0;
        fullTotal = fullTotal > 0.0 ? fullTotal : 0.0;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String orgId = SessionUtils.getEmployee(request).getCurrentPartner().getOrganizationid();
        List<Map<String, Object>> rebateList = Cache.getDescriptions("rebate");
        Double ratio = null;
        for (Map<String, Object> map : rebateList) {
            String description = String.valueOf(map.get("DESCRIPTION"));
            if (!orgId.equals(description)) continue;
            ratio = Double.valueOf(String.valueOf(map.get("VAL")));
        }
        Double productDatio = Beans.isEmpty(ratio) ? 0.4 : ratio;
        Double giftDatio = 1.0;
        productCanuse = productTotal < MathUtils.mul((Double)productMoney, (Double)productDatio) ? productTotal : MathUtils.mul((Double)productMoney, (Double)productDatio);
        giftCanuse = giftTotal < MathUtils.mul((Double)giftMoney, (Double)giftDatio) ? giftTotal : MathUtils.mul((Double)giftMoney, (Double)giftDatio);
        fullProductCanuse = fullTotal < MathUtils.mul((Double)productMoney, (Double)productDatio) ? fullTotal : MathUtils.mul((Double)productMoney, (Double)productDatio);
        fullGiftCanuse = fullTotal < MathUtils.mul((Double)giftMoney, (Double)giftDatio) ? fullTotal : MathUtils.mul((Double)giftMoney, (Double)giftDatio);
        Double productDiscount = MathUtils.mul((Double)productMoney, (Double)productDatio);
        Double giftDiscount = MathUtils.mul((Double)giftMoney, (Double)giftDatio);
        precision = precision != null ? precision : 1;
        productTotal = MathUtils.getPrecision((Double)productTotal, (Integer)precision);
        productCanuse = MathUtils.getPrecision((Double)productCanuse, (Integer)precision);
        giftTotal = MathUtils.getPrecision((Double)giftTotal, (Integer)precision);
        giftCanuse = MathUtils.getPrecision((Double)giftCanuse, (Integer)precision);
        fullTotal = MathUtils.getPrecision((Double)fullTotal, (Integer)precision);
        fullProductCanuse = MathUtils.getPrecision((Double)fullProductCanuse, (Integer)precision);
        fullGiftCanuse = MathUtils.getPrecision((Double)fullGiftCanuse, (Integer)precision);
        productDiscount = MathUtils.getPrecision((Double)productDiscount, (Integer)precision);
        giftDiscount = MathUtils.getPrecision((Double)giftDiscount, (Integer)precision);
        Double[] result = new Double[]{productTotal, productCanuse, giftTotal, giftCanuse, fullTotal, fullProductCanuse, fullGiftCanuse, productDiscount, giftDiscount};
        return result;
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from IntRebate r where r.indentApplyId = ? and r.state = '1' ", new Object[]{orderId}, IntRebate.class);
        for (IntRebate r : list) {
            String rebateId = r.getRebateId();
            IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)rebateId));
            if (intRebatemg != null) {
                intRebatemg.setWithheldMoney(MathUtils.sub((Double)intRebatemg.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())));
                this.baseDao.update((Object)intRebatemg);
            }
            this.baseDao.executeHQL(" update IntRebate set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate, String type) {
        double used = 0.0;
        List<IntRebatemg> list = this.intRebatemgService.getlist(supplierId, applyerId, orderDate);
        for (IntRebatemg r : list) {
            if (!type.equals(r.getProducttype())) continue;
            if (used >= useSum) break;
            double canuse = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            if (MathUtils.add((Double)used, (Double)canuse) > useSum) {
                canuse = MathUtils.sub((Double)useSum, (Double)used);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)canuse));
            used = MathUtils.add((Double)used, (Double)canuse);
            this.baseDao.update((Object)r);
            if (!(canuse > 0.0)) continue;
            IntRebate intRebate = new IntRebate();
            operaterId = operaterId == null ? "0-1" : operaterId;
            intRebate.setCreatorId(operaterId);
            intRebate.setLastUpdatorId(operaterId);
            intRebate.setIndentApplyId(orderId);
            intRebate.setOrderNo(orderNo);
            intRebate.setRebateId(r.getId());
            intRebate.setWithheldMoney(String.valueOf(canuse));
            intRebate.setState(1);
            this.baseDao.save((Object)intRebate);
        }
    }
}

