/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemg;

import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.intrebatemg.IntRebatemgCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Arith;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="intrebatemgService")
public class IntRebatemgService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;

    public IntRebatemg get(String id) {
        return (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)id));
    }

    public void save(IntRebatemg obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, IntRebatemgCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        args.add(condition.getSupplierId());
        HQL.append(" and (c.bigAreaCode in ( ");
        HQL.append(sb);
        HQL.append(") or c.areaCode in ( ");
        HQL.append(sb);
        HQL.append(" ))");
        HQL.append("  and (state is null or state = '1')");
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        HQL.append(" order by o. createDt desc");
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<IntRebatemg> list = new ArrayList<IntRebatemg>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((IntRebatemg)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public List<IntRebatemg> getOrgList(String supplierId, String date) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from IntRebatemg o where supplierId = ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(supplierId);
        if (StringUtils.isNotEmpty(date)) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + date + "%");
        }
        HQL.append(" order by lastUpdateDt desc ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), IntRebatemg.class);
    }

    public List<IntRebatemg> getlist(String supplierId, String applyerId, Date findDate) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from IntRebatemg o where supplierId = ? and applyerId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(supplierId);
        args.add(applyerId);
        findDate = findDate != null ? DateUtils.getEndTime((Date)findDate) : new Date();
        HQL.append(" and startDate <= ? and nvl(endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        HQL.append(" and (state is null or state = '1') ");
        HQL.append(" order by createDt ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), IntRebatemg.class);
    }

    public void update(IntRebatemg obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)id));
        intRebatemg.setEndDate(DateUtils.now());
        this.baseDao.update((Object)intRebatemg);
    }

    public Double[] getDiscount(String supplierId, String applyerId, Date date, Double[] _productMoney, Double[] _giftMoney, Integer precision) {
        List<IntRebatemg> list = this.getlist(supplierId, applyerId, date);
        double resultProductMoney = 0.0;
        double resultGiftMoney = 0.0;
        double availableProductMoney = 0.0;
        double availableGiftMoney = 0.0;
        double totalAvailableProductMoney = 0.0;
        double totalAvailableGiftMoney = 0.0;
        double productMoney = _productMoney[0] == null ? 0.0 : _productMoney[0];
        double freezeProductMoney = _productMoney[1] == null ? 0.0 : _productMoney[1];
        double giftMoney = _giftMoney[0] == null ? 0.0 : _giftMoney[0];
        double freezeGiftMoney = _giftMoney[1] == null ? 0.0 : _giftMoney[1];
        for (IntRebatemg r : list) {
            double over;
            double available;
            if ("PRODUCT".equals(r.getProducttype())) {
                available = MathUtils.div((Double)MathUtils.mul((Double)productMoney, (Double)r.getIndentMoneyPercent()), (Double)100.0);
                if (available > (over = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney()).doubleValue())) {
                    available = over;
                }
                available = available > 0.0 ? available : 0.0;
                availableProductMoney = MathUtils.add((Double)availableProductMoney, (Double)available);
                totalAvailableProductMoney += over;
                continue;
            }
            if (!"GIFT".equals(r.getProducttype())) continue;
            available = MathUtils.div((Double)MathUtils.mul((Double)giftMoney, (Double)r.getIndentMoneyPercent()), (Double)100.0);
            if (available > (over = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney()).doubleValue())) {
                available = over;
            }
            available = available > 0.0 ? available : 0.0;
            availableGiftMoney = MathUtils.add((Double)availableGiftMoney, (Double)available);
            totalAvailableGiftMoney += over;
        }
        totalAvailableProductMoney = MathUtils.sub((Double)totalAvailableProductMoney, (Double)freezeProductMoney);
        totalAvailableGiftMoney = MathUtils.sub((Double)totalAvailableGiftMoney, (Double)freezeGiftMoney);
        totalAvailableProductMoney = totalAvailableProductMoney < 0.0 ? 0.0 : totalAvailableProductMoney;
        totalAvailableGiftMoney = totalAvailableGiftMoney < 0.0 ? 0.0 : totalAvailableGiftMoney;
        availableGiftMoney = availableGiftMoney > giftMoney ? giftMoney : availableGiftMoney;
        availableProductMoney = availableProductMoney > productMoney ? productMoney : availableProductMoney;
        resultProductMoney = availableProductMoney > totalAvailableProductMoney ? totalAvailableProductMoney : availableProductMoney;
        double d = resultGiftMoney = availableGiftMoney > totalAvailableGiftMoney ? totalAvailableGiftMoney : availableGiftMoney;
        if (precision != null) {
            switch (precision) {
                case 0: {
                    resultProductMoney = MathUtils.getInt((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getInt((Double)resultGiftMoney);
                    break;
                }
                case 1: {
                    resultProductMoney = MathUtils.getPrecision1((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getPrecision1((Double)resultGiftMoney);
                    break;
                }
                case 2: {
                    resultProductMoney = MathUtils.getPrecision2((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getPrecision2((Double)resultGiftMoney);
                    break;
                }
            }
        }
        Double[] result = new Double[]{totalAvailableProductMoney, resultProductMoney, totalAvailableGiftMoney, resultGiftMoney};
        return result;
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from IntRebate r where r.indentApplyId = ? and r.state = '1' ", new Object[]{orderId}, IntRebate.class);
        for (IntRebate r : list) {
            String rebateId = r.getRebateId();
            IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)rebateId));
            if (intRebatemg != null) {
                intRebatemg.setWithheldMoney(MathUtils.sub((Double)intRebatemg.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())));
                this.baseDao.update((Object)intRebatemg);
            }
            this.baseDao.executeHQL(" update IntRebate set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate, String type) {
        double useed = 0.0;
        List<IntRebatemg> list = this.getlist(supplierId, applyerId, orderDate);
        for (IntRebatemg r : list) {
            if (!type.equals(r.getProducttype())) continue;
            if (useed == useSum) break;
            double c = MathUtils.format((Double)MathUtils.div((Double)MathUtils.mul((Double)r.getIndentMoneyPercent(), (Double)orderSum), (Double)100.0));
            if (c > MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney())) {
                c = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            }
            if (MathUtils.add((Double)useed, (Double)c) > useSum) {
                c = MathUtils.sub((Double)useSum, (Double)useed);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)c));
            useed = MathUtils.add((Double)useed, (Double)c);
            this.baseDao.update((Object)r);
            if (c == 0.0) continue;
            IntRebate intRebate = new IntRebate();
            operaterId = operaterId == null ? "0-1" : operaterId;
            intRebate.setCreatorId(operaterId);
            intRebate.setLastUpdatorId(operaterId);
            intRebate.setIndentApplyId(orderId);
            intRebate.setOrderNo(orderNo);
            intRebate.setRebateId(r.getId());
            intRebate.setWithheldMoney(String.valueOf(c));
            intRebate.setState(1);
            this.baseDao.save((Object)intRebate);
        }
    }

    public List<IntRebate> getIntRebateHistoryById(String id) {
        List list = this.baseDao.findEntity(" from IntRebate where rebateId = ? order by createDt desc", (Object)id, IntRebate.class);
        return list;
    }

    public String saveIntRebate(IntRebate intRebate, Employee em) {
        double sub;
        IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)intRebate.getRebateId()));
        if (intRebate.getState() == 3) {
            sub = Arith.add((double)intRebatemg.getWithheldMoney(), (double)new Double(intRebate.getWithheldMoney()));
        } else if (intRebate.getState() == 4) {
            sub = Arith.sub((double)intRebatemg.getWithheldMoney(), (double)new Double(intRebate.getWithheldMoney()));
            if (sub < 0.0) {
                return "overrangingsub";
            }
        } else {
            return "false";
        }
        if (Arith.sub((double)intRebatemg.getRebateMoney(), (double)sub) < 0.0) {
            return "overranging";
        }
        intRebatemg.setWithheldMoney(sub);
        this.baseDao.update((Object)intRebatemg);
        IntRebate entity = new IntRebate();
        entity.fillInitData(em);
        entity.setCreateDt(intRebate.getCreateDt());
        entity.setWithheldMoney(intRebate.getWithheldMoney());
        entity.setOrderNo(intRebate.getOrderNo());
        entity.setState(intRebate.getState());
        entity.setRebateId(intRebate.getRebateId());
        this.baseDao.save((Object)entity);
        return "true";
    }
}

