/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemgnew;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.UpdateRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.intrebatemgnew.IntRebatemgNewCondition;
import com.tcbj.crm.intrebatemgnew.IntRebatemgNewService;
import com.tcbj.crm.intrebatemgnew.excel.RebateListExc;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.updaterecord.UpdateRecordService;
import com.tcbj.crm.upload.ExcelHandle;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/intrebatemgnew"})
public class IntRebatemgNewController
extends BaseController {
    @Autowired
    IntRebatemgNewService intrebatemgservice;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    RegionService regionService;
    @Autowired
    UpdateRecordService updateRecordService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String add_get(Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        String orgId = e.getCurrentPartner().getId();
        String bm = this.orderNoService.maxNo(e.getCurrentPartner().getNo(), "08");
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("bm", (Object)bm);
        IntRebatemg intRebatemg = new IntRebatemg();
        model.addAttribute("master", (Object)intRebatemg);
        return "intrebatemgnew/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result add_post(@Valid @RequestBody IntRebatemg intrebatemg, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        intrebatemg.fillInitData(e);
        intrebatemg.setSupplierId(e.getCurrentPartner().getId());
        intrebatemg.setState("0");
        if (Beans.isNotEmpty((Object)intrebatemg.getEndDate())) {
            intrebatemg.setEndDate(DateUtils.getEndTime((Date)intrebatemg.getEndDate()));
        }
        this.intrebatemgservice.save(intrebatemg);
        this.saveUpdateRecord(intrebatemg.getId(), "ADD", null);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getId();
        condition.setSupplierId(orgId);
        condition.setUserId(em.getId());
        condition.setRegionFilter(true);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("page", (Object)this.intrebatemgservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            List<IntRebatemg> ibs = this.intrebatemgservice.getlist(this.getCurrentEmployee().getCurrentPartner().getId(), condition.getApplyerId(), DateUtils.now());
            BigDecimal sum_product = BigDecimal.valueOf(0.0);
            BigDecimal sum_gift = BigDecimal.valueOf(0.0);
            BigDecimal sum_all = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_product = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_gift = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_all = BigDecimal.valueOf(0.0);
            int cp_sum = 0;
            int zp_sum = 0;
            int qp_sum = 0;
            for (IntRebatemg ib : ibs) {
                if ("PRODUCT".equals(ib.getProducttype())) {
                    sum_product = sum_product.add(BigDecimal.valueOf(ib.getRebateMoney()));
                    sy_sum_product = sy_sum_product.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                    ++cp_sum;
                    continue;
                }
                if ("GIFT".equals(ib.getProducttype())) {
                    sum_gift = sum_gift.add(BigDecimal.valueOf(ib.getRebateMoney()));
                    sy_sum_gift = sy_sum_gift.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                    ++zp_sum;
                    continue;
                }
                if (!"FULL".equals(ib.getProducttype())) continue;
                sum_all = sum_all.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_all = sy_sum_all.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++qp_sum;
            }
            BigDecimal ky_sum_product = sum_product.subtract(sy_sum_product);
            BigDecimal ky_sum_gift = sum_gift.subtract(sy_sum_gift);
            BigDecimal ky_sum_all = sum_all.subtract(sy_sum_all);
            model.addAttribute("cp_sum", (Object)cp_sum);
            model.addAttribute("zp_sum", (Object)zp_sum);
            model.addAttribute("qp_sum", (Object)qp_sum);
            model.addAttribute("ky_sum_product", (Object)ky_sum_product);
            model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
            model.addAttribute("ky_sum_all", (Object)ky_sum_all);
            model.addAttribute("sum_product", (Object)sum_product);
            model.addAttribute("sum_gift", (Object)sum_gift);
            model.addAttribute("sum_all", (Object)sum_all);
            model.addAttribute("ibs", (Object)ibs.size());
        }
        return "intrebatemgnew/list.ftl";
    }

    @RequestMapping(value={"/listExcle.do"}, method={RequestMethod.GET})
    public void listExcel(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        condition.setSupplierId(em.getCurrentPartner().getId());
        condition.setUserId(em.getId());
        condition.setRegionFilter(true);
        List<RebateListExc> excels = this.intrebatemgservice.getListToExc(1, condition);
        try {
            String[] titles = new String[]{"\u5927\u533a", "\u533a\u57df", "\u6298\u8ba9\u5355\u53f7", "OA\u5355\u53f7", "\u6298\u8ba9\u7c7b\u578b", "\u4ea7\u54c1\u7c7b\u578b", "\u6298\u8ba9\u91d1\u989d", "\u5df2\u4f7f\u7528", "\u672a\u4f7f\u7528", "\u5ba2\u6237", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u5173\u6237\u65f6\u95f4", "\u7533\u8bf7\u4e8b\u7531"};
            ExcelUtils.exportExcel("\u6298\u8ba9\u6982\u89c8\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), "\u6298\u8ba9\u6982\u89c8\u8868", titles, excels, response);
        }
        catch (Exception e) {
            throw new AppException("\u6298\u8ba9\u6982\u89c8\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/applys.do"}, method={RequestMethod.GET})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getOrganizationid();
        condition.setApplyerId(em.getCurrentPartner().getId());
        condition.setState("1");
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("page", (Object)this.intrebatemgservice.getListNew(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("date", (Object)new Timestamp(new Date().getTime()));
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            condition.setPageSize(Integer.MAX_VALUE);
            List ibs = this.intrebatemgservice.getList(pageno, condition).getList();
            BigDecimal sum_product = BigDecimal.valueOf(0.0);
            BigDecimal sum_gift = BigDecimal.valueOf(0.0);
            BigDecimal sum_all = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_product = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_gift = BigDecimal.valueOf(0.0);
            BigDecimal sy_sum_all = BigDecimal.valueOf(0.0);
            int cp_sum = 0;
            int zp_sum = 0;
            int qp_sum = 0;
            for (IntRebatemg ib : ibs) {
                if ("PRODUCT".equals(ib.getProducttype())) {
                    sum_product = sum_product.add(BigDecimal.valueOf(ib.getRebateMoney()));
                    sy_sum_product = sy_sum_product.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                    ++cp_sum;
                    continue;
                }
                if ("GIFT".equals(ib.getProducttype())) {
                    sum_gift = sum_gift.add(BigDecimal.valueOf(ib.getRebateMoney()));
                    sy_sum_gift = sy_sum_gift.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                    ++zp_sum;
                    continue;
                }
                if (!"FULL".equals(ib.getProducttype())) continue;
                sum_all = sum_all.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_all = sy_sum_all.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++qp_sum;
            }
            BigDecimal ky_sum_product = sum_product.subtract(sy_sum_product);
            BigDecimal ky_sum_gift = sum_gift.subtract(sy_sum_gift);
            BigDecimal ky_sum_all = sum_all.subtract(sy_sum_all);
            model.addAttribute("cp_sum", (Object)cp_sum);
            model.addAttribute("zp_sum", (Object)zp_sum);
            model.addAttribute("qp_sum", (Object)qp_sum);
            model.addAttribute("ky_sum_product", (Object)ky_sum_product);
            model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
            model.addAttribute("ky_sum_all", (Object)ky_sum_all);
            model.addAttribute("sum_product", (Object)sum_product);
            model.addAttribute("sum_gift", (Object)sum_gift);
            model.addAttribute("sum_all", (Object)sum_all);
            model.addAttribute("ibs", (Object)ibs.size());
        }
        return "intrebatemgnew/applys.ftl";
    }

    @RequestMapping(value={"/rebateTotalList.do"}, method={RequestMethod.GET})
    public String rebateTotalList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request) {
        if (condition.getStart_dates() == null) {
            Calendar ca = Calendar.getInstance();
            ca.add(2, 0);
            ca.set(5, 1);
            condition.setStart_dates(ca.getTime());
            condition.setStart_datee(new Date());
        }
        if (condition.getStart_datee() == null) {
            condition.setStart_datee(new Date());
        }
        condition.setStart_datee(DateUtils.getEndTime((Date)condition.getStart_datee()));
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getId();
        condition.setSupplierId(orgId);
        condition.setUserId(em.getId());
        model.addAttribute("page", (Object)this.intrebatemgservice.getListTotal(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("orgId", (Object)orgId);
        return "intrebatemgnew/rebateTotalList.ftl";
    }

    @RequestMapping(value={"/rebateModeList.do"}, method={RequestMethod.GET})
    public String rebateModeList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getOrganizationid();
        condition.setSupplierId(orgId);
        condition.setUserId(em.getId());
        Map<String, String> map = Cache.getMapByType2("TCBJ_PACT_EXPENSE_TYPE", orgId);
        Set<String> keylist = map.keySet();
        model.addAttribute("page", (Object)this.intrebatemgservice.getListByMode(pageno, condition, map));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("map", map);
        model.addAttribute("keylist", keylist);
        model.addAttribute("orgId", (Object)orgId);
        return "intrebatemgnew/rebateModeList.ftl";
    }

    @RequestMapping(value={"/rebateTypeList.do"}, method={RequestMethod.GET})
    public String rebateTypeList(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, IntRebatemgNewCondition condition, Model model, HttpServletRequest request) {
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getOrganizationid();
        condition.setSupplierId(orgId);
        Map<String, String> map = Cache.getMapByType("TCBJ_DISCOUNT_PRODUCT_TYPE", orgId);
        Set<String> keylist = map.keySet();
        model.addAttribute("page", (Object)this.intrebatemgservice.getListByType(pageno, condition, map));
        model.addAttribute("condition", (Object)condition);
        model.addAttribute("map", map);
        model.addAttribute("keylist", keylist);
        model.addAttribute("orgId", (Object)orgId);
        return "intrebatemgnew/rebateTypeList.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String edit_get(String id, String applyerId, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getOrganizationid();
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("master", (Object)intrebatemg);
        return "intrebatemgnew/edit.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_post(@Valid @RequestBody IntRebatemg intrebatemg, BindingResult errors, Model model, HttpServletRequest request) {
        if (intrebatemg.getRebateMoney() < intrebatemg.getWithheldMoney()) {
            throw new AppException("1401");
        }
        Employee e = this.getCurrentEmployee();
        intrebatemg.fillInitData(e);
        intrebatemg.setState("0");
        if (Beans.isNotEmpty((Object)intrebatemg.getEndDate())) {
            intrebatemg.setEndDate(DateUtils.getEndTime((Date)intrebatemg.getEndDate()));
        }
        this.intrebatemgservice.update(intrebatemg);
        this.saveUpdateRecord(intrebatemg.getId(), "UPDATE", null);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit_get(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getId();
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("master", (Object)intrebatemg);
        model.addAttribute("orgId", (Object)orgId);
        List<IntRebatemg> ibs = this.intrebatemgservice.getlist(this.getCurrentEmployee().getCurrentPartner().getId(), intrebatemg.getApplyerId(), DateUtils.now());
        Double sum_product = 0.0;
        Double sum_gift = 0.0;
        Double sy_sum_product = 0.0;
        Double sy_sum_gift = 0.0;
        int cp_sum = 0;
        int zp_sum = 0;
        for (IntRebatemg ib : ibs) {
            if ("PRODUCT".equals(ib.getProducttype())) {
                sum_product = MathUtils.add((Double)sum_product, (Double)ib.getRebateMoney());
                sy_sum_product = MathUtils.add((Double)sy_sum_product, (Double)ib.getWithheldMoney());
                ++cp_sum;
                continue;
            }
            sum_gift = MathUtils.add((Double)sum_gift, (Double)ib.getRebateMoney());
            sy_sum_gift = MathUtils.add((Double)sy_sum_gift, (Double)ib.getWithheldMoney());
            ++zp_sum;
        }
        Double ky_sum_product = sum_product - sy_sum_product;
        Double ky_sum_gift = sum_gift - sy_sum_gift;
        model.addAttribute("cp_sum", (Object)cp_sum);
        model.addAttribute("zp_sum", (Object)zp_sum);
        model.addAttribute("ky_sum_product", (Object)ky_sum_product);
        model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
        model.addAttribute("sum_product", (Object)sum_product);
        model.addAttribute("sum_gift", (Object)sum_gift);
        model.addAttribute("ibs", (Object)ibs.size());
        return "intrebatemgnew/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_post(@Valid @RequestBody IntRebatemg intrebatemgt, BindingResult errors, Model model, HttpServletRequest request) {
        IntRebatemg intrebatemg = this.intrebatemgservice.get(intrebatemgt.getId());
        if (intrebatemg.getRebateMoney() < intrebatemg.getWithheldMoney()) {
            throw new AppException("1401");
        }
        Employee e = this.getCurrentEmployee();
        intrebatemg.fillInitData(e);
        intrebatemg.setState("1");
        this.intrebatemgservice.update(intrebatemg);
        this.saveUpdateRecord(intrebatemg.getId(), "AUDITPASS", null);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/exporttotal.do"}, method={RequestMethod.GET})
    public void export_total(IntRebatemgNewCondition con, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        String orgId = em.getCurrentPartner().getId();
        con.setSupplierId(orgId);
        con.setUserId(em.getId());
        con.setStart_datee(DateUtils.getEndTime((Date)con.getStart_datee()));
        List<Map<String, Object>> excels = this.intrebatemgservice.getListTotalToExc(1, con);
        try {
            String[] titles = new String[]{"\u5ba2\u6237\u4ee3\u7801", "\u5ba2\u6237\u540d\u79f0", "\u6e20\u9053", "\u5927\u533a", "\u533a\u57df", "\u671f\u521d\u53ef\u7528\u6298\u8ba9\u91d1\u989d", "\u672c\u671f\u7533\u8bf7\u6298\u8ba9", "\u672c\u671f\u4f7f\u7528\u6298\u8ba9", "\u671f\u672b\u53ef\u7528\u6298\u8ba9\u91d1\u989d"};
            String[] pop = new String[]{"partnercode", "partnername", "channelname", "districtname", "regionname", "plus", "total", "used", "qimo"};
            ExcelUtils.exportExcelNew("\u6298\u8ba9\u6c47\u603b\u660e\u7ec6\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6298\u8ba9\u6c47\u603b\u660e\u7ec6\u8868", ".xlsx", titles, excels, pop, null, response);
        }
        catch (Exception e) {
            throw new AppException("\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/exportlist.do"}, method={RequestMethod.GET})
    public void export_list(IntRebatemgNewCondition con, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        con.setSupplierId(em.getCurrentPartner().getId());
        con.setUserId(em.getId());
        con.setRegionFilter(true);
        List<RebateListExc> excels = this.intrebatemgservice.getListByListToExc(1, con);
        try {
            String[] titles = new String[]{"\u5927\u533a", "\u533a\u57df", "\u6298\u8ba9\u5355\u53f7", "OA\u5355\u53f7", "\u6298\u8ba9\u7c7b\u578b", "\u4ea7\u54c1\u7c7b\u578b", "\u6298\u8ba9\u91d1\u989d", "\u5df2\u4f7f\u7528", "\u672a\u4f7f\u7528", "\u5ba2\u6237", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u5173\u6237\u65f6\u95f4", "\u7533\u8bf7\u4e8b\u7531", "\u4f7f\u7528\u65f6\u95f4", "\u4f7f\u7528\u91d1\u989d", "\u8ba2\u5355\u7f16\u53f7", "\u521b\u5efa\u4eba", "\u72b6\u6001"};
            ExcelUtils.exportExcel("\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), "\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868", titles, excels, response);
        }
        catch (Exception e) {
            throw new AppException("\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/exportapplyslist.do"}, method={RequestMethod.GET})
    public void export_applyslist(IntRebatemgNewCondition con, HttpServletResponse response) {
        Employee em = this.getCurrentEmployee();
        con.setApplyerId(em.getCurrentPartner().getId());
        con.setState("1");
        List<RebateListExc> excels = this.intrebatemgservice.getListByListToExcNew(1, con);
        try {
            String[] titles = new String[]{"\u5927\u533a", "\u533a\u57df", "\u6298\u8ba9\u5355\u53f7", "OA\u5355\u53f7", "\u6298\u8ba9\u7c7b\u578b", "\u4ea7\u54c1\u7c7b\u578b", "\u6298\u8ba9\u91d1\u989d", "\u5df2\u4f7f\u7528", "\u672a\u4f7f\u7528", "\u5ba2\u6237", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u5173\u6237\u65f6\u95f4", "\u7533\u8bf7\u4e8b\u7531", "\u4f7f\u7528\u65f6\u95f4", "\u4f7f\u7528\u91d1\u989d", "\u8ba2\u5355\u7f16\u53f7", "\u521b\u5efa\u4eba", "\u72b6\u6001"};
            ExcelUtils.exportExcel("\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), "\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868", titles, excels, response);
        }
        catch (Exception e) {
            throw new AppException("\u6298\u8ba9\u5bf9\u8d26\u660e\u7ec6\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/exportmode.do"}, method={RequestMethod.GET})
    public void export_mode(IntRebatemgNewCondition con, HttpServletResponse response) {
        try {
            Employee em = this.getCurrentEmployee();
            String orgId = em.getCurrentPartner().getOrganizationid();
            con.setSupplierId(orgId);
            Map<String, String> map = Cache.getMapByType2("TCBJ_PACT_EXPENSE_TYPE", orgId);
            Set<String> keylist = map.keySet();
            Collection<String> valuelist = map.values();
            List<Map<String, Object>> excels = this.intrebatemgservice.getListByModeToExcNew(1, con, map);
            ArrayList<String> listarr = new ArrayList<String>();
            listarr.add("\u5ba2\u6237\u4ee3\u7801");
            listarr.add("\u5ba2\u6237\u540d\u79f0");
            listarr.add("\u6e20\u9053");
            listarr.add("\u5927\u533a");
            listarr.add("\u533a\u57df");
            for (String value : valuelist) {
                listarr.add(value);
            }
            listarr.add("\u5176\u4ed6");
            listarr.add("\u5408\u8ba1");
            int size = listarr.size();
            String[] titles = listarr.toArray(new String[size]);
            ArrayList<String> listarr1 = new ArrayList<String>();
            listarr1.add("partnercode");
            listarr1.add("partnername");
            listarr1.add("channelname");
            listarr1.add("districtname");
            listarr1.add("regionname");
            for (String key : keylist) {
                listarr1.add(key);
            }
            listarr1.add("other");
            listarr1.add("total");
            int size1 = listarr.size();
            String[] pop = listarr1.toArray(new String[size1]);
            ExcelUtils.exportExcelNew("\u6298\u8ba9\u7c7b\u578b\u5206\u6790\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6298\u8ba9\u7c7b\u578b\u5206\u6790\u8868", ".xlsx", titles, excels, pop, null, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("\u6298\u8ba9\u7c7b\u578b\u5206\u6790\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/exporttype.do"}, method={RequestMethod.GET})
    public void export_type(IntRebatemgNewCondition con, HttpServletResponse response) {
        try {
            Employee em = this.getCurrentEmployee();
            String orgId = em.getCurrentPartner().getOrganizationid();
            con.setSupplierId(orgId);
            Map<String, String> map = Cache.getMapByType("TCBJ_DISCOUNT_PRODUCT_TYPE", orgId);
            Set<String> keylist = map.keySet();
            Collection<String> valuelist = map.values();
            List<Map<String, Object>> excels = this.intrebatemgservice.getListByTypeToExc(1, con, map);
            ArrayList<String> listarr = new ArrayList<String>();
            listarr.add("\u5ba2\u6237\u4ee3\u7801");
            listarr.add("\u5ba2\u6237\u540d\u79f0");
            listarr.add("\u6e20\u9053");
            listarr.add("\u5927\u533a");
            listarr.add("\u533a\u57df");
            for (String value : valuelist) {
                listarr.add(value);
            }
            listarr.add("\u5176\u4ed6");
            listarr.add("\u5408\u8ba1");
            int size = listarr.size();
            String[] titles = listarr.toArray(new String[size]);
            ArrayList<String> listarr1 = new ArrayList<String>();
            listarr1.add("partnercode");
            listarr1.add("partnername");
            listarr1.add("channelname");
            listarr1.add("districtname");
            listarr1.add("regionname");
            for (String key : keylist) {
                listarr1.add(key);
            }
            listarr1.add("other");
            listarr1.add("total");
            int size1 = listarr.size();
            String[] pop = listarr1.toArray(new String[size1]);
            ExcelUtils.exportExcelNew("\u6298\u8ba9\u65b9\u5f0f\u5206\u6790\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u6298\u8ba9\u65b9\u5f0f\u5206\u6790\u8868", ".xlsx", titles, excels, pop, null, response);
        }
        catch (Exception e) {
            throw new AppException("\u6298\u8ba9\u65b9\u5f0f\u5206\u6790\u8868\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("master", (Object)intrebatemg);
        List<IntRebatemg> ibs = this.intrebatemgservice.getlist(this.getCurrentEmployee().getCurrentPartner().getId(), intrebatemg.getApplyerId(), DateUtils.now());
        BigDecimal sum_product = BigDecimal.valueOf(0.0);
        BigDecimal sum_gift = BigDecimal.valueOf(0.0);
        BigDecimal sum_all = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_product = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_gift = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_all = BigDecimal.valueOf(0.0);
        int cp_sum = 0;
        int zp_sum = 0;
        int qp_sum = 0;
        for (IntRebatemg ib : ibs) {
            if ("PRODUCT".equals(ib.getProducttype())) {
                sum_product = sum_product.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_product = sy_sum_product.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++cp_sum;
                continue;
            }
            if ("GIFT".equals(ib.getProducttype())) {
                sum_gift = sum_gift.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_gift = sy_sum_gift.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++zp_sum;
                continue;
            }
            if (!"FULL".equals(ib.getProducttype())) continue;
            sum_all = sum_all.add(BigDecimal.valueOf(ib.getRebateMoney()));
            sy_sum_all = sy_sum_all.add(BigDecimal.valueOf(ib.getWithheldMoney()));
            ++qp_sum;
        }
        BigDecimal ky_sum_product = sum_product.subtract(sy_sum_product);
        BigDecimal ky_sum_gift = sum_gift.subtract(sy_sum_gift);
        BigDecimal ky_sum_all = sum_all.subtract(sy_sum_all);
        model.addAttribute("cp_sum", (Object)cp_sum);
        model.addAttribute("zp_sum", (Object)zp_sum);
        model.addAttribute("qp_sum", (Object)qp_sum);
        model.addAttribute("ky_sum_product", (Object)ky_sum_product);
        model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
        model.addAttribute("ky_sum_all", (Object)ky_sum_all);
        model.addAttribute("sum_product", (Object)sum_product);
        model.addAttribute("sum_gift", (Object)sum_gift);
        model.addAttribute("sum_all", (Object)sum_all);
        model.addAttribute("ibs", (Object)ibs.size());
        return "intrebatemgnew/look.ftl";
    }

    @RequestMapping(value={"/lookapply.do"}, method={RequestMethod.GET})
    public String look_apply(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        IntRebatemg intrebatemg = this.intrebatemgservice.get(id);
        model.addAttribute("master", (Object)intrebatemg);
        return "intrebatemgnew/lookapply.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.POST})
    public String delete_get(String id, String updateRemark, Model model, HttpServletRequest request) {
        IntRebatemg intRebatemg = this.intrebatemgservice.delete(id, updateRemark);
        this.saveUpdateRecord(intRebatemg.getId(), "DISCARD", updateRemark);
        return "redirect:/intrebatemgnew/list.do";
    }

    @RequestMapping(value={"/viewHistory.do"}, method={RequestMethod.GET})
    public String viewIntRebate(String id, Model model) {
        List<IntRebate> list = this.intrebatemgservice.getIntRebateHistoryById(id);
        model.addAttribute("list", list);
        model.addAttribute("id", (Object)id);
        return "intrebatemgnew/viewHistory.ftl";
    }

    @RequestMapping(value={"/viewHistoryApply.do"}, method={RequestMethod.GET})
    public String viewHistory(String id, Model model) {
        List<IntRebate> list = this.intrebatemgservice.getIntRebateHistoryById(id);
        model.addAttribute("list", list);
        model.addAttribute("id", (Object)id);
        return "intrebatemg/viewHistoryApply.ftl";
    }

    @RequestMapping(value={"/viewHistoryadd.do"}, method={RequestMethod.GET})
    public String viewHistoryadd(Model model, String id) {
        model.addAttribute("id", (Object)id);
        return "intrebatemg/viewHistoryadd.ftl";
    }

    @RequestMapping(value={"/viewHistoryadd.do"}, method={RequestMethod.POST})
    @ResponseBody
    public String viewHistoryaddPost(IntRebate intRebate) {
        try {
            return this.intrebatemgservice.saveIntRebate(intRebate, this.getCurrentEmployee());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
    }

    @RequestMapping(value={"/getRegionByApplyid.do"}, method={RequestMethod.POST})
    public void getPartner(String id, HttpServletResponse response) throws Exception {
        Customer cus = this.clientService.getCustomerByApplyerId(id);
        Region region = this.regionService.getAreaByAreaCode(cus.getAreaCode());
        JSONObject rootNode = new JSONObject();
        rootNode.put("regionname", (Object)region.getRegionName());
        rootNode.put("id", (Object)region.getId());
        response.getWriter().write(rootNode.toString());
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.GET})
    public String intoExcel() throws Exception {
        return "intrebatemgnew/excel.ftl";
    }

    @RequestMapping(value={"/intoExcel.do"}, method={RequestMethod.POST})
    public String intoExcel(Model model, HttpServletRequest request) throws Exception {
        IUploadFile file;
        List<List<Object>> datas;
        List<String> errorList;
        List<IUploadFile> list = this.uploadFile(request, "intrebatemg");
        String rtn = null;
        if (list.size() > 0 && (errorList = this.intrebatemgservice.saveBatch(datas = ExcelHandle.readExcel((file = list.get(0)).getRealPath()), this.getCurrentEmployee(), request)).size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(errorList)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        String uuid = UUIDUtils.getId();
        rtn = JSON.toJSONString((Object)this.getSuccessResult("true:" + uuid));
        model.addAttribute("rtn", (Object)rtn);
        List intRebatemgList = (List)request.getAttribute("intRebatemgs");
        for (IntRebatemg intRebatemg : intRebatemgList) {
            this.saveUpdateRecord(intRebatemg.getId(), "EXCELADD", null);
        }
        request.getSession().setAttribute(uuid, (Object)intRebatemgList);
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/batchApproveExcel.do"}, method={RequestMethod.GET})
    public String batchApproveExcel(String uuid, Model model, HttpServletRequest request) {
        HttpSession session = request.getSession();
        model.addAttribute("intRebatemgs", session.getAttribute(uuid));
        return "intrebatemgnew/batchApproveExcel.ftl";
    }

    @RequestMapping(value={"/batchApproveExcel.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result batchApproveExcel(String[] id) {
        String[] stringArray = id;
        int n = id.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IntRebatemg intrebatemg = this.intrebatemgservice.get(string);
            if (intrebatemg.getRebateMoney() < intrebatemg.getWithheldMoney()) {
                throw new AppException("1401");
            }
            Employee e = this.getCurrentEmployee();
            intrebatemg.updateLastData(e);
            intrebatemg.setState("1");
            this.intrebatemgservice.update(intrebatemg);
            this.saveUpdateRecord(intrebatemg.getId(), "AUDITPASS", "Excel\u5bfc\u5165\u540e\u7684\u6279\u91cf\u5ba1\u6279");
            ++n2;
        }
        return this.getSuccessResult(null);
    }

    public void saveUpdateRecord(String id, String type, String remark) {
        IntRebatemg intRebatemg = this.intrebatemgservice.get(id);
        UpdateRecord updateRecord = new UpdateRecord();
        updateRecord.fillInitData(this.getCurrentEmployee());
        updateRecord.setOperationCode("intRebatemg");
        updateRecord.setDataMainId(id);
        updateRecord.setOperationType(type);
        updateRecord.setRemark(remark);
        updateRecord.setOperationData(JSON.toJSONString((Object)intRebatemg));
        this.updateRecordService.save(updateRecord);
    }

    @RequestMapping(value={"/findRecords.do"}, method={RequestMethod.GET})
    public String findRecords(String id, Model model) {
        List<UpdateRecord> updateRecords = this.updateRecordService.getByCodeAndId("intRebatemg", id, this.getCurrentEmployee());
        model.addAttribute("updateRecords", updateRecords);
        return "intrebatemgnew/records.ftl";
    }

    @RequestMapping(value={"/lookRecord.do"}, method={RequestMethod.GET})
    public String lookRecord(String id, Model model) {
        UpdateRecord ur = this.updateRecordService.get(id);
        String jsonData = ur.getOperationData();
        IntRebatemg intrebatemg = (IntRebatemg)JSON.parseObject((String)jsonData, IntRebatemg.class);
        model.addAttribute("master", (Object)intrebatemg);
        return "intrebatemgnew/lookRecord.ftl";
    }
}

