/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.intrebatemgnew;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.IntRebate;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.intrebatemgnew.IntRebatemgNewCondition;
import com.tcbj.crm.intrebatemgnew.excel.RebateListExc;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Arith;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="intrebatemgNewService")
public class IntRebatemgNewService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    private NewBaseDao newBaseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    OrderNoService orderNoService;

    public IntRebatemg get(String id) {
        return (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)id));
    }

    public void save(IntRebatemg obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, IntRebatemgNewCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        if (condition.getRegionFilter().booleanValue()) {
            HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
            args.add(condition.getSupplierId());
            String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        } else {
            HQL.append(" and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                HQL.append(" and o.rebateType is null ");
            } else {
                HQL.append(" and o.rebateType = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            if (condition.getState().equals("2")) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            } else if (condition.getState().equals("3")) {
                HQL.append(" and o.endDate <= ? ");
                args.add(DateUtils.now());
            } else {
                if ("1".equals(condition.getState())) {
                    HQL.append(" and (o.state is null or o.state = ?) ");
                    args.add(condition.getState());
                } else if ("0".equals(condition.getState())) {
                    HQL.append(" and o.state = ? ");
                    args.add(condition.getState());
                }
                HQL.append(" and o.startDate <= ? and nvl(o.endDate,?) >= ? ");
                args.add(DateUtils.now());
                args.add(DateUtils.getEndTime());
                args.add(DateUtils.now());
            }
        }
        if (condition.getStart_dates() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(condition.getStart_datee());
        }
        HQL.append(" order by o. createDt desc");
        System.out.println("HAL" + HQL.toString());
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), condition.getPageSize() == null ? Constant.DEFAULT_ROWS : condition.getPageSize(), pageno);
        ArrayList<IntRebatemg> list = new ArrayList<IntRebatemg>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((IntRebatemg)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public Page getListNew(int pageno, IntRebatemgNewCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        if (condition.getRegionFilter().booleanValue()) {
            HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
            args.add(condition.getSupplierId());
            String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        } else {
            HQL.append(" and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                HQL.append(" and o.rebateType is null ");
            } else {
                HQL.append(" and o.rebateType = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            if (condition.getState().equals("2")) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            } else if (condition.getState().equals("3")) {
                HQL.append(" and o.endDate <= ? ");
                args.add(DateUtils.now());
            } else if ("1".equals(condition.getState())) {
                HQL.append(" and (o.state is null or o.state = ?) ");
                args.add(condition.getState());
            } else if ("0".equals(condition.getState())) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            }
        }
        if (condition.getStart_dates() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(DateUtils.getEndTime((Date)condition.getStart_datee()));
        }
        HQL.append(" order by o.created desc");
        System.out.println("HAL" + HQL.toString());
        Page page = this.baseDao.search(HQL.toString(), args.toArray(), condition.getPageSize() == null ? Constant.DEFAULT_ROWS : condition.getPageSize(), pageno);
        ArrayList<IntRebatemg> list = new ArrayList<IntRebatemg>();
        List obgs = page.getList();
        for (Object[] objects : obgs) {
            list.add((IntRebatemg)objects[0]);
        }
        page.setList(list);
        return page;
    }

    public Page getListTotal(int pageno, IntRebatemgNewCondition condition) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num     \"partnercode\",\r\n          f.partner_name    \"partnername\",\r\n          q.name            \"channelname\",\r\n          f.district_name   \"districtname\",\r\n          f.region_name     \"regionname\",\r\n          f.qichu           \"plus\",\r\n          f.apply           \"total\",\r\n          f.used            \"used\",\r\n          f.qimo            \"qimo\" from\r\n(select u.*,\r\n          c.partner_num,\r\n          c.partner_name,\r\n          c.district_name,\r\n          c.region_name,\r\n          c.channel_id from\r\n(select dealer,\r\n       nvl(qi, 0) qichu,\r\n       nvl(apply, 0) apply,\r\n       nvl(used, 0) used,\r\n       nvl(qimo, 0) qimo\r\n  from (select *\r\n          from (select *\r\n                  from (select *\r\n                          from (select j.dealer_id dealer\r\n                                  from cx_int_rebatemg j where 1=1 ");
        if (condition.getSupplierId() != null) {
            sql.append(" and j.organization_id = ? ");
            args.add(condition.getSupplierId());
        }
        if (Beans.isNotEmpty((Object)condition.getApplyerId())) {
            sql.append(" and j.dealer_id = ? ");
            args.add(condition.getApplyerId());
        }
        sql.append("                                 group by j.dealer_id) qichu\r\n                          left join (select mg.dealer_id,\r\n                                           (money - nvl(used, 0)) qi\r\n                                      from (select j.dealer_id,\r\n                                                   sum(nvl(j.rebate_money, 0)) money\r\n                                              from cx_int_rebatemg j\r\n                                             where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                               and (j.state = '1' or j.state is null) ");
        if (condition.getStart_dates() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                            or  j.end_date is null)\r\n                                             group by dealer_id) mg\r\n                                      left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) -nvl(cexiao, 0)) used, ltotal.dealer_id\r\n                                                  from (select r.dealer_id,\r\n                                                               sum(case when t.state = '4' then  t.withheld_money end) cexiao,\r\n                                                               sum(case  when t.state = '3' then t.withheld_money end) hexiao,\r\n                                                               sum(case when t.state = '1' then t.withheld_money end) dingdan\r\n                                                          from (select * from CX_INT_REBATE t\r\n                                                                 where 1=1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and  t.created <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                   and t.rebate_id in\r\n                                                                       (select j.row_id from cx_int_rebatemg j\r\n                                                                         where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                           and (j.state = '1' or  j.state is null) ");
        if (condition.getStart_dates() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                                        or j.end_date is null))) t\r\n                                                          left join cx_int_rebatemg r on t.rebate_id =  r.row_id\r\n                                                         group by r.dealer_id) ltotal) lt\r\n                                        on mg.dealer_id = lt.dealer_id) qichu1\r\n                            on qichu.dealer = qichu1.dealer_id) sq\r\n                  left join (select j.dealer_id, sum(j.rebate_money) apply\r\n                              from cx_int_rebatemg j\r\n                             where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                               and (j.state = '1' or j.state is null)\r\n                             group by j.dealer_id) sq1\r\n                    on sq.dealer = sq1.dealer_id) used\r\n          left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) - nvl(cexiao, 0)) used,ltotal.dealer_id\r\n                      from (select sum(case when t.state = '1' then t.withheld_money end) dingdan,\r\n                                   sum(case when t.state = '3' then t.withheld_money  end) hexiao,\r\n                                   sum(case when t.state = '4' then t.withheld_money end) cexiao,\r\n                                   r.dealer_id\r\n                              from (select * from cx_int_rebate u\r\n                                     where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and  u.created <= ? ");
            args.add(condition.getStart_datee());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and u.created >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                   ) t\r\n                              left join cx_int_rebatemg r on t.rebate_id = r.row_id\r\n                             group by r.dealer_id) ltotal) used1\r\n            on used.dealer = used1.dealer_id) qimo\r\n  left join (select mg.dealer_id, (money - nvl(used, 0)) qimo\r\n               from (select j.dealer_id, sum(nvl(j.rebate_money, 0)) money\r\n                       from cx_int_rebatemg j\r\n                      where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                        and (j.state = '1' or j.state is null) ");
        if (condition.getStart_datee() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                     or j.end_date is null)\r\n                      group by dealer_id) mg\r\n               left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) - nvl(cexiao, 0)) used, ltotal.dealer_id\r\n                           from (select r.dealer_id,\r\n                                        sum(case when t.state = '4' then t.withheld_money end) cexiao,\r\n                                        sum(case when t.state = '3' then  t.withheld_money end) hexiao,\r\n                                        sum(case when t.state = '1' then t.withheld_money end) dingdan\r\n                                   from (select * from CX_INT_REBATE t\r\n                                          where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and t.created <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                            and t.rebate_id in\r\n                                                (select j.row_id from cx_int_rebatemg j\r\n                                                  where 1= 1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <=? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                                    and (j.state = '1' or  j.state is null) ");
        if (condition.getStart_datee() != null) {
            sql.append(" and(j.end_date >=? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                                                 or j.end_date is null))) t\r\n                                   left join cx_int_rebatemg r on t.rebate_id = r.row_id\r\n                                  group by r.dealer_id) ltotal) lt\r\n                 on mg.dealer_id = lt.dealer_id) qimo1\r\n    on qimo.dealer = qimo1.dealer_id)\r\n  u left join CX_PARTNERLIST_V c on u.dealer = c.partner_id)\r\n  f left join CX_CHANNEL_TYPE q on f.channel_id = q.row_id");
        Page p = this.newBaseDao.findPageBySql(sql.toString(), args, pageno, Beans.isNotEmpty((Object)condition.getPageSize()) ? condition.getPageSize() : Constant.DEFAULT_ROWS);
        return p;
    }

    public List<Map<String, Object>> getListTotalToExc(int pageno, IntRebatemgNewCondition condition) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num     \"partnercode\",\r\n          f.partner_name    \"partnername\",\r\n          q.name            \"channelname\",\r\n          f.district_name   \"districtname\",\r\n          f.region_name     \"regionname\",\r\n          f.qichu           \"plus\",\r\n          f.apply           \"total\",\r\n          f.used            \"used\",\r\n          f.qimo            \"qimo\" from\r\n(select u.*,\r\n          c.partner_num,\r\n          c.partner_name,\r\n          c.district_name,\r\n          c.region_name,\r\n          c.channel_id from\r\n(select dealer,\r\n       nvl(qi, 0) qichu,\r\n       nvl(apply, 0) apply,\r\n       nvl(used, 0) used,\r\n       nvl(qimo, 0) qimo\r\n  from (select *\r\n          from (select *\r\n                  from (select *\r\n                          from (select j.dealer_id dealer\r\n                                  from cx_int_rebatemg j where 1=1 ");
        if (condition.getSupplierId() != null) {
            sql.append(" and j.organization_id = ? ");
            args.add(condition.getSupplierId());
        }
        if (Beans.isNotEmpty((Object)condition.getApplyerId())) {
            sql.append(" and j.dealer_id = ? ");
            args.add(condition.getApplyerId());
        }
        sql.append("                                 group by j.dealer_id) qichu\r\n                          left join (select mg.dealer_id,\r\n                                           (money - nvl(used, 0)) qi\r\n                                      from (select j.dealer_id,\r\n                                                   sum(nvl(j.rebate_money, 0)) money\r\n                                              from cx_int_rebatemg j\r\n                                             where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                               and (j.state = '1' or j.state is null) ");
        if (condition.getStart_dates() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                            or  j.end_date is null)\r\n                                             group by dealer_id) mg\r\n                                      left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) -nvl(cexiao, 0)) used, ltotal.dealer_id\r\n                                                  from (select r.dealer_id,\r\n                                                               sum(case when t.state = '4' then  t.withheld_money end) cexiao,\r\n                                                               sum(case  when t.state = '3' then t.withheld_money end) hexiao,\r\n                                                               sum(case when t.state = '1' then t.withheld_money end) dingdan\r\n                                                          from (select * from CX_INT_REBATE t\r\n                                                                 where 1=1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and  t.created <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                   and t.rebate_id in\r\n                                                                       (select j.row_id from cx_int_rebatemg j\r\n                                                                         where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                           and (j.state = '1' or  j.state is null) ");
        if (condition.getStart_dates() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                                                        or j.end_date is null))) t\r\n                                                          left join cx_int_rebatemg r on t.rebate_id =  r.row_id\r\n                                                         group by r.dealer_id) ltotal) lt\r\n                                        on mg.dealer_id = lt.dealer_id) qichu1\r\n                            on qichu.dealer = qichu1.dealer_id) sq\r\n                  left join (select j.dealer_id, sum(j.rebate_money) apply\r\n                              from cx_int_rebatemg j\r\n                             where 1= 1 ");
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                               and (j.state = '1' or j.state is null)\r\n                             group by j.dealer_id) sq1\r\n                    on sq.dealer = sq1.dealer_id) used\r\n          left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) - nvl(cexiao, 0)) used,ltotal.dealer_id\r\n                      from (select sum(case when t.state = '1' then t.withheld_money end) dingdan,\r\n                                   sum(case when t.state = '3' then t.withheld_money  end) hexiao,\r\n                                   sum(case when t.state = '4' then t.withheld_money end) cexiao,\r\n                                   r.dealer_id\r\n                              from (select * from cx_int_rebate u\r\n                                     where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and  u.created <= ? ");
            args.add(condition.getStart_datee());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and u.created >= ? ");
            args.add(condition.getStart_dates());
        }
        sql.append("                                                   ) t\r\n                              left join cx_int_rebatemg r on t.rebate_id = r.row_id\r\n                             group by r.dealer_id) ltotal) used1\r\n            on used.dealer = used1.dealer_id) qimo\r\n  left join (select mg.dealer_id, (money - nvl(used, 0)) qimo\r\n               from (select j.dealer_id, sum(nvl(j.rebate_money, 0)) money\r\n                       from cx_int_rebatemg j\r\n                      where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                        and (j.state = '1' or j.state is null) ");
        if (condition.getStart_datee() != null) {
            sql.append(" and (j.END_DATE >= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                     or j.end_date is null)\r\n                      group by dealer_id) mg\r\n               left join (select (nvl(hexiao, 0) + nvl(dingdan, 0) - nvl(cexiao, 0)) used, ltotal.dealer_id\r\n                           from (select r.dealer_id,\r\n                                        sum(case when t.state = '4' then t.withheld_money end) cexiao,\r\n                                        sum(case when t.state = '3' then  t.withheld_money end) hexiao,\r\n                                        sum(case when t.state = '1' then t.withheld_money end) dingdan\r\n                                   from (select * from CX_INT_REBATE t\r\n                                          where 1=1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and t.created <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                            and t.rebate_id in\r\n                                                (select j.row_id from cx_int_rebatemg j\r\n                                                  where 1= 1 ");
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <=? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                                    and (j.state = '1' or  j.state is null) ");
        if (condition.getStart_datee() != null) {
            sql.append(" and(j.end_date >=? ");
            args.add(condition.getStart_datee());
        }
        sql.append("                                                                 or j.end_date is null))) t\r\n                                   left join cx_int_rebatemg r on t.rebate_id = r.row_id\r\n                                  group by r.dealer_id) ltotal) lt\r\n                 on mg.dealer_id = lt.dealer_id) qimo1\r\n    on qimo.dealer = qimo1.dealer_id)\r\n  u left join CX_PARTNERLIST_V c on u.dealer = c.partner_id)\r\n  f left join CX_CHANNEL_TYPE q on f.channel_id = q.row_id");
        List<Map<String, Object>> list = this.newBaseDao.findBySql(sql.toString(), args);
        return list;
    }

    public Page getListByMode(int pageno, IntRebatemgNewCondition condition, Map<String, String> map) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num \"partnercode\",f.partner_name \"partnername\",q.name \"channelname\",f.district_name \"districtname\",f.region_name \"regionname\",");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("f.").append(entry.getKey()).append(" \"").append(entry.getKey()).append("\",");
        }
        sql.append("f.other \"other\",f.total \"total\" from ").append("(select i.*,c.partner_num,c.partner_name,c.district_name,c.REGION_NAME,c.channel_id from ").append("(select j.Dealer_Id,");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("sum( case rebate_type when '").append(entry.getKey()).append("' THEN REBATE_MONEY ELSE 0 END ) ").append(entry.getKey()).append(",");
        }
        sql.append("sum( case  when rebate_type is null THEN REBATE_MONEY ELSE 0 END ) other ,").append("sum(REBATE_MONEY) total").append(" from CX_INT_REBATEMG j").append(" where 1 = 1 ").append(" and j.ORGANIZATION_ID = ?");
        args.add(condition.getSupplierId());
        sql.append(" and j.START_DATE <= ? and nvl(j.END_DATE,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sql.append(" and (j.state = '1' or j.state is null) ");
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            sql.append(" and j.product_type = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sql.append(" and j.Dealer_Id = ? ");
            args.add(condition.getApplyerId());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append(" GROUP BY DEALER_ID)  i  ").append(" left join CX_PARTNERLIST_V  c ").append(" on i.DEALER_ID  = c.partner_id) f ").append(" left join CX_CHANNEL_TYPE  q").append(" on f.channel_id = q.row_id");
        System.out.println("sql" + sql.toString());
        Page p = this.newBaseDao.findPageBySql(sql.toString(), args, pageno, Constant.DEFAULT_ROWS);
        return p;
    }

    public List<Map<String, Object>> getListByModeToExcNew(int pageno, IntRebatemgNewCondition condition, Map<String, String> map) {
        condition.setPageSize(Integer.MAX_VALUE);
        List list = this.getListByMode(pageno, condition, map).getList();
        return list;
    }

    public List<Map<String, Object>> getListByModeToExc(int pageno, IntRebatemgNewCondition condition, Map<String, String> map) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num \"partnercode\",f.partner_name \"partnername\",q.name \"channelname\",f.district_name \"districtname\",f.region_name \"regionname\",");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("f.").append(entry.getKey()).append(" \"").append(entry.getKey()).append("\",");
        }
        sql.append("f.other \"other\",f.total \"total\" from ").append("(select i.*,c.partner_num,c.partner_name,c.district_name,c.REGION_NAME,c.channel_id from ").append("(select j.Dealer_Id,");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("sum( case rebate_type when '").append(entry.getKey()).append("' THEN REBATE_MONEY ELSE 0 END ) ").append(entry.getKey()).append(",");
        }
        sql.append("sum( case  when rebate_type is null THEN REBATE_MONEY ELSE 0 END ) other ,").append("sum(REBATE_MONEY) total").append(" from CX_INT_REBATEMG j").append(" where 1 = 1 ").append(" and j.ORGANIZATION_ID = ?");
        args.add(condition.getSupplierId());
        sql.append(" and j.START_DATE <= ? and nvl(j.END_DATE,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sql.append(" and (j.state = '1' or j.state is null) ");
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            sql.append(" and j.product_type = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sql.append(" and j.Dealer_Id = ? ");
            args.add(condition.getApplyerId());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append(" GROUP BY DEALER_ID)  i  ").append(" left join CX_PARTNERLIST_V  c ").append(" on i.DEALER_ID  = c.partner_id) f ").append(" left join CX_CHANNEL_TYPE  q").append(" on f.channel_id = q.row_id");
        List<Map<String, Object>> list = this.newBaseDao.findBySql(sql.toString(), args);
        return list;
    }

    public List<RebateListExc> getListByListToExc(int pageno, IntRebatemgNewCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        if (condition.getRegionFilter().booleanValue()) {
            HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
            args.add(condition.getSupplierId());
            String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        } else {
            HQL.append(" and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                HQL.append(" and o.rebateType is null ");
            } else {
                HQL.append(" and o.rebateType = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            if (condition.getState().equals("2")) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            } else if (condition.getState().equals("3")) {
                HQL.append(" and o.endDate <= ? ");
                args.add(DateUtils.now());
            } else {
                if ("1".equals(condition.getState())) {
                    HQL.append(" and (o.state is null or o.state = ?) ");
                    args.add(condition.getState());
                } else if ("0".equals(condition.getState())) {
                    HQL.append(" and o.state = ? ");
                    args.add(condition.getState());
                }
                HQL.append(" and o.startDate <= ? and nvl(o.endDate,?) >= ? ");
                args.add(DateUtils.now());
                args.add(DateUtils.getEndTime());
                args.add(DateUtils.now());
            }
        }
        if (condition.getStart_dates() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(condition.getStart_datee());
        }
        HQL.append(" order by o. createDt desc");
        System.out.println("HQL" + HQL.toString());
        List listf = this.baseDao.findEntity(HQL.toString(), args.toArray());
        ArrayList<RebateListExc> list = new ArrayList<RebateListExc>();
        List inrebatelist = this.baseDao.findEntity(" from IntRebate ", IntRebate.class);
        ArrayList<String> inIdList = new ArrayList<String>();
        for (IntRebate in : inrebatelist) {
            inIdList.add(in.getRebateId());
        }
        for (Object objs : listf) {
            Object[] obj = (Object[])objs;
            IntRebatemg exctem = (IntRebatemg)obj[0];
            Customer cs = (Customer)obj[1];
            if (inIdList.contains(exctem.getId())) {
                for (IntRebate in : inrebatelist) {
                    if (!in.getRebateId().equals(exctem.getId())) continue;
                    RebateListExc exc = new RebateListExc();
                    exc.setUseDate(in.getCreateDt());
                    exc.setWithheldMoneyCurrent(in.getWithheldMoney());
                    exc.setOrderNo(this.checkEmp(in.getOrderNo()));
                    exc.setCreatorName(in.getCreatorName());
                    exc.setHisstate(in.getState() == 1 ? "\u4f7f\u7528" : (in.getState() == 3 ? "\u624b\u5de5\u6838\u9500" : (in.getState() == 4 ? "\u624b\u5de5\u64a4\u9500" : "\u64a4\u9500")));
                    exc.setRebateNo(exctem.getRebateNo());
                    exc.setOaCode(exctem.getOaCode());
                    exc.setRebateType(exctem.getRebateTypeName());
                    exc.setProducttype(exctem.getProducttypeName());
                    exc.setRebateMoney(exctem.getRebateMoney());
                    exc.setWithheldMoney(exctem.getWithheldMoney());
                    exc.setOvermoney(exctem.getOverMoney());
                    exc.setPartnerName(exctem.getApplyerName());
                    exc.setStartDate(exctem.getStartDate());
                    exc.setEndDate(exctem.getEndDate());
                    exc.setRemark(exctem.getRemark());
                    exc.setDistrictname(cs.getBigAreaName());
                    exc.setRegionname(cs.getAreaName());
                    list.add(exc);
                }
                continue;
            }
            RebateListExc exc = new RebateListExc();
            exc.setRebateNo(exctem.getRebateNo());
            exc.setOaCode(exctem.getOaCode());
            exc.setRebateType(exctem.getRebateTypeName());
            exc.setProducttype(exctem.getProducttypeName());
            exc.setRebateMoney(exctem.getRebateMoney());
            exc.setWithheldMoney(exctem.getWithheldMoney());
            exc.setOvermoney(exctem.getOverMoney());
            exc.setPartnerName(exctem.getApplyerName());
            exc.setStartDate(exctem.getStartDate());
            exc.setEndDate(exctem.getEndDate());
            exc.setRemark(exctem.getRemark());
            exc.setDistrictname(cs.getBigAreaName());
            exc.setRegionname(cs.getAreaName());
            list.add(exc);
        }
        return list;
    }

    public List<RebateListExc> getListByListToExcNew(int pageno, IntRebatemgNewCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        if (condition.getRegionFilter().booleanValue()) {
            HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
            args.add(condition.getSupplierId());
            String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        } else {
            HQL.append(" and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                HQL.append(" and o.rebateType is null ");
            } else {
                HQL.append(" and o.rebateType = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            if (condition.getState().equals("2")) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            } else if (condition.getState().equals("3")) {
                HQL.append(" and o.endDate <= ? ");
                args.add(DateUtils.now());
            } else if ("1".equals(condition.getState())) {
                HQL.append(" and (o.state is null or o.state = ?) ");
                args.add(condition.getState());
            } else if ("0".equals(condition.getState())) {
                HQL.append(" and o.state = ? ");
                args.add(condition.getState());
            }
        }
        if (condition.getStart_dates() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(condition.getStart_datee());
        }
        HQL.append(" order by o. createDt desc");
        System.out.println("HQL" + HQL.toString());
        List listf = this.baseDao.findEntity(HQL.toString(), args.toArray());
        ArrayList<RebateListExc> list = new ArrayList<RebateListExc>();
        List inrebatelist = this.baseDao.findEntity(" from IntRebate ", IntRebate.class);
        ArrayList<String> inIdList = new ArrayList<String>();
        for (IntRebate in : inrebatelist) {
            inIdList.add(in.getRebateId());
        }
        for (Object objs : listf) {
            Object[] obj = (Object[])objs;
            IntRebatemg exctem = (IntRebatemg)obj[0];
            Customer cs = (Customer)obj[1];
            if (inIdList.contains(exctem.getId())) {
                for (IntRebate in : inrebatelist) {
                    if (!in.getRebateId().equals(exctem.getId())) continue;
                    RebateListExc exc = new RebateListExc();
                    exc.setUseDate(in.getCreateDt());
                    exc.setWithheldMoneyCurrent(in.getWithheldMoney());
                    exc.setOrderNo(this.checkEmp(in.getOrderNo()));
                    exc.setCreatorName(in.getCreatorName());
                    exc.setHisstate(in.getState() == 1 ? "\u4f7f\u7528" : (in.getState() == 3 ? "\u624b\u5de5\u6838\u9500" : (in.getState() == 4 ? "\u624b\u5de5\u64a4\u9500" : "\u64a4\u9500")));
                    exc.setRebateNo(exctem.getRebateNo());
                    exc.setOaCode(exctem.getOaCode());
                    exc.setRebateType(exctem.getRebateTypeName());
                    exc.setProducttype(exctem.getProducttypeName());
                    exc.setRebateMoney(exctem.getRebateMoney());
                    exc.setWithheldMoney(exctem.getWithheldMoney());
                    exc.setOvermoney(exctem.getOverMoney());
                    exc.setPartnerName(exctem.getApplyerName());
                    exc.setStartDate(exctem.getStartDate());
                    exc.setEndDate(exctem.getEndDate());
                    exc.setRemark(exctem.getRemark());
                    exc.setDistrictname(cs.getBigAreaName());
                    exc.setRegionname(cs.getAreaName());
                    list.add(exc);
                }
                continue;
            }
            RebateListExc exc = new RebateListExc();
            exc.setRebateNo(exctem.getRebateNo());
            exc.setOaCode(exctem.getOaCode());
            exc.setRebateType(exctem.getRebateTypeName());
            exc.setProducttype(exctem.getProducttypeName());
            exc.setRebateMoney(exctem.getRebateMoney());
            exc.setWithheldMoney(exctem.getWithheldMoney());
            exc.setOvermoney(exctem.getOverMoney());
            exc.setPartnerName(exctem.getApplyerName());
            exc.setStartDate(exctem.getStartDate());
            exc.setEndDate(exctem.getEndDate());
            exc.setRemark(exctem.getRemark());
            exc.setDistrictname(cs.getBigAreaName());
            exc.setRegionname(cs.getAreaName());
            list.add(exc);
        }
        return list;
    }

    public List<RebateListExc> getListToExc(int pageno, IntRebatemgNewCondition condition) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" from IntRebatemg o,Customer c where 1=1 ");
        if (condition.getRegionFilter().booleanValue()) {
            HQL.append(" and c.supplierId = ? and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
            args.add(condition.getSupplierId());
            String sb = this.personnelService.getFRegionsByUserId(condition.getUserId());
            HQL.append(" and (c.bigAreaCode in ( ");
            HQL.append(sb);
            HQL.append(") or c.areaCode in ( ");
            HQL.append(sb);
            HQL.append(" ))");
        } else {
            HQL.append(" and c.applyerId = o.applyerId  and c.supplierId = o.supplierId");
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            HQL.append(" and o.applyerId = ? ");
            args.add(condition.getApplyerId());
        }
        if (StringUtils.isNotEmpty(condition.getSupplierId())) {
            HQL.append(" and o.supplierId = ? ");
            args.add(condition.getSupplierId());
        }
        if (StringUtils.isNotEmpty(condition.getRebateNo())) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + condition.getRebateNo() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getProducttype())) {
            HQL.append(" and o.producttype = ? ");
            args.add(condition.getProducttype());
        }
        if (StringUtils.isNotEmpty(condition.getMoneyType())) {
            HQL.append(" and o.moneyType = ? ");
            args.add(condition.getMoneyType());
        }
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                HQL.append(" and o.rebateType is null ");
            } else {
                HQL.append(" and o.rebateType = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            if (condition.getState().equals("2")) {
                HQL.append(" and (o.endDate <= ? or o.state = ?) ");
                args.add(DateUtils.now());
                args.add(condition.getState());
            } else {
                if ("1".equals(condition.getState())) {
                    HQL.append(" and (o.state is null or o.state = ?) ");
                    args.add(condition.getState());
                } else if ("0".equals(condition.getState())) {
                    HQL.append(" and o.state = ? ");
                    args.add(condition.getState());
                }
                HQL.append(" and o.startDate <= ? and nvl(o.endDate,?) >= ? ");
                args.add(DateUtils.now());
                args.add(DateUtils.getEndTime());
                args.add(DateUtils.now());
            }
        }
        if (condition.getStart_dates() != null) {
            HQL.append(" and o.startDate >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            HQL.append(" and o.startDate <= ? ");
            args.add(condition.getStart_datee());
        }
        HQL.append(" order by o. createDt desc");
        System.out.println("HQL" + HQL.toString());
        List listf = this.baseDao.findEntity(HQL.toString(), args.toArray());
        ArrayList<RebateListExc> list = new ArrayList<RebateListExc>();
        List inrebatelist = this.baseDao.findEntity(" from IntRebate ", IntRebate.class);
        ArrayList<String> inIdList = new ArrayList<String>();
        for (IntRebate in : inrebatelist) {
            inIdList.add(in.getRebateId());
        }
        for (Object objs : listf) {
            Object[] obj = (Object[])objs;
            IntRebatemg exctem = (IntRebatemg)obj[0];
            Customer cs = (Customer)obj[1];
            RebateListExc exc = new RebateListExc();
            exc.setRebateNo(exctem.getRebateNo());
            exc.setOaCode(exctem.getOaCode());
            exc.setRebateType(exctem.getRebateTypeName());
            exc.setProducttype(exctem.getProducttypeName());
            exc.setRebateMoney(exctem.getRebateMoney());
            exc.setWithheldMoney(exctem.getWithheldMoney());
            exc.setOvermoney(exctem.getOverMoney());
            exc.setPartnerName(exctem.getApplyerName());
            exc.setStartDate(exctem.getStartDate());
            exc.setEndDate(exctem.getEndDate());
            exc.setRemark(exctem.getRemark());
            exc.setDistrictname(cs.getBigAreaName());
            exc.setRegionname(cs.getAreaName());
            exc.setCloseCustomerData(cs.getEnddate());
            list.add(exc);
        }
        return list;
    }

    public Page getListByType(int pageno, IntRebatemgNewCondition condition, Map<String, String> map) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num \"partnercode\",f.partner_name \"partnername\",q.name \"channelname\",f.district_name \"districtname\",f.region_name \"regionname\",");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("f.").append(entry.getKey()).append(" \"").append(entry.getKey()).append("\",");
        }
        sql.append("f.other \"other\",f.total \"total\" from ").append("(select i.*,c.partner_num,c.partner_name,c.district_name,c.REGION_NAME,c.channel_id from ").append("(select j.Dealer_Id,");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("sum( case PRODUCT_TYPE when '").append(entry.getKey()).append("' THEN REBATE_MONEY ELSE 0 END ) ").append(entry.getKey()).append(",");
        }
        sql.append("sum( case  when PRODUCT_TYPE is null THEN REBATE_MONEY ELSE 0 END ) other ,").append("sum(REBATE_MONEY) total").append(" from CX_INT_REBATEMG j").append(" where 1 = 1 ").append(" and j.ORGANIZATION_ID = ?");
        args.add(condition.getSupplierId());
        sql.append(" and j.START_DATE <= ? and nvl(j.END_DATE,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sql.append(" and (j.state = '1' or j.state is null) ");
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                sql.append(" and j.rebate_type is null ");
            } else {
                sql.append(" and j.rebate_type = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sql.append(" and j.Dealer_Id = ? ");
            args.add(condition.getApplyerId());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append(" GROUP BY DEALER_ID)  i  ").append(" left join CX_PARTNERLIST_V  c ").append(" on i.DEALER_ID  = c.partner_id) f ").append(" left join CX_CHANNEL_TYPE  q").append(" on f.channel_id = q.row_id");
        System.out.println("sql" + sql.toString());
        Page p = this.newBaseDao.findPageBySql(sql.toString(), args, pageno, Constant.DEFAULT_ROWS);
        return p;
    }

    public List<Map<String, Object>> getListByTypeToExc(int pageno, IntRebatemgNewCondition condition, Map<String, String> map) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select f.partner_num \"partnercode\",f.partner_name \"partnername\",q.name \"channelname\",f.district_name \"districtname\",f.region_name \"regionname\",");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("f.").append(entry.getKey()).append(" \"").append(entry.getKey()).append("\",");
        }
        sql.append("f.other \"other\",f.total \"total\" from ").append("(select i.*,c.partner_num,c.partner_name,c.district_name,c.REGION_NAME,c.channel_id from ").append("(select j.Dealer_Id,");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sql.append("sum( case PRODUCT_TYPE when '").append(entry.getKey()).append("' THEN REBATE_MONEY ELSE 0 END ) ").append(entry.getKey()).append(",");
        }
        sql.append("sum( case  when PRODUCT_TYPE is null THEN REBATE_MONEY ELSE 0 END ) other ,").append("sum(REBATE_MONEY) total").append(" from CX_INT_REBATEMG j").append(" where 1 = 1 ").append(" and j.ORGANIZATION_ID = ?");
        args.add(condition.getSupplierId());
        sql.append(" and j.START_DATE <= ? and nvl(j.END_DATE,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        sql.append(" and (j.state = '1' or j.state is null) ");
        if (StringUtils.isNotEmpty(condition.getRebateType())) {
            if (condition.getRebateType().equals("othertype")) {
                sql.append(" and j.rebate_type is null ");
            } else {
                sql.append(" and j.rebate_type = ? ");
                args.add(condition.getRebateType());
            }
        }
        if (StringUtils.isNotEmpty(condition.getApplyerId())) {
            sql.append(" and j.Dealer_Id = ? ");
            args.add(condition.getApplyerId());
        }
        if (condition.getStart_dates() != null) {
            sql.append(" and j.START_DATE >= ? ");
            args.add(condition.getStart_dates());
        }
        if (condition.getStart_datee() != null) {
            sql.append(" and j.START_DATE <= ? ");
            args.add(condition.getStart_datee());
        }
        sql.append(" GROUP BY DEALER_ID)  i  ").append(" left join CX_PARTNERLIST_V  c ").append(" on i.DEALER_ID  = c.partner_id) f ").append(" left join CX_CHANNEL_TYPE  q").append(" on f.channel_id = q.row_id");
        System.out.println("sql" + sql.toString());
        List<Map<String, Object>> list = this.newBaseDao.findBySql(sql.toString(), args);
        return list;
    }

    public List<IntRebatemg> getOrgList(String supplierId, String date) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from IntRebatemg o where supplierId = ? ");
        ArrayList<String> args = new ArrayList<String>();
        args.add(supplierId);
        if (StringUtils.isNotEmpty(date)) {
            HQL.append(" and o.rebateNo like ? ");
            args.add("%" + date + "%");
        }
        HQL.append(" order by lastUpdateDt desc ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), IntRebatemg.class);
    }

    public List<IntRebatemg> getlist(String supplierId, String applyerId, Date findDate) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from IntRebatemg o where supplierId = ? and applyerId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(supplierId);
        args.add(applyerId);
        if (findDate != null) {
            findDate = DateUtils.getEndTime((Date)findDate);
        }
        HQL.append(" and startDate <= ? and nvl(endDate,?) >= ? ");
        args.add(findDate);
        args.add(DateUtils.getEndTime());
        args.add(findDate);
        HQL.append(" and (state is null or state = '1') ");
        HQL.append(" order by createDt ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), IntRebatemg.class);
    }

    public void update(IntRebatemg obj) {
        this.baseDao.update((Object)obj);
    }

    public IntRebatemg delete(String id, String updateRemark) {
        IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)id));
        intRebatemg.setEndDate(DateUtils.now());
        intRebatemg.setState("2");
        intRebatemg.setUpdateRemark(updateRemark);
        this.baseDao.update((Object)intRebatemg);
        return intRebatemg;
    }

    public Double[] getDiscount(String supplierId, String applyerId, Date date, Double[] _productMoney, Double[] _giftMoney, Integer precision) {
        List<IntRebatemg> list = this.getlist(supplierId, applyerId, date);
        double resultProductMoney = 0.0;
        double resultGiftMoney = 0.0;
        double availableProductMoney = 0.0;
        double availableGiftMoney = 0.0;
        double totalAvailableProductMoney = 0.0;
        double totalAvailableGiftMoney = 0.0;
        double productMoney = _productMoney[0] == null ? 0.0 : _productMoney[0];
        double freezeProductMoney = _productMoney[1] == null ? 0.0 : _productMoney[1];
        double giftMoney = _giftMoney[0] == null ? 0.0 : _giftMoney[0];
        double freezeGiftMoney = _giftMoney[1] == null ? 0.0 : _giftMoney[1];
        for (IntRebatemg r : list) {
            double over;
            double available;
            if ("PRODUCT".equals(r.getProducttype())) {
                available = MathUtils.div((Double)MathUtils.mul((Double)productMoney, (Double)r.getIndentMoneyPercent()), (Double)100.0);
                if (available > (over = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney()).doubleValue())) {
                    available = over;
                }
                available = available > 0.0 ? available : 0.0;
                availableProductMoney = MathUtils.add((Double)availableProductMoney, (Double)available);
                totalAvailableProductMoney += over;
                continue;
            }
            if (!"GIFT".equals(r.getProducttype())) continue;
            available = MathUtils.div((Double)MathUtils.mul((Double)giftMoney, (Double)r.getIndentMoneyPercent()), (Double)100.0);
            if (available > (over = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney()).doubleValue())) {
                available = over;
            }
            available = available > 0.0 ? available : 0.0;
            availableGiftMoney = MathUtils.add((Double)availableGiftMoney, (Double)available);
            totalAvailableGiftMoney += over;
        }
        totalAvailableProductMoney = MathUtils.sub((Double)totalAvailableProductMoney, (Double)freezeProductMoney);
        totalAvailableGiftMoney = MathUtils.sub((Double)totalAvailableGiftMoney, (Double)freezeGiftMoney);
        totalAvailableProductMoney = totalAvailableProductMoney < 0.0 ? 0.0 : totalAvailableProductMoney;
        totalAvailableGiftMoney = totalAvailableGiftMoney < 0.0 ? 0.0 : totalAvailableGiftMoney;
        availableGiftMoney = availableGiftMoney > giftMoney ? giftMoney : availableGiftMoney;
        availableProductMoney = availableProductMoney > productMoney ? productMoney : availableProductMoney;
        resultProductMoney = availableProductMoney > totalAvailableProductMoney ? totalAvailableProductMoney : availableProductMoney;
        double d = resultGiftMoney = availableGiftMoney > totalAvailableGiftMoney ? totalAvailableGiftMoney : availableGiftMoney;
        if (precision != null) {
            switch (precision) {
                case 0: {
                    resultProductMoney = MathUtils.getInt((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getInt((Double)resultGiftMoney);
                    break;
                }
                case 1: {
                    resultProductMoney = MathUtils.getPrecision1((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getPrecision1((Double)resultGiftMoney);
                    break;
                }
                case 2: {
                    resultProductMoney = MathUtils.getPrecision2((Double)resultProductMoney);
                    resultGiftMoney = MathUtils.getPrecision2((Double)resultGiftMoney);
                    break;
                }
            }
        }
        Double[] result = new Double[]{totalAvailableProductMoney, resultProductMoney, totalAvailableGiftMoney, resultGiftMoney};
        return result;
    }

    public void unuse(String orderId) {
        List list = this.baseDao.findEntity(" from IntRebate r where r.indentApplyId = ? and r.state = '1' ", new Object[]{orderId}, IntRebate.class);
        for (IntRebate r : list) {
            String rebateId = r.getRebateId();
            IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)rebateId));
            if (intRebatemg != null) {
                intRebatemg.setWithheldMoney(MathUtils.sub((Double)intRebatemg.getWithheldMoney(), (Double)Double.valueOf(r.getWithheldMoney())));
                this.baseDao.update((Object)intRebatemg);
            }
            this.baseDao.executeHQL(" update IntRebate set state = ? where id = ?", new Object[]{0, r.getId()});
        }
    }

    public void use(String orderId, String orderNo, String applyerId, String supplierId, String operaterId, double orderSum, double useSum, Date orderDate, String type) {
        double useed = 0.0;
        List<IntRebatemg> list = this.getlist(supplierId, applyerId, orderDate);
        for (IntRebatemg r : list) {
            if (!type.equals(r.getProducttype())) continue;
            if (useed == useSum) break;
            double c = MathUtils.format((Double)MathUtils.div((Double)MathUtils.mul((Double)r.getIndentMoneyPercent(), (Double)orderSum), (Double)100.0));
            if (c > MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney())) {
                c = MathUtils.sub((Double)r.getRebateMoney(), (Double)r.getWithheldMoney());
            }
            if (MathUtils.add((Double)useed, (Double)c) > useSum) {
                c = MathUtils.sub((Double)useSum, (Double)useed);
            }
            r.setWithheldMoney(MathUtils.add((Double)r.getWithheldMoney(), (Double)c));
            useed = MathUtils.add((Double)useed, (Double)c);
            this.baseDao.update((Object)r);
            if (c == 0.0) continue;
            IntRebate intRebate = new IntRebate();
            operaterId = operaterId == null ? "0-1" : operaterId;
            intRebate.setCreatorId(operaterId);
            intRebate.setLastUpdatorId(operaterId);
            intRebate.setIndentApplyId(orderId);
            intRebate.setOrderNo(orderNo);
            intRebate.setRebateId(r.getId());
            intRebate.setWithheldMoney(String.valueOf(c));
            intRebate.setState(1);
            this.baseDao.save((Object)intRebate);
        }
    }

    public List<IntRebate> getIntRebateHistoryById(String id) {
        List list = this.baseDao.findEntity(" from IntRebate where rebateId = ? order by createDt desc", (Object)id, IntRebate.class);
        return list;
    }

    public String saveIntRebate(IntRebate intRebate, Employee em) {
        double sub;
        IntRebatemg intRebatemg = (IntRebatemg)this.baseDao.get(IntRebatemg.class, (Serializable)((Object)intRebate.getRebateId()));
        if (intRebate.getState() == 3) {
            sub = Arith.add((double)intRebatemg.getWithheldMoney(), (double)new Double(intRebate.getWithheldMoney()));
        } else if (intRebate.getState() == 4) {
            sub = Arith.sub((double)intRebatemg.getWithheldMoney(), (double)new Double(intRebate.getWithheldMoney()));
            if (sub < 0.0) {
                return "overrangingsub";
            }
        } else {
            return "false";
        }
        if (Arith.sub((double)intRebatemg.getRebateMoney(), (double)sub) < 0.0) {
            return "overranging";
        }
        intRebatemg.setWithheldMoney(sub);
        this.baseDao.update((Object)intRebatemg);
        IntRebate entity = new IntRebate();
        entity.fillInitData(em);
        entity.setCreateDt(intRebate.getCreateDt());
        entity.setWithheldMoney(intRebate.getWithheldMoney());
        entity.setOrderNo(intRebate.getOrderNo());
        entity.setState(intRebate.getState());
        entity.setRebateId(intRebate.getRebateId());
        this.baseDao.save((Object)entity);
        return "true";
    }

    public String checkEmp(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public List<String> saveBatch(List<List<Object>> datas, Employee emp, HttpServletRequest request) {
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<IntRebatemg> intRebatemgList = new ArrayList<IntRebatemg>();
        int line = 1;
        for (List<Object> row : datas) {
            Date date;
            String name;
            int errorSize = errorList.size();
            IntRebatemg intRebatemg = new IntRebatemg();
            if (this.validataIsEmpty("\u4ea7\u54c1\u540d\u79f0", row.get(0), ++line, errorList)) {
                name = Cache.getDesByTypeAndDisposition("TCBJ_DISCOUNT_PRODUCT_TYPE", row.get(0).toString());
                if (StringUtils.isEmpty(name)) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setProducttype(name);
                if ("PRODUCT".equals(name)) {
                    intRebatemg.setIndentMoneyPercent(40.0);
                } else if ("GIFT".equals(name)) {
                    intRebatemg.setIndentMoneyPercent(100.0);
                } else if ("FULL".equals(name)) {
                    intRebatemg.setIndentMoneyPercent(null);
                }
            }
            if (this.validataIsEmpty("\u91d1\u989d\u7c7b\u578b", row.get(1), line, errorList)) {
                name = Cache.getItemType("TCBJ_FINE_TYPE", row.get(1).toString());
                if (StringUtils.isEmpty(name)) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u91d1\u989d\u7c7b\u578b\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setMoneyType(name);
            }
            if (this.validataIsEmpty("\u5ba1\u6279\u91d1\u989d", row.get(2), line, errorList)) {
                Double rebateMoney = 0.0;
                try {
                    rebateMoney = Double.parseDouble(row.get(2).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u5ba1\u6279\u91d1\u989d\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setRebateMoney(rebateMoney);
            }
            if (this.validataIsEmpty("\u6298\u8ba9\u7c7b\u578b", row.get(3), line, errorList)) {
                name = Cache.getItemType("TCBJ_PACT_EXPENSE_TYPE", row.get(3).toString());
                if (StringUtils.isEmpty(name)) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u6298\u8ba9\u7c7b\u578b\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setRebateType(name);
            }
            if (this.validataIsEmpty("\u5f00\u59cb\u65f6\u95f4", row.get(4), line, errorList)) {
                date = DateUtils.autoFormatDate((String)row.get(4).toString(), (String[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy_MM_dd"});
                if (date == null) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setStartDate(date);
            }
            if (Beans.isNotEmpty((Object)row.get(5))) {
                date = DateUtils.autoFormatDate((String)row.get(5).toString(), (String[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy_MM_dd"});
                if (date == null) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u6b63\u786e\uff01");
                }
                intRebatemg.setEndDate(DateUtils.getEndTime((Date)date));
            }
            if (this.validataIsEmpty("\u5ba2\u6237\u7f16\u53f7", row.get(6), line, errorList)) {
                Partner partner = Cache.getPartnerByNo(row.get(6).toString());
                if (Beans.isEmpty((Object)partner)) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u6b63\u786e\uff01");
                } else {
                    intRebatemg.setApplyerId(partner.getId());
                    intRebatemg.setAreaCode(partner.getAreaCode());
                }
            }
            if (Beans.isNotEmpty((Object)row.get(7))) {
                String remark = row.get(7).toString();
                if (remark.length() > 200) {
                    errorList.add("\u7b2c" + line + "\u884c\u4e2d\uff0c\u7533\u8bf7\u4e8b\u7531\u8fc7\u957f\uff01");
                } else {
                    intRebatemg.setRemark(remark);
                }
            }
            if (errorSize != errorList.size()) continue;
            intRebatemgList.add(intRebatemg);
        }
        if (Beans.isNotEmpty(errorList)) {
            return errorList;
        }
        for (IntRebatemg ir : intRebatemgList) {
            ir.fillInitData(emp);
            ir.setSupplierId(emp.getCurrentPartner().getId());
            ir.setState("0");
            ir.setRebateNo(this.orderNoService.maxNo(emp.getCurrentPartner().getNo(), "08"));
        }
        this.baseDao.save(intRebatemgList);
        request.setAttribute("intRebatemgs", intRebatemgList);
        return errorList;
    }

    public boolean validataIsEmpty(String name, Object data, int line, List<String> errorList) {
        if (Beans.isEmpty((Object)data)) {
            errorList.add("\u7b2c" + line + "\u884c" + name + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        return true;
    }
}

