/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.job;

import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.job.JobCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jobService")
public class JobService {
    @Autowired
    BaseDao baseDao;

    public void save(JobLog log) {
        this.baseDao.save((Object)log);
    }

    public JobLog get(String id) {
        return (JobLog)this.baseDao.get(JobLog.class, (Serializable)((Object)id));
    }

    public Page find(JobCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append(" from JobLog where orgId = ? ");
        args.add(condition.getOrgId());
        if (condition.getState() != null) {
            hql.append(" and state = ? ");
            args.add(condition.getState());
        }
        if (condition.getStartDt() != null) {
            hql.append(" and runDt >= ? ");
            args.add(condition.getStartDt());
        }
        if (condition.getEndDt() != null) {
            hql.append(" and runDt <= ? ");
            args.add(condition.getEndDt());
        }
        if (StringUtils.isNotEmpty(condition.getJobType())) {
            hql.append(" and jobType = ? ");
            args.add(condition.getJobType());
        }
        hql.append(" order by runDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
        return page;
    }
}

