/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.util.ActivityRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="activityStateJobService")
public class ActivityStateJobService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    JobService jobService;
    String orgId = StringUtils.getOrgId();

    @Scheduled(cron="0 0 2 * * ?")
    public void run() {
        if (this.orgId == null) {
            return;
        }
        this.runActivity();
    }

    public void runActivity() {
        String organization = StringUtils.getPrefix();
        long start = System.currentTimeMillis();
        try {
            List<Activity> conList = this.activityStateJob(organization, start);
            for (Activity activity : conList) {
                this.upDateState(organization, activity.getCode(), start);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.saveJob(start, 9, e.getMessage());
        }
    }

    public void saveJob(long start, int state, String message) {
        JobLog log = new JobLog(null, DateUtils.now(), null, "activityState");
        long end = System.currentTimeMillis();
        log.setState(state);
        log.setRemark(message);
        end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(this.orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    public List<Activity> activityStateJob(String organization, long start) {
        String url = String.valueOf(StringUtils.getActicity()) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", organization);
        map.put("endDate_end", DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd"));
        map.put("status", "1");
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        List<Activity> conList = new ArrayList<Activity>();
        if (body != null) {
            conList = (List)Jsons.toListBean((String)EsbAnalyUtil.getResults(body, "activityInfo"), Activity.class);
            Map<String, Object> errorCode = EsbAnalyUtil.returnErrorCode(body, null);
            if (errorCode == null || errorCode.get("success") == null) {
                this.saveJob(start, 9, "\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f,Job\u81ea\u52a8\u505c\u7528\u5931\u8d25!\u539f\u56e0\u5982\u4e0b\uff1a" + errorCode.get("error"));
            }
        }
        return conList;
    }

    public void upDateState(String organization, String code, long start) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("status", "2");
        map.put("lastUpdateMan", "JOB\u81ea\u52a8\u66f4\u65b0");
        String url = String.valueOf(StringUtils.getActicity()) + "ActivityApi/updateActivityStatus";
        map.put("organization", organization);
        StringBuffer hql = new StringBuffer();
        hql.append(" select o.no from OrderApply o,OrderActivityInfo c ");
        hql.append(" where o.state='2' and o.id=c.orderApplyId and c.activityId=? ");
        List list = this.baseDao.findEntity(hql.toString(), new Object[]{code}, Object.class);
        if (list.size() > 0) {
            this.saveJob(start, 9, "\u6d3b\u52a8\u7f16\u53f7:" + code + "\u7684\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f,Job\u81ea\u52a8\u505c\u7528\u5931\u8d25,\u539f\u56e0\u5982\u4e0b\uff1a\u8be5\u6d3b\u52a8\u5b58\u5728\u6709\u672a\u5904\u7406\u7684\u7ed1\u5b9a\u8ba2\u5355" + list.get(0).toString() + "\u7b49");
        } else {
            String body = ActivityRequestHelper.getInstance().sendBody(url, map);
            Map<String, Object> errorCode = EsbAnalyUtil.returnErrorCode(body, null);
            if (errorCode != null && errorCode.get("success") != null) {
                this.saveJob(start, 1, "\u6d3b\u52a8\u7f16\u53f7:" + code + "\u7684\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f,Job\u81ea\u52a8\u505c\u7528\u6210\u529f!");
            } else {
                this.saveJob(start, 9, "\u6d3b\u52a8\u7f16\u53f7:" + code + "\u7684\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\u671f,Job\u81ea\u52a8\u505c\u7528\u5931\u8d25!\u539f\u56e0\u5982\u4e0b\uff1a" + errorCode.get("error"));
            }
        }
    }
}

