/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.adjuststock.AdjustStockService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.AdjustStock;
import com.tcbj.crm.entity.AdjustStockDetails;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.entity.Stock;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitRepositoryJob {
    @Autowired
    SessionFactory sessionFactory2;
    @Autowired
    BaseDao baseDao;
    @Autowired
    JobService jobService;
    @Autowired
    ClientService clientService;
    @Autowired
    AdjustStockService adjustStockService;

    public void run() {
        this.run(StringUtils.getOrgId());
    }

    public void run(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "initrepository");
        long start = System.currentTimeMillis();
        try {
            String rtn = this.initPartnerStocks(orgId);
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    public String initPartnerStocks(String orgId) {
        List<Partner> partners = Cache.getPartnersBySupplierId(orgId);
        int count = 0;
        for (Partner partner : partners) {
            if (StringUtils.isEmpty(partner.getClientAppNo())) continue;
            String clientNo = this.subClientNo(partner.getClientAppNo());
            List<Stock> dssPartnerStock = this.getDssPartnerStocks(partner.getId(), clientNo);
            Storage defaultStorage = this.getPartnerDefaultStorage(partner.getId());
            if (dssPartnerStock.size() == 0 || defaultStorage == null) continue;
            List<Stock> cspPartnerStock = this.getCspPartnerStock(partner.getId());
            this.initParnterStock(partner.getId(), clientNo, dssPartnerStock, cspPartnerStock, defaultStorage);
            ++count;
        }
        return "\u901a\u8fc7\u76d8\u70b9\u5dee\u5f02\u66f4\u65b0\u4e86" + count + "\u4e2a\u7ecf\u9500\u5546\u7684\u5e93\u5b58";
    }

    private void initParnterStock(String partnerId, String clientNo, List<Stock> dssStocks, List<Stock> cspStocks, Storage defaultStorage) {
        AdjustStock adjustStock = this.constructAdjustStock(partnerId, clientNo, dssStocks, cspStocks, defaultStorage);
        this.adjustStockService.saveAndUpdateStock(adjustStock, "1-1");
    }

    private void clearPartnerStock(String partnerId) {
        String hql = " delete Stock where partnerId=? ";
        Object[] args = new Object[]{partnerId};
        this.baseDao.executeHQL(hql, args);
    }

    private Storage getPartnerDefaultStorage(String partnerId) {
        String hql = " from Storage where supplierId=? ";
        hql = String.valueOf(hql) + " order by isAcquiesce desc ";
        Object[] args = new Object[]{partnerId};
        List ss = this.baseDao.findEntity(hql, args, Storage.class);
        if (ss.size() > 0) {
            return (Storage)ss.get(0);
        }
        return null;
    }

    private List<Stock> getCspPartnerStock(String partnerId) {
        String hql = "from Stock where partnerId=?";
        Object[] args = new Object[]{partnerId};
        return this.baseDao.findEntity(hql, args, Stock.class);
    }

    private List<Stock> getDssPartnerStocks(String partnerId, String clientNo) {
        Session session = this.sessionFactory2.openSession();
        String sql2 = "select * from V_TrackPartnerRepository where zid='" + clientNo + "' ";
        ArrayList<Stock> partnerStocks = new ArrayList<Stock>();
        try {
            List list = session.createSQLQuery(sql2).list();
            int i = 0;
            while (i < list.size()) {
                Object[] row = (Object[])list.get(i);
                String repositoryCode = (String)row[1];
                String productNo = (String)row[3];
                Double quantity = Double.valueOf(String.valueOf(row[4]));
                Product product = Cache.getProductByNo(productNo);
                if (product != null) {
                    Stock stock = new Stock(null, repositoryCode, partnerId, product.getId(), quantity);
                    partnerStocks.add(stock);
                }
                ++i;
            }
            ArrayList<Stock> arrayList = partnerStocks;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            session.close();
        }
    }

    private String subClientNo(String clientNo) {
        int pos = clientNo.lastIndexOf(".");
        if (pos >= 0 && clientNo.length() > pos + 1) {
            clientNo = clientNo.substring(pos + 1);
        }
        return clientNo;
    }

    private AdjustStock constructAdjustStock(String partnerId, String clientNo, List<Stock> dssStocks, List<Stock> cspStocks, Storage defaultStorage) {
        AdjustStock adjustStock = new AdjustStock();
        adjustStock.setPartnerId(partnerId);
        adjustStock.setAdjustNumber(this.getNo(clientNo));
        adjustStock.setStorageId(defaultStorage.getId());
        adjustStock.setAdjustType("CHECK_ADJUST");
        adjustStock.setState("1");
        adjustStock.setCreateDt(DateUtils.now());
        adjustStock.setLastUpdateDt(DateUtils.now());
        adjustStock.setCreatorId("1-1");
        adjustStock.setLastUpdatorId("1-1");
        for (Stock dssStock : dssStocks) {
            AdjustStockDetails detail = new AdjustStockDetails();
            detail.setAdjustStockId(adjustStock.getId());
            detail.setProductId(dssStock.getProductId());
            detail.setStorageId(defaultStorage.getId());
            detail.setShopId(partnerId);
            detail.setState("1");
            detail.setReceiverId(partnerId);
            Double differ = this.calDiffer(dssStock, cspStocks);
            detail.setAdjustQuantity(differ);
            detail.setCreateDt(DateUtils.now());
            detail.setLastUpdateDt(DateUtils.now());
            detail.setCreatorId("1-1");
            detail.setLastUpdatorId("1-1");
            adjustStock.getAdjustStockDetailss().add(detail);
        }
        for (Stock cspStock : cspStocks) {
            boolean has = false;
            for (Stock dssStock : dssStocks) {
                if (!cspStock.getProductId().equals(dssStock.getProductId())) continue;
                has = true;
                break;
            }
            if (has) continue;
            AdjustStockDetails detail = new AdjustStockDetails();
            detail.setAdjustStockId(adjustStock.getId());
            detail.setProductId(cspStock.getProductId());
            detail.setAdjustQuantity(MathUtils.sub((Double)0.0, (Double)cspStock.getQuantity()));
            detail.setStorageId(defaultStorage.getId());
            detail.setShopId(partnerId);
            detail.setState("1");
            detail.setReceiverId(partnerId);
            detail.setCreateDt(DateUtils.now());
            detail.setLastUpdateDt(DateUtils.now());
            detail.setCreatorId("1-1");
            detail.setLastUpdatorId("1-1");
            adjustStock.getAdjustStockDetailss().add(detail);
        }
        return adjustStock;
    }

    private String getNo(String clientNo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        return String.valueOf(clientNo) + sdf.format(new Date());
    }

    private Double calDiffer(Stock dssStock, List<Stock> cspStocks) {
        Double dssQuantity = dssStock.getQuantity() == null ? 0.0 : dssStock.getQuantity();
        for (Stock cspStock : cspStocks) {
            if (!cspStock.getProductId().equals(dssStock.getProductId())) continue;
            Double cspQuantity = cspStock.getQuantity() == null ? 0.0 : cspStock.getQuantity();
            Double differ = MathUtils.sub((Double)dssQuantity, (Double)cspQuantity);
            return differ;
        }
        return dssQuantity;
    }
}

