/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.entity.Stock;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitRepositoryJobOld {
    @Autowired
    SessionFactory sessionFactory2;
    @Autowired
    BaseDao baseDao;
    @Autowired
    JobService jobService;
    @Autowired
    ClientService clientService;

    public void run() {
        this.run(StringUtils.getOrgId());
    }

    public void run(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "initrepository");
        long start = System.currentTimeMillis();
        try {
            String rtn = this._initRepository(orgId);
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    private Map<String, Partner> getPartners(String orgId) {
        List<Partner> partners = Cache.getPartnersBySupplierId(orgId);
        HashMap<String, Partner> partnerMap = new HashMap<String, Partner>();
        for (Partner partner : partners) {
            String clientNo = partner.getClientAppNo();
            if (StringUtils.isEmpty(clientNo)) continue;
            int pos = clientNo.lastIndexOf(".");
            if (pos > 0 && clientNo.length() > pos + 1) {
                clientNo = clientNo.substring(pos + 1);
            }
            partnerMap.put(clientNo, partner);
        }
        return partnerMap;
    }

    private String getInSql(Map<String, String> partnerIds) {
        StringBuffer sb = new StringBuffer();
        for (String key : partnerIds.keySet()) {
            String value = partnerIds.get(key);
            sb.append("'");
            sb.append(value);
            sb.append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private List<Storage> getPartnerStorages(Map<String, String> partnerIds) {
        String str = this.getInSql(partnerIds);
        String hql = " from Storage where 1=1 ";
        if (partnerIds.size() > 0) {
            hql = String.valueOf(hql) + " and supplierId in (" + str + ") ";
        }
        hql = String.valueOf(hql) + " order by isAcquiesce desc ";
        return this.baseDao.findEntity(hql, Storage.class);
    }

    private void clearPartnerStorages(Map<String, String> partnerIds) {
        String str = this.getInSql(partnerIds);
        String hql = " delete Storage where 1=1 ";
        if (partnerIds.size() > 0) {
            hql = String.valueOf(hql) + " and supplierId in (" + str + ") ";
        }
        this.baseDao.executeHQL(hql);
    }

    private void setRepository(Stock stock, List<Storage> storages) {
        if (storages == null) {
            return;
        }
        String partnerId = stock.getPartnerId();
        for (Storage s : storages) {
            if (!s.getSupplierId().equals(partnerId)) continue;
            stock.setStorageId(s.getId());
            return;
        }
    }

    private String _initRepository(String orgId) {
        Map<String, Partner> partnerMap = this.getPartners(orgId);
        Session session = this.sessionFactory2.openSession();
        String sql2 = "select * from V_TrackPartnerRepository";
        HashMap<String, String> partnerIds = new HashMap<String, String>();
        try {
            List list = session.createSQLQuery(sql2).list();
            ArrayList<Stock> stocks = new ArrayList<Stock>();
            int i = 0;
            while (i < list.size()) {
                Product product;
                Object[] row = (Object[])list.get(i);
                String cfr_ignored_0 = (String)row[0];
                String repositoryCode = (String)row[1];
                String productNo = (String)row[3];
                Double quantity = Double.valueOf(String.valueOf(row[4]));
                String partnerNo = (String)row[5];
                Partner partner = partnerMap.get(partnerNo);
                if (partner != null && (product = Cache.getProductByNo(productNo)) != null) {
                    Stock stock = new Stock(null, repositoryCode, partner.getId(), product.getId(), quantity);
                    partnerIds.put(partner.getId(), partner.getId());
                    stocks.add(stock);
                }
                ++i;
            }
            List<Storage> storages = this.getPartnerStorages(partnerIds);
            this.clearPartnerStorages(partnerIds);
            int count = 0;
            for (Stock stock : stocks) {
                this.setRepository(stock, storages);
                if (StringUtils.isEmpty(stock.getStorageId())) continue;
                ++count;
                this.baseDao.save((Object)stock);
            }
            String string = "\u66f4\u65b0\u4ea7\u54c1\u5e93\u5b58\u6570:" + count;
            return string;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            session.close();
        }
    }
}

