/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.jobImpl.DssService;
import com.tcbj.crm.jobImpl.InitRepositoryJob;
import com.tcbj.crm.jobImpl.InitWarningSummaryJob;
import com.tcbj.crm.jobImpl.OAFeeJob;
import com.tcbj.crm.jobImpl.PushOrderJob;
import com.tcbj.crm.jobImpl.TargetDataJob;
import com.tcbj.crm.jobImpl.TargetDataJobService;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/job"})
public class JobImplController
extends BaseController {
    @Autowired
    BaseDao baseDao;
    @Autowired
    TargetDataJobService targetDataJobService;
    @Autowired
    PushOrderJob pushOrderJob;
    @Autowired
    TargetDataJob targetDataJob;
    @Autowired
    InitRepositoryJob initRepositoryJob;
    @Autowired
    OAFeeJob oaFeeJob;
    @Autowired
    InitWarningSummaryJob initWarningSummaryJob;
    @Autowired
    JobService jobService;
    @Autowired
    DssService dssService;

    @RequestMapping(value={"/targetDataJobRun.do"}, method={RequestMethod.GET})
    public String run(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/targetDataJobRun.ftl";
    }

    @RequestMapping(value={"/targetDataJobRun.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result run_do(Model model, HttpServletRequest request) throws Exception {
        Integer year = null;
        Integer month = null;
        Employee me = this.getCurrentEmployee();
        if (StringUtils.isEmpty((Object)request.getParameter("year")) || StringUtils.isEmpty((Object)request.getParameter("month"))) {
            return this.getSuccessResult(null);
        }
        try {
            year = Integer.valueOf(request.getParameter("year"));
            month = Integer.valueOf(request.getParameter("month"));
            this.targetDataJob.grapSaleData(me.getCurrentPartner().getId(), year, month);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/initRepositoryJobRun.do"}, method={RequestMethod.GET})
    public String initRepositoryJobRun(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/initRepositoryJobRun.ftl";
    }

    @RequestMapping(value={"/initRepositoryJobRun.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result initRepositoryJobRun_do(Model model, HttpServletRequest request) throws Exception {
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        try {
            this.initRepositoryJob.run(orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/pushOrderJobRun.do"}, method={RequestMethod.GET})
    public String pushOrderJobRun(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/pushOrderJobRun.ftl";
    }

    @RequestMapping(value={"/pushOrderJobRun.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result pushOrderJobRun_do(Model model, HttpServletRequest request) throws Exception {
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        try {
            this.pushOrderJob.grapPushOrder(orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/grapOaFeeRun.do"}, method={RequestMethod.GET})
    public String grapOaFeeRun(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/grapOaFeeRun.ftl";
    }

    @RequestMapping(value={"/grapOaFeeRun.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result grapOaFeeRun_do(Model model, HttpServletRequest request) throws Exception {
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        try {
            this.oaFeeJob.run(orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/grapWarningSummary.do"}, method={RequestMethod.GET})
    public String grapWarningSummary(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/grapWarningSummaryRun.ftl";
    }

    @RequestMapping(value={"/grapWarningSummary.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result grapWarningSummary_do(Model model, HttpServletRequest request) throws Exception {
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        try {
            this.initWarningSummaryJob.run(orgId);
        }
        catch (Exception exception) {}
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/dssRun.do"}, method={RequestMethod.GET})
    public String dss(Model model, HttpServletRequest request) throws Exception {
        return "jobImpl/dssRun.ftl";
    }

    @RequestMapping(value={"/dssRun.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result dssPost(Model model, HttpServletRequest request) throws Exception {
        try {
            this.dssService.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getSuccessResult(null);
    }
}

