/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.SystemOrgService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.OrderInOutView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="orderOutStateJobService")
public class OrderOutStateJobService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    JobService jobService;
    @Autowired
    SystemOrgService systemOrgService;
    int batchSize = 900;

    @Scheduled(cron="0 0/10 * * * ?")
    public void run() {
        this.runSended(StringUtils.getOrgId());
    }

    public void runSended(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "updateOrderState");
        long start = System.currentTimeMillis();
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        try {
            int rtn = this.updateOrderStateJob(orgId, messageMap);
            if (rtn == -1) {
                log.setState(9);
                log.setRemark(messageMap.get("error").toString());
            } else {
                log.setState(1);
                log.setRemark("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u6210\u529f:" + rtn + "\u4e2a");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    public int updateOrderStateJob(String orgId, Map<String, Object> messageMap) {
        String url = String.valueOf(StringUtils.getEasStock()) + "querySaleIssueBill";
        Map<String, Object> map = this.sWP(orgId);
        HashMap<String, String> rm = new HashMap<String, String>();
        rm.put("jsonStr", Jsons.toJson(map));
        String body = EasRequestHelper.getInstance().sendBody(url, rm);
        messageMap.putAll(EsbAnalyUtil.returnErrorCode(body, null));
        if (Beans.isNotEmpty((Object)messageMap.get("error"))) {
            return -1;
        }
        List orderList = (List)Jsons.toListBean((String)EsbAnalyUtil.getResults(body, null), OrderInOutView.class);
        ArrayList<String> list = new ArrayList<String>();
        for (OrderInOutView orderInOutView : orderList) {
            list.add(orderInOutView.getNo());
        }
        if (list.size() > 0) {
            if (list.size() > this.batchSize) {
                int index = list.size() / this.batchSize;
                int left = list.size() % this.batchSize;
                int i = 1;
                while (i <= index) {
                    List newList = list.subList((i - 1) * this.batchSize, i * this.batchSize);
                    String ids = StringUtils.listToString(newList, "','");
                    this.baseDao.executeHQL(" update OrderApply set state = ? where no in ('" + ids + "')", new Object[]{TCBJEnum.AuditState.sended.getValue()});
                    ++i;
                }
                if (left > 0) {
                    List newList = list.subList(index * this.batchSize, index * this.batchSize + left);
                    String ids = StringUtils.listToString(newList, "','");
                    this.baseDao.executeHQL(" update OrderApply set state = ? where no in ('" + ids + "')", new Object[]{TCBJEnum.AuditState.sended.getValue()});
                }
            } else {
                String ids = StringUtils.listToString(list, "','");
                this.baseDao.executeHQL(" update OrderApply set state = ? where no in ('" + ids + "')", new Object[]{TCBJEnum.AuditState.sended.getValue()});
            }
        }
        return list.size();
    }

    public Map<String, Object> sWP(String orgId) {
        StringBuffer sql = new StringBuffer();
        sql.append("CRM_ORDER_NUMBER \"no\" ");
        StringBuffer where = new StringBuffer();
        LinkedHashMap<String, String> whereParams = new LinkedHashMap<String, String>();
        where.append(" where DELIVERED_STATUS=:DELIVERED_STATUS ");
        whereParams.put("DELIVERED_STATUS", "\u5df2\u53d1\u51fa");
        where.append(" and ORG_ID=:ORG_ID ");
        whereParams.put("ORG_ID", this.systemOrgService.getEasOrgIdByCrmOrgId(orgId));
        List list = this.baseDao.findEntity(" select no from OrderApply where state = '" + TCBJEnum.AuditState.balancePass.getValue() + "'", String.class);
        if (list.size() > 0) {
            if (list.size() > this.batchSize) {
                where.append(" and (");
                int index = list.size() / this.batchSize;
                int left = list.size() % this.batchSize;
                int i = 1;
                while (i <= index) {
                    List newList = list.subList((i - 1) * this.batchSize, i * this.batchSize);
                    String ids = StringUtils.listToString(newList, "','");
                    where.append(" CRM_ORDER_NUMBER in('" + ids + "') or ");
                    ++i;
                }
                if (left > 0) {
                    List newList = list.subList(index * this.batchSize, index * this.batchSize + left);
                    String ids = StringUtils.listToString(newList, "','");
                    where.append(" CRM_ORDER_NUMBER in('" + ids + "') or ");
                }
                where.delete(where.lastIndexOf("or") - 1, where.length());
                where.append(" )");
            } else {
                String ids = StringUtils.listToString(list, "','");
                where.append(" and CRM_ORDER_NUMBER in('").append(ids).append("')");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldType", new LinkedHashMap());
        map.put("sql", sql);
        map.put("where", where.toString());
        map.put("mapParams", whereParams);
        return map;
    }
}

