/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.OrderPushItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PartnerProduct;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.pushrule.PushRuleService;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushOrderJob {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ProductService productService;
    @Autowired
    StockService stockService;
    @Autowired
    ClientService clientService;
    @Autowired
    OrderApplyService orderApplyService;
    @Autowired
    PactMainService pactMainService;
    @Autowired
    PushRuleService pushRuleService;
    @Autowired
    JobService jobService;

    public void grapPushOrders() {
        this.grapPushOrder(StringUtils.getOrgId());
    }

    public void grapPushOrder(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "pushorder");
        long start = System.currentTimeMillis();
        try {
            String rtn = this._grapPushOrder();
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    /*
     * WARNING - void declaration
     */
    private String _grapPushOrder() {
        List<OrderPushItem> pushList = this.pushRuleService.getAllOrderPushItmes(null);
        int count = 0;
        for (OrderPushItem pushItem : pushList) {
            boolean bl;
            List<PartnerAddress> addressList;
            Product product;
            Object objs;
            String packCtrlFlg;
            String[] days;
            if ("N".equals(pushItem.getUseSale()) || StringUtils.isEmpty(pushItem.getSchedule()) || (days = pushItem.getSchedule().split(",")).length == 0) continue;
            ArrayList<String> daysList = new ArrayList<String>();
            String[] stringArray = days;
            int n = days.length;
            int n2 = 0;
            while (n2 < n) {
                String day = stringArray[n2];
                daysList.add(day.trim());
                ++n2;
            }
            Calendar c = Calendar.getInstance();
            if (!daysList.contains(String.valueOf(c.get(5)))) continue;
            String applyerId = pushItem.getApplyerId();
            String supplierId = pushItem.getSupplierId();
            Partner partner = Cache.getPartner(applyerId);
            Customer customer = this.clientService.getCustomer(supplierId, applyerId);
            String string = packCtrlFlg = "N".equals(customer.getPackCtrlFlg()) ? "N" : "Y";
            if ("N".equals(customer.getIsAdditionalCal()) || this.orderApplyService.hasPushOrder(supplierId, applyerId)) continue;
            Map<Object, Object> resultMap = new HashMap<String, Double>();
            List<PartnerProduct> ppList = this.productService.getProductStock(applyerId);
            PactMain contract = this.pactMainService.getPactMain(applyerId, supplierId, new Date());
            List<Object> products = this.productService.getPartnerProducts(applyerId, supplierId);
            HashMap<String, Product> myProduct = new HashMap<String, Product>();
            for (Object objects : products) {
                objs = (Object[])objects;
                product = (Product)objs[0];
                myProduct.put(product.getId(), product);
            }
            if ("Y".equals(pushItem.getUseSale())) {
                Double additionalRatio = Double.parseDouble(customer.getAdditionalRatio().toString());
                Double saleMonths = pushItem.getSaleMonths();
                Date endDate = new Date();
                Date startDate = DateUtils.getDateBeforeMonth((Date)endDate, (int)saleMonths.intValue());
                resultMap = this.orderApplyService.findProductApplyQuantitys(applyerId, supplierId, startDate, endDate, null);
                Set<Object> productIdSet = resultMap.keySet();
                for (String string2 : productIdSet) {
                    Double d = (Double)resultMap.get(string2);
                    d = MathUtils.m2((Double)MathUtils.mul((Double)(d / saleMonths), (Double)additionalRatio), (int)0);
                    resultMap.put(string2, d);
                }
            } else {
                for (Object objects : products) {
                    objs = (Object[])objects;
                    product = (Product)objs[0];
                    resultMap.put(product.getId(), 0.0);
                }
            }
            if ("Y".equals(pushItem.getUseApplyerStock())) {
                Map<String, Double> stockMap = this.stockService.getQuantityByPartner(applyerId);
                for (PartnerProduct pp : ppList) {
                    void var23_31;
                    Double resultCount = (Double)resultMap.get(pp.getProductId());
                    if (resultCount == null) {
                        resultCount = 0.0;
                    }
                    Double currentCount = 0.0;
                    if ("Y".equals(pushItem.getUseSupplierStock()) && (currentCount = stockMap.get(pp.getProductId())) == null) {
                        currentCount = 0.0;
                    }
                    resultCount = pp.getStockMax() != null && resultCount - currentCount > pp.getStockMax() ? Double.valueOf(pp.getStockMax() - currentCount) : Double.valueOf(resultCount - currentCount);
                    resultCount = resultCount < 0.0 ? 0.0 : resultCount;
                    resultMap.put(pp.getProductId(), resultCount);
                    Double d = 0.0;
                    if (pp.getStockMin() != null) {
                        Double d2 = pp.getStockMin();
                    }
                    if (!(resultCount + currentCount < var23_31.doubleValue())) continue;
                    resultCount = var23_31.doubleValue() - currentCount;
                }
            }
            OrderApply order = new OrderApply(null, applyerId, supplierId, TCBJEnum.OrderNature.buy.getValue(), TCBJEnum.AuditState.draft.getValue());
            order.setCurrencyCode("CNY");
            order.setSource("\u81ea\u52a8\u8865\u8d27");
            order.setOrgId(partner.getMasterOuId());
            order.setAreaCode(customer.getAreaCode());
            order.setTaxCode(customer.getSaleTax());
            order.setCreateDt(new Date());
            order.setIsReport(partner.getIsReport());
            order.setSettlementModeCode(customer.getSettlementModeCode());
            order.setDeliveryLevelCode(customer.getDeliveryLevelCode());
            order.setOrderTypeCode(customer.getOrderTypeCode());
            order.setIsDeliveryFreezed(customer.getIsDeliveryFreezed());
            order.setDeliveryCode(customer.getDeliveryCode());
            order.setIsCreditManaged(customer.getIsCreditManaged());
            order.setContractNo(contract.getPactNo());
            order.setSalesman(customer.getCityManagerId());
            order.setRelatedApplyerId(customer.getRelatedDelearId());
            if (customer.getReceiptAddresses() != null && customer.getReceiptAddresses().size() > 0) {
                PartnerAddress address = customer.getReceiptAddresses().get(0);
                order.setContacts(address.getContactCode());
                order.setPhone(address.getContactPhone());
                order.setShippingAddress(address.getAddress());
                order.setHarvestWarehouse(address.getHarvestWarehouse());
                order.setDisApplyerId(address.getDisDelearId());
            }
            if ((addressList = customer.getReceiptAddresses()) != null && addressList.size() > 0) {
                PartnerAddress pa = addressList.get(0);
                order.setShippingAddress(pa.getAddress());
                order.setContacts(pa.getContactCode());
                order.setPhone(pa.getContactPhone());
            }
            this.baseDao.save((Object)order);
            ++count;
            Set<Object> productIdSet = resultMap.keySet();
            double allQuantity = 0.0;
            boolean bl2 = false;
            for (String string3 : productIdSet) {
                Double quantity = (Double)resultMap.get(string3);
                if (quantity == 0.0 || myProduct.get(string3) == null || !"PRODUCT".equals(Cache.getProduct(string3).getOrderProdType().toUpperCase())) continue;
                OrderApplyItem item = new OrderApplyItem();
                item.setProductId(string3);
                item.setQuantity(quantity);
                item.setOrderApplyId(order.getId());
                item.setCreateDt(new Date());
                item.setCreatorId("0-2");
                item.setLastUpdateDt(new Date());
                item.setLastUpdatorId("0-2");
                Product product2 = Cache.getProduct(string3);
                if (product2 == null) continue;
                if (packCtrlFlg.equals("Y")) {
                    Double minUnit = product2.getMinUnit();
                    if (quantity < minUnit) continue;
                    quantity = quantity - quantity % minUnit;
                    item.setQuantity(quantity);
                }
                allQuantity += quantity.doubleValue();
                item.setUnitCode(product2.getUnitCode() == null ? " " : product2.getUnitCode());
                this.baseDao.save((Object)item);
                bl = true;
            }
            if (!bl) {
                this.baseDao.delete((Object)order);
                --count;
                continue;
            }
            order.setQuantity(allQuantity);
            this.baseDao.update((Object)order);
        }
        return "\u63a8\u9001\u8ba2\u5355\u4e2a\u6570:" + count;
    }
}

