/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.jobImpl.TargetDataJobService;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TargetDataJob {
    @Autowired
    BaseDao baseDao;
    @Autowired
    TargetDataJobService targetDataJobService;
    @Autowired
    JobService jobService;

    public void grapSaleDatas() {
        int year = DateUtils.getYear();
        int month = DateUtils.getMonth();
        this.grapSaleData(StringUtils.getOrgId(), year, month);
    }

    public void grapActivityAmount() {
    }

    public void grapSaleData(String orgId, Integer year, Integer month) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "targetdata");
        long start = System.currentTimeMillis();
        try {
            String rtn = this.targetDataJobService.grapSaleDatas(orgId, year, month);
            log.setState(1);
            log.setRemark(rtn);
        }
        catch (Exception e) {
            log.setState(9);
            log.setRemark(e.getMessage());
        }
        long end = System.currentTimeMillis();
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }
}

