/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.entity.TargetData;
import com.tcbj.crm.view.Customer;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="targetDataJobService")
public class TargetDataJobService {
    @Autowired
    BaseDao baseDao;

    private List<Object[]> getSaleDatas(String orgId, int year, int month) {
        String startDt = String.valueOf(year) + "-" + month + "-01";
        String endDt = null;
        int days = DateUtils.getDaysByYearMonth((int)year, (int)month);
        endDt = days > 9 ? String.valueOf(year) + "-" + month + "-" + days : String.valueOf(year) + "-" + month + "-0" + days;
        String HQL = " SELECT NOTE.CUSTOMER_NUMBER,SUM(LINE.SHIP_QUANTITY*LINE.SALE_PRICE) amount  FROM CX_DELIVERED_NOTE_IFACE NOTE,  CX_DELIVERED_NOTE_LINE_IFACE LINE  WHERE LINE.DELIVERED_ID = NOTE.DELIVERED_ID AND  NOTE.MASTER_OU_ID='" + orgId + "' AND " + " NOTE.TRANSACTION_DATE > TO_DATE('" + startDt + "', 'yyyy-MM-dd') AND " + " NOTE.TRANSACTION_DATE<=TO_DATE('" + endDt + "','yyyy-MM-dd') AND " + " NOTE.source_system = 'EAS' AND " + " NOTE.target_system='CRM' " + " GROUP BY NOTE.CUSTOMER_NUMBER ";
        return this.baseDao.findBySql(HQL);
    }

    private List<Customer> getCustomers(String orgId) {
        Object[] args = new Object[]{orgId};
        return this.baseDao.findEntity("from Customer where supplierId=?", args, Customer.class);
    }

    private Customer getCustomer(List<Customer> customers, String no) {
        for (Customer customer : customers) {
            if (!StringUtils.isNotEmpty(customer.getExtCode()) || !customer.getExtCode().equals(no)) continue;
            return customer;
        }
        return null;
    }

    private TargetData createTargetData(Customer customer, String orgId, Double amount, int year, int month) {
        TargetData data = new TargetData();
        data.setApplyerId(customer.getApplyerId());
        data.setAreaId(customer.getAreaCode());
        data.setBigareaId(customer.getBigAreaCode());
        data.setChannelId(customer.getPartnerChnlType());
        data.setCreateDt(DateUtils.now());
        data.setCreatorId("");
        data.setLastUpdateDt(DateUtils.now());
        data.setLastUpdatorId("");
        data.setYear(Long.valueOf(year));
        data.setType("SAL_TARGET");
        data.setSupplierId(orgId);
        data.setM1(0.0);
        data.setM2(0.0);
        data.setM3(0.0);
        data.setM4(0.0);
        data.setM5(0.0);
        data.setM6(0.0);
        data.setM7(0.0);
        data.setM8(0.0);
        data.setM9(0.0);
        data.setM10(0.0);
        data.setM11(0.0);
        data.setM12(0.0);
        this.setMonthAmount(data, month, amount);
        return data;
    }

    private void setMonthAmount(TargetData data, int month, Double amount) {
        if (data == null) {
            return;
        }
        switch (month) {
            case 1: {
                data.setM1(amount);
                break;
            }
            case 2: {
                data.setM2(amount);
                break;
            }
            case 3: {
                data.setM3(amount);
                break;
            }
            case 4: {
                data.setM4(amount);
                break;
            }
            case 5: {
                data.setM5(amount);
                break;
            }
            case 6: {
                data.setM6(amount);
                break;
            }
            case 7: {
                data.setM7(amount);
                break;
            }
            case 8: {
                data.setM8(amount);
                break;
            }
            case 9: {
                data.setM9(amount);
                break;
            }
            case 10: {
                data.setM10(amount);
                break;
            }
            case 11: {
                data.setM11(amount);
                break;
            }
            case 12: {
                data.setM12(amount);
            }
        }
    }

    private List<TargetData> getTargetDatas(String orgId, int year) {
        String hql = " from TargetData where supplierId=? and year=? ";
        Object[] args = new Object[]{orgId, (long)year};
        return this.baseDao.findEntity(hql, args, TargetData.class);
    }

    private TargetData getTargetData(Customer customer, List<TargetData> datas) {
        for (TargetData data : datas) {
            if (!StringUtils.isNotEmpty(data.getApplyerId()) || !data.getApplyerId().equals(customer.getApplyerId())) continue;
            return data;
        }
        return null;
    }

    public String grapSaleDatas(String orgId, int year, int month) {
        List<Customer> customers = this.getCustomers(orgId);
        List<TargetData> datas = this.getTargetDatas(orgId, year);
        List<Object[]> rtn = this.getSaleDatas(orgId, year, month);
        int addCounts = 0;
        int updateCounts = 0;
        for (Object[] obj : rtn) {
            String no = (String)obj[0];
            Customer customer = this.getCustomer(customers, no);
            if (customer == null) continue;
            Double amount = ((BigDecimal)obj[1]).doubleValue();
            TargetData data = this.getTargetData(customer, datas);
            if (data == null) {
                data = this.createTargetData(customer, orgId, amount, year, month);
                this.baseDao.save((Object)data);
                ++addCounts;
                continue;
            }
            this.setMonthAmount(data, month, amount);
            this.baseDao.update((Object)data);
            ++updateCounts;
        }
        return "\u6293\u53d6\u4e86" + year + "\u5e74" + month + "\u6708\u4efd" + rtn.size() + "\u4e2a\u7ecf\u9500\u5546\u7684\u9500\u552e\u6570\u636e , \u5176\u4e2d\u65b0\u589e" + addCounts + "\u4e2a , \u4fee\u6539" + updateCounts + "\u4e2a";
    }
}

