/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.jobImpl;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.JobLog;
import com.tcbj.crm.entity.PartnerAndShop;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.job.JobService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.siebel.service.PartnerSiebelService;
import com.tcbj.crm.siebel.service.ShopSiebelService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="updateShopOrPartnerStateJob")
public class UpdateShopOrPartnerStateJob {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PartnerService partnerService;
    @Autowired
    JobService jobService;
    @Autowired
    ShopService shopSerivce;
    @Autowired
    StorageService storageService;

    public void run() {
        this.runSended(StringUtils.getOrgId());
    }

    public void runSended(String orgId) {
        if (Cache.getPartner(orgId) == null) {
            return;
        }
        JobLog log = new JobLog(null, DateUtils.now(), null, "DSSPartnerShop");
        long start = System.currentTimeMillis();
        HashMap<String, String> failRecord = new HashMap<String, String>();
        try {
            this.updateShopOrPartnerState(failRecord);
            log.setState(1);
        }
        catch (Exception e) {
            failRecord.put("failno", "\u672a\u77e5\u9519\u8bef,\u8bf7\u8ddf\u8fdb:" + e.getMessage());
            e.printStackTrace();
            log.setState(9);
        }
        String remark = "";
        for (String no : failRecord.keySet()) {
            remark = String.valueOf(remark) + no + (String)failRecord.get(no) + "<br/>";
        }
        long end = System.currentTimeMillis();
        log.setRemark(remark);
        log.setUseTime(end - start);
        log.setOrgId(orgId);
        log.setRunType(1);
        this.jobService.save(log);
    }

    private int updateShopOrPartnerState(Map<String, String> failRecord) {
        String msg = "select ARG2,PHONE,ID from sms_mo where mo_biztype = 'SMSApproval' and ARG1='DXSP' and MO_STATE = 'N' ";
        List msgs = this.baseDao.findBySql(msg);
        int i = 0;
        for (Object[] nos : msgs) {
            String no = (String)nos[0];
            String phone = (String)nos[1];
            String id = ((BigDecimal)nos[2]).toString();
            List partnerAndShops = this.baseDao.findEntity("from PartnerAndShop where no = '" + no + "' ", PartnerAndShop.class);
            if (partnerAndShops.size() == 0) {
                this.fillBack(id.toString());
                failRecord.put(no, "\u4e2d\u95f4\u5e93\u65e0\u8be5\u8bb0\u5f55\uff01");
                continue;
            }
            if (partnerAndShops.size() > 1) {
                this.fillBack(id.toString());
                failRecord.put(no, "\u4e2d\u95f4\u5e93\u6709\u591a\u6761\u8be5\u8bb0\u5f55\uff01");
                continue;
            }
            PartnerAndShop partnerAndShop = (PartnerAndShop)partnerAndShops.get(0);
            if ("Partner".equals(partnerAndShop.getType())) {
                PartnerSiebelService ss = new PartnerSiebelService();
                PartnerRecord partnerRecord = this.partnerService.getFirstPartnerByNo(no);
                if (partnerRecord != null) {
                    if (TCBJEnum.ApplyState.pass.getValue().equals(partnerRecord.getApplyState())) {
                        this.sendMessage(phone, "\u7ecf\u9500\u5546:" + partnerRecord.getName() + "[" + no + "]\u5ba1\u6279\u6210\u529f\uff0c\u5df2\u7ecf\u751f\u6548\uff01");
                        this.fillBack(id);
                        failRecord.put(no, ":\u5df2\u7ecf\u5ba1\u6279\u6210\u529f!");
                        continue;
                    }
                    if (!TCBJEnum.ApplyState.audit.getValue().equals(partnerRecord.getApplyState())) {
                        this.fillBack(id);
                        failRecord.put(no, ":\u4e0d\u662f\u5f85\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u6539\uff01");
                        continue;
                    }
                } else {
                    this.fillBack(id);
                    failRecord.put(no, ":\u672c\u5730\u8868\u4e2d\u65e0\u8be5\u8bb0\u5f55!");
                    continue;
                }
                List siebelPartners = this.baseDao.findEntity("from Partner where no = '" + no + "'", Partner.class);
                if (siebelPartners.size() == 0) {
                    this.fillBack(id.toString());
                    failRecord.put(no, "siebel\u4e2d\u65e0\u8be5\u8bb0\u5f55\uff01");
                    continue;
                }
                if (siebelPartners.size() > 1) {
                    this.fillBack(id.toString());
                    failRecord.put(no, "siebel\u4e2d\u6709\u591a\u6761\u8be5\u8bb0\u5f55\uff01");
                    continue;
                }
                String applyType = partnerRecord.getApplyType();
                int toSiebelType = 1;
                if (ShopEnum.ApplyType.add.getValue().equals(applyType)) {
                    toSiebelType = 0;
                }
                String siebelId = "";
                try {
                    siebelId = ss.addOrUpdatePartnerToSiebel(partnerRecord, toSiebelType);
                }
                catch (Exception e) {
                    String result = "";
                    if (e instanceof AppException) {
                        AppException ae = (AppException)e;
                        Object[] obj = ae.getArgs();
                        result = (String)obj[0];
                    } else {
                        result = e.getMessage();
                    }
                    String type = toSiebelType == 0 ? "\u65b0\u589e" : "\u4fee\u6539";
                    failRecord.put(no, ":\u8c03\u7528siebel\u63a5\u53e3\u51fa\u9519" + type + result);
                    this.fillBack(id);
                    continue;
                }
                String hql = "update PartnerRecord set applyState=?,opinion=?,auditorId=?,auditDt=?,siebelId=? where id=?";
                Object[] args = new Object[]{TCBJEnum.ApplyState.pass.getValue(), "\u77ed\u4fe1\u5ba1\u6279", "0-1", DateUtils.now(), siebelId, partnerRecord.getId()};
                this.baseDao.executeHQL(hql, args);
                String hql2 = "update PartnerAndShop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=?,dssIfaceFlag=?,sfaIfaceFlag=? where no=? and type = 'Partner' ";
                Object[] args2 = new Object[]{TCBJEnum.ApplyState.pass.getValue(), "\u77ed\u4fe1\u5ba1\u6279", "0-1", DateUtils.now(), siebelId, "0", "0", partnerRecord.getNo()};
                this.baseDao.executeHQL(hql2, args2);
                this.sendMessage(phone, "\u7ecf\u9500\u5546:" + partnerRecord.getName() + "[" + no + "]\u5ba1\u6279\u6210\u529f\uff0c\u5df2\u7ecf\u751f\u6548\uff01");
                this.fillBack(id);
                ++i;
                continue;
            }
            Shop shop = this.shopSerivce.getFirstShopByShopNo(no, null);
            if (shop == null) {
                this.fillBack(id);
                failRecord.put(no, ":\u672c\u5730\u8868\u4e2d\u65e0\u8be5\u8bb0\u5f55!");
                continue;
            }
            List siebelShops = this.baseDao.findEntity("from ShopView where shopNumber = '" + no + "' ", ShopView.class);
            if (siebelShops.size() == 0) {
                this.fillBack(id);
                failRecord.put(no, ":siebel\u65e0\u8be5\u8bb0\u5f55!");
                continue;
            }
            if (siebelShops.size() > 1) {
                this.fillBack(id);
                failRecord.put(no, ":siebel\u4e2d\u6709\u591a\u6761\u8be5\u8bb0\u5f55!");
                continue;
            }
            if (ShopEnum.ApproveState.pass.getValue().equals(shop.getApproveState())) {
                this.sendMessage(phone, "\u95e8\u5e97:" + shop.getShopName() + "[" + no + "]\u5ba1\u6279\u6210\u529f\uff0c\u5df2\u7ecf\u751f\u6548\uff01");
                this.fillBack(id);
                failRecord.put(no, ":\u8be5\u95e8\u5e97\u5df2\u7ecf\u5ba1\u6279\u6210\u529f!");
                continue;
            }
            if (!ShopEnum.ApproveState.audit.getValue().equals(shop.getApproveState())) {
                this.fillBack(id);
                failRecord.put(no, ":\u4e0d\u662f\u5f85\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u6539\uff01");
                continue;
            }
            ShopSiebelService ss = new ShopSiebelService();
            String siebleType = "update";
            if (ShopEnum.ApplyType.add.getValue().equals(partnerAndShop.getApplyType())) {
                siebleType = "insert";
            }
            Employee me = new Employee();
            EmployeePartner currentPartner = new EmployeePartner();
            Partner parentPartner = Cache.getPartner(shop.getParentDealerId());
            currentPartner.setOrganizationid(parentPartner.getMasterOuId());
            me.setCurrentPartner(currentPartner);
            me.setId("0-1");
            String siebelId = "";
            try {
                siebelId = ss.addOrUpdateShopToSiebel(shop, siebleType, me);
            }
            catch (Exception e) {
                String result = "";
                if (e instanceof AppException) {
                    AppException ae = (AppException)e;
                    Object[] obj = ae.getArgs();
                    result = (String)obj[0];
                } else {
                    result = e.getMessage();
                }
                failRecord.put(no, ":\u8c03\u7528siebel\u63a5\u53e3\u51fa\u9519-" + siebleType + result);
                this.fillBack(id);
                continue;
            }
            if ("insert".equals(siebleType)) {
                this.storageService.addStorage(siebelId, me);
            }
            String hql = "update Shop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=? where id=?";
            Object[] args = new Object[]{TCBJEnum.ApplyState.pass.getValue(), "\u77ed\u4fe1\u5ba1\u6279", "0-1", DateUtils.now(), siebelId, shop.getId()};
            this.baseDao.executeHQL(hql, args);
            String hql2 = "update PartnerAndShop set approveState=?,approveRemark=?,auditorId=?,auditDate=?,siebelShopId=?,dssIfaceFlag=?,sfaIfaceFlag=? where crmId=?";
            Object[] args2 = new Object[]{TCBJEnum.ApplyState.pass.getValue(), "\u77ed\u4fe1\u5ba1\u6279", "0-1", DateUtils.now(), siebelId, "0", "0", shop.getId()};
            this.baseDao.executeHQL(hql2, args2);
            this.sendMessage(phone, "\u95e8\u5e97:" + shop.getShopName() + "[" + no + "]\u5ba1\u6279\u6210\u529f\uff0c\u5df2\u7ecf\u751f\u6548\uff01");
            this.fillBack(id);
            ++i;
        }
        return i;
    }

    private void sendMessage(String phone, String msg) {
        String sql = "insert into sms_send(massID,phone,content,state,submit_time,sendtype,Username,Password,Biz_type) values(?,?,?,?,?,?,?,?,?)";
        Object[] args = new Object[]{UUIDUtils.getId(), phone, msg, "0", new Date(), "1", "admin", "123456", "1"};
        this.baseDao.executeSQL(sql, args);
    }

    private void fillBack(String id) {
        String sql = "update sms_mo set MO_STATE = 'Y' where ID = '" + id + "'";
        this.baseDao.executeSQL(sql);
    }
}

