/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.log;

import com.tcbj.crm.base.BaseCondition;
import com.tcbj.crm.log.LogCondition;
import com.tcbj.crm.log.LogService;
import com.tcbj.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/log"})
public class LogController
extends BaseCondition {
    @Autowired
    LogService logService;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @RequestMapping(value={"/find.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String find(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, LogCondition condition, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("page", (Object)this.logService.find(condition));
        model.addAttribute("condition", (Object)condition);
        return "log/list.ftl";
    }

    @RequestMapping(value={"/reportHour.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String reportHour(LogCondition condition, Model model, HttpServletRequest request) throws Exception {
        String models = "";
        if (StringUtils.isNotEmpty(request.getParameter("models"))) {
            models = new String(request.getParameter("models").getBytes("iso8859-1"), "utf-8");
        }
        List<Object[]> list = this.logService.reportHour(this.sdf.format(Calendar.getInstance().getTime()), models);
        StringBuilder hours = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (Object[] objs : list) {
            hours.append("\"").append(objs[0]).append("\"").append(",");
            values.append(objs[1].toString()).append(",");
        }
        if (list.size() > 0) {
            hours.deleteCharAt(hours.length() - 1);
            values.deleteCharAt(values.length() - 1);
        }
        model.addAttribute("hours", (Object)hours.toString());
        model.addAttribute("values", (Object)values.toString());
        return "log/reportHour.ftl";
    }

    @RequestMapping(value={"/reportModel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String reportModer(LogCondition condition, Model model, HttpServletRequest request) throws Exception {
        String hours = request.getParameter("hours");
        List<Object[]> list = this.logService.reportModer(this.sdf.format(Calendar.getInstance().getTime()), hours);
        StringBuilder models = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (Object[] objs : list) {
            models.append("\"").append(objs[0]).append("\"").append(",");
            values.append(objs[1].toString()).append(",");
        }
        if (list.size() > 0) {
            models.deleteCharAt(models.length() - 1);
            values.deleteCharAt(values.length() - 1);
        }
        model.addAttribute("models", (Object)models.toString());
        model.addAttribute("values", (Object)values.toString());
        model.addAttribute("hours", (Object)hours);
        return "log/reportModer.ftl";
    }

    @RequestMapping(value={"/reportOper.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String reportOper(LogCondition condition, Model model, HttpServletRequest request) throws Exception {
        String models = "";
        String hours = request.getParameter("hours");
        if (StringUtils.isNotEmpty(request.getParameter("models"))) {
            models = new String(request.getParameter("models").getBytes("iso8859-1"), "utf-8");
        }
        List<Object[]> list = this.logService.reportOper(this.sdf.format(Calendar.getInstance().getTime()), models, hours);
        StringBuilder oper = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (Object[] objs : list) {
            oper.append("\"").append(objs[0]).append("\"").append(",");
            values.append(objs[1].toString()).append(",");
        }
        if (list.size() > 0) {
            oper.deleteCharAt(oper.length() - 1);
            values.deleteCharAt(values.length() - 1);
        }
        model.addAttribute("oper", (Object)oper.toString());
        model.addAttribute("values", (Object)values.toString());
        return "log/reportOper.ftl";
    }
}

