/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.log;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.Log;
import com.tcbj.crm.entity.SystemFunction;
import com.tcbj.crm.log.LogService;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.ApplicationContextUtils;
import com.tcbj.util.SessionUtils;
import com.tcbj.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LogInterceptorAdapter
extends HandlerInterceptorAdapter {
    private static Executor executor = new ThreadPoolExecutor(20, 40, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5));

    public boolean isValidUrl(String url, String method) {
        SystemFunction func = Cache.getSysFunc(url, method);
        return func != null && "0".equals(func.getFutureState());
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.saveLog(request, response, handler, ex);
        super.afterCompletion(request, response, handler, ex);
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        super.afterConcurrentHandlingStarted(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("log_startDate", (Object)Calendar.getInstance().getTime());
        return super.preHandle(request, response, handler);
    }

    public void saveLog(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String url = request.getRequestURI();
        String cxtPath = request.getContextPath();
        String exceptionInfo = "";
        String isException = "0";
        url = url.replaceAll(cxtPath, "");
        final String method = request.getMethod();
        if (ex != null) {
            isException = "1";
            exceptionInfo = ex.toString();
            if (exceptionInfo.length() > 800) {
                exceptionInfo = exceptionInfo.substring(0, 800);
            }
        }
        if (this.isValidUrl(url, method) && SessionUtils.getEmployee(request) != null) {
            final Date startDate = (Date)request.getAttribute("log_startDate");
            final String day = new SimpleDateFormat("yyyyMMdd").format(startDate);
            final Employee emp = SessionUtils.getEmployee(request);
            final String url_temp = url;
            final String isError = isException;
            final String ip_addr = LogInterceptorAdapter.getIpAddress(request);
            final String exception = exceptionInfo;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    String loginId = emp.getId();
                    String loginName = emp.getAccount();
                    String fullName = emp.getName();
                    Date endDate = Calendar.getInstance().getTime();
                    String hour = String.valueOf(Calendar.getInstance().get(11));
                    if (hour.length() < 2) {
                        hour = "0" + hour;
                    }
                    long cost = endDate.getTime() - startDate.getTime();
                    String model = Cache.getRootSysFunc(Cache.getSysFunc(url_temp, method)).getFunctionName();
                    String operation = Cache.getSysFunc(url_temp, method).getFunctionName();
                    Log entiry = new Log(day, hour, loginId, loginName, fullName, url_temp, startDate, endDate, cost, exception, isError, model, operation, ip_addr);
                    entiry.setOrgId(StringUtils.getOrgId());
                    LogService logService = (LogService)ApplicationContextUtils.getContext().getBean(LogService.class);
                    logService.saveLog(entiry);
                }
            });
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ((ipAddress = request.getRemoteAddr()).equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

