/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.log;

import com.tcbj.crm.entity.Log;
import com.tcbj.crm.log.LogCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="logService")
public class LogService {
    @Autowired
    BaseDao baseDao;

    public void saveLog(Log entiry) {
        this.baseDao.save((Object)entiry);
    }

    public Page find(LogCondition condition) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Log where 1=1 and orgId = ? ");
        args.add(StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(condition.getIsError())) {
            hql.append(" and isError = ? ");
            args.add(condition.getIsError());
        }
        if (StringUtils.isNotEmpty(condition.getLoginName())) {
            hql.append(" and loginName like ? ");
            args.add("%" + condition.getLoginName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getModel())) {
            hql.append(" and model like ? ");
            args.add("%" + condition.getModel().trim() + "%");
        }
        hql.append(" order by startDate desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), condition.getRowsize().intValue(), condition.getPageno().intValue());
        return page;
    }

    public List<Object[]> reportHour(String day, String model) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select t2.hour hour,nvl(t1.ct,0) num  from t_hour t2,  ").append(" (").append(" select count(*) ct,t.hour from CX_AWK_LOG_F t  ").append(" where 1=1 and t.day=?   ");
        if (StringUtils.isNotEmpty(model)) {
            sb.append("  and  t.model=  '").append(model).append("'");
        }
        sb.append(" group by t.hour ) t1 ").append(" where t2.hour=t1.hour(+) ").append(" order by t2.hour  ");
        return this.baseDao.findBySql(sb.toString(), new Object[]{day});
    }

    public List<Object[]> reportModer(String day, String hour) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select  t.model, count(*) ct from CX_AWK_LOG_F t ").append(" where 1=1  ").append(" and t.day=?  ");
        if (StringUtils.isNotEmpty(hour)) {
            sb.append(" and t.hour=  '").append(hour).append("'");
        }
        sb.append(" group by t.model   ").append(" order by count(*) desc   ");
        return this.baseDao.findBySql(sb.toString(), new Object[]{day});
    }

    public List<Object[]> reportOper(String day, String model, String hour) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select  t.oper, count(*) ct from CX_AWK_LOG_F t ").append(" where 1=1  ").append(" and t.day=?  ");
        if (StringUtils.isNotEmpty(model)) {
            sb.append(" and t.model =  '").append(model).append("'");
        }
        if (StringUtils.isNotEmpty(hour)) {
            sb.append(" and t.hour =  '").append(hour).append("'");
        }
        sb.append(" group by t.oper   ").append(" order by count(*)  desc   ");
        return this.baseDao.findBySql(sb.toString(), new Object[]{day});
    }
}

