/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.login;

import com.tcbj.crm.accountRelevance.AccountRelevanceService;
import com.tcbj.crm.backParam.BackParamService;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.base.User;
import com.tcbj.crm.entity.BrandAccountRelevance;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.login.LoginService;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.right.RightService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.SessionUtils;
import com.tcbj.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LoginController
extends BaseController {
    @Autowired
    private LoginService service;
    @Autowired
    private PartnerService partnerService;
    @Autowired
    private RightService rightService;
    @Autowired
    private BackParamService backParamService;
    @Autowired
    AccountRelevanceService accountRelevanceService;

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
    }

    private void loadConfig(Model model) {
        model.addAttribute("auto_orgId", (Object)StringUtils.getOrgId());
        model.addAttribute("auto_url", (Object)StringUtils.getConfigure("auto_url"));
        model.addAttribute("auto_gwUrl", (Object)StringUtils.getConfigure("auto_gwUrl"));
        model.addAttribute("bottom", (Object)StringUtils.getBottom());
        model.addAttribute("phone", (Object)StringUtils.getPhone());
        model.addAttribute("system", (Object)StringUtils.getSystem());
        model.addAttribute("title", (Object)StringUtils.getConfigure("title"));
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        model.addAttribute("other_system", (Object)StringUtils.getConfigure("other_system"));
        model.addAttribute("other_orgId", (Object)StringUtils.getConfigure("other_orgId"));
        model.addAttribute("other_url", (Object)StringUtils.getConfigure("other_url"));
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.GET})
    public String login(Model model) {
        model.addAttribute("backParam", (Object)this.backParamService.getFirstParam());
        User user = new User();
        model.addAttribute("user", (Object)user);
        this.loadConfig(model);
        return "login/newlogin.ftl";
    }

    @RequestMapping(value={"/relogin.do"}, method={RequestMethod.GET})
    public String relogin(Model model) {
        model.addAttribute("backParam", (Object)this.backParamService.getFirstParam());
        User user = new User();
        model.addAttribute("user", (Object)user);
        return "login/relogin.ftl";
    }

    @RequestMapping(value={"/login2.do"}, method={RequestMethod.GET})
    public String login2(Model model) {
        User user = new User();
        model.addAttribute("user", (Object)user);
        this.loadConfig(model);
        return "login/login2.ftl";
    }

    @RequestMapping(value={"/logout.do"}, method={RequestMethod.GET})
    public String logout(HttpServletRequest request) {
        SessionUtils.clearEmployee(request);
        return "redirect:login.do";
    }

    @RequestMapping(value={"/nologin.do"}, method={RequestMethod.GET})
    public String nologin(String account, Model model, HttpServletRequest request) {
        Employee e = this.service.noauth(account);
        List<EmployeePartner> partners = this.partnerService.findEmployeePartners(e.getId());
        e.setPartners(partners);
        if (partners.size() > 0) {
            e.setCurrentPartner(partners.get(0));
        }
        SessionUtils.setEmployee(request, e);
        this.rightService.cacheRights(request, e);
        return "redirect:index.do";
    }

    @RequestMapping(value={"/login.do"}, method={RequestMethod.POST})
    public String login_do(@Valid @ModelAttribute(value="user") User user, BindingResult br, Model model, HttpServletRequest request) {
        model.addAttribute("backParam", (Object)this.backParamService.getFirstParam());
        if ("1".equals(StringUtils.getConfigure("auto_validate"))) {
            this.validatCode(user.getValidateCode(), br, request);
        }
        if (br.hasErrors()) {
            return this.loadConfigAndToLoginPage(model);
        }
        Employee e = this.service.auth(user);
        if (e == null) {
            br.rejectValue("account", "user.account.error");
        }
        if (br.hasErrors()) {
            return this.loadConfigAndToLoginPage(model);
        }
        if (e.getEndDt() != null && e.getEndDt().getTime() <= DateUtils.now().getTime()) {
            br.rejectValue("account", "user.account.invalid");
        }
        if (br.hasErrors()) {
            return this.loadConfigAndToLoginPage(model);
        }
        List<EmployeePartner> partners = this.partnerService.findEmployeePartners(e.getId());
        e.setPartners(partners);
        if (partners.size() > 0) {
            e.setCurrentPartner(partners.get(0));
        } else {
            br.rejectValue("account", "user.account.logout");
        }
        if (br.hasErrors()) {
            return this.loadConfigAndToLoginPage(model);
        }
        SessionUtils.setEmployee(request, e);
        this.rightService.cacheRights(request, e);
        return "redirect:index.do";
    }

    @RequestMapping(value={"/loginAccountRelevance.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result loginAccountRelevance(String personId, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        List<BrandAccountRelevance> brandAccountRelevances = this.accountRelevanceService.findBrandAccountRelevanceByPerson(e.getId(), e.getCurrentPartner().getOrganizationid());
        BrandAccountRelevance brandAccountRelevance = null;
        if (Beans.isNotEmpty(brandAccountRelevances)) {
            for (BrandAccountRelevance accountRelevance : brandAccountRelevances) {
                if (!personId.equals(accountRelevance.getPersonId())) continue;
                brandAccountRelevance = accountRelevance;
                break;
            }
        }
        Employee employee = null;
        if (Beans.isNotEmpty(brandAccountRelevance)) {
            employee = this.service.noauth(brandAccountRelevance.getRelevanceAccount());
        }
        if (Beans.isEmpty(employee)) {
            throw new AppException("0010", "\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (employee.getEndDt() != null && employee.getEndDt().getTime() <= DateUtils.now().getTime()) {
            throw new AppException("0010", "\u7528\u6237\u5df2\u5931\u6548,\u4e0d\u80fd\u4f7f\u7528\u7cfb\u7edf");
        }
        List<EmployeePartner> partners = this.partnerService.findEmployeePartners(employee.getId());
        if (partners.size() <= 0) {
            throw new AppException("0010", "\u7528\u6237\u5df2\u6ce8\u9500,\u4e0d\u80fd\u4f7f\u7528\u7cfb\u7edf");
        }
        employee.setPartners(partners);
        employee.setCurrentPartner(partners.get(0));
        SessionUtils.setEmployee(request, employee);
        this.rightService.cacheRights(request, employee);
        return this.getSuccessResult(null);
    }

    private String loadConfigAndToLoginPage(Model model) {
        this.loadConfig(model);
        return "login/newlogin.ftl";
    }

    private void validatCode(String vc, BindingResult br, HttpServletRequest request) {
        String code = (String)request.getSession().getAttribute("KAPTCHA_SESSION_KEY");
        if (vc == null || code == null || !vc.toLowerCase().equals(code.toLowerCase())) {
            br.rejectValue("account", "user.validateCodeError");
        }
    }
}

