/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.notice;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.SqlDao;
import com.tcbj.crm.desktop.DesktopService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ContactRegion;
import com.tcbj.crm.entity.Notice;
import com.tcbj.crm.entity.NoticeE;
import com.tcbj.crm.entity.NoticeS;
import com.tcbj.crm.entity.NoticeU;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.notice.Condition;
import com.tcbj.crm.notice.NoticeCondition;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Contact;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.NoticeRead;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.ApplicationContextUtils;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="noticeService")
public class NoticeService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PersonnelService personService;
    @Autowired
    DesktopService desktopService;
    @Autowired
    SqlDao dao = null;

    public Page getList(String organizationId, NoticeCondition condition, int pageNo, Contact contact) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuffer whereHql = new StringBuffer(" where 1=1 ");
        StringBuffer hql = new StringBuffer();
        StringBuffer hql2 = new StringBuffer();
        if (StringUtils.isNotEmpty(condition.getTitle())) {
            whereHql.append(" and n.NOTICE_TITLE like ? ");
            args.add("%" + condition.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getNoticeType())) {
            whereHql.append(" and n.NOTICE_TYPE =? ");
            args.add(condition.getNoticeType());
        }
        if (StringUtils.isNotEmpty(condition.getState())) {
            whereHql.append(" and n.NOTICE_FLAG =? ");
            args.add(condition.getState());
        }
        if (condition.getStartDate() != null) {
            whereHql.append(" and  n.CREATE_DT >= to_date(?,'yyyy-MM-dd') ");
            args.add(DateUtils.formartDate((Date)condition.getStartDate(), (String)"yyyy-MM-dd"));
        }
        if (condition.getEndDate() != null) {
            whereHql.append(" and n.CREATE_DT <=  to_date(?,'yyyy-MM-dd') ");
            args.add(DateUtils.formartDate((Date)DateUtils.getDateAfter((Date)condition.getEndDate(), (int)1), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty(condition.getBelongsSys())) {
            whereHql.append(" and s.SYSTEM_FLAG =? ");
            args.add(condition.getBelongsSys());
        }
        hql.append("select n1.row_id id,n1.notice_flag noticeFlag,n1.notice_picture noticePicture,n1.notice_title noticeTitle,n1.notice_type noticeType ,n1.CREATE_DT from CX_AWK_NOTICE n1 join (select  distinct n.row_id from CX_AWK_NOTICE n left join CX_AWK_NOTICE_S s on n.ROW_ID = s.NOTICE_ID ").append(whereHql).append("   ) t on t.row_id = n1.row_id where 1=1");
        hql2.append("select s.system_flag,t.ID from  CX_AWK_NOTICE_S s  join (select n1.row_id id,n1.notice_flag noticeFlag,n1.notice_picture noticePicture,n1.notice_title noticeTitle,n1.notice_type noticeType ,n1.CREATE_DT createDt from CX_AWK_NOTICE n1 join (select  distinct n.row_id from CX_AWK_NOTICE n left join CX_AWK_NOTICE_S s on n.ROW_ID = s.NOTICE_ID ").append(whereHql).append("   ) t on t.row_id = n1.row_id ").append(" order by  n1.CREATE_DT desc )t on s.notice_id = t.ID");
        List systemList = this.baseDao.findBySql(hql2.toString(), args.toArray());
        HashMap<String, ArrayList<String>> sysMap = new HashMap<String, ArrayList<String>>();
        for (Object[] objs : systemList) {
            String sys = (String)objs[0];
            String noticeId = (String)objs[1];
            ArrayList<String> list = (ArrayList<String>)sysMap.get(noticeId);
            if (list == null) {
                list = new ArrayList<String>();
                sysMap.put(noticeId, list);
            }
            list.add(sys);
        }
        if (contact != null && StringUtils.isNotEmpty(contact.getPartnerOrgId())) {
            hql.append(" and n1.ORGANIZATION_ID=? ");
            args.add(contact.getPartnerOrgId());
        }
        hql.append(" order by n1.CREATE_DT desc");
        Page page = this.baseDao.searchBySql(hql.toString(), args.toArray(), 10, pageNo, Notice.class);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] objs = (Object[])page.getList().get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", objs[0]);
            map.put("noticeFlag", objs[1]);
            map.put("noticePicture", objs[2]);
            map.put("noticeTitle", objs[3]);
            map.put("noticeType", objs[4]);
            map.put("createDt", objs[5]);
            map.put("disNoticeType", Cache.getItemName("TCBJ_NOTICE_TYPE", (String)objs[4]));
            map.put("systems", sysMap.get(objs[0]));
            list.add(map);
            ++i;
        }
        page.setList(list);
        return page;
    }

    public void save(Notice notice, Collection<IUploadFile> fileList, Employee e) {
        for (IUploadFile file : fileList) {
            if (!"np".equals(file.getFieldName())) continue;
            notice.setNoticePicture(file.getWebPath());
        }
        this.baseDao.save((Object)notice);
        for (IUploadFile file : fileList) {
            if ("np".equals(file.getFieldName())) continue;
            NoticeE n = new NoticeE();
            n.setNoticeId(notice.getId());
            n.setEnclosureType(file.getSuffix());
            n.setEnclosurePath(file.getWebPath());
            n.setEnclosureName(file.getName());
            n.fillInitData(e);
            this.baseDao.save((Object)n);
        }
    }

    public void save(NoticeE n) {
        this.baseDao.save((Object)n);
    }

    public void save(Employee e, String noticeId, String[] systems) {
        this.baseDao.executeHQL("delete from NoticeS s where s.noticeId = ? ", new Object[]{noticeId});
        if (systems != null) {
            String[] stringArray = systems;
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                String sys = stringArray[n2];
                NoticeS noticeS = new NoticeS();
                noticeS.setCreated(DateUtils.now());
                noticeS.setCreatedBy(e.getId());
                noticeS.setDbLastUpd(DateUtils.now());
                noticeS.setLastUpdBy(e.getId());
                noticeS.setLastUpd(DateUtils.now());
                noticeS.setModificationNum(922337203L);
                noticeS.setConflictId("11");
                noticeS.setSystemFlag(sys);
                noticeS.setNoticeId(noticeId);
                noticeS.setLastupdateDt(DateUtils.now());
                noticeS.setLastupdatorId(e.getId());
                noticeS.setCreateDt(DateUtils.now());
                noticeS.setCreatorId(e.getId());
                this.baseDao.save((Object)noticeS);
                ++n2;
            }
        }
    }

    public void save(NoticeU noticeU) {
        this.deleteNotice(noticeU.getUserId(), noticeU.getNoticeId());
        this.baseDao.save((Object)noticeU);
    }

    public List<NoticeU> getSelectedList(String noticeId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from NoticeU u where  u.noticeId =? ");
        args.add(noticeId);
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), NoticeU.class);
        return list;
    }

    public List<Contact> getSelectedNoticeUser(String noticeId, NoticeCondition condition) {
        Contact contact;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("  from Contact c ,NoticeU n  ,EmployeePartner e  ");
        hql.append(" where n.userId = c.id and c.id = e.personId");
        hql.append(" and n.noticeId = ? ");
        args.add(noticeId);
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            hql.append(" and  c.fullname like ?");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPhone())) {
            hql.append(" and  c.phonenumber like ?");
            args.add("%" + condition.getPhone() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPersontype())) {
            hql.append(" and c.persontype = ? ");
            args.add(condition.getPersontype());
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            hql.append(" and c.roletype = ? ");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getDealerId())) {
            hql.append(" and e.id =? ");
            args.add(condition.getDealerId());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Object[] obj : list) {
            contact = (Contact)obj[0];
            contact.setEmployeePartner((EmployeePartner)obj[2]);
            contactList.add(contact);
        }
        Iterator it = contactList.iterator();
        LinkedHashMap<String, Contact> map = new LinkedHashMap<String, Contact>();
        while (it.hasNext()) {
            contact = (Contact)it.next();
            map.put(contact.getId(), contact);
        }
        ArrayList<Contact> contactList2 = new ArrayList<Contact>();
        contactList2.addAll(map.values());
        return contactList2;
    }

    public void update(Notice notice, Collection<IUploadFile> fileList, Employee e) {
        Notice nt = (Notice)this.baseDao.get(Notice.class, (Serializable)((Object)notice.getId()));
        for (IUploadFile file : fileList) {
            if (!"np".equals(file.getFieldName())) continue;
            nt.setNoticePicture(file.getWebPath());
        }
        nt.setNoticeTitle(notice.getNoticeTitle());
        nt.setNoticeType(notice.getNoticeType());
        nt.setStartDate(notice.getStartDate());
        nt.setEndDate(notice.getEndDate());
        nt.setFullDisclosureFlag(notice.getFullDisclosureFlag());
        nt.setOrderId(notice.getOrderId());
        nt.setDetail(notice.getDetail());
        nt.setNoticeFlag(notice.getNoticeFlag());
        this.baseDao.update((Object)nt);
        for (IUploadFile file : fileList) {
            if ("np".equals(file.getFieldName())) continue;
            NoticeE n = new NoticeE();
            n.fillInitData(e);
            n.setNoticeId(notice.getId());
            n.setEnclosureType(file.getSuffix());
            n.setEnclosurePath(file.getWebPath());
            n.setEnclosureName(file.getName());
            this.baseDao.save((Object)n);
        }
    }

    public void updateCheck(String id, String noticeFlag, String publishOrgId) {
        Notice nt = (Notice)this.baseDao.get(Notice.class, (Serializable)((Object)id));
        nt.setPublishDate(new Date());
        nt.setPublishOrgId(publishOrgId);
        nt.setNoticeFlag(noticeFlag);
        this.baseDao.update((Object)nt);
    }

    public Notice findById(String id) {
        return (Notice)this.baseDao.get(Notice.class, (Serializable)((Object)id));
    }

    public List<NoticeE> getNoticeFile(String id) {
        String sql = " from NoticeE where noticeId = ? order by createDt desc ";
        return this.baseDao.findEntity(sql, new Object[]{id}, NoticeE.class);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Notice.class, (Serializable)((Object)id));
    }

    public void deleteFile(String id) {
        this.baseDao.deleteById(NoticeE.class, (Serializable)((Object)id));
    }

    public void deleteNotice(String userId, String noticeid) {
        this.baseDao.executeHQL("delete from NoticeU u where u.noticeId= ? and userId = ? ", new Object[]{noticeid, userId});
    }

    public Map<String, NoticeS> findNoticeSById(String id) {
        String hql = " from NoticeS where noticeId= ? ";
        HashMap<String, NoticeS> result = new HashMap<String, NoticeS>();
        List list = this.baseDao.findEntity(hql, new Object[]{id}, NoticeS.class);
        for (NoticeS ns : list) {
            result.put(ns.getSystemFlag(), ns);
        }
        return result;
    }

    public Page getNoticeByPage(Employee me, NoticeCondition condition, int pageno) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sql.append(" SELECT * FROM (");
        sql.append(" SELECT nn.row_id ,nn.NOTICE_TITLE,nn.publish_date , nn.NOTICE_PICTURE,nn.CREATOR_ID  FROM CX_AWK_NOTICE nn ,CX_AWK_NOTICE_S ns  ");
        sql.append(" WHERE nn.row_id=ns.notice_id   and  nn.NOTICE_FLAG='2'  ");
        sql.append(" and ns.system_flag ='CRM'  ");
        sql.append(" and sysdate between nvl(nn.start_date,sysdate-1) and  nvl(nn.end_date, sysdate + 1)");
        sql.append("  and nn.notice_type=?  ");
        sql.append(" and nn.PUBLISH_ORG_ID = ?");
        args.add(condition.getNoticeType());
        args.add(me.getCurrentPartner().getOrganizationid());
        sql.append("  union  ");
        sql.append(" SELECT nn.row_id ,nn.NOTICE_TITLE,nn.publish_date , nn.NOTICE_PICTURE,nn.CREATOR_ID  FROM CX_AWK_NOTICE nn ,CX_AWK_NOTICE_U  nu ");
        sql.append(" WHERE nn.row_id = nu.notice_id  and  nn.NOTICE_FLAG='2'  ");
        sql.append(" and sysdate between nvl(nn.start_date,sysdate-1) and  nvl(nn.end_date, sysdate + 1)");
        sql.append("  and nn.notice_type=?  and nu.user_id=? ");
        sql.append(" and nn.PUBLISH_ORG_ID = ?");
        args.add(condition.getNoticeType());
        args.add(me.getId());
        args.add(me.getCurrentPartner().getOrganizationid());
        sql.append(") t where 1=1 ");
        if (StringUtils.isNotEmpty(condition.getTitle())) {
            sql.append(" and t.NOTICE_TITLE like ? ");
            args.add("%" + condition.getTitle() + "%");
        }
        sql.append(" order by t.publish_date desc");
        Page page = this.baseDao.searchBySql(sql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno, null);
        ArrayList<Notice> voList = new ArrayList<Notice>();
        int i = 0;
        while (i < page.getList().size()) {
            Object[] objs = (Object[])page.getList().get(i);
            Notice vo = new Notice();
            vo.setId((String)objs[0]);
            vo.setNoticeTitle((String)objs[1]);
            vo.setPublishDate((Date)objs[2]);
            vo.setNoticePicture((String)objs[3]);
            vo.setCreatorId((String)objs[4]);
            voList.add(vo);
            ++i;
        }
        page.setList(voList);
        return page;
    }

    public List<PartnerContact> findNoticeUsers(String id) {
        String hql = " select pc from PartnerContact pc ,NoticeU nu where pc.id = nu.userId and nu.userId =? ";
        return this.baseDao.findEntity(hql, new Object[]{id}, PartnerContact.class);
    }

    public List<Contact> getInnerPerson(Employee me, Condition condition) {
        Contact contact;
        int i;
        List<ContactRegion> crList;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Contact c ,EmployeePartner e ,ContactRegion cr where e.id=? and c.id=e.personId and c.id=cr.userId");
        hql.append(" and c.partnerOrgId=? and  (sysdate <= c.enddate or  c.enddate is null)  ");
        args.add(me.getCurrentPartner().getId());
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            hql.append(" and c.fullname like ?");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPhone())) {
            hql.append(" and c.phonenumber like ? ");
            args.add("%" + condition.getPhone() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            hql.append(" and c.roletype = ?");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            crList = this.personService.getUserByRegion(condition.getBigAreaCode());
            hql.append(" and cr.id in( ");
            if (crList.size() > 0) {
                i = 0;
                while (i < crList.size()) {
                    hql.append(i == 0 ? "?" : ",? ");
                    args.add(crList.get(i).getUserId());
                    ++i;
                }
            }
            hql.append(")");
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            crList = this.personService.getUserByRegion(condition.getAreaCode());
            hql.append(" or cr.id in( ");
            if (crList.size() > 0) {
                i = 0;
                while (i < crList.size()) {
                    hql.append(i == 0 ? "?" : ",? ");
                    args.add(crList.get(i).getUserId());
                    ++i;
                }
            }
            hql.append(")");
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Object[] obj : list) {
            contact = (Contact)obj[0];
            contact.setEmployeePartner((EmployeePartner)obj[1]);
            contactList.add(contact);
        }
        Iterator it = contactList.iterator();
        LinkedHashMap<String, Contact> map = new LinkedHashMap<String, Contact>();
        while (it.hasNext()) {
            contact = (Contact)it.next();
            map.put(contact.getId(), contact);
        }
        ArrayList<Contact> contactList2 = new ArrayList<Contact>();
        contactList2.addAll(map.values());
        return contactList2;
    }

    public List<Contact> getOuterPerson(Employee me, Condition condition) {
        Contact contact;
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Contact c,Customer u,EmployeePartner e where    u.applyerId = e.id and u.supplierId = nvl(e.parPartnerId,e.id)   and c.id = e.personId  ");
        hql.append("    and c.partnerOrgId=? and  (sysdate <= c.enddate or  c.enddate is null) ");
        args.add(me.getCurrentPartner().getOrganizationid());
        hql.append(" and persontype = 'External'");
        if (StringUtils.isNotEmpty(condition.getContactName())) {
            hql.append(" and c.fullname like ?");
            args.add("%" + condition.getContactName() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getPhone())) {
            hql.append(" and c.phonenumber like ? ");
            args.add("%" + condition.getPhone() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getRoletype())) {
            hql.append(" and c.roletype = ?");
            args.add(condition.getRoletype());
        }
        if (StringUtils.isNotEmpty(condition.getSaleChannelTypeCode())) {
            hql.append(" and u.partnerChnlType = ?");
            args.add(condition.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(condition.getBigAreaCode())) {
            hql.append(" and u.bigAreaCode = ?");
            args.add(condition.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(condition.getDealerId())) {
            hql.append(" and u.applyerId = ? ");
            args.add(condition.getDealerId());
        }
        if (StringUtils.isNotEmpty(condition.getAreaCode())) {
            hql.append(" and u.areaCode = ? ");
            args.add(condition.getAreaCode());
        }
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        for (Object[] obj : list) {
            contact = (Contact)obj[0];
            contact.setEmployeePartner((EmployeePartner)obj[2]);
            contactList.add(contact);
        }
        Iterator it = contactList.iterator();
        LinkedHashMap<String, Contact> map = new LinkedHashMap<String, Contact>();
        while (it.hasNext()) {
            contact = (Contact)it.next();
            map.put(contact.getId(), contact);
        }
        ArrayList<Contact> contactList2 = new ArrayList<Contact>();
        contactList2.addAll(map.values());
        return contactList2;
    }

    public List<PartnerContact> getEmployees(String areaId, String partnerId) {
        StringBuilder hql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from Customer c,PartnerContact p,Region r where r.id = ? and c.areaCode = r.id and c.applyerId = p.partnerId and c.supplierId = ? and p.isContact='Y'");
        args.add(areaId);
        args.add(partnerId);
        List list = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        ArrayList<PartnerContact> pcs = new ArrayList<PartnerContact>();
        for (Object[] obj : list) {
            PartnerContact pc = (PartnerContact)obj[1];
            pcs.add(pc);
        }
        return pcs;
    }

    public Page getNoticesByPage(NoticeCondition condition, int pageSize, int pageNo) {
        this.baseDao = (BaseDao)ApplicationContextUtils.getContext().getBean("baseDao");
        if (StringUtils.isEmpty(condition.getPublishSys())) {
            throw new AppException("4005");
        }
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" select n from Notice n , NoticeS s where n.id = s.noticeId  and ( n.endDate >= to_date(?,'yyyy-MM-dd') or  n.endDate is null ) ").append(" and ( s.endDate >=to_date(?,'yyyy-MM-dd') or s.endDate is null ) ").append(" and n.noticeFlag='2'  ");
        args.add(DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd"));
        args.add(DateUtils.formartDate((Date)new Date(), (String)"yyyy-MM-dd"));
        hql.append(" and s.systemFlag =? ");
        args.add(condition.getPublishSys());
        if (StringUtils.isNotEmpty(condition.getTitle())) {
            hql.append(" and n.noticeTitle like ?");
            args.add("%" + condition.getTitle() + "%");
        }
        if (condition.getStartDate() != null) {
            hql.append(" and n.publishDate >= to_date(?,'yyyy-MM-dd') ");
            args.add(DateUtils.formartDate((Date)condition.getStartDate(), (String)"yyyy-MM-dd"));
        }
        if (condition.getEndDate() != null) {
            hql.append(" and n.publishDate <= to_date(?,'yyyy-MM-dd')");
            args.add(DateUtils.formartDate((Date)DateUtils.getDateAfter((Date)condition.getEndDate(), (int)1), (String)"yyyy-MM-dd"));
        }
        hql.append(" order by n.publishDate desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), pageSize == 0 ? 10 : pageSize, pageNo == 0 ? 1 : pageNo);
    }

    public Notice getNoticDetailById(String noticeId) {
        this.baseDao = (BaseDao)ApplicationContextUtils.getContext().getBean("baseDao");
        Notice notice = (Notice)this.baseDao.get(Notice.class, (Serializable)((Object)noticeId));
        String hql = " from NoticeS where noticeId= ? ";
        NoticeS noticeS = (NoticeS)this.baseDao.findFirstEntity(hql, new Object[]{noticeId}, NoticeS.class);
        String systemFlag = "";
        List<DictionaryItem> dicList = Cache.getItems("TCBJ_NOTICE_SYS");
        for (DictionaryItem item : dicList) {
            if (!item.getName().equals(noticeS.getSystemFlag())) continue;
            systemFlag = item.getVal();
        }
        notice.setSystemFlagName(systemFlag);
        List<NoticeE> fileList = this.getNoticeFile(noticeId);
        notice.setNotiecEs(fileList);
        return notice;
    }

    public String findNotices(String conditionXML) {
        Document resultDocument = DocumentHelper.createDocument();
        Element resultElement = DocumentHelper.createElement((String)"result");
        resultDocument.setRootElement(resultElement);
        Element statusElement = resultElement.addElement("status");
        Element result = null;
        NoticeCondition condition = null;
        int pageSize = 10;
        int pageNo = 1;
        try {
            Document conditionDocument = DocumentHelper.parseText((String)conditionXML);
            Element rootElement = conditionDocument.getRootElement();
            String title = rootElement.elementText("title");
            String noticeType = rootElement.elementText("noticeType");
            String publishSys = rootElement.elementText("publishSys");
            String state = rootElement.elementText("state");
            String _pageSize = rootElement.elementText("pageSize");
            String _pageNo = rootElement.elementText("pageNo");
            String startDate = rootElement.elementText("startDate");
            String endDate = rootElement.elementText("endDate");
            pageSize = Integer.parseInt(_pageSize);
            pageNo = Integer.parseInt(_pageNo);
            condition = new NoticeCondition();
            condition.setTitle(title);
            condition.setNoticeType(noticeType);
            condition.setPublishSys(publishSys);
            condition.setState(state);
            if (StringUtils.isNotEmpty(startDate)) {
                condition.setStartDate(DateUtils.formDate((String)startDate, (String)"yyyy-MM-dd"));
            }
            if (StringUtils.isNotEmpty(endDate)) {
                condition.setEndDate(DateUtils.formDate((String)endDate, (String)"yyyy-MM-dd"));
            }
            Page page = this.getNoticesByPage(condition, pageSize, pageNo);
            result = this.toXML(page);
            resultElement.add(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            statusElement.addAttribute("code", "error").addAttribute("message", "\u65e0\u6548\u7684\u53c2\u6570\uff01");
            return resultDocument.asXML();
        }
        statusElement.addAttribute("code", "ok");
        System.out.println(resultDocument.asXML());
        return resultDocument.asXML();
    }

    private Element toXML(Page page) {
        Element noticePage = DocumentHelper.createElement((String)"NoticePage");
        Element pageElement = noticePage.addElement("page");
        pageElement.addAttribute("currentPage", String.valueOf(page.getCurrentPage())).addAttribute("maxPage", String.valueOf(page.getMaxPage()));
        pageElement.addAttribute("nextPage", String.valueOf(page.getNextPage())).addAttribute("pageSize", String.valueOf(page.getPageSize()));
        pageElement.addAttribute("prePage", String.valueOf(page.getPrePage())).addAttribute("count", String.valueOf(page.getCount()));
        Element noticesElement = noticePage.addElement("notices");
        List list = page.getList();
        for (Notice notice : list) {
            Element noticElement = noticesElement.addElement("notice");
            Element titleElement = noticElement.addElement("title");
            titleElement.addText(notice.getNoticeTitle());
            Element idElement = noticElement.addElement("id");
            idElement.addText(notice.getId());
            Element noticeTypeElement = noticElement.addElement("noticeType");
            noticeTypeElement.addText(notice.getNoticeType());
            Element createDateElement = noticElement.addElement("creatDate");
            createDateElement.addText(notice.getCreateDt().toString());
            Element publishSysElement = noticElement.addElement("publishDate");
            publishSysElement.addText(notice.getPublishDate().toString());
        }
        return noticePage;
    }

    public String getNoticeDetail(String noticeId) {
        Document resultDocument = DocumentHelper.createDocument();
        Element resultElement = DocumentHelper.createElement((String)"result");
        resultDocument.setRootElement(resultElement);
        Element statusElement = resultElement.addElement("status");
        try {
            Element noticeElement = resultElement.addElement("Notice");
            Notice notice = this.getNoticDetailById(noticeId);
            Element titleElement = noticeElement.addElement("title");
            titleElement.addText(notice.getNoticeTitle());
            Element idElement = noticeElement.addElement("id");
            idElement.addText(notice.getId());
            Element detailElement = noticeElement.addElement("detail");
            detailElement.addText(notice.getDetail());
            Element pubishSysElement = noticeElement.addElement("pubishSys");
            pubishSysElement.addText(notice.getSystemFlagName());
            Element publishDateElement = noticeElement.addElement("publishDate");
            publishDateElement.addText(notice.getPublishDate().toString());
            Element noticeEElement = resultElement.addElement("NoticeE");
            for (NoticeE noticeE : notice.getNotiecEs()) {
                Element fileElement = noticeEElement.addElement("file");
                Element idElement1 = fileElement.addElement("id");
                idElement1.addText(noticeE.getId());
                Element enclosureNameElement = fileElement.addElement("enclosureName");
                if (StringUtils.isNotNull(noticeE.getEnclosureName())) {
                    enclosureNameElement.addText(noticeE.getEnclosureName());
                }
                Element enclosurePathElement = fileElement.addElement("enclosurePath");
                if (StringUtils.isNotNull(noticeE.getEnclosurePath())) {
                    enclosurePathElement.addText(noticeE.getEnclosurePath());
                }
                Element enclosureValueElement = fileElement.addElement("enclosureValue");
                if (!StringUtils.isNotNull(noticeE.getEnclosureValue())) continue;
                enclosureValueElement.addText(noticeE.getEnclosureValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            statusElement.addAttribute("code", "error").addAttribute("message", "\u65e0\u6548\u7684\u53c2\u6570\uff01");
        }
        statusElement.addAttribute("code", "ok");
        return resultDocument.asXML();
    }

    public static void main(String[] args) {
    }

    public void saveReadEmp(String noticeId, String empId) {
        Notice notice = this.findById(noticeId);
        if (!"2".equals(notice.getNoticeFlag())) {
            return;
        }
        NoticeRead noticeRead = null;
        if (!this.checkEmpReadFlag(noticeId, empId)) {
            List<NoticeRead> noticeReads = this.findNoticeReadByNoticeId(noticeId);
            if (noticeReads.size() > 0) {
                noticeRead = noticeReads.get(0);
                noticeRead.setReadIds(String.valueOf(noticeRead.getReadIds()) + empId + ",");
            } else {
                noticeRead = new NoticeRead();
                noticeRead.setNoticeId(noticeId);
                noticeRead.setReadIds("," + empId + ",");
            }
        }
        if (noticeRead != null) {
            this.baseDao.save(noticeRead);
        }
    }

    private boolean checkEmpReadFlag(String noticeId, String empId) {
        NoticeRead noticeRead;
        List<NoticeRead> noticeReads = this.findNoticeReadByNoticeId(noticeId);
        return noticeReads.size() > 0 && StringUtils.isNotEmpty((noticeRead = noticeReads.get(0)).getReadIds()) && StringUtils.isNotNull(noticeRead.getReadIds()) && noticeRead.getReadIds().contains(String.valueOf(empId) + ",");
    }

    private List<NoticeRead> findNoticeReadByNoticeId(String noticId) {
        List noticeReads = this.baseDao.findEntity("from NoticeRead o where o.noticeId = ?", (Object)noticId, NoticeRead.class);
        return noticeReads;
    }

    public Page getUnreadSysNoticesByPage(Employee emp, NoticeCondition con, int pageNo) {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("SELECT * from (");
        sql.append("select a.row_id ,a.NOTICE_TITLE,a.publish_date , a.NOTICE_PICTURE,a.CREATOR_ID from CX_AWK_NOTICE a ,CX_AWK_NOTICE_S s ");
        sql.append(" where a.row_id = s.NOTICE_ID and s.system_flag = 'CRM' and a.NOTICE_FLAG = '2' and a.NOTICE_TYPE = 'NOTICE' and a.PUBLISH_ORG_ID = ?");
        sql.append("and SYSDATE BETWEEN NVL(a.start_date, SYSDATE - 1) AND NVL(a.end_date, SYSDATE + 1)");
        params.add(emp.getCurrentPartner().getOrganizationid());
        sql.append(" ) t where 1 = 1 ");
        if (StringUtils.isNotEmpty(con.getTitle())) {
            sql.append(" and t.NOTICE_TITLE like ? ");
            params.add("%" + con.getTitle() + "%");
        }
        sql.append(" order by t.publish_date desc ");
        Page page = this.baseDao.searchBySql(sql.toString(), params.toArray(), Constant.DEFAULT_ROWS, pageNo, null);
        ArrayList<Notice> unreadNotices = new ArrayList<Notice>();
        for (Object obj : page.getList()) {
            Object[] objs = (Object[])obj;
            if (this.checkEmpReadFlag((String)objs[0], emp.getId())) continue;
            Notice notice = new Notice();
            notice.setId((String)objs[0]);
            notice.setNoticeTitle((String)objs[1]);
            notice.setPublishDate((Date)objs[2]);
            notice.setNoticePicture((String)objs[3]);
            notice.setCreatorId((String)objs[4]);
            boolean flag = DateUtils.timeCompare((Date)new Date(), (Date)notice.getPublishDate()) <= 3L;
            notice.setFlag(flag);
            unreadNotices.add(notice);
        }
        page.setList(unreadNotices);
        return page;
    }
}

