/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PartnerActivityInfo;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.ActivityInfoService;
import com.tcbj.crm.order.ActivityOrderProduct;
import com.tcbj.crm.order.ActivityPlatformHelper;
import com.tcbj.crm.order.OrderApplyService;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.view.Employee;
import com.tcbj.util.ApplicationContextUtils;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.ui.Model;

public abstract class AbstractActivityProcessor {
    protected OrderApply orderApply;
    protected String orderState;
    protected Employee currentEmployee;
    protected List<OrderProduct> allProducts;
    protected Model model;
    protected Map<String, OrderProduct> productMap = new HashMap<String, OrderProduct>();
    protected ActivityInfoService activityService;
    protected OrderApplyService orderApplyService;
    protected boolean isViewAll = true;
    protected boolean isView = false;
    public static final String ALLMON = "mon";
    public static final String ALLSUM = "num";
    public static final String ALLOWEDIT = "1";
    public static final String NOTALLOWEDIT = "0";
    public static final String SHOWACTIVITY = "block";
    public static final String NOTSHOWACTIVITY = "none";
    private Map<String, Object> params = new HashMap<String, Object>();
    private List<Activity> activitys;

    public AbstractActivityProcessor() {
        this.activityService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
        this.orderApplyService = (OrderApplyService)ApplicationContextUtils.getContext().getBean(OrderApplyService.class);
    }

    public abstract List<String> handleView();

    public void doView() {
        if (Beans.isEmpty((Object)this.orderApply)) {
            throw new RuntimeException("orderApply can not be null");
        }
        List<String> aIds = this.handleView();
        this.cacheActivityProduct(aIds);
    }

    public void doEdit() {
        if (Beans.isEmpty((Object)this.orderApply)) {
            throw new RuntimeException("orderApply can not be null");
        }
        List<String> aIds = this.handleEdit();
        this.cacheActivityProduct(aIds);
    }

    private void cacheActivityProduct(List<String> aIds) {
        String aIdStr;
        List<Map<String, Object>> items;
        ArrayList<OrderProduct> cacheActivityProduct = new ArrayList<OrderProduct>();
        if (Beans.isNotEmpty(aIds) && Beans.isNotEmpty(items = ActivityPlatformHelper.getActivityItem(aIdStr = StringUtils.listToString(aIds, ",")))) {
            Iterator<OrderProduct> iter = this.allProducts.iterator();
            block0: while (iter.hasNext()) {
                OrderProduct p = iter.next();
                for (Map<String, Object> item : items) {
                    String pNo = item.get("rule_productCode").toString();
                    if (!pNo.equals(p.getNo()) || !StringUtils.getOrgId().equals(p.getOrgId())) continue;
                    cacheActivityProduct.add(p);
                    if (Beans.isEmpty((Object)item.get("showInNormal"))) {
                        if (!"GIFT".equals(p.getProductType())) continue block0;
                        iter.remove();
                        continue block0;
                    }
                    String showInNormal = item.get("showInNormal").toString();
                    if (!NOTALLOWEDIT.equals(showInNormal)) continue block0;
                    iter.remove();
                    continue block0;
                }
            }
        }
        this.model.addAttribute("cacheActivityProduct", (Object)Jsons.toJson(cacheActivityProduct));
        this.model.addAttribute("cacheActivityProductEntitys", cacheActivityProduct);
    }

    public void doSubmit() {
        if (Beans.isEmpty((Object)this.orderApply)) {
            throw new RuntimeException("orderApply can not be null");
        }
        this.handleSubmit(this.orderApply);
    }

    public Map<String, Object> initActivity() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> activity = new ArrayList();
        boolean initItem = false;
        List<Object> aops = new ArrayList();
        Map<String, Object> activityInfo = ActivityPlatformHelper.getActivityFromPlatform(this.orderApply.getApplyerId());
        this.initActivityProduct((List)activityInfo.get("productIds"));
        if (Beans.isEmpty((Object)this.orderApply.getId())) {
            activity = (List)activityInfo.get("activityInfo");
        } else if ("\u81ea\u52a8\u8865\u8d27".equals(this.orderApply.getSource())) {
            if (Beans.isEmpty(this.orderApply.getActivitys()) && Beans.isNotEmpty((Object)activityInfo.get("activityInfo"))) {
                this.orderApply.setActivitys((List)activityInfo.get("activityInfo"));
                OrderApply o = new OrderApply();
                o.setApplyerId(this.orderApply.getApplyerId());
                o.setSupplierId(this.orderApply.getSupplierId());
                o.setActivitys((List)activityInfo.get("activityInfo"));
                ArrayList<OrderApplyItem> arrayList = new ArrayList<OrderApplyItem>();
                for (OrderApplyItem item : this.orderApply.getOrderApplyItems()) {
                    if (ALLOWEDIT.equals(item.getActivityFlag())) continue;
                    OrderProduct p = this.productMap.get(item.getNo());
                    if (Beans.isNotEmpty((Object)p)) {
                        item.setPrice(p.getPrice());
                    }
                    arrayList.add(item);
                }
                o.setOrderApplyItems(arrayList);
                Map<String, Object> synProducts = ActivityHandler.getActivityProducts(o);
                activity = (List)synProducts.get("activityInfo");
                aops = (List)synProducts.get("activityProduct");
                initItem = false;
            } else {
                activity = this.orderApply.getActivitys();
                initItem = true;
            }
        } else {
            activity = this.orderApply.getActivitys();
            initItem = true;
        }
        ArrayList<String> aIds = new ArrayList<String>();
        if (Beans.isNotEmpty(activity)) {
            for (OrderActivityInfo orderActivityInfo : activity) {
                aIds.add(orderActivityInfo.getActivityId());
            }
            if (initItem) {
                List<OrderActivityProduct> list = this.orderApply.getActivityProducts();
                aops = this.fillQuantityToProducts(list);
            }
            if (TCBJEnum.AuditState.draft.getValue().equals(this.orderState) || TCBJEnum.AuditState.approve.getValue().equals(this.orderState) || TCBJEnum.AuditState.approveNoPass.getValue().equals(this.orderState)) {
                AbstractActivityProcessor.newfillTotalCountActivitys(this.orderApply, activity, aIds);
            } else {
                AbstractActivityProcessor.newfillTotalCountActivitysForView(this.orderApply, activity, aIds);
            }
        }
        result.put("activityIds", aIds);
        result.put("activitys", activity);
        result.put("activityItems", aops);
        return result;
    }

    private void unShowActivity() {
        this.model.addAttribute("activitys", (Object)Jsons.toJson(new ArrayList()));
        this.model.addAttribute("activityItems", (Object)Jsons.toJson(new ArrayList()));
        this.model.addAttribute("showActivity", (Object)NOTSHOWACTIVITY);
    }

    private void showActivity(List<OrderActivityInfo> activity, List<ActivityOrderProduct> aops) {
        this.model.addAttribute("activitys", (Object)Jsons.toJson(activity));
        this.model.addAttribute("activityItems", (Object)Jsons.toJson(aops));
        this.model.addAttribute("showActivity", (Object)SHOWACTIVITY);
    }

    public static void fillTotalCountActivitys(OrderApply orderApply, List<OrderActivityInfo> activity, List<String> aIds) {
        ActivityInfoService aService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
        Map<String, PartnerActivityInfo> totals = aService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aIds);
        for (OrderActivityInfo info : activity) {
            AbstractActivityProcessor.fillTotalCountActivitys(orderApply, info, totals);
        }
    }

    public static boolean fillTotalCountActivitys(OrderApply orderApply, OrderActivityInfo activity, Map<String, PartnerActivityInfo> totals) {
        String calMethod = "";
        if (totals.containsKey(activity.getActivityId())) {
            PartnerActivityInfo paInfo = totals.get(activity.getActivityId());
            activity.setTotal(paInfo.getTotalCount());
            activity.setTotalGain(paInfo.getTotalGain());
            activity.setTotalUse(paInfo.getTotalUse());
            if (ALLOWEDIT.equals(paInfo.getReturnFlag()) || paInfo.getInitValue() <= 0.0) {
                if (orderApply.getState().equals(TCBJEnum.AuditState.draft.getValue()) || orderApply.getState().equals(TCBJEnum.AuditState.approveNoPass.getValue())) {
                    activity.setTotalCanUse(activity.getCurrentCount() + activity.getTotal());
                    calMethod = activity.getCurrentCount() + "+" + activity.getTotal();
                } else {
                    activity.setTotalCanUse(paInfo.getTotalCount());
                    calMethod = paInfo.getTotalCount().toString();
                }
            } else if (paInfo.getTotalGain() + activity.getCurrentCount() >= paInfo.getInitValue()) {
                activity.setTotalCanUse(activity.getCurrentCount() + activity.getTotal() - paInfo.getInitValue());
                calMethod = activity.getCurrentCount() + "+" + activity.getTotal() + "-" + paInfo.getInitValue();
            } else {
                activity.setTotalCanUse(paInfo.getInitValue() - paInfo.getTotalUse());
                calMethod = paInfo.getInitValue() + "-" + paInfo.getTotalUse();
            }
        } else {
            activity.setTotalCanUse(activity.getTotal() + activity.getCurrentCount());
            calMethod = activity.getCurrentCount() + "+" + activity.getTotal();
        }
        activity.setCanUseCalMethod(calMethod);
        return activity.getTotalCanUse() > 0.0;
    }

    protected List<String> whetherToShowActivity() {
        Map<String, Object> map = this.initActivity();
        List activity = (List)map.get("activitys");
        this.model.addAttribute("canEdit", (Object)ALLOWEDIT);
        if (activity.size() > 0) {
            this.showActivity(activity, (List)map.get("activityItems"));
        } else {
            this.unShowActivity();
        }
        List aIds = (List)map.get("activityIds");
        return aIds;
    }

    public abstract void handleSubmit(OrderApply var1);

    public abstract List<String> handleEdit();

    protected void initActivityProduct(List<String> productId) {
        for (String pId : productId) {
            if (!this.productMap.containsKey(pId)) continue;
            this.productMap.get(pId).setActivityProduct(ALLOWEDIT);
        }
    }

    protected List<ActivityOrderProduct> fillQuantityToProducts(List<OrderActivityProduct> items) {
        ArrayList<ActivityOrderProduct> activityOrderProducts = new ArrayList<ActivityOrderProduct>();
        if (Beans.isNotEmpty(items)) {
            for (OrderActivityProduct ap : items) {
                if (!this.isViewAll && (Beans.isEmpty((Object)ap.getQuantity()) || ap.getQuantity() == 0.0)) continue;
                ActivityOrderProduct aop = new ActivityOrderProduct();
                if (this.productMap.containsKey(ap.getProductNum())) {
                    Beans.copy((Object)aop, (Object)this.productMap.get(ap.getProductNum()));
                } else {
                    aop.setSpec(ap.getSpecification());
                    aop.setBasePrice(ap.getBasePrice());
                    aop.setPrice(ap.getPrice());
                    aop.setMinUnit(ap.getMinCount());
                    aop.setUnitName(ap.getUnit());
                    aop.setNo(ap.getProductNum());
                    aop.setName(ap.getProductName());
                }
                if (this.getRulePrice(ap.getActivityId(), ap.getProductNum()) != null) {
                    aop.setPrice(ap.getPrice());
                }
                aop.setQuantity(ap.getQuantity());
                aop.setActQuantity(ap.getQuantity());
                aop.setActivityId(ap.getActivityId());
                aop.setActivityName(ap.getActivityName());
                aop.setActivityFlag(ALLOWEDIT);
                aop.setMoney(ap.getMoney());
                aop.setPriceFormula(ap.getPriceFormula());
                aop.setIsFree(ap.getIsFree());
                activityOrderProducts.add(aop);
            }
        }
        return activityOrderProducts;
    }

    public Employee getCurrentEmployee() {
        return this.currentEmployee;
    }

    public AbstractActivityProcessor setCurrentEmployee(Employee currentEmployee) {
        this.currentEmployee = currentEmployee;
        return this;
    }

    public List<OrderProduct> getAllProducts() {
        return this.allProducts;
    }

    public AbstractActivityProcessor setAllProducts(List<OrderProduct> allProducts) {
        this.allProducts = allProducts;
        if (Beans.isNotEmpty(allProducts)) {
            for (OrderProduct o : allProducts) {
                this.productMap.put(o.getNo(), o);
            }
        }
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    public AbstractActivityProcessor setModel(Model model) {
        this.model = model;
        return this;
    }

    public String getOrderState() {
        return this.orderState;
    }

    public AbstractActivityProcessor setOrderState(String orderState) {
        this.orderState = orderState;
        return this;
    }

    public OrderApply getOrderApply() {
        return this.orderApply;
    }

    public AbstractActivityProcessor setOrderApply(OrderApply orderApply) {
        this.orderApply = orderApply;
        return this;
    }

    public boolean isViewAll() {
        return this.isViewAll;
    }

    public void setViewAll(boolean isViewAll) {
        this.isViewAll = isViewAll;
    }

    public static void newfillTotalCountActivitys(OrderApply orderApply, List<OrderActivityInfo> activity, List<String> aIds) {
        AbstractActivityProcessor.newCommonfillTotalCountActivitys(orderApply, activity, aIds, false);
    }

    private static void newCommonfillTotalCountActivitys(OrderApply orderApply, List<OrderActivityInfo> activity, List<String> aIds, boolean isView) {
        ActivityInfoService aService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
        Map<String, PartnerActivityInfo> totals = aService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aIds);
        Map<String, List<PartnerActivityTrack>> trackMap = aService.findPartnerActivityTrackMap(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aIds);
        for (OrderActivityInfo info : activity) {
            AbstractActivityProcessor.calculateAmount(orderApply, info, totals, trackMap, isView);
        }
    }

    public static void newfillTotalCountActivitysForView(OrderApply orderApply, List<OrderActivityInfo> activity, List<String> aIds) {
        AbstractActivityProcessor.newCommonfillTotalCountActivitys(orderApply, activity, aIds, true);
    }

    public static boolean calculateAmount(OrderApply orderApply, OrderActivityInfo activity, Map<String, PartnerActivityInfo> totals, Map<String, List<PartnerActivityTrack>> trackMap, boolean isView) {
        List<PartnerActivityTrack> tracks = trackMap.get(activity.getActivityId());
        Double prePayDel = 0.0;
        Double prePayAdd = 0.0;
        Double actAdd = 0.0;
        Double actDel = 0.0;
        Double validHold = 0.0;
        Double orderPrePayDel = 0.0;
        PartnerActivityInfo paInfo = totals.get(activity.getActivityId());
        Double initValue = Beans.isEmpty((Object)paInfo) ? 0.0 : paInfo.getInitValue();
        if (Beans.isNotEmpty(tracks)) {
            for (PartnerActivityTrack track : tracks) {
                if (Constant.ActivityTrackAddType.prePayAdd.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                    prePayAdd = prePayAdd + track.getChangeValue();
                    continue;
                }
                if (Constant.ActivityTrackAddType.prePayDel.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                    prePayDel = prePayDel + track.getChangeValue();
                    if (!StringUtils.isNotEmpty(orderApply.getId()) || !orderApply.getId().equals(track.getOrderApplyId())) continue;
                    orderPrePayDel = orderPrePayDel + track.getChangeValue();
                    continue;
                }
                if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyAdd.value.equals(track.getAddType())) {
                    actAdd = actAdd + track.getChangeValue();
                    continue;
                }
                if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyDel.value.equals(track.getAddType())) {
                    actDel = actDel + track.getChangeValue();
                    continue;
                }
                if (!Constant.ActivityTrackAddType.historyHold.value.equals(track.getAddType()) || !Constant.ActivityTrackState.valid.value.equals(track.getState()) || track.getOrderApplyId().equals(orderApply.getId())) continue;
                validHold = validHold + track.getChangeValue();
            }
        }
        Double prePayLeft = initValue + prePayAdd - prePayDel;
        Double historyTotal = actAdd - actDel - validHold;
        Double totalCanUse = 0.0;
        if (!isView) {
            if (TCBJEnum.AuditState.approve.getValue().equals(orderApply.getState()) || TCBJEnum.AuditState.approveNoPass.getValue().equals(orderApply.getState())) {
                prePayLeft = prePayLeft + orderPrePayDel;
                prePayDel = prePayDel - orderPrePayDel;
            }
            if (prePayLeft > 0.0) {
                totalCanUse = historyTotal + activity.getCurrentCount() >= initValue ? Double.valueOf(historyTotal + activity.getCurrentCount() - prePayDel) : prePayLeft;
            } else {
                Double initValueTemp = initValue < 0.0 ? 0.0 - initValue : initValue;
                totalCanUse = historyTotal + activity.getCurrentCount() - initValueTemp;
                if (historyTotal >= initValue) {
                    historyTotal = historyTotal - initValue;
                }
            }
        } else if (prePayLeft > 0.0) {
            totalCanUse = historyTotal >= initValue ? Double.valueOf(historyTotal - prePayDel) : prePayLeft;
        } else {
            Double initValueTemp = initValue < 0.0 ? 0.0 - initValue : initValue;
            totalCanUse = historyTotal - initValueTemp;
            if (historyTotal >= initValue) {
                historyTotal = historyTotal - initValue;
            }
        }
        activity.setTotal(historyTotal);
        activity.setTotalCanUse(totalCanUse);
        activity.setPrePayAmountLeft(prePayLeft);
        activity.setInitValue(initValue);
        return totalCanUse > 0.0;
    }

    private Double getRulePrice(String activityId, String productCode) {
        if (this.activitys == null) {
            ArrayList<String> activityIds = new ArrayList<String>();
            for (OrderActivityInfo activityInfo : this.orderApply.getActivitys()) {
                if (NOTALLOWEDIT.equals(activityInfo.getChooseFlag())) continue;
                activityIds.add(activityInfo.getActivityId());
            }
            this.activitys = ActivityPlatformHelper.getActivity(activityIds);
            this.activitys = ActivityPlatformHelper.getMYSYActivity(this.activitys);
        }
        Double ruleMoney = null;
        block1: for (Activity activity : this.activitys) {
            if (!activity.getCode().equals(activityId)) continue;
            List zpList = (List)Jsons.toBean((String)activity.getRuleJson(), List.class);
            Map map = (Map)zpList.get(zpList.size() - 1);
            List giftProducts = (List)((Map)map.get("ruleInfo")).get("rulePrivilege");
            for (Map giftProduct : giftProducts) {
                if (!productCode.equals(((String)giftProduct.get("rule_productCode")).toString())) continue;
                ruleMoney = Double.valueOf((String)giftProduct.get("price"));
                break block1;
            }
        }
        return ruleMoney;
    }
}

