/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PartnerActivityInfo;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.entity.PartnerProductREL;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.crm.order.ActivityInfoService;
import com.tcbj.crm.order.ActivityOrderProduct;
import com.tcbj.crm.order.ActivityPlatformHelper;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.order.ProcessorFactory;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.util.ApplicationContextUtils;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.ui.Model;

public class ActivityHandler {
    public static void view(OrderApply orderApply, String orderState, List<OrderProduct> products, Employee employee, Model model, Boolean isViewAll) {
        AbstractActivityProcessor processor = ProcessorFactory.getProcessor(orderState);
        processor.setAllProducts(products).setCurrentEmployee(employee).setModel(model).setOrderApply(orderApply).setOrderState(orderState).setViewAll(isViewAll);
        processor.doView();
    }

    public static void edit(OrderApply orderApply, String orderState, List<OrderProduct> products, Employee employee, Model model, Boolean isViewAll) {
        AbstractActivityProcessor processor = ProcessorFactory.getProcessor(orderState);
        processor.setAllProducts(products).setCurrentEmployee(employee).setModel(model).setOrderApply(orderApply).setOrderState(orderState).setViewAll(isViewAll);
        processor.doEdit();
    }

    public static void edit(OrderApply orderApply, String orderState, List<OrderProduct> products, Employee employee, Model model) {
        ActivityHandler.edit(orderApply, orderState, products, employee, model, Boolean.TRUE);
    }

    public static void submit(OrderApply orderApply, String orderState) {
        AbstractActivityProcessor processor = ProcessorFactory.getProcessor(orderState);
        processor.setOrderApply(orderApply).setOrderState(orderState);
        processor.doSubmit();
    }

    private static Map<String, OrderProduct> getProducts(String applyerId, String supplierId, List<String> productNos) {
        HashMap<String, OrderProduct> orderProducts = new HashMap<String, OrderProduct>();
        ProductService productService = (ProductService)ApplicationContextUtils.getContext().getBean(ProductService.class);
        List<Object> products = productService.getPartnerProductsByProductNos(applyerId, supplierId, true, productNos);
        for (Object ps : products) {
            Product p = (Product)((Object[])ps)[0];
            PartnerProductREL pd = (PartnerProductREL)((Object[])ps)[1];
            OrderProduct orderProduct = new OrderProduct(p, pd);
            orderProducts.put(orderProduct.getNo(), orderProduct);
        }
        return orderProducts;
    }

    public static Map<String, Object> getActivityProducts(OrderApply orderApply) {
        ArrayList<String> ruleAIds = new ArrayList<String>();
        HashMap<String, OrderActivityInfo> oaiMap = new HashMap<String, OrderActivityInfo>();
        for (OrderActivityInfo info : orderApply.getActivitys()) {
            ruleAIds.add(info.getActivityId());
            oaiMap.put(info.getActivityId(), info);
        }
        ArrayList<OrderApplyItem> orderApplyItem = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            OrderApplyItem itemTemp = new OrderApplyItem();
            Beans.copy((Object)itemTemp, (Object)item);
            if (!TCBJEnum.AuditState.draft.getValue().equals(orderApply.getState())) {
                itemTemp.setQuantity(itemTemp.getActQuantity());
            }
            orderApplyItem.add(itemTemp);
        }
        List<Map<String, Object>> result = ActivityPlatformHelper.getActivityItemFromPlatForm(orderApplyItem, ruleAIds, orderApply.getApplyerId());
        ArrayList<String> productNos = new ArrayList<String>();
        ArrayList<ActivityOrderProduct> aops = new ArrayList<ActivityOrderProduct>();
        if (Beans.isNotEmpty(result)) {
            ActivityInfoService aService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
            Map<String, PartnerActivityInfo> totals = aService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), ruleAIds);
            Map<String, List<PartnerActivityTrack>> trackMap = aService.findPartnerActivityTrackMap(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), ruleAIds);
            for (Map<String, Object> map : result) {
                List productIds;
                OrderActivityInfo oai = (OrderActivityInfo)oaiMap.get(map.get("activityCode").toString());
                if (oai == null) {
                    oai = new OrderActivityInfo();
                }
                oai.setCalType(Beans.isEmpty((Object)map.get("giftType")) ? "" : map.get("giftType").toString());
                oai.setUnit(Beans.isEmpty((Object)map.get("giftType")) ? "" : map.get("giftType").toString());
                oai.setCurrentCount(Beans.isEmpty((Object)map.get("returnValue")) ? 0.0 : Double.valueOf(map.get("returnValue").toString()));
                boolean hasCanUse = AbstractActivityProcessor.calculateAmount(orderApply, oai, totals, trackMap, false);
                if (!"1".equals(oai.getChooseFlag())) continue;
                if (!hasCanUse) {
                    oai.setChooseFlag("0");
                    continue;
                }
                List list = productIds = Beans.isEmpty((Object)map.get("giftProduct")) ? new ArrayList() : (List)map.get("giftProduct");
                if (Beans.isEmpty(productIds)) {
                    if (hasCanUse) {
                        Map<String, List<String>> noRuleProduct = ActivityPlatformHelper.getActivityItemFromPlatFormNoRule(oai.getActivityId());
                        List<String> pIds = noRuleProduct.get(oai.getActivityId());
                        if (Beans.isNotEmpty((Object)pIds)) {
                            for (String pId : pIds) {
                                ActivityOrderProduct aop = new ActivityOrderProduct();
                                aop.setActivityId(oai.getActivityId());
                                aop.setActivityName(oai.getActivityName());
                                aop.setNo(pId);
                                aop.setPartnerId(orderApply.getApplyerId());
                                aops.add(aop);
                                productNos.add(pId);
                            }
                        }
                    } else {
                        oai.setChooseFlag("0");
                        continue;
                    }
                }
                for (Map pId : productIds) {
                    ActivityOrderProduct aop = new ActivityOrderProduct();
                    aop.setActivityId(map.get("activityCode").toString());
                    aop.setActivityName(map.get("activityName").toString());
                    aop.setNo(pId.get("rule_productCode").toString());
                    aop.setPartnerId(orderApply.getApplyerId());
                    aops.add(aop);
                    productNos.add(aop.getNo());
                }
            }
            Map<String, OrderProduct> products = ActivityHandler.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), productNos);
            for (ActivityOrderProduct aop : aops) {
                OrderProduct product = products.get(aop.getNo());
                Beans.copy((Object)aop, (Object)product);
                Activity activity = ActivityPlatformHelper.getActivity(aop.getActivityId());
                List activityRule = (List)Jsons.toBean((String)activity.getRuleJson(), List.class);
                String droolsRuleCode = (String)((Map)activityRule.get(activityRule.size() - 1)).get("droolsRuleCode");
                Map ruleInfo = (Map)((Map)activityRule.get(activityRule.size() - 1)).get("ruleInfo");
                List rulePrivilege = (List)ruleInfo.get("rulePrivilege");
                if ("RULE003".equals(droolsRuleCode)) {
                    for (Map rp : rulePrivilege) {
                        if (!((String)rp.get("rule_productCode")).equals(aop.getNo())) continue;
                        aop.setActivityRulePrice(Double.valueOf(((String)rp.get("price")).toString()));
                        aop.setPrice(aop.getActivityRulePrice());
                        break;
                    }
                }
                aop.setActivityType(activity.getType());
            }
        }
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        rtn.put("activityInfo", orderApply.getActivitys());
        rtn.put("activityProduct", aops);
        return rtn;
    }

    public static void validateActivityProduct(OrderApply orderApply) {
        List<OrderActivityInfo> activitys = orderApply.getActivitys();
        if (Beans.isNotEmpty(activitys)) {
            List<OrderActivityProduct> activityProducts = orderApply.getActivityProducts();
            for (OrderActivityInfo info : activitys) {
                if ("0".equals(info.getChooseFlag())) continue;
                Double currentTotal = 0.0;
                for (OrderActivityProduct product : activityProducts) {
                    if (!info.getActivityId().equals(product.getActivityId()) || Beans.isEmpty((Object)product.getQuantity())) continue;
                    currentTotal = "mon".equals(info.getUnit()) ? Double.valueOf(currentTotal + product.getQuantity() * product.getPrice()) : Double.valueOf(currentTotal + product.getQuantity());
                }
                if (!"1".equals(info.getChooseFlag())) continue;
                boolean isvalid = DateUtils.compare((Date)new Date(), (Date)info.getEndDate());
                if (isvalid && currentTotal > info.getTotalCanUse()) {
                    throw new AppException("0010", "\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u6570\u91cf");
                }
                if (isvalid || !(currentTotal > info.getTotalCanUse() - info.getCurrentCount())) continue;
                throw new AppException("0010", "\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u6570\u91cf");
            }
        }
    }

    public static boolean validateActivity(OrderApply orderApply) {
        List<OrderActivityInfo> orderActivity = orderApply.getActivitys();
        if (Beans.isNotEmpty(orderActivity)) {
            Map<String, OrderActivityInfo> activityMap = ActivityHandler.getActivityMapFromPlatform(orderApply.getApplyerId());
            for (OrderActivityInfo info : orderActivity) {
                if (Beans.isEmpty((Object)activityMap.get(info.getActivityId()))) {
                    return false;
                }
                if (activityMap.get(info.getActivityId()).getLastUpdateTime().getTime() <= info.getLastUpdateTime().getTime()) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<String, OrderActivityInfo> getActivityMapFromPlatform(String applyerId) {
        Map<String, Object> activityInfo = ActivityPlatformHelper.getActivityFromPlatform(applyerId);
        List activityList = (List)activityInfo.get("activityInfo");
        HashMap<String, OrderActivityInfo> map = new HashMap<String, OrderActivityInfo>();
        if (Beans.isNotEmpty((Object)activityList)) {
            for (OrderActivityInfo info : activityList) {
                map.put(info.getActivityId(), info);
            }
        }
        return map;
    }

    public static Map<String, Object> synchronizeActivity(OrderApply orderApply) {
        ActivityInfoService activityService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
        List<OrderActivityInfo> orderActivityList = orderApply.getActivitys();
        Map<String, Object> activityInfo = ActivityPlatformHelper.getActivityFromPlatform(orderApply.getApplyerId());
        List activityList = (List)activityInfo.get("activityInfo");
        HashMap<String, OrderActivityInfo> orderActivityMap = new HashMap<String, OrderActivityInfo>();
        if (Beans.isNotEmpty(orderActivityList)) {
            for (OrderActivityInfo info : orderActivityList) {
                orderActivityMap.put(info.getActivityId(), info);
            }
        }
        for (OrderActivityInfo info : activityList) {
            OrderActivityInfo orderActivity = (OrderActivityInfo)orderActivityMap.get(info.getActivityId());
            if (Beans.isNotEmpty((Object)orderActivity)) {
                info.setTotal(orderActivity.getTotal());
                info.setChooseFlag(orderActivity.getChooseFlag());
                continue;
            }
            ArrayList<String> aId = new ArrayList<String>();
            aId.add(info.getActivityId());
            Map<String, PartnerActivityInfo> total = activityService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aId);
            PartnerActivityInfo painfo = total.get(info.getActivityId());
            if (!Beans.isNotEmpty((Object)painfo)) continue;
            info.setTotal(painfo.getTotalCount());
        }
        ArrayList<OrderApplyItem> items = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            if ("1".equals(item.getActivityFlag())) continue;
            items.add(item);
        }
        OrderApply order = new OrderApply();
        order.setId(orderApply.getId());
        order.setApplyerId(orderApply.getApplyerId());
        order.setSupplierId(orderApply.getSupplierId());
        order.setActivitys(activityList);
        order.setOrderApplyItems(items);
        Map<String, Object> result = ActivityHandler.getActivityProducts(order);
        List newActivityList = (List)result.get("activityInfo");
        HashMap<String, OrderActivityInfo> newActivityMap = new HashMap<String, OrderActivityInfo>();
        for (OrderActivityInfo info : newActivityList) {
            newActivityMap.put(info.getActivityId(), info);
        }
        for (OrderActivityInfo info : orderActivityList) {
            ActivityOrderProduct p;
            Iterator iter;
            List aops;
            OrderActivityInfo newActivity = (OrderActivityInfo)newActivityMap.get(info.getActivityId());
            if (Beans.isEmpty((Object)newActivity)) {
                aops = (List)result.get("activityProduct");
                if (!Beans.isNotEmpty((Object)aops)) continue;
                iter = aops.iterator();
                while (iter.hasNext()) {
                    p = (ActivityOrderProduct)iter.next();
                    if (!p.getActivityId().equals(info.getActivityId())) continue;
                    iter.remove();
                }
                continue;
            }
            if (newActivity.getLastUpdateTime().getTime() <= info.getLastUpdateTime().getTime()) continue;
            aops = (List)result.get("activityProduct");
            if (Beans.isNotEmpty((Object)aops)) {
                iter = aops.iterator();
                while (iter.hasNext()) {
                    p = (ActivityOrderProduct)iter.next();
                    if (!p.getActivityId().equals(info.getActivityId())) continue;
                    iter.remove();
                }
            }
            newActivity.setChooseFlag("0");
        }
        result.put("activityItems", result.get("activityProduct"));
        result.put("activitys", result.get("activityInfo"));
        return result;
    }

    public static void checkOrderCanUnapprove(OrderApply orderApply) {
        ActivityInfoService activityInfoService = (ActivityInfoService)ApplicationContextUtils.getContext().getBean(ActivityInfoService.class);
        List<OrderActivityInfo> activitys = orderApply.getActivitys();
        ArrayList<String> aIds = new ArrayList<String>();
        if (Beans.isNotEmpty(activitys)) {
            for (OrderActivityInfo activity : activitys) {
                aIds.add(activity.getActivityId());
            }
            Map<String, PartnerActivityInfo> historyTotals = activityInfoService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aIds);
            for (OrderActivityInfo info : activitys) {
                PartnerActivityInfo paInfo = historyTotals.get(info.getActivityId());
                if (!"1".equals(paInfo.getReturnFlag())) continue;
                String orderId = paInfo.getRemark();
                if (!orderApply.getId().equals(orderId)) continue;
                throw new AppException("0010", "\u672c\u5355\u662f\u6263\u51cf\u6d3b\u52a8(" + info.getActivityId() + ":" + info.getActivityName() + ") \u9884\u652f\u503c\u7684\u8ba2\u5355\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6279");
            }
        }
    }
}

