/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.PartnerActivityInfo;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activityInfoService")
public class ActivityInfoService {
    @Autowired
    private NewBaseDao newBaseDao;
    @Autowired
    PartnerService service;

    public List<OrderActivityInfo> getActivityByOrderApplyId(String orderApplyId) {
        String hql = "from OrderActivityInfo a where a.orderApplyId = '" + orderApplyId + "'";
        List<OrderActivityInfo> result = this.newBaseDao.findByHql(hql);
        return result;
    }

    public List<OrderActivityProduct> getActivityProductByOIdAndAIds(String orderApplyId, List<String> activityIds) {
        StringBuilder hql = new StringBuilder("from OrderActivityProduct a where a.orderApplyId = '" + orderApplyId + "' ");
        if (Beans.isNotEmpty(activityIds)) {
            hql.append(" and a.activityId in(");
            int i = 0;
            while (i < activityIds.size()) {
                hql.append("'" + activityIds.get(i) + "'");
                if (i == activityIds.size() - 1) {
                    hql.append(")");
                } else {
                    hql.append(",");
                }
                ++i;
            }
        }
        List<OrderActivityProduct> result = this.newBaseDao.findByHql(hql.toString());
        return result;
    }

    public Map<String, OrderActivityInfo> getMapActivityByOrderApplyId(String orderApplyId) {
        HashMap<String, OrderActivityInfo> map = new HashMap<String, OrderActivityInfo>();
        List<OrderActivityInfo> list = this.getActivityByOrderApplyId(orderApplyId);
        if (Beans.isNotEmpty(list)) {
            for (OrderActivityInfo info : list) {
                map.put(info.getActivityId(), info);
            }
        }
        return map;
    }

    public Map<String, List<OrderActivityProduct>> getMapActivityProductByOIdAndAIds(String orderApplyId, List<String> activityIds) {
        HashMap<String, List<OrderActivityProduct>> map = new HashMap<String, List<OrderActivityProduct>>();
        List<OrderActivityProduct> list = this.getActivityProductByOIdAndAIds(orderApplyId, activityIds);
        if (Beans.isNotEmpty(list)) {
            for (OrderActivityProduct p : list) {
                ArrayList<OrderActivityProduct> l = (ArrayList<OrderActivityProduct>)map.get(p.getActivityId());
                if (Beans.isEmpty((Object)l)) {
                    l = new ArrayList<OrderActivityProduct>();
                    map.put(p.getActivityId(), l);
                }
                l.add(p);
            }
        }
        return map;
    }

    public int deleteOrderActivityProductByOIdAndAIds(String orderApplyId, List<String> activityIds) {
        StringBuilder hql = new StringBuilder("delete from OrderActivityProduct a where a.orderApplyId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(orderApplyId);
        if (Beans.isNotEmpty(activityIds)) {
            hql.append(" and a.activityId in (");
            int i = 0;
            while (i < activityIds.size()) {
                hql.append("?");
                args.add(activityIds.get(i));
                if (i == activityIds.size() - 1) {
                    hql.append(")");
                } else {
                    hql.append(",");
                }
                ++i;
            }
        }
        return this.newBaseDao.updateByHql(hql.toString(), args);
    }

    public void saveOrderActivityAndProduct(String orderApplyId, List<OrderActivityInfo> activitys, List<OrderActivityProduct> newList) {
        List<String> activityIds = this.saveActivityInfo(orderApplyId, activitys);
        this.saveActivityProduct(orderApplyId, activityIds, newList);
    }

    private void saveActivityProduct(String orderApplyId, List<String> activityIds, List<OrderActivityProduct> newList) {
        HashSet<String> needToDelete = new HashSet<String>();
        if (Beans.isEmpty(activityIds)) {
            this.deleteOrderActivityProductByOIdAndAIds(orderApplyId, null);
            return;
        }
        Map<String, List<OrderActivityProduct>> oldActivityProducts = this.getMapActivityProductByOIdAndAIds(orderApplyId, null);
        if (Beans.isNotEmpty(newList)) {
            block0: for (OrderActivityProduct activityProduct : newList) {
                if (oldActivityProducts.containsKey(activityProduct.getActivityId())) {
                    List<OrderActivityProduct> pList = oldActivityProducts.get(activityProduct.getActivityId());
                    for (OrderActivityProduct p : pList) {
                        if (!p.getProductNum().equals(activityProduct.getProductNum())) continue;
                        Beans.copy((Object)p, (Object)activityProduct);
                        this.newBaseDao.update(p);
                        continue block0;
                    }
                    continue;
                }
                activityProduct.setOrderApplyId(orderApplyId);
                this.newBaseDao.save(activityProduct);
            }
        }
        for (String key : oldActivityProducts.keySet()) {
            if (activityIds.contains(key)) continue;
            needToDelete.add(key);
        }
        if (Beans.isNotEmpty(needToDelete)) {
            this.deleteOrderActivityProductByOIdAndAIds(orderApplyId, new ArrayList<String>(needToDelete));
        }
    }

    private List<String> saveActivityInfo(String orderApplyId, List<OrderActivityInfo> activitys) {
        Map<String, OrderActivityInfo> oldActivityMap = this.getMapActivityByOrderApplyId(orderApplyId);
        HashMap<String, OrderActivityInfo> newActivityMap = new HashMap<String, OrderActivityInfo>();
        ArrayList<String> activityIds = new ArrayList<String>();
        ArrayList<String> needToDeleteIds = new ArrayList<String>();
        if (Beans.isEmpty(activitys)) {
            this.deleteActivityInfoByOIdAndAIds(orderApplyId, null);
            return activityIds;
        }
        for (OrderActivityInfo act : activitys) {
            if ("1".equals(act.getChooseFlag())) {
                activityIds.add(act.getActivityId());
            }
            act.setOrderApplyId(orderApplyId);
            newActivityMap.put(act.getActivityId(), act);
        }
        if (Beans.isEmpty(oldActivityMap)) {
            this.newBaseDao.saveAll(activitys);
        } else {
            for (OrderActivityInfo act : activitys) {
                if (oldActivityMap.containsKey(act.getActivityId())) {
                    Beans.copy((Object)oldActivityMap.get(act.getActivityId()), (Object)act);
                    this.newBaseDao.update(oldActivityMap.get(act.getActivityId()));
                    continue;
                }
                this.newBaseDao.save(act);
            }
            for (String actId : oldActivityMap.keySet()) {
                if (newActivityMap.containsKey(actId)) continue;
                needToDeleteIds.add(actId);
            }
        }
        if (Beans.isNotEmpty(needToDeleteIds)) {
            this.deleteActivityInfoByOIdAndAIds(orderApplyId, needToDeleteIds);
        }
        return activityIds;
    }

    private int deleteActivityInfoByOIdAndAIds(String orderApplyId, List<String> activityIds) {
        StringBuilder hql = new StringBuilder("delete from OrderActivityInfo a where a.orderApplyId = ? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(orderApplyId);
        if (Beans.isNotEmpty(activityIds)) {
            hql.append(" and a.activityId in (");
            int i = 0;
            while (i < activityIds.size()) {
                hql.append("?");
                args.add(activityIds.get(i));
                if (i == activityIds.size() - 1) {
                    hql.append(")");
                } else {
                    hql.append(",");
                }
                ++i;
            }
        }
        return this.newBaseDao.updateByHql(hql.toString(), args);
    }

    public Map<String, PartnerActivityInfo> findTotalHistoryCountByPartnerIdAndAids(String partnerId, List<String> activityIds) {
        HashMap<String, PartnerActivityInfo> map = new HashMap<String, PartnerActivityInfo>();
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder hql = new StringBuilder(" from PartnerActivityInfo a where a.partnerId = ? and a.orgCode = ? and a.activityId in (");
        args.add(partnerId);
        args.add(StringUtils.getOrgId());
        int i = 0;
        while (i < activityIds.size()) {
            hql.append("?");
            args.add(activityIds.get(i));
            if (i == activityIds.size() - 1) {
                hql.append(")");
            } else {
                hql.append(",");
            }
            ++i;
        }
        List result = this.newBaseDao.findByHql(hql.toString(), args);
        if (Beans.isNotEmpty(result)) {
            for (PartnerActivityInfo info : result) {
                map.put(info.getActivityId(), info);
            }
        }
        return map;
    }

    public PartnerActivityInfo getPartnerActivity(String partnerId, String aId) {
        String hql = " from PartnerActivityInfo a where a.partnerId = '" + partnerId + "' and a.activityId = '" + aId + "' and a.orgCode = '" + StringUtils.getOrgId() + "'";
        List result = this.newBaseDao.findByHql(hql);
        if (Beans.isNotEmpty(result)) {
            return (PartnerActivityInfo)result.get(0);
        }
        return null;
    }

    public Page queryPartnerActivity(OrderApplyCondition condition) {
        StringBuilder sql = new StringBuilder("select a.ID \"id\", a.activity_Id \"activityId\", a.partner_id \"partnerId\",a.partner_name \"partnerName\",a.initValue \"initValue\", a.create_date \"createDate\" ");
        sql.append("from cx_indent_partner_activity a where 1=1 and a.orgCode = '" + StringUtils.getOrgId() + "' ");
        if (Beans.isNotEmpty((Object)condition)) {
            if (Beans.isNotEmpty((Object)condition.getApplyerName())) {
                sql.append(" and a.partner_name like '%" + condition.getApplyerName() + "%'");
            }
            if (Beans.isNotEmpty((Object)condition.getApplyerId())) {
                sql.append("  and  a.partner_id = '" + condition.getApplyerId() + "'");
            }
            if (Beans.isNotEmpty((Object)condition.getId())) {
                sql.append("  and  a.id = '" + condition.getId() + "'");
            }
        }
        sql.append(" order by a.CREATE_DATE desc");
        Page p = this.newBaseDao.findPageBySql(sql.toString(), null, condition.getPageno(), Constant.DEFAULT_ROWS);
        List result = p.getList();
        if (Beans.isNotEmpty((Object)result)) {
            for (Map map : result) {
                String returnFlag;
                List<PartnerActivityTrack> tracks = this.findPartnerActivityTrackByPIdAndAId(map.get("partnerId").toString(), map.get("activityId").toString());
                Double prePayDel = 0.0;
                Double prePayAdd = 0.0;
                Double actAdd = 0.0;
                Double actDel = 0.0;
                Double validHold = 0.0;
                Double initValue = Beans.isNotEmpty(map.get("initValue")) ? Double.valueOf(map.get("initValue").toString()) : 0.0;
                if (Beans.isNotEmpty(tracks)) {
                    for (PartnerActivityTrack track : tracks) {
                        if (Constant.ActivityTrackAddType.prePayAdd.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                            prePayAdd = prePayAdd + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackAddType.prePayDel.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                            prePayDel = prePayDel + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyAdd.value.equals(track.getAddType())) {
                            actAdd = actAdd + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyDel.value.equals(track.getAddType())) {
                            actDel = actDel + track.getChangeValue();
                            continue;
                        }
                        if (!Constant.ActivityTrackAddType.historyHold.value.equals(track.getAddType()) || !Constant.ActivityTrackState.valid.value.equals(track.getState())) continue;
                        validHold = validHold + track.getChangeValue();
                    }
                }
                Double prePayLeft = initValue + prePayAdd - prePayDel;
                Double historyTotal = actAdd - actDel - validHold;
                map.put("totalUse", actDel);
                map.put("totalGain", actAdd);
                map.put("prePayLeft", prePayLeft);
                initValue = initValue < 0.0 ? 0.0 - initValue : initValue;
                String string = initValue == 0.0 ? "-" : (prePayLeft > 0.0 ? "\u5426" : (returnFlag = historyTotal >= initValue ? "\u662f" : "\u5426"));
                historyTotal = prePayLeft > 0.0 ? historyTotal : (historyTotal < initValue ? historyTotal : historyTotal - initValue);
                map.put("returnFlag", returnFlag);
                map.put("historyTotal", historyTotal);
            }
        }
        return p;
    }

    public void calculateActivityAmount(List<PartnerActivityInfo> list) {
        if (Beans.isNotEmpty(list)) {
            for (PartnerActivityInfo info : list) {
                String returnFlag;
                List<PartnerActivityTrack> tracks = this.findPartnerActivityTrackByPIdAndAId(info.getPartnerId(), info.getActivityId());
                Double prePayDel = 0.0;
                Double prePayAdd = 0.0;
                Double actAdd = 0.0;
                Double actDel = 0.0;
                Double validHold = 0.0;
                Double initValue = info.getInitValue();
                if (Beans.isNotEmpty(tracks)) {
                    for (PartnerActivityTrack track : tracks) {
                        if (Constant.ActivityTrackAddType.prePayAdd.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                            prePayAdd = prePayAdd + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackAddType.prePayDel.value.equals(track.getAddType()) && Constant.ActivityTrackState.valid.value.equals(track.getState())) {
                            prePayDel = prePayDel + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyAdd.value.equals(track.getAddType())) {
                            actAdd = actAdd + track.getChangeValue();
                            continue;
                        }
                        if (Constant.ActivityTrackState.valid.value.equals(track.getState()) && Constant.ActivityTrackAddType.historyDel.value.equals(track.getAddType())) {
                            actDel = actDel + track.getChangeValue();
                            continue;
                        }
                        if (!Constant.ActivityTrackAddType.historyHold.value.equals(track.getAddType()) || !Constant.ActivityTrackState.valid.value.equals(track.getState())) continue;
                        validHold = validHold + track.getChangeValue();
                    }
                }
                Double prePayLeft = initValue + prePayAdd - prePayDel;
                Double historyTotal = actAdd - actDel - validHold;
                info.setTotalUse(actDel);
                info.setTotalGain(actAdd);
                info.setPrePayLeft(prePayLeft);
                String string = initValue == 0.0 ? "-" : (prePayLeft > 0.0 ? "\u5426" : (returnFlag = historyTotal >= initValue ? "\u662f" : "\u5426"));
                historyTotal = prePayLeft > 0.0 ? historyTotal : (historyTotal < initValue ? historyTotal : historyTotal - initValue);
                info.setReturnFlag(returnFlag);
                info.setTotalCount(historyTotal);
            }
        }
    }

    public void savePartnerAcitivtyInfo(String partnerId, Map<String, PartnerActivityInfo> infos) {
        for (String aId : infos.keySet()) {
            PartnerActivityInfo oldInfo = infos.get(aId);
            if (Beans.isEmpty((Object)oldInfo.getId())) {
                oldInfo.setActivityId(aId);
                oldInfo.setCreateDate(new Date());
                oldInfo.setModifyDate(new Date());
                oldInfo.setPartnerId(partnerId);
                oldInfo.setInitValue(0.0);
                oldInfo.setReturnFlag("0");
                oldInfo.setPartnerName(Cache.getPartnerByNo(partnerId).getName());
                oldInfo.setOrgCode(StringUtils.getOrgId());
                this.newBaseDao.save(oldInfo);
                continue;
            }
            oldInfo.setModifyDate(new Date());
            this.newBaseDao.update(oldInfo);
        }
    }

    public OrderActivityInfo getActivityByActivityId(String activityId) {
        String hql = "from OrderActivityInfo a where a.activityId = '" + activityId + "'";
        OrderActivityInfo info = (OrderActivityInfo)this.newBaseDao.findByHqlUnique(hql, null);
        return info;
    }

    public Map<String, String> addPartnerActivity(List<Map> data) {
        ArrayList<PartnerActivityInfo> needToAdd = new ArrayList<PartnerActivityInfo>();
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        HashMap<String, String> dulplicate = new HashMap<String, String>();
        ArrayList<PartnerActivityInfo> needToUpdate = new ArrayList<PartnerActivityInfo>();
        if (Beans.isNotEmpty(data)) {
            int i = 2;
            BigDecimal initValue = null;
            for (Map m : data) {
                if (Beans.isEmpty(m.get("partnerId")) || Beans.isEmpty(m.get("activityId")) || Beans.isEmpty(m.get("initValue"))) {
                    errorMsg.put(String.valueOf(i), "\u7ecf\u9500\u5546\u7f16\u53f7,\u6d3b\u52a8ID,\u671f\u521d\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    ++i;
                    continue;
                }
                String partnerId = m.get("partnerId").toString();
                String activityId = m.get("activityId").toString();
                if (dulplicate.containsKey(String.valueOf(partnerId) + activityId)) {
                    dulplicate.put(String.valueOf(partnerId) + activityId, String.valueOf((String)dulplicate.get(String.valueOf(partnerId) + activityId)) + "," + String.valueOf(i));
                    ++i;
                    continue;
                }
                dulplicate.put(String.valueOf(partnerId) + activityId, String.valueOf(i));
                try {
                    initValue = new BigDecimal(m.get("initValue").toString());
                }
                catch (NumberFormatException numberFormatException) {
                    errorMsg.put(String.valueOf(i), "\u671f\u521d\u503c\u53ea\u80fd\u662f\u6570\u5b57");
                    ++i;
                    continue;
                }
                int compareResult = initValue.compareTo(Constant.MONEY_MAX_VALUE);
                if (compareResult == 1 || compareResult == 0) {
                    errorMsg.put(String.valueOf(i), "\u671f\u521d\u503c\u592a\u5927");
                    ++i;
                    continue;
                }
                if (Beans.isEmpty((Object)Cache.getPartnerByNoAndOrgCode(partnerId))) {
                    errorMsg.put(String.valueOf(i), "\u7ecf\u9500\u5546\u4e0d\u5b58\u5728");
                    ++i;
                    continue;
                }
                PartnerActivityInfo info = this.getPartnerActivity(partnerId, activityId);
                if (Beans.isEmpty((Object)info)) {
                    info = new PartnerActivityInfo();
                    info.setActivityId(activityId);
                    info.setCreateDate(new Date());
                    info.setInitValue(initValue.doubleValue());
                    info.setModifyDate(new Date());
                    info.setPartnerId(Cache.getPartnerByNo(partnerId).getNo());
                    info.setPartnerName(Cache.getPartnerByNo(partnerId).getName());
                    info.setReturnFlag("0");
                    info.setTotalCount(0.0);
                    info.setTotalGain(0.0);
                    info.setTotalUse(0.0);
                    info.setOrgCode(StringUtils.getOrgId());
                    needToAdd.add(info);
                } else {
                    info.setInitValue(initValue.doubleValue());
                    needToUpdate.add(info);
                }
                ++i;
            }
            if (Beans.isNotEmpty(dulplicate)) {
                for (String key : dulplicate.keySet()) {
                    String value = (String)dulplicate.get(key);
                    if (value.indexOf(",") == -1) continue;
                    errorMsg.put(value, "\u91cd\u590d\u7684\u7ecf\u9500\u5546\u6d3b\u52a8\u6570\u636e");
                }
            }
            if (Beans.isEmpty(errorMsg) && Beans.isNotEmpty(needToAdd)) {
                try {
                    this.newBaseDao.saveAll(needToAdd);
                    this.newBaseDao.updateAll(needToUpdate);
                }
                catch (Exception exception) {
                    throw new AppException("0010", "\u6570\u636e\u9519\u8bef\u6216\u6570\u636e\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165");
                }
            }
        }
        return Beans.isEmpty(errorMsg) ? null : errorMsg;
    }

    public List<PartnerActivityTrack> findPartnerActivityTrackByPIdAndAId(String partnerId, String activityId) {
        String hql = " from PartnerActivityTrack a where a.partnerId = '" + partnerId + "' and a.activityId = '" + activityId + "'";
        List<PartnerActivityTrack> result = this.newBaseDao.findByHql(hql);
        return result;
    }

    public Map<String, List<PartnerActivityTrack>> findPartnerActivityTrackMap(String partnerId, List<String> aIds) {
        StringBuilder hql = new StringBuilder(" from PartnerActivityTrack a where a.partnerId = '" + partnerId + "' ");
        if (Beans.isNotEmpty(aIds)) {
            hql.append(" and a.activityId in(");
            int i = 0;
            while (i < aIds.size()) {
                hql.append("'" + aIds.get(i) + "'");
                if (i == aIds.size() - 1) {
                    hql.append(")");
                } else {
                    hql.append(",");
                }
                ++i;
            }
        }
        List result = this.newBaseDao.findByHql(hql.toString());
        HashMap<String, List<PartnerActivityTrack>> map = new HashMap<String, List<PartnerActivityTrack>>();
        if (Beans.isNotEmpty(result)) {
            for (PartnerActivityTrack p : result) {
                ArrayList<PartnerActivityTrack> l = (ArrayList<PartnerActivityTrack>)map.get(p.getActivityId());
                if (Beans.isEmpty((Object)l)) {
                    l = new ArrayList<PartnerActivityTrack>();
                    map.put(p.getActivityId(), l);
                }
                l.add(p);
            }
        }
        return map;
    }

    public Map<String, List<PartnerActivityTrack>> findPartnerActivityTrackMapByOrderId(String orderId) {
        StringBuilder hql = new StringBuilder(" from PartnerActivityTrack a where a.orderApplyId = '" + orderId + "' ");
        List result = this.newBaseDao.findByHql(hql.toString());
        HashMap<String, List<PartnerActivityTrack>> map = new HashMap<String, List<PartnerActivityTrack>>();
        if (Beans.isNotEmpty(result)) {
            for (PartnerActivityTrack p : result) {
                ArrayList<PartnerActivityTrack> l = (ArrayList<PartnerActivityTrack>)map.get(p.getActivityId());
                if (Beans.isEmpty((Object)l)) {
                    l = new ArrayList<PartnerActivityTrack>();
                    map.put(p.getActivityId(), l);
                }
                l.add(p);
            }
        }
        return map;
    }

    public void saveAndUpdatePartnerTrack(Map<String, List<PartnerActivityTrack>> persistList) {
        for (String key : persistList.keySet()) {
            if ("add".equals(key)) {
                this.newBaseDao.saveAll(persistList.get(key));
                continue;
            }
            this.newBaseDao.updateAll(persistList.get(key));
        }
    }

    public void updateInitValue(String id, String initValue) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(id);
        List partnerActivityInfos = this.newBaseDao.findByHql("from PartnerActivityInfo where id = ?", args);
        PartnerActivityInfo partnerActivityInfo = (PartnerActivityInfo)partnerActivityInfos.get(0);
        partnerActivityInfo.setInitValue(Double.valueOf(initValue));
        this.newBaseDao.update(partnerActivityInfo);
    }

    public Map<String, Object> get(String id) {
        OrderApplyCondition oac = new OrderApplyCondition();
        oac.setId(id);
        Page page = this.queryPartnerActivity(oac);
        if (Beans.isNotEmpty((Object)page.getList())) {
            List result = page.getList();
            return (Map)result.get(0);
        }
        return null;
    }
}

