/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.activityPlat.Activity;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.util.ActivityRequestHelper;
import com.tcbj.crm.util.PropertyManager;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.Product;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityPlatformHelper {
    public static final Logger logger = LoggerFactory.getLogger(ActivityPlatformHelper.class);

    public static Map<String, Object> getActivityFromPlatform(String partnerid) {
        String url = StringUtils.getConfigure("act_activityInfo_url");
        HashMap<String, String> map = new HashMap<String, String>();
        String dateStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        map.put("organization", StringUtils.getPrefix());
        map.put("partner_id", partnerid);
        map.put("status", "1");
        map.put("beginDate_end", dateStr);
        map.put("endDate_start", dateStr);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        ArrayList<OrderActivityInfo> infoList = new ArrayList<OrderActivityInfo>();
        List productIds = new ArrayList();
        try {
            Map finalresult;
            String response = ActivityRequestHelper.getInstance().sendBody(url, map);
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            if ("00".equals(result.get("errorCode")) && Beans.isNotEmpty((Object)(finalresult = (Map)result.get("returnObject")))) {
                if (Beans.isNotEmpty(finalresult.get("returnActivityInfos"))) {
                    List activityInfos = (List)finalresult.get("returnActivityInfos");
                    for (Map info : activityInfos) {
                        OrderActivityInfo oai = new OrderActivityInfo();
                        oai.setActivityId(info.get("code").toString());
                        oai.setActivityName(info.get("name").toString());
                        oai.setActivityRule(info.get("description").toString());
                        oai.setShowStartDate(info.get("beginDate").toString());
                        oai.setShowEndDate(info.get("endDate").toString());
                        oai.setShowLastUpdateTime(info.get("lastUpdateDate").toString());
                        oai.setType(info.get("type") == null ? "" : info.get("type").toString());
                        infoList.add(oai);
                    }
                }
                if (Beans.isNotEmpty(finalresult.get("returnProducts"))) {
                    productIds = (List)finalresult.get("returnProducts");
                }
            }
        }
        catch (Exception exception) {
            logger.error("\u8fde\u63a5\u6d3b\u52a8\u5e73\u53f0\u9519\u8bef\u6216\u6d3b\u52a8\u5e73\u53f0\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
        }
        rtn.put("activityInfo", infoList);
        rtn.put("productIds", productIds);
        return rtn;
    }

    public static List<Map<String, Object>> getActivityItemFromPlatForm(List<OrderApplyItem> item, List<String> activityList, String partner_id) {
        String url = StringUtils.getConfigure("act_activityProduct_url");
        HashMap<String, Object> mappara = new HashMap<String, Object>();
        ArrayList items = new ArrayList();
        Double productallcount = 0.0;
        Double ordermoney = 0.0;
        for (OrderApplyItem temp : item) {
            Product p = Cache.getProduct(temp.getProductId());
            if (!Beans.isNotEmpty((Object)p) || !"PRODUCT".equals(p.getOrderProdType())) continue;
            HashMap<String, Object> itemmap = new HashMap<String, Object>();
            itemmap.put("productCode", temp.getNo());
            itemmap.put("productCodeCount", temp.getQuantity());
            itemmap.put("productMoney", temp.getPrice());
            items.add(itemmap);
            productallcount = productallcount + temp.getQuantity();
            if (!(temp.getQuantity() > 0.0)) continue;
            ordermoney = Beans.isNotEmpty((Object)temp.getMoney()) ? Double.valueOf(ordermoney + temp.getMoney()) : Double.valueOf(ordermoney + temp.getQuantity() * temp.getPrice());
        }
        mappara.put("productAllCount", productallcount);
        mappara.put("items", items);
        mappara.put("activityList", StringUtils.listToString(activityList, ","));
        mappara.put("orderMoney", ordermoney);
        mappara.put("partner_id", partner_id);
        String jsonpara = Jsons.toJson(mappara);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("jsonStr", jsonpara);
        param.put("organization", StringUtils.getPrefix());
        try {
            List finalresult;
            String response = ActivityRequestHelper.getInstance().sendBody(url, param);
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            if ("00".equals(result.get("errorCode")) && Beans.isNotEmpty((Object)(finalresult = (List)result.get("returnObject")))) {
                return finalresult;
            }
        }
        catch (Exception exception) {
            logger.error("\u8fde\u63a5\u6d3b\u52a8\u5e73\u53f0\u9519\u8bef\u6216\u6d3b\u52a8\u5e73\u53f0\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
        }
        return null;
    }

    public static Map<String, List<String>> getActivityItemFromPlatFormNoRule(String activityIds) {
        HashMap<String, List<String>> rtn = new HashMap<String, List<String>>();
        List<Map<String, Object>> list = ActivityPlatformHelper.getActivityItem(activityIds);
        try {
            if (Beans.isNotEmpty(list)) {
                for (Map<String, Object> o : list) {
                    ArrayList<String> pCode = (ArrayList<String>)rtn.get(o.get("activityCode"));
                    if (Beans.isEmpty((Object)pCode)) {
                        pCode = new ArrayList<String>();
                        rtn.put(o.get("activityCode").toString(), pCode);
                    }
                    pCode.add(o.get("rule_productCode").toString());
                }
            }
        }
        catch (Exception exception) {
            logger.error("\u8fde\u63a5\u6d3b\u52a8\u5e73\u53f0\u9519\u8bef\u6216\u6d3b\u52a8\u5e73\u53f0\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
        }
        return rtn;
    }

    public static List<Map<String, Object>> getActivityItem(String activityIds) {
        String url = StringUtils.getConfigure("act_activityProduct_norule_url");
        String organization = StringUtils.getPrefix();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("organization", organization);
        map.put("code", activityIds);
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            String response = ActivityRequestHelper.getInstance().sendBody(url, map);
            Map result = (Map)Jsons.toBean((String)response, Map.class);
            if ("00".equals(result.get("errorCode")) && Beans.isNotEmpty(result.get("returnObject"))) {
                list = (List)result.get("returnObject");
            }
        }
        catch (Exception exception) {
            logger.error("\u8fde\u63a5\u6d3b\u52a8\u5e73\u53f0\u9519\u8bef\u6216\u6d3b\u52a8\u5e73\u53f0\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32");
        }
        return list;
    }

    public static Activity getActivity(String activityId) {
        String URL2 = PropertyManager.getProperty("act_activity");
        String url = String.valueOf(URL2) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        String organization = StringUtils.getPrefix();
        map.put("organization", organization);
        map.put("code", activityId);
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        Map<String, Object> activityInfo = EsbAnalyUtil.getResult(body, "activityInfo");
        Activity activity = new Activity();
        Beans.copy((Object)activity, activityInfo);
        ArrayList ruleList = new ArrayList();
        Map<String, Object> variabls = EsbAnalyUtil.getResult(body, "variabls");
        HashMap<String, Object> ruleData = new HashMap<String, Object>();
        if (variabls != null) {
            activity.setPartnerJson(variabls.get("fwList").toString());
            ruleData.put("activityType", variabls.get("activityType").toString());
            ruleData.put("droolsRuleCode", variabls.get("droolsRuleCode").toString());
            ruleData.put("creatDate", variabls.get("creatDate").toString());
            ruleData.put("priceFlag", variabls.get("priceFlag").toString());
            ruleData.put("partFlag", variabls.get("partFlag").toString());
            List zpList = (List)Jsons.toBean((String)variabls.get("zpList").toString(), List.class);
            variabls.put("rulePrivilege", zpList);
            List tjList = (List)Jsons.toBean((String)variabls.get("tjList").toString(), List.class);
            variabls.put("ruleCondition", tjList);
            variabls.remove("fwList");
            variabls.remove("zpList");
            variabls.remove("tjList");
            variabls.remove("channel_id");
            variabls.remove("district_id");
            variabls.remove("region_id");
            variabls.remove("partner_id");
            ruleData.put("ruleInfo", variabls);
        }
        ruleList.add(ruleData);
        activity.setRuleJson(Jsons.toJson(ruleList));
        return activity;
    }

    public static List<Activity> getActivity(List<String> activityId) {
        String URL2 = PropertyManager.getProperty("act_activity");
        String url = String.valueOf(URL2) + "ActivityApi/queryActivityInfo";
        HashMap<String, String> map = new HashMap<String, String>();
        String organization = StringUtils.getPrefix();
        map.put("organization", organization);
        if (Beans.isEmpty(activityId)) {
            return null;
        }
        String activityIds = "";
        for (String id : activityId) {
            activityIds = String.valueOf(activityIds) + id + ",";
        }
        map.put("code", activityIds.substring(0, activityIds.lastIndexOf(44)));
        String body = ActivityRequestHelper.getInstance().sendBody(url, map);
        List<Map<String, Object>> returnObjects = EsbAnalyUtil.getResult3(body);
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        for (Map<String, Object> returnObject : returnObjects) {
            Map activityInfo = (Map)returnObject.get("activityInfo");
            Map variabls = (Map)returnObject.get("variabls");
            Activity activity = new Activity();
            Beans.copy((Object)activity, (Map)activityInfo);
            ArrayList ruleList = new ArrayList();
            HashMap<String, Object> ruleData = new HashMap<String, Object>();
            if (variabls != null) {
                activity.setPartnerJson(variabls.get("fwList").toString());
                ruleData.put("activityType", variabls.get("activityType").toString());
                ruleData.put("droolsRuleCode", variabls.get("droolsRuleCode").toString());
                ruleData.put("creatDate", variabls.get("creatDate").toString());
                ruleData.put("priceFlag", variabls.get("priceFlag").toString());
                ruleData.put("partFlag", variabls.get("partFlag").toString());
                List zpList = (List)Jsons.toBean((String)variabls.get("zpList").toString(), List.class);
                variabls.put("rulePrivilege", zpList);
                List tjList = (List)Jsons.toBean((String)variabls.get("tjList").toString(), List.class);
                variabls.put("ruleCondition", tjList);
                variabls.remove("fwList");
                variabls.remove("zpList");
                variabls.remove("tjList");
                variabls.remove("channel_id");
                variabls.remove("district_id");
                variabls.remove("region_id");
                variabls.remove("partner_id");
                ruleData.put("ruleInfo", variabls);
            }
            ruleList.add(ruleData);
            activity.setRuleJson(Jsons.toJson(ruleList));
            activityList.add(activity);
        }
        return activityList;
    }

    public static List<Activity> getMYSYActivity(List<Activity> activitys) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        if (activitys != null) {
            for (Activity activity : activitys) {
                List zpList;
                Map map;
                if (StringUtils.isEmpty(activity.getRuleJson()) || !"RULE003".equals((map = (Map)(zpList = (List)Jsons.toBean((String)activity.getRuleJson(), List.class)).get(zpList.size() - 1)).get("droolsRuleCode"))) continue;
                arrayList.add(activity);
            }
        }
        return arrayList;
    }

    public static void main(String[] args) {
        Map<String, Object> resultfinal = ActivityPlatformHelper.getActivityFromPlatform("1-2PTF");
        System.out.println("done:-------------" + resultfinal);
    }
}

