/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.PartnerActivityInfo;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.util.Beans;
import com.tcbj.util.Jsons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApproveNoPassProcessor
extends AbstractActivityProcessor {
    @Override
    public void handleSubmit(OrderApply orderApply) {
        List<OrderActivityInfo> activitys = orderApply.getActivitys();
        List<OrderActivityProduct> activityProducts = orderApply.getActivityProducts();
        if (Beans.isNotEmpty(activitys)) {
            ArrayList<String> aIds = new ArrayList<String>();
            for (OrderActivityInfo activity : activitys) {
                aIds.add(activity.getActivityId());
            }
            Map<String, PartnerActivityInfo> historyTotals = this.activityService.findTotalHistoryCountByPartnerIdAndAids(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), aIds);
            for (OrderActivityInfo activity : activitys) {
                Double currentTotal = 0.0;
                PartnerActivityInfo paInfo = historyTotals.get(activity.getActivityId());
                if (Beans.isEmpty((Object)paInfo)) {
                    paInfo = new PartnerActivityInfo();
                    paInfo.setActivityId(activity.getActivityId());
                    paInfo.setPartnerId(orderApply.getApplyerId());
                    historyTotals.put(activity.getActivityId(), paInfo);
                }
                Double historyTotal = Beans.isEmpty((Object)paInfo.getTotalCount()) ? 0.0 : paInfo.getTotalCount();
                for (OrderActivityProduct product : activityProducts) {
                    if (!activity.getActivityId().equals(product.getActivityId())) continue;
                    currentTotal = "mon".equals(activity.getUnit()) ? Double.valueOf(currentTotal + product.getMoney()) : Double.valueOf(currentTotal + product.getQuantity());
                }
                if (currentTotal - activity.getCurrentCount() <= 0.0) {
                    paInfo.setTotalCount(historyTotal);
                    continue;
                }
                if (currentTotal - (activity.getCurrentCount() + activity.getTotal()) > 0.0) {
                    throw new RuntimeException("\u5f53\u524d\u8d2d\u4e70\u6570\u91cf\u8d85\u51fa\u5386\u53f2\u7d2f\u79ef\u6570\u91cf");
                }
                paInfo.setTotalCount(activity.getTotal() + activity.getCurrentCount() - currentTotal);
                paInfo.setTotalUse(paInfo.getTotalUse() - currentTotal);
                paInfo.setTotalGain(paInfo.getTotalGain() - activity.getCurrentCount());
            }
            this.activityService.savePartnerAcitivtyInfo(Cache.getApplyer(orderApply.getApplyerId()).getApplyerCode(), historyTotals);
        }
    }

    @Override
    public List<String> handleEdit() {
        Map<String, Object> map = this.initActivity();
        this.model.addAttribute("activitys", (Object)Jsons.toJson((Object)map.get("activitys")));
        this.model.addAttribute("activityItems", (Object)Jsons.toJson((Object)map.get("activityItems")));
        this.model.addAttribute("canEdit", (Object)true);
        return null;
    }

    @Override
    public List<String> handleView() {
        return this.handleEdit();
    }
}

