/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.ActivityOrderProduct;
import com.tcbj.crm.order.ActivityPlatformHelper;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.Jsons;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DraftProcessor
extends AbstractActivityProcessor {
    @Override
    public void handleSubmit(OrderApply orderApply) {
        List<OrderActivityInfo> activitys = orderApply.getActivitys();
        List<OrderActivityProduct> activityProducts = orderApply.getActivityProducts();
        if (Beans.isNotEmpty(activitys)) {
            ArrayList<String> aIds = new ArrayList<String>();
            for (OrderActivityInfo activity : activitys) {
                aIds.add(activity.getActivityId());
            }
            Map<String, List<PartnerActivityTrack>> trackMap = this.activityService.findPartnerActivityTrackMapByOrderId(orderApply.getId());
            HashMap<String, List<PartnerActivityTrack>> persistList = new HashMap<String, List<PartnerActivityTrack>>();
            for (OrderActivityInfo activity : activitys) {
                Double currentTotal = 0.0;
                List<PartnerActivityTrack> tracks = trackMap.get(activity.getActivityId());
                for (OrderActivityProduct product : activityProducts) {
                    if (!activity.getActivityId().equals(product.getActivityId())) continue;
                    currentTotal = "mon".equals(activity.getUnit()) ? Double.valueOf(currentTotal + product.getMoney()) : Double.valueOf(currentTotal + product.getQuantity());
                }
                Double currentCount = activity.getCurrentCount();
                Double hold = 0.0;
                Double prePayDel = 0.0;
                Double historyDel = 0.0;
                Double historyAdd = currentCount;
                if (activity.getPrePayAmountLeft() > 0.0) {
                    if (currentTotal <= activity.getPrePayAmountLeft()) {
                        prePayDel = currentTotal;
                    } else {
                        Double left;
                        prePayDel = activity.getPrePayAmountLeft();
                        historyDel = left = Double.valueOf(currentTotal - activity.getPrePayAmountLeft());
                        if (left > currentCount + activity.getTotal() && "1".equals(activity.getChooseFlag())) {
                            throw new AppException("0010", "\u4fc3\u9500\u6d3b\u52a8\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u914d\u989d");
                        }
                        if (left > currentCount) {
                            hold = left - currentCount;
                        }
                    }
                } else {
                    if (currentTotal > currentCount + activity.getTotal() && "1".equals(activity.getChooseFlag())) {
                        throw new AppException("0010", "\u4fc3\u9500\u6d3b\u52a8\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u914d\u989d");
                    }
                    if (currentTotal - currentCount > 0.0) {
                        hold = currentTotal - currentCount;
                    }
                    historyDel = currentTotal;
                }
                HashMap<String, Double> amountMap = new HashMap<String, Double>();
                amountMap.put(Constant.ActivityTrackAddType.historyAdd.value, historyAdd);
                amountMap.put(Constant.ActivityTrackAddType.historyDel.value, historyDel);
                amountMap.put(Constant.ActivityTrackAddType.historyHold.value, hold);
                amountMap.put(Constant.ActivityTrackAddType.prePayDel.value, prePayDel);
                if (Beans.isEmpty(tracks)) {
                    if (Beans.isNotEmpty(persistList.get("add"))) {
                        ((List)persistList.get("add")).addAll(this.addPartnerActivityTrack(activity.getActivityId(), amountMap));
                        continue;
                    }
                    persistList.put("add", this.addPartnerActivityTrack(activity.getActivityId(), amountMap));
                    continue;
                }
                HashMap<String, PartnerActivityTrack> orderTrackMap = new HashMap<String, PartnerActivityTrack>();
                for (PartnerActivityTrack p : tracks) {
                    orderTrackMap.put(p.getAddType(), p);
                }
                if (Beans.isNotEmpty(persistList.get("update"))) {
                    ((List)persistList.get("update")).addAll(this.updatePartnerActivityTrack(amountMap, orderTrackMap));
                    continue;
                }
                persistList.put("update", this.updatePartnerActivityTrack(amountMap, orderTrackMap));
            }
            this.activityService.saveAndUpdatePartnerTrack(persistList);
        }
    }

    @Override
    public List<String> handleEdit() {
        Map<String, Object> activityInfo;
        List aops = new ArrayList();
        ArrayList<String> aIds = new ArrayList<String>();
        List<OrderActivityInfo> activityList = new ArrayList();
        List<OrderActivityProduct> oapsInOrder = this.orderApply.getActivityProducts();
        if (Beans.isNotEmpty((Object)this.orderApply.getId())) {
            activityInfo = ActivityPlatformHelper.getActivityFromPlatform(this.orderApply.getApplyerId());
            this.initActivityProduct((List)activityInfo.get("productIds"));
            Map<String, Object> result = ActivityHandler.synchronizeActivity(this.orderApply);
            activityList = (List)result.get("activitys");
            aops = (List)result.get("activityItems");
            if (Beans.isNotEmpty(aops)) {
                HashMap<String, OrderActivityProduct> oapMap = new HashMap<String, OrderActivityProduct>();
                if (Beans.isNotEmpty(oapsInOrder)) {
                    for (OrderActivityProduct oap : oapsInOrder) {
                        oapMap.put(String.valueOf(oap.getActivityId()) + oap.getProductNum(), oap);
                    }
                }
                for (ActivityOrderProduct aop : aops) {
                    OrderProduct o = (OrderProduct)this.productMap.get(aop.getNo());
                    if (!Beans.isNotEmpty((Object)o)) continue;
                    if (Beans.isNotEmpty((Object)aop.getActivityRulePrice())) {
                        aop.setPrice(aop.getActivityRulePrice());
                    } else {
                        aop.setPrice(o.getPrice());
                    }
                    aop.setBasePrice(o.getBasePrice());
                    aop.setRemainQuantity(o.getRemainQuantity());
                    aop.setRemainQuantityView(o.getRemainQuantityView());
                    aop.setPriceFormula(o.getPriceFormula());
                    OrderActivityProduct oap = (OrderActivityProduct)oapMap.get(String.valueOf(aop.getActivityId()) + aop.getNo());
                    if (Beans.isNotEmpty((Object)oap)) {
                        aop.setQuantity(oap.getQuantity());
                        aop.setIsFree(oap.getIsFree());
                    }
                    aop.setMoney(aop.getQuantity() * aop.getPrice());
                }
            }
        } else {
            activityInfo = ActivityPlatformHelper.getActivityFromPlatform(this.orderApply.getApplyerId());
            activityList = (List)activityInfo.get("activityInfo");
            this.initActivityProduct((List)activityInfo.get("productIds"));
            if (Beans.isNotEmpty(activityList)) {
                ArrayList<OrderApplyItem> items = new ArrayList<OrderApplyItem>();
                for (OrderProduct p : this.allProducts) {
                    if (!Beans.isNotEmpty((Object)p.getQuantity()) || !(p.getQuantity() > 0.0)) continue;
                    OrderApplyItem item = new OrderApplyItem();
                    item.setNo(p.getNo());
                    item.setQuantity(p.getQuantity());
                    item.setPrice(p.getPrice());
                    items.add(item);
                }
                if (Beans.isNotEmpty(items)) {
                    this.orderApply.setOrderApplyItems(items);
                    this.orderApply.setActivitys(activityList);
                    ActivityHandler.getActivityProducts(this.orderApply);
                    this.orderApply.setOrderApplyItems(null);
                    this.orderApply.setActivitys(null);
                }
            }
        }
        if (Beans.isNotEmpty(activityList)) {
            for (OrderActivityInfo info : activityList) {
                aIds.add(info.getActivityId());
            }
            if (this.isView) {
                DraftProcessor.newfillTotalCountActivitysForView(this.orderApply, activityList, aIds);
            } else {
                DraftProcessor.newfillTotalCountActivitys(this.orderApply, activityList, aIds);
            }
        }
        this.model.addAttribute("activitys", (Object)Jsons.toJson(activityList));
        this.model.addAttribute("activityItems", (Object)Jsons.toJson(aops));
        this.model.addAttribute("canEdit", (Object)true);
        this.model.addAttribute("showActivity", (Object)(Beans.isEmpty(activityList) ? "none" : "block"));
        return aIds;
    }

    @Override
    public List<String> handleView() {
        this.isView = true;
        List<String> aIds = this.handleEdit();
        List<OrderActivityInfo> infos = this.orderApply.getActivitys();
        String showActivity = "block";
        if (Beans.isEmpty(infos)) {
            showActivity = "none";
        } else {
            int i = 0;
            for (OrderActivityInfo info : infos) {
                if (!"0".equals(info.getChooseFlag())) continue;
                ++i;
            }
            if (i == infos.size()) {
                showActivity = "none";
            }
        }
        this.model.addAttribute("showActivity", (Object)showActivity);
        return aIds;
    }

    private List<PartnerActivityTrack> addPartnerActivityTrack(String activityId, Map<String, Double> amountMap) {
        ArrayList<PartnerActivityTrack> list = new ArrayList<PartnerActivityTrack>();
        for (String key : amountMap.keySet()) {
            PartnerActivityTrack p = new PartnerActivityTrack();
            p.setActivityId(activityId);
            p.setPartnerId(Cache.getApplyer(this.orderApply.getApplyerId()).getApplyerCode());
            p.setOrderApplyId(this.orderApply.getId());
            p.setChangeValue(amountMap.get(key));
            p.setCreateDate(new Date());
            p.setModifyDate(new Date());
            p.setAddType(key);
            if (Constant.ActivityTrackAddType.historyHold.value.equals(key) || Constant.ActivityTrackAddType.prePayDel.value.equals(key)) {
                p.setState(Constant.ActivityTrackState.valid.value);
            } else {
                p.setState(Constant.ActivityTrackState.invalid.value);
            }
            list.add(p);
        }
        return list;
    }

    private List<PartnerActivityTrack> updatePartnerActivityTrack(Map<String, Double> amountMap, Map<String, PartnerActivityTrack> orderTrackMap) {
        ArrayList<PartnerActivityTrack> list = new ArrayList<PartnerActivityTrack>();
        for (String key : amountMap.keySet()) {
            PartnerActivityTrack track = orderTrackMap.get(key);
            track.setChangeValue(amountMap.get(key));
            track.setModifyDate(new Date());
            if (Constant.ActivityTrackAddType.historyHold.value.equals(key) || Constant.ActivityTrackAddType.prePayDel.value.equals(key)) {
                track.setState(Constant.ActivityTrackState.valid.value);
            } else {
                track.setState(Constant.ActivityTrackState.invalid.value);
            }
            list.add(track);
        }
        return list;
    }
}

