/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.allot.QyAllotService;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.IntRebatemg;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.OrderApplyLocus;
import com.tcbj.crm.entity.OrderDeliveryInformation;
import com.tcbj.crm.entity.PactBrand;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.entity.QyAllotRow;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.intrebatemgnew.IntRebatemgNewService;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.ApproveDto;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyLocusService;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.order.PartnerCreditService;
import com.tcbj.crm.order.base.BaseApplyController;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.specialRule.SpecialRuleService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerArea;
import com.tcbj.crm.view.PartnerCredit;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.Jsons;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/orderapply"})
public class OrderApplyController
extends BaseApplyController {
    @Autowired
    protected QyAllotService qyAllService;
    @Autowired
    protected PartnerCreditService creditServcie;
    @Autowired
    protected GiftService giftService;
    @Autowired
    protected IntRebatemgFacadeService intRebatemgService;
    @Autowired
    protected GiftIntRebatemgService giftIntRebatemgService;
    @Autowired
    IntRebatemgNewService intrebatemgservice;
    @Autowired
    ScoreService scoreService;
    @Autowired
    SpecialRuleService specialRuleService;
    @Autowired
    Cache cache;
    @Autowired
    OrderApplyLocusService orderApplyLocusService;
    @Autowired
    BaseDao baseDao;

    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u8ba2\u5355");
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        List<OrderProduct> products = this.getProducts(orderApply);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        String[] exchangeOrdersByIds = orderApply.getExchangeOrderIdArray();
        if (exchangeOrdersByIds != null) {
            List<ExchangeOrder> exchangeOrders = null;
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(exchangeOrdersByIds);
            model.addAttribute("exchangeOrders", exchangeOrders);
        }
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        model.addAttribute("view", (Object)"true");
        if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
            Double freeGiftTotal = orderApply.getFreeGiftTotal() == null ? 0.0 : orderApply.getFreeGiftTotal();
            Double freeGiftOrder = orderApply.getFreeGiftOrder() == null ? 0.0 : orderApply.getFreeGiftOrder();
            Double freeGiftCanuse = orderApply.getFreeGiftCanuse() == null ? 0.0 : orderApply.getFreeGiftCanuse();
            Double[] _rtns = new Double[]{MathUtils.div((Double)freeGiftTotal, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftOrder, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftCanuse, (Double)Constant.FREE_RATE)};
            model.addAttribute("freeGiftQuantitys", (Object)_rtns);
        }
        ActivityHandler.view(orderApply, orderApply.getState(), products, this.getCurrentEmployee(), model, Boolean.FALSE);
        ArrayList<OrderProduct> orderProducts = new ArrayList<OrderProduct>();
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            if ("1".equals(item.getActivityFlag())) continue;
            OrderProduct product = new OrderProduct(orderApply.getApplyerId(), item);
            orderProducts.add(product);
        }
        this.calculateOrderMoney(orderApply, 2);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        if (orderApply.getDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0 || orderApply.getFullDiscountMoney() > 0.0 || orderApply.getFullGiftDiscountMoney() > 0.0) {
            customer = customer != null ? customer : this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
            List<Double[]> discounts = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("discounts", discounts);
        }
        List<AuditInfo> auditInfos = this.auditService.find(orderApply.getId());
        model.addAttribute("auditInfos", auditInfos);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("products", (Object)JSON.toJSONString(orderProducts));
        model.addAttribute("canEdit", (Object)"0");
        model.addAttribute("gridColsSwitch", (Object)JSON.toJSONString(this.getFrontGridColsSwithMap()));
        return "order/view.ftl";
    }

    @RequestMapping(value={"/viewAll.do"}, method={RequestMethod.GET})
    public String viewAll(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        Map<String, OrderProduct> productsMap = this.getProductsMap(orderApply);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.fillInfoToProducts(orderApply, products);
        for (OrderProduct product : products) {
            if (!productsMap.containsKey(product.getId())) continue;
            product.setPrice(productsMap.get(product.getId()).getPrice());
        }
        ArrayList<OrderProduct> selectedProducts = new ArrayList<OrderProduct>();
        ArrayList<OrderProduct> noselectedProducts = new ArrayList<OrderProduct>();
        for (OrderProduct product : products) {
            if (product.getQuantity() != null && product.getQuantity() > 0.0) {
                selectedProducts.add(product);
                continue;
            }
            noselectedProducts.add(product);
        }
        for (OrderProduct product : noselectedProducts) {
            selectedProducts.add(product);
        }
        String[] exchangeOrdersByIds = orderApply.getExchangeOrderIdArray();
        if (exchangeOrdersByIds != null) {
            List<ExchangeOrder> exchangeOrders = null;
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(exchangeOrdersByIds);
            model.addAttribute("exchangeOrders", exchangeOrders);
        }
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
            Double freeGiftTotal = orderApply.getFreeGiftTotal() == null ? 0.0 : orderApply.getFreeGiftTotal();
            Double freeGiftOrder = orderApply.getFreeGiftOrder() == null ? 0.0 : orderApply.getFreeGiftOrder();
            Double freeGiftCanuse = orderApply.getFreeGiftCanuse() == null ? 0.0 : orderApply.getFreeGiftCanuse();
            Double[] _rtns = new Double[]{MathUtils.div((Double)freeGiftTotal, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftOrder, (Double)Constant.FREE_RATE), MathUtils.div((Double)freeGiftCanuse, (Double)Constant.FREE_RATE)};
            model.addAttribute("freeGiftQuantitys", (Object)_rtns);
        }
        ActivityHandler.view(orderApply, orderApply.getState(), products, this.getCurrentEmployee(), model, Boolean.TRUE);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("products", (Object)JSON.toJSONString(selectedProducts));
        model.addAttribute("canEdit", (Object)"0");
        model.addAttribute("gridColsSwitch", (Object)JSON.toJSONString(this.getFrontGridColsSwithMap()));
        return "order/view.ftl";
    }

    @RequestMapping(value={"/viewFromK3.do"}, method={RequestMethod.GET})
    public String viewFromK3(@RequestParam(value="id", required=true) String id, Model model) {
        Map<String, Object> order;
        Employee em;
        block4: {
            em = this.getCurrentEmployee();
            String url = Cache.getInterfaceConfig("TCBJ_ORDER_VIEW_BUY");
            if (Beans.isEmpty((Object)url)) {
                model.addAttribute("rtn", (Object)"<script language=\"javascript\">alert('\u5bf9\u4e0d\u8d77\uff01\u60a8\u6ca1\u6709\u914d\u7f6e\u5916\u90e8\u67e5\u8be2\u63a5\u53e3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01');window.location.href=base+'/orderapply/applys.do'</script>");
                return "common/iframeRtn.ftl";
            }
            try {
                OrderApply orderApply = this.service.getSimpleOrderApply(id);
                this.assertOrderExist(orderApply);
                order = this.service.getOrderApplyFromK3(orderApply, url);
                if (!Beans.isEmpty(order)) break block4;
                model.addAttribute("rtn", (Object)"<script language=\"javascript\">alert('\u5728\u91d1\u8776\u7cfb\u7edf\u4e0a\u672a\u53d1\u73b0\u6b64\u5355\u53f7\u7684\u6570\u636e\u3002');window.location.href=base+'/orderapply/applys.do'</script>");
                return "common/iframeRtn.ftl";
            }
            catch (Exception e) {
                e.printStackTrace();
                model.addAttribute("rtn", (Object)("<script language=\"javascript\">alert('" + e.getMessage() + "');" + "window.location.href=base+'/orderapply/applys.do'</script>"));
                return "common/iframeRtn.ftl";
            }
        }
        String dt = String.valueOf(order.get("CreateDate"));
        model.addAttribute("order", order);
        model.addAttribute("dt", (Object)DateUtils.autoFormatDate((String)dt, (String[])new String[]{"yyyy-MM-dd"}));
        model.addAttribute("supplierName", (Object)em.getCurrentPartner().getOrganization());
        return "order/viewFromK3.ftl";
    }

    private Map<String, OrderProduct> getProductsMap(OrderApply orderApply) {
        HashMap<String, OrderProduct> map = new HashMap<String, OrderProduct>();
        List<OrderProduct> list = this.getProducts(orderApply);
        if (Beans.isNotEmpty(list)) {
            for (OrderProduct p : list) {
                map.put(p.getId(), p);
            }
        }
        return map;
    }

    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setApplyerId(me.getCurrentPartner().getId());
        if (StringUtils.isNotEmpty(con.getState())) {
            con.getOrderStates().add(con.getState());
        }
        this.findApplys(con, "order by T1.create_Dt desc", model);
        return "order/applys.ftl";
    }

    @RequestMapping(value={"/approves.do"})
    public String approves(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setSupplierId(me.getCurrentPartner().getId());
        con.setCurrentPartnerId(me.getCurrentPartner().getId());
        if (StringUtils.isBlank(con.getState())) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.balancePass.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.billing.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.sended.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.received.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.cspapprove.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.cspapproveNoPass.getValue());
        } else if (con.getState().equals("dealing")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
        } else if (con.getState().equals("dealed")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
        } else if (con.getState().equals("noDealed")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approveNoPass.getValue());
        } else if (con.getState().equals("finance")) {
            con.getOrderStates().add(TCBJEnum.AuditState.balancePass.getValue());
        } else if (con.getState().equals("billing")) {
            con.getOrderStates().add(TCBJEnum.AuditState.billing.getValue());
        } else if (con.getState().equals("shipments")) {
            con.getOrderStates().add(TCBJEnum.AuditState.sended.getValue());
        } else if (con.getState().equals("collect")) {
            con.getOrderStates().add(TCBJEnum.AuditState.received.getValue());
        } else if (con.getState().equals("cspapprove")) {
            con.getOrderStates().add(TCBJEnum.AuditState.cspapprove.getValue());
        } else if (con.getState().equals("cspapproveNoPass")) {
            con.getOrderStates().add(TCBJEnum.AuditState.cspapproveNoPass.getValue());
        }
        con.setEmployeeId(me.getId());
        con.setRegionFilter(true);
        this.findApplys(con, "order by T1.lastUpdate_Dt desc", model);
        return "order/approves.ftl";
    }

    @RequestMapping(value={"/getDiscount.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getDiscount(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        OrderApply old;
        if (StringUtils.isNotEmpty(orderApply.getId()) && (old = this.service.getSimpleOrderApply(orderApply.getId())) != null) {
            orderApply.setDt(old.getDt());
        }
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        List<Double[]> rtns = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getOtherDiscount.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getOtherDiscount(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double[] rtns = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getGiftRule.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getGiftRuel(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        ArrayList<OrderApplyItem> newItems = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : items) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            newItems.add(item);
        }
        List<GiftService.GiftWarp> giftWarps = this.giftService.getGiftRuleAvailableList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, newItems, null);
        Double totalGiftBalance = this.giftService.getGiftBalance(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double orderGiftBalance = this.giftService.getCurrentGiftBalance(orderApply);
        Double canuseGiftBalance = MathUtils.add((Double)totalGiftBalance, (Double)orderGiftBalance);
        Object[] rtns = new Object[]{giftWarps, totalGiftBalance, orderGiftBalance, canuseGiftBalance};
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getFreeGift.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getFreeGift(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getGiftRuleOnApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getGiftRuelOnApprove(@Valid @RequestBody OrderApply orderApply, BindingResult errors, Model model) {
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        ArrayList<OrderApplyItem> newItems = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : items) {
            if (!"PRODUCT".equals(item.getProductType())) continue;
            item.setQuantity(item.getActQuantity());
            item.setPrice(item.getActPrice());
            item.setMoney(MathUtils.sub((Double)item.getActQuantity(), (Double)item.getActPrice()));
            newItems.add(item);
        }
        List<GiftService.GiftWarp> giftWarps = this.giftService.getGiftRuleAvailableList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, newItems, orderApply.getId());
        Double totalGiftBalance = this.giftService.getGiftBalance(orderApply.getApplyerId(), orderApply.getSupplierId());
        Double orderGiftBalance = this.giftService.getCurrentGiftBalance(orderApply);
        Double canuseGiftBalance = MathUtils.add((Double)totalGiftBalance, (Double)orderGiftBalance);
        Object[] rtns = new Object[]{giftWarps, totalGiftBalance, orderGiftBalance, canuseGiftBalance};
        return this.getSuccessResult(rtns);
    }

    @RequestMapping(value={"/getCredit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getCredit(@RequestParam(value="applyerId", required=false) String applyerId, Model model) {
        Partner applyer = this.partnerService.getSimplePartner(applyerId);
        PartnerCredit credit = this.creditServcie.getCredit(applyer);
        return this.getSuccessResult(credit);
    }

    @RequestMapping(value={"/getSuppliers.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<Partner> getSuppliers(String applyerId, Model model) {
        return this.clientService.getSuppliers(applyerId);
    }

    @RequestMapping(value={"/canUnApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result canUnApprove(@RequestParam(value="id", required=false) String id, Model model) {
        boolean tof = false;
        try {
            tof = true;
        }
        catch (Exception exception) {}
        return this.getSuccessResult(tof);
    }

    @RequestMapping(value={"/test.do"}, method={RequestMethod.GET})
    public String test(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        List<OrderProduct> products = this.getProducts(me.getCurrentPartner().getId(), me.getCurrentPartner().getParPartnerId());
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        return "order/test.ftl";
    }

    @RequestMapping(value={"/test1.do"})
    public String test(HttpServletResponse response, Model model) throws IOException {
        List pm = this.baseDao.findEntity(" from PactMain p ", PactMain.class);
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        for (PactMain p : pm) {
            List<OrderProduct> products = null;
            try {
                products = this.getProducts(p.getApplyerId(), p.getSupplierId());
            }
            catch (Exception exception) {}
            if (products == null) continue;
            List<PrAdjdetail> details = this.priceAdjustService.getList(p.getApplyerId(), p.getSupplierId(), new Date());
            Customer customer = this._getCustomer(p.getApplyerId(), p.getSupplierId());
            if (customer != null) {
                this.calculateProductPrices(p, products, details, customer.getPrecision());
            }
            for (OrderProduct product : products) {
                sb.append("<tr>");
                sb.append("<td>").append(p.getApplyerName()).append("</td>");
                sb.append("<td>").append(product.getNo()).append("</td>");
                sb.append("<td>").append(product.getName()).append("</td>");
                sb.append("<td>").append(product.getPrice()).append("</td>");
                sb.append("</tr>");
            }
        }
        sb.append("</table>");
        model.addAttribute("rtn", (Object)sb.toString());
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/importOrder.do"}, method={RequestMethod.POST, RequestMethod.GET})
    public String importOrder(HttpServletRequest request, Model model) {
        HashMap<String, String> errorMsg = new HashMap<String, String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        List sheet1 = new ArrayList();
        ArrayList<String> productNoList = new ArrayList<String>();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("uploadfile_1");
        if (Beans.isNotEmpty((Object)file)) {
            try {
                sheet1 = Excels.readExcel((String)file.getOriginalFilename(), (InputStream)file.getInputStream(), (String[])new String[]{"productno", "quantity"}, (int)0);
            }
            catch (IOException iOException) {
                throw new AppException("\u89e3\u6790excel\u51fa\u9519");
            }
        }
        if (sheet1.size() < 1) {
            errorMsg.put("XXXX", "excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            result.put("errormsg", errorMsg);
            model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(result)));
            return "common/iframeRtn.ftl";
        }
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply("", model);
        orderApply.setApplyerId(me.getCurrentPartner().getId());
        this.assertOrderBelongMyPartner(orderApply, me);
        this.fillSupplierInOrderApply(orderApply, request);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (orderApply.isDraft() && contract != null) {
            orderApply.setContractNo(contract.getPactNo());
        }
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.assertHasPushOrder(orderApply, customer);
        model.addAttribute("addresses", (Object)JSON.toJSONString(customer.getReceiptAddresses()));
        if (orderApply.isNew()) {
            orderApply.bindEditData(customer, me);
        } else {
            orderApply.bindOrderContacts(me);
        }
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.fillQuantityToProducts(orderApply, products);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateProductStocks(products, orderApply.getSupplierId(), null, customer.getIsStockShow());
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        Map<String, String> mapDates = this.qyAllService.getAllotRowDates(orderApply.getApplyerId());
        productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), mapDates, regularDt, orderApply.getId());
        if (Beans.isEmpty((Object)orderApply.getId())) {
            this.calculateProductLimitQuantitys(products, qys, productUsedQuantitys);
        }
        this.calulateProductMaxStockQuantitys(orderApply, products);
        ActivityHandler.edit(orderApply, orderApply.getState(), products, me, model);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        for (OrderProduct op : products) {
            productNoList.add(op.getNo());
        }
        for (Map pmap : sheet1) {
            if (!productNoList.contains(pmap.get("productno"))) {
                errorMsg.put(pmap.get("productno").toString(), "\u4e0d\u5b58\u5728\u7684\u4ea7\u54c1\u7f16\u53f7");
                continue;
            }
            String qe = pmap.get("quantity").toString();
            Double quantity = null;
            try {
                quantity = StringUtils.subToDouble(Double.valueOf(qe), 0);
            }
            catch (Exception exception) {
                errorMsg.put(pmap.get("productno").toString(), "\u4ea7\u54c1\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u6574\u6570");
                continue;
            }
            if (quantity < 0.0) {
                errorMsg.put(pmap.get("productno").toString(), "\u4ea7\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570");
                continue;
            }
            for (OrderProduct op : products) {
                if (!pmap.get("productno").equals(op.getNo())) continue;
                if (quantity < op.getRemainQuantity()) {
                    op.setQuantity(quantity);
                    op.setMoney(op.getQuantity() * op.getPrice());
                    continue;
                }
                errorMsg.put(pmap.get("productno").toString(), "\u5e93\u5b58\u4e0d\u8db3");
            }
        }
        result.put("product", products);
        result.put("errormsg", errorMsg);
        model.addAttribute("rtn", (Object)JSON.toJSONString((Object)this.getSuccessResult(result)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/excelRtn.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public void excelRtn(@RequestParam(value="rtndata", required=false) String rtndata, HttpServletResponse response, HttpServletRequest request) throws Exception {
        ArrayList listMap = new ArrayList();
        Map map = (Map)Jsons.toBean((String)rtndata, Map.class);
        for (String key : map.keySet()) {
            HashMap<String, String> lmap = new HashMap<String, String>();
            lmap.put("no", key);
            lmap.put("msg", (String)map.get(key));
            listMap.add(lmap);
        }
        String[] titles = new String[]{"\u7f16\u53f7", "\u9519\u8bef\u4fe1\u606f"};
        String[] pop = new String[]{"no", "msg"};
        try {
            ExcelUtils.exportExcelNew("\u66f4\u591a\u62a5\u9519\u4fe1\u606f" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u4ea7\u54c1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", ".xlsx", titles, listMap, pop, response);
        }
        catch (Exception e) {
            throw new AppException("\u62a5\u9519\u4fe1\u606f\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        orderApply.setApplyerId(me.getCurrentPartner().getId());
        this.assertOrderBelongMyPartner(orderApply, me);
        this.fillSupplierInOrderApply(orderApply, request);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (orderApply.isDraft() && contract != null) {
            orderApply.setContractNo(contract.getPactNo());
        }
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.assertHasPushOrder(orderApply, customer);
        model.addAttribute("addresses", (Object)JSON.toJSONString(customer.getReceiptAddresses()));
        if (orderApply.isNew()) {
            orderApply.bindEditData(customer, me);
        } else {
            orderApply.bindOrderContacts(me);
        }
        orderApply.bindCannotEditData(customer, me);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.fillQuantityToProducts(orderApply, products);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateProductStocks(products, orderApply.getSupplierId(), null, customer.getIsStockShow());
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        Map<String, String> mapDates = this.qyAllService.getAllotRowDates(orderApply.getApplyerId());
        productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), mapDates, regularDt, orderApply.getId());
        if (Beans.isEmpty((Object)orderApply.getId())) {
            this.calculateProductLimitQuantitys(products, qys, productUsedQuantitys);
        }
        ActivityHandler.edit(orderApply, orderApply.getState(), products, me, model);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double fineTotalMoney = this.getFineMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, orderApply.getId());
        orderApply.setFineTotalMoney(fineTotalMoney);
        if (!orderApply.isNew() && (orderApply.getDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0 || orderApply.getFullDiscountMoney() > 0.0 || orderApply.getFullGiftDiscountMoney() > 0.0)) {
            List<Double[]> discounts = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
            this.setRemainMoney(discounts, orderApply, customer.getPrecision());
            model.addAttribute("discounts", discounts);
        }
        if (!orderApply.isNew() && orderApply.getOtherDiscountMoney() > 0.0) {
            Double[] otherDiscount = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("otherDiscounts", (Object)otherDiscount);
        }
        if (!orderApply.isNew() && orderApply.getFreeGiftMoney() > 0.0) {
            Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
            model.addAttribute("freeGiftMoneys", (Object)rtns);
            if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
                Double[] _rtns = new Double[]{MathUtils.div((Double)rtns[0], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[1], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[2], (Double)Constant.FREE_RATE)};
                model.addAttribute("freeGiftQuantitys", (Object)_rtns);
            }
        }
        List<ExchangeOrder> exchangeOrders = null;
        if (StringUtils.isEmpty(orderApply.getId()) && StringUtils.isEmpty(orderApply.getExchangeOrderIds())) {
            exchangeOrders = this.scoreService.getMyExchangeOrders(me.getCurrentPartner().getId());
            exchangeOrders = this.service.filterHasBind(orderApply.getApplyerId(), exchangeOrders, null);
        } else {
            exchangeOrders = this.scoreService.getExchangeOrdersByIds(orderApply.getExchangeOrderIdArray());
        }
        model.addAttribute("exchangeOrders", exchangeOrders);
        List<AuditInfo> auditInfos = this.auditService.find(orderApply.getId());
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("auditInfos", auditInfos);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("gridColsSwitch", (Object)JSON.toJSONString(this.getFrontGridColsSwithMap()));
        return "order/apply.ftl";
    }

    private void setRemainMoney(List<Double[]> discounts, OrderApply orderApply, Integer precision) {
        Double discountMoney = discounts.get(0)[0] <= 0.0 ? 0.0 : orderApply.getDiscountMoney();
        Double giftDiscountMoney = discounts.get(1)[0] <= 0.0 ? 0.0 : orderApply.getGiftDiscountMoney();
        Double fullDiscountMoney = discounts.get(2)[0] <= 0.0 ? 0.0 : orderApply.getFullDiscountMoney();
        Double fullGiftDiscountMoney = discounts.get(3)[0] <= 0.0 ? 0.0 : orderApply.getFullGiftDiscountMoney();
        orderApply.setRemainMoney(MathUtils.m2((Double)(orderApply.getTotalMoney() - discountMoney - giftDiscountMoney - fullDiscountMoney - fullGiftDiscountMoney - orderApply.getOtherDiscountMoney() - orderApply.getFreeMoney() - orderApply.getFreeGiftMoney() - orderApply.getActivityDeductMoney()), (int)precision));
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request, Model model) {
        boolean flag;
        this.assertOrderApplyData(orderApply);
        Employee me = this.getCurrentEmployee();
        try {
            this.validateService.validateOrder(me, orderApply);
            this.giftService.validate(orderApply, orderApply.getActGiftQuantity());
        }
        catch (Exception e) {
            throw new AppException("3017", e.getMessage());
        }
        orderApply.fillInitData(me);
        this.assertOrderBelongMyPartner(orderApply, me);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.bindCannotEditData(customer, me);
        if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
            orderApply.setSalesman(customer.getCityManagerId());
        }
        if (!(flag = ActivityHandler.validateActivity(orderApply))) {
            throw new AppException("0010", "\u6d3b\u52a8\u4fe1\u606f\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
        }
        OrderApply oldOrderApply = null;
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
            this.assertOrderExist(oldOrderApply);
            this.assertOrderBelongMyPartner(oldOrderApply, me);
            this.assertOrderCanApply(oldOrderApply);
            if (!oldOrderApply.isDraft()) {
                orderApply.setState(oldOrderApply.getState());
                orderApply.setNo(oldOrderApply.getNo());
                orderApply.setDt(oldOrderApply.getDt());
                orderApply.setContractNo(oldOrderApply.getContractNo());
                orderApply.setNature(oldOrderApply.getNature());
            }
        }
        Partner applyer = this.assertOrderApplyerIsEffective(orderApply.getApplyerId());
        this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        if (oldOrderApply == null || !oldOrderApply.isApprovedNotPass()) {
            this.assertOrderProduct(orderApply, products);
        }
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertProductPrices(orderApply, contract, products, details, customer.getPrecision());
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        Map<String, Double> productUsedQuantitys = null;
        Map<String, String> mapDates = this.qyAllService.getAllotRowDates(orderApply.getApplyerId());
        productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), mapDates, regularDt, orderApply.getId());
        this.assertProductLimitQuantitys(orderApply, products, qys, productUsedQuantitys);
        if ("N".equals(customer.getNothingCanOrderFlg())) {
            this.assertProductAvailableStock(orderApply.getOrderApplyItems(), products, orderApply.getSupplierId(), customer.getIsStockShow());
        }
        if ("Y".equals(customer.getIsStockReceived())) {
            this.assertProductIsOverRepository(orderApply);
        }
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        this.assertFineMoney(orderApply, products, regularDt, customer.getPrecision());
        this.assertOrderOtherDiacount(orderApply, regularDt, customer.getPrecision());
        this.assertOrderDiacount(orderApply, regularDt, customer.getPrecision());
        this.assertOrderFreeGiftMoney(orderApply, contract.getFreeScaleType(), customer.getPrecision());
        String orderState = orderApply.getState();
        double totalQuantity = 0.0;
        HashMap<String, Double> offerPrices = new HashMap<String, Double>();
        for (OrderProduct orderProduct : products) {
            offerPrices.put(orderProduct.getId(), orderProduct.getPrice());
        }
        for (OrderActivityProduct orderActivityProduct : orderApply.getActivityProducts()) {
            if (!Beans.isNotEmpty(offerPrices.get(orderActivityProduct.getProductId()))) continue;
            orderActivityProduct.setOfferPrice((Double)offerPrices.get(orderActivityProduct.getProductId()));
        }
        for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
            orderApplyItem.fillInitData(me);
            if (Beans.isNotEmpty(offerPrices.get(orderApplyItem.getProductId()))) {
                orderApplyItem.setOfferPrice((Double)offerPrices.get(orderApplyItem.getProductId()));
            }
            double quantity = orderApplyItem.getActQuantity() == null || orderApplyItem.getActQuantity() == 0.0 ? orderApplyItem.getQuantity() : orderApplyItem.getActQuantity();
            double price = orderApplyItem.getActPrice() == null || orderApplyItem.getActPrice() == 0.0 ? orderApplyItem.getPrice() : orderApplyItem.getActPrice();
            if (!"GIFT".equals(orderApplyItem.getProductType())) continue;
            if ("QUANTITY".equals(contract.getScaleType())) {
                totalQuantity += quantity;
                continue;
            }
            totalQuantity += MathUtils.mul((Double)quantity, (Double)price).doubleValue();
        }
        orderApply.setActGiftQuantity(totalQuantity);
        orderApply.setGiftQuantity(totalQuantity);
        if (orderApply.getExchangeOrderIdArray() != null && this.service.hasBind(orderApply.getApplyerId(), orderApply.getExchangeOrderIdArray(), orderApply.getId())) {
            throw new AppException("3063");
        }
        orderApply.bindAddressData(customer, me);
        this.splitDiscountMoneyToItems(orderApply, customer.getPrecision());
        this.service.saveOrUpdateOrderApply(orderApply, false);
        if (orderApply.isToAudit() || orderApply.isToApprove()) {
            if (Beans.isNotEmpty(orderApply.getActivitys())) {
                ActivityHandler.submit(orderApply, orderState);
            }
            if (StringUtils.isEmpty(orderApply.getNo())) {
                String string = orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue()) ? "01" : "02";
                orderApply.setNo(this.orderNoService.maxNo(applyer.getNo(), string));
                orderApply.setDt(DateUtils.now());
                orderApply.setContractNo(contract.getPactNo());
            }
            orderApply.setState(TCBJEnum.AuditState.approve.getValue());
            this.service.updateOrderApply(orderApply);
            this.orderApplyLocusService.saveOrderApplyLocus(orderApply.getId(), me, OrderApplyLocus.LocusType.apply.getValue(), "\u8ba2\u5355\u5df2\u63d0\u4ea4");
        }
        return this.getSuccessResult(null);
    }

    /*
     * WARNING - void declaration
     */
    public void splitDiscountMoneyToItems(OrderApply orderApply, Integer precision) {
        Product product;
        Double productDiscountMoney = orderApply.getDiscountMoney();
        Double giftDiscountMoney = orderApply.getGiftDiscountMoney();
        Double fullProductDiscountMoney = orderApply.getFullDiscountMoney();
        Double fullGiftDiscountMoney = orderApply.getFullGiftDiscountMoney();
        Double productTotalMoney = 0.0;
        Double giftTotalMoney = 0.0;
        String productId = null;
        String giftId = null;
        for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
            if ("\u662f".equals(orderApplyItem.getIsFree()) || "1".equals(orderApplyItem.getActivityFlag())) continue;
            Product product2 = Cache.getProduct(orderApplyItem.getProductId());
            if ("PRODUCT".equals(product2.getOrderProdType())) {
                productTotalMoney = productTotalMoney + orderApplyItem.getMoney();
                productId = orderApplyItem.getProductId();
                continue;
            }
            if (!"GIFT".equals(product2.getOrderProdType()) && !"MATERIAL".equals(product2.getOrderProdType())) continue;
            giftTotalMoney = giftTotalMoney + orderApplyItem.getMoney();
            giftId = orderApplyItem.getProductId();
        }
        for (OrderActivityProduct orderActivityProduct : orderApply.getActivityProducts()) {
            if ("\u662f".equals(orderActivityProduct.getIsFree()) || "3".equals(orderActivityProduct.getIsFree())) continue;
            Product product2 = Cache.getProduct(orderActivityProduct.getProductId());
            if ("PRODUCT".equals(product2.getOrderProdType())) {
                productTotalMoney = productTotalMoney + orderActivityProduct.getMoney();
                productId = String.valueOf(orderActivityProduct.getActivityId()) + orderActivityProduct.getProductId();
                continue;
            }
            if (!"GIFT".equals(product2.getOrderProdType()) && !"MATERIAL".equals(product2.getOrderProdType())) continue;
            giftTotalMoney = giftTotalMoney + orderActivityProduct.getMoney();
            giftId = String.valueOf(orderActivityProduct.getActivityId()) + orderActivityProduct.getProductId();
        }
        Double d = 0.0;
        Double giftUseingMoney = 0.0;
        Double fullProductUseingMoney = 0.0;
        Double fillGiftUseingMoney = 0.0;
        for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
            if ("\u662f".equals(orderApplyItem.getIsFree()) || "1".equals(orderApplyItem.getActivityFlag())) continue;
            product = Cache.getProduct(orderApplyItem.getProductId());
            if ("PRODUCT".equals(product.getOrderProdType())) {
                void var11_16;
                if (orderApplyItem.getProductId().equals(productId)) {
                    orderApplyItem.setItemDiscountMoney(productDiscountMoney - var11_16.doubleValue());
                    orderApplyItem.setItemFullDiscountMoney(fullProductDiscountMoney - fullProductUseingMoney);
                    continue;
                }
                orderApplyItem.setItemDiscountMoney(MathUtils.m2((Double)(productDiscountMoney * orderApplyItem.getMoney() / productTotalMoney), (int)precision));
                orderApplyItem.setItemFullDiscountMoney(MathUtils.m2((Double)(fullProductDiscountMoney * orderApplyItem.getMoney() / productTotalMoney), (int)precision));
                Double d2 = MathUtils.add((Double)var11_16, (Double)orderApplyItem.getItemDiscountMoney());
                fullProductUseingMoney = MathUtils.add((Double)fullProductUseingMoney, (Double)orderApplyItem.getItemFullDiscountMoney());
                continue;
            }
            if (!"GIFT".equals(product.getOrderProdType()) && !"MATERIAL".equals(product.getOrderProdType())) continue;
            if (orderApplyItem.getProductId().equals(giftId)) {
                orderApplyItem.setItemDiscountMoney(giftDiscountMoney - giftUseingMoney);
                orderApplyItem.setItemFullDiscountMoney(fullGiftDiscountMoney - fillGiftUseingMoney);
                continue;
            }
            orderApplyItem.setItemDiscountMoney(MathUtils.m2((Double)(giftDiscountMoney * orderApplyItem.getMoney() / giftTotalMoney), (int)precision));
            orderApplyItem.setItemFullDiscountMoney(MathUtils.m2((Double)(fullGiftDiscountMoney * orderApplyItem.getMoney() / giftTotalMoney), (int)precision));
            giftUseingMoney = MathUtils.add((Double)giftUseingMoney, (Double)orderApplyItem.getItemDiscountMoney());
            fillGiftUseingMoney = MathUtils.add((Double)fillGiftUseingMoney, (Double)orderApplyItem.getItemFullDiscountMoney());
        }
        for (OrderActivityProduct orderActivityProduct : orderApply.getActivityProducts()) {
            if ("\u662f".equals(orderActivityProduct.getIsFree()) || "3".equals(orderActivityProduct.getIsFree())) continue;
            product = Cache.getProduct(orderActivityProduct.getProductId());
            if ("PRODUCT".equals(product.getOrderProdType())) {
                void var11_18;
                if ((String.valueOf(orderActivityProduct.getActivityId()) + orderActivityProduct.getProductId()).equals(productId)) {
                    orderActivityProduct.setItemDiscountMoney(productDiscountMoney - var11_18.doubleValue());
                    orderActivityProduct.setItemFullDiscountMoney(fullProductDiscountMoney - fullProductUseingMoney);
                    continue;
                }
                orderActivityProduct.setItemDiscountMoney(MathUtils.m2((Double)(productDiscountMoney * orderActivityProduct.getMoney() / productTotalMoney), (int)precision));
                orderActivityProduct.setItemFullDiscountMoney(MathUtils.m2((Double)(fullProductDiscountMoney * orderActivityProduct.getMoney() / productTotalMoney), (int)precision));
                Double d3 = MathUtils.add((Double)var11_18, (Double)orderActivityProduct.getItemDiscountMoney());
                fullProductUseingMoney = MathUtils.add((Double)fullProductUseingMoney, (Double)orderActivityProduct.getItemFullDiscountMoney());
                continue;
            }
            if (!"GIFT".equals(product.getOrderProdType()) && !"MATERIAL".equals(product.getOrderProdType())) continue;
            if ((String.valueOf(orderActivityProduct.getActivityId()) + orderActivityProduct.getProductId()).equals(giftId)) {
                orderActivityProduct.setItemDiscountMoney(giftDiscountMoney - giftUseingMoney);
                orderActivityProduct.setItemFullDiscountMoney(fullGiftDiscountMoney - fillGiftUseingMoney);
                continue;
            }
            orderActivityProduct.setItemDiscountMoney(MathUtils.m2((Double)(giftDiscountMoney * orderActivityProduct.getMoney() / giftTotalMoney), (int)precision));
            orderActivityProduct.setItemFullDiscountMoney(MathUtils.m2((Double)(fullGiftDiscountMoney * orderActivityProduct.getMoney() / giftTotalMoney), (int)precision));
            giftUseingMoney = MathUtils.add((Double)giftUseingMoney, (Double)orderActivityProduct.getItemDiscountMoney());
            fillGiftUseingMoney = MathUtils.add((Double)fillGiftUseingMoney, (Double)orderActivityProduct.getItemFullDiscountMoney());
        }
    }

    protected void assertLimitQuantitys(OrderApply orderApply, List<QyAllotRow> qys, Map<String, Double> productUsedQuantitys2) {
        List<OrderApplyItem> items = orderApply.getOrderApplyItems();
        PartnerArea partnerArea = Cache.getPartnerAreaById(orderApply.getApplyerId());
        for (QyAllotRow qy : qys) {
            String qyCheckId = "";
            String orderCheckId = "";
            if ("area".equals(qy.getQyAllotType())) {
                qyCheckId = qy.getAreaId();
                orderCheckId = partnerArea.getRegionId();
            } else if ("bigArea".equals(qy.getQyAllotType())) {
                qyCheckId = qy.getBigAreaId();
                orderCheckId = partnerArea.getDistrictId();
            } else {
                qyCheckId = qy.getApplyerId();
                orderCheckId = orderApply.getApplyerId();
            }
            for (OrderApplyItem item : items) {
                if (!item.getProductId().equals(qy.getProductId()) || !orderCheckId.equals(qyCheckId)) continue;
                Double usedQuantity = 0.0;
                if (productUsedQuantitys2 != null) {
                    usedQuantity = productUsedQuantitys2.get(item.getProductId());
                }
                usedQuantity = usedQuantity == null ? 0.0 : usedQuantity;
                Double lq = qy.getQuotaNumber() - usedQuantity;
                lq = lq > 0.0 ? lq : 0.0;
                if (!(item.getQuantity() > lq)) continue;
                throw new AppException("0010", "\u4ea7\u54c1\uff1a" + item.getProductName() + "  \u8ba2\u8d2d\u6570\u91cf:" + item.getQuantity() + "\u8d85\u8fc7\u4e86\u9650\u8d2d\u6570\u91cf:" + lq + "\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u63d0\u4ea4");
            }
        }
    }

    private void assertProductAvailableStock(List<OrderApplyItem> orderApplyItems, List<OrderProduct> products, String supplierId, String isShow) {
        this.calculateProductStocks(products, supplierId, null, isShow);
        for (OrderApplyItem orderItem : orderApplyItems) {
            for (OrderProduct allProdcut : products) {
                if (!orderItem.getProductId().equals(allProdcut.getId()) || !(orderItem.getQuantity() > allProdcut.getRemainQuantity())) continue;
                throw new AppException("3066", "(" + allProdcut.getNo() + ")" + allProdcut.getName());
            }
        }
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        this.assertOrderBelongMySupplier(orderApply, me);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.setBigAreaId(customer.getBigAreaCode());
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        int days = customer.getTransportOnlineCode() == null ? 3 : customer.getTransportOnlineCode().intValue();
        orderApply.setPredictArriveDt(DateUtils.getDateAfter((Date)orderApply.getDt(), (int)days));
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        model.addAttribute("contract", (Object)contract);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateProductStocks(products, orderApply.getSupplierId(), orderApply.getId(), "N");
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (qys != null && qys.size() > 0) {
            Date startDt = qys.get(0).getStartDate();
            this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), startDt, regularDt, orderApply.getId());
        }
        this.fillQuantityToProducts(orderApply, products);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double fineTotalMoney = this.getFineMoney(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt, orderApply.getId());
        orderApply.setFineTotalMoney(fineTotalMoney);
        if (orderApply.getDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0 || orderApply.getFullDiscountMoney() > 0.0 || orderApply.getFullGiftDiscountMoney() > 0.0) {
            List<Double[]> discounts = this.getDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("discounts", discounts);
        }
        if (!orderApply.isNew() && (orderApply.getOtherDiscountMoney() > 0.0 || orderApply.getGiftDiscountMoney() > 0.0)) {
            Double[] otherDiscount = this.getOtherDiscounts(orderApply, regularDt, customer.getPrecision());
            model.addAttribute("otherDiscounts", (Object)otherDiscount);
        }
        if (!orderApply.isNew() && orderApply.getFreeGiftMoney() > 0.0) {
            Double[] rtns = this.getFreeGiftMoneys(orderApply, contract.getFreeScaleType(), customer.getPrecision());
            model.addAttribute("freeGiftMoneys", (Object)rtns);
            if (Constant.SCALETYPE_QUANTITY.equals(contract.getFreeScaleType())) {
                Double[] _rtns = new Double[]{MathUtils.div((Double)rtns[0], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[1], (Double)Constant.FREE_RATE), MathUtils.div((Double)rtns[2], (Double)Constant.FREE_RATE)};
                model.addAttribute("freeGiftQuantitys", (Object)_rtns);
            }
        }
        List<ExchangeOrder> exchangeOrders = this.scoreService.getExchangeOrdersByIds(orderApply.getExchangeOrderIdArray());
        model.addAttribute("exchangeOrders", exchangeOrders);
        ActivityHandler.edit(orderApply, orderApply.getState(), products, me, model);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("gridColsSwitch", (Object)JSON.toJSONString(this.getFrontGridColsSwithMap()));
        model.addAttribute("orgId", (Object)me.getCurrentPartner().getOrganizationid());
        Disposition dis = Cache.getDispositionFirst("acctID_display");
        if (Beans.isNotEmpty((Object)dis) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        return "order/approve.ftl";
    }

    @RequestMapping(value={"/unApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result unApprove_do(@RequestParam(value="id", required=false) String id, HttpServletRequest request, Model model) {
        OrderApply order = this.service.getOrderApply(id);
        Employee me = this.getCurrentEmployee();
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateUnApprove(id);
        ActivityHandler.submit(order, order.getState());
        this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), me, OrderApplyLocus.LocusType.approveInvert.getValue(), "\u8ba2\u5355\u53cd\u5ba1\u6279");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request, Model model) {
        String approveOrder = "approveOrder_" + orderApply.getNo();
        ServletContext servletContext = request.getServletContext();
        try {
            Employee me = this.getCurrentEmployee();
            OrderApply oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
            this.assertOrderExist(oldOrderApply);
            String orderState = oldOrderApply.getState();
            if (!orderApply.isPass()) {
                orderApply.setState(TCBJEnum.AuditState.approveNoPass.getValue());
                if (orderApply.getBilling() != null && orderApply.getBilling().equals("true")) {
                    this.intRebatemgService.unuse(orderApply.getId());
                    this.giftIntRebatemgService.unuse(orderApply.getId());
                    this.aplfineService.unuse(orderApply.getId());
                    this.giftService.unuse(orderApply.getId());
                    this.fGiftService.unuse(orderApply.getId());
                }
                ActivityHandler.submit(orderApply, orderState);
                this.service.updateOrderApplyState(orderApply.getId(), TCBJEnum.AuditState.approveNoPass.getValue(), me);
                AuditInfo auditInfo = new AuditInfo();
                auditInfo.setCreateDt(DateUtils.now());
                auditInfo.setCreatorId(me.getId());
                auditInfo.setBusinessId(orderApply.getId());
                auditInfo.setBusinessType("OrderApply");
                auditInfo.setOpinion(TCBJEnum.AuditState.approveNoPass.getValue());
                auditInfo.setRemark(orderApply.getRemark());
                this.auditService.add(auditInfo);
                this.orderApplyLocusService.saveOrderApplyLocus(orderApply.getId(), me, OrderApplyLocus.LocusType.approveNoPass.getValue(), "\u8ba2\u5355\u5ba1\u6279\u4e0d\u901a\u8fc7");
                Result result = this.getSuccessResult(null);
                return result;
            }
            this.assertApplyerIsValid(orderApply.getApplyerId());
            orderApply.setApproverId(me.getId());
            orderApply.setApproveDt(DateUtils.now());
            this.stockService.getStorageQuantityByPartner(orderApply.getSupplierId());
            Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
            Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
            if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
                orderApply.setSalesman(customer.getCityManagerId());
            }
            PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            this.assertContractIsExsit(contract);
            this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
            this.calculateOrderMoney(orderApply, customer.getPrecision());
            if (orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
                this.assertOrderOtherDiacount(orderApply, regularDt, customer.getPrecision());
                this.assertOrderDiacount(orderApply, regularDt, customer.getPrecision());
                this.assertOrderFreeGiftMoney(orderApply, contract.getFreeScaleType(), customer.getPrecision());
                List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
                List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
                this.calculateProductPrices(contract, products, details, customer.getPrecision());
                this.assertFineMoney(orderApply, products, regularDt, customer.getPrecision());
                HashMap<String, Double> offerPrices = new HashMap<String, Double>();
                for (OrderProduct orderProduct : products) {
                    offerPrices.put(orderProduct.getId(), orderProduct.getPrice());
                }
                for (OrderActivityProduct orderActivityProduct : orderApply.getActivityProducts()) {
                    if (!Beans.isNotEmpty(offerPrices.get(orderActivityProduct.getProductId()))) continue;
                    orderActivityProduct.setOfferPrice((Double)offerPrices.get(orderActivityProduct.getProductId()));
                }
                for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
                    if (!Beans.isNotEmpty(offerPrices.get(orderApplyItem.getProductId()))) continue;
                    orderApplyItem.setOfferPrice((Double)offerPrices.get(orderApplyItem.getProductId()));
                }
            } else {
                Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
                Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
                this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
            }
            for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
                item.fillInitData(me);
            }
            try {
                this.giftService.validate(orderApply, orderApply.getActGiftQuantity());
            }
            catch (Exception e) {
                throw new AppException("3017", e.getMessage());
            }
            boolean triggerEAS = false;
            if (oldOrderApply.isOrder()) {
                triggerEAS = true;
            } else {
                Partner supplier = this.partnerService.getSimplePartner(orderApply.getSupplierId());
                if (!supplier.isOrg()) {
                    triggerEAS = true;
                }
            }
            ArrayList<String> aIds = new ArrayList<String>();
            if (Beans.isNotEmpty(orderApply.getActivitys())) {
                for (OrderActivityInfo info : orderApply.getActivitys()) {
                    aIds.add(info.getActivityId());
                }
            }
            AbstractActivityProcessor.newfillTotalCountActivitys(orderApply, orderApply.getActivitys(), aIds);
            ActivityHandler.validateActivityProduct(orderApply);
            this.splitDiscountMoneyToItems(orderApply, customer.getPrecision());
            this.service.approveOrderApply(orderApply, triggerEAS, customer.getPrecision());
            Partner supplier = this.partnerService.getPartner(orderApply.getSupplierId());
            if (!supplier.isOrg()) {
                this.service.addOrderInOut(orderApply.getId(), me);
            }
            ActivityHandler.submit(orderApply, orderState);
            this.service.updateOrderApplyState(orderApply.getId(), TCBJEnum.AuditState.approvePass.getValue(), me);
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setCreateDt(DateUtils.now());
            auditInfo.setCreatorId(me.getId());
            auditInfo.setBusinessId(orderApply.getId());
            auditInfo.setBusinessType("OrderApply");
            auditInfo.setOpinion(TCBJEnum.AuditState.approvePass.getValue());
            auditInfo.setRemark(orderApply.getRemark());
            this.auditService.add(auditInfo);
            this.orderApplyLocusService.saveOrderApplyLocus(orderApply.getId(), me, OrderApplyLocus.LocusType.approvePass.getValue(), "\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7");
        }
        finally {
            servletContext.removeAttribute(approveOrder);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.service.getSimpleOrderApply(id);
        this.assertOrderBelongMyPartner(orderApply, me);
        this.assertOrderIsDraft(orderApply);
        this.service.delOrderApply(id);
        return "redirect:applys.do?conscope=session";
    }

    @RequestMapping(value={"/cancel.do"})
    public String cancel(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.service.getSimpleOrderApply(id);
        this.assertOrderBelongMyPartner(orderApply, me);
        this.assertOrderIsApproveNotPass(orderApply);
        this.service.cancelOrderApply(id, orderApply.getExchangeOrderIdArray());
        return "redirect:applys.do?conscope=session";
    }

    @RequestMapping(value={"/viewPrices.do"}, method={RequestMethod.GET})
    public String viewPrices(@RequestParam(value="applyerId", required=false) String applyerId, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        String supplierId = me.getCurrentPartner().getId();
        if (StringUtils.isEmpty(applyerId)) {
            supplierId = me.getCurrentPartner().getParPartnerId();
            applyerId = me.getCurrentPartner().getId();
        }
        model.addAttribute("applyerId", (Object)applyerId);
        Date regularDt = DateUtils.now();
        PactMain contract = this.getPactMain(applyerId, supplierId, regularDt);
        if (contract == null) {
            return "order/viewPrices.ftl";
        }
        List<OrderProduct> products = this.getProducts(applyerId, supplierId);
        Customer customer = this._getCustomer(applyerId, supplierId);
        List<PrAdjdetail> details = this.priceAdjustService.getList(applyerId, supplierId, regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        return "order/viewPrices.ftl";
    }

    @RequestMapping(value={"findIntRebatemg.do"})
    public String get_details(String supplierId, Model model) {
        List<IntRebatemg> its = this.intrebatemgservice.getlist(supplierId, this.getCurrentEmployee().getCurrentPartner().getId(), DateUtils.now());
        model.addAttribute("its", its);
        BigDecimal sum_product = BigDecimal.valueOf(0.0);
        BigDecimal sum_gift = BigDecimal.valueOf(0.0);
        BigDecimal sum_all = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_product = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_gift = BigDecimal.valueOf(0.0);
        BigDecimal sy_sum_all = BigDecimal.valueOf(0.0);
        int cp_sum = 0;
        int zp_sum = 0;
        int qp_sum = 0;
        for (IntRebatemg ib : its) {
            if ("PRODUCT".equals(ib.getProducttype())) {
                sum_product = sum_product.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_product = sy_sum_product.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++cp_sum;
                continue;
            }
            if ("GIFT".equals(ib.getProducttype())) {
                sum_gift = sum_gift.add(BigDecimal.valueOf(ib.getRebateMoney()));
                sy_sum_gift = sy_sum_gift.add(BigDecimal.valueOf(ib.getWithheldMoney()));
                ++zp_sum;
                continue;
            }
            if (!"FULL".equals(ib.getProducttype())) continue;
            sum_all = sum_all.add(BigDecimal.valueOf(ib.getRebateMoney()));
            sy_sum_all = sy_sum_all.add(BigDecimal.valueOf(ib.getWithheldMoney()));
            ++qp_sum;
        }
        BigDecimal ky_sum_product = sum_product.subtract(sy_sum_product);
        BigDecimal ky_sum_gift = sum_gift.subtract(sy_sum_gift);
        BigDecimal ky_sum_all = sum_all.subtract(sy_sum_all);
        model.addAttribute("cp_sum", (Object)cp_sum);
        model.addAttribute("zp_sum", (Object)zp_sum);
        model.addAttribute("qp_sum", (Object)qp_sum);
        model.addAttribute("ky_sum_product", (Object)ky_sum_product);
        model.addAttribute("ky_sum_gift", (Object)ky_sum_gift);
        model.addAttribute("ky_sum_all", (Object)ky_sum_all);
        model.addAttribute("sum_product", (Object)sum_product);
        model.addAttribute("sum_gift", (Object)sum_gift);
        model.addAttribute("sum_all", (Object)sum_all);
        model.addAttribute("ibs", (Object)its.size());
        return "order/findIntRebatemg.ftl";
    }

    @RequestMapping(value={"/proPrice.do"}, method={RequestMethod.GET})
    public String priceExcel() {
        return "order/proPrice.ftl";
    }

    @RequestMapping(value={"/getActivityItem.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getActivityItem(@Valid @RequestBody OrderApply orderApply, Model model) {
        Map<String, Object> result = ActivityHandler.getActivityProducts(orderApply);
        return this.getSuccessResult(Jsons.toJson(result));
    }

    @RequestMapping(value={"/validateActivityProduct.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result validateActivityProduct(@Valid @RequestBody OrderApply orderApply, Model model) {
        ActivityHandler.validateActivityProduct(orderApply);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        List<QyAllotRow> qys = this.qyAllService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId());
        Map<String, Double> productUsedQuantitys = null;
        Map<String, String> mapDates = this.qyAllService.getAllotRowDates(orderApply.getApplyerId());
        productUsedQuantitys = this.service.findProductApplyQuantitys(orderApply.getApplyerId(), orderApply.getSupplierId(), mapDates, regularDt, orderApply.getId());
        this.assertProductLimitQuantitys(orderApply, products, qys, productUsedQuantitys);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/priceExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void priceExcel(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="format", required=false) String format) throws Exception {
        String orgId = this.getCurrentEmployee().getCurrentPartner().getOrganizationid();
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from PactMain p where pactState = '1' and p.supplierId = ? ");
        args.add(orgId);
        if (!this.getCurrentEmployee().getCurrentPartner().isOrg()) {
            hql.append(" and applyerId = ? ");
            args.add(this.getCurrentEmployee().getCurrentPartner().getId());
        }
        String hql2 = "from PactBrand pb where exists(" + hql.toString() + "and p.id = pb.pactId )";
        hql.append("  order by endDate asc ");
        List pm = this.baseDao.findEntity(hql.toString(), args.toArray(), PactMain.class);
        HashMap<String, PactMain> map = new HashMap<String, PactMain>();
        int i = 0;
        while (i < pm.size()) {
            PactMain pactMain = (PactMain)pm.get(i);
            map.put(pactMain.getId(), pactMain);
            ++i;
        }
        List pactBrands = this.baseDao.findEntity(hql2.toString(), args.toArray(), PactBrand.class);
        for (PactBrand pactBrand : pactBrands) {
            PactMain pactMain = (PactMain)map.get(pactBrand.getPactId());
            pactMain.getPactBrand().add(pactBrand);
        }
        ArrayList list = new ArrayList();
        for (PactMain p : pm) {
            List<OrderProduct> products = null;
            try {
                products = this.getProducts(p.getApplyerId(), p.getSupplierId());
            }
            catch (Exception exception) {}
            if (products == null) continue;
            List<PrAdjdetail> details = this.priceAdjustService.getList(p.getApplyerId(), p.getSupplierId(), new Date());
            Customer customer = this._getCustomer(p.getApplyerId(), p.getSupplierId());
            if (customer != null) {
                this.calculateProductPrices(p, products, details, customer.getPrecision());
            }
            for (OrderProduct product : products) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                Partner partner = Cache.getPartner(p.getApplyerId());
                if (Beans.isNotEmpty((Object)partner)) {
                    resultMap.put("partnerName", partner.getName());
                    resultMap.put("partnerNo", partner.getNo());
                    resultMap.put("area", partner.getAreaName());
                    resultMap.put("bigArea", partner.getBigAreaName());
                    resultMap.put("beginDate", partner.getStartDt());
                    resultMap.put("endDate", partner.getEndDt());
                }
                resultMap.put("no", product.getNo());
                resultMap.put("name", product.getName());
                resultMap.put("price", product.getPrice());
                resultMap.put("invalidDt", p.getEndDate());
                list.add(resultMap);
            }
        }
        if (format.endsWith(".xls") && list.size() >= 60000) {
            throw new AppException("5109");
        }
        String[] titles = new String[]{"\u7ecf\u9500\u5546", "\u7ecf\u9500\u5546\u52a9\u8bb0\u7801", "\u533a\u57df", "\u5927\u533a", "\u5f00\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4", "\u4ea7\u54c1\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u4ef7\u683c", "\u5408\u540c\u7ed3\u675f\u65f6\u95f4"};
        String[] pop = new String[]{"partnerName", "partnerNo", "area", "bigArea", "beginDate", "endDate", "no", "name", "price", "invalidDt"};
        ExcelUtils.exportExcelNew("\u5408\u540c\u4f9b\u8d27\u65b9\u7ed9\u7684\u4ea7\u54c1\u4ef7\u683c\u62a5\u8868-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u7ec8\u7aef\u62a5\u8868", format, titles, list, pop, response);
    }

    @RequestMapping(value={"/balanceApprove.do"})
    public String balanceApprove(@RequestParam(value="id", required=false) String id, Model model) {
        model.addAttribute("balanceApprove", (Object)"true");
        return "forward:/orderapply/view.do";
    }

    @RequestMapping(value={"/billing.do"})
    public String billing(@RequestParam(value="id", required=false) String id, Model model) {
        model.addAttribute("balanceApprove", (Object)"true");
        model.addAttribute("billing", (Object)"true");
        return "forward:/orderapply/view.do";
    }

    @RequestMapping(value={"/billing.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result billing(ApproveDto dto, @RequestParam(value="ERPNumber", required=false) String ERPNumber) {
        OrderApply order = this.service.getOrderApply(dto.getId());
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateBillingApprove(dto.getId(), ERPNumber);
        this.addAuditInfo(dto.getId(), "OrderApply", TCBJEnum.AuditState.billing.getValue(), dto.getRemark());
        this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.billing.getValue(), "\u5df2\u5f00\u5355\u6210\u529f");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/nobilling.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(ApproveDto dto, HttpServletRequest request, Model model) {
        OrderApply orderApply = this.service.getOrderApply(dto.getId());
        String approveOrder = "approveOrder_" + orderApply.getNo();
        ServletContext servletContext = request.getServletContext();
        try {
            this.service.runNobilling(this.getCurrentEmployee(), orderApply);
            this.addAuditInfo(dto.getId(), "OrderApply", TCBJEnum.AuditState.approveNoPass.getValue(), dto.getRemark());
            this.orderApplyLocusService.saveOrderApplyLocus(orderApply.getId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.approveNoPass.getValue(), "\u8ba2\u5355\u5ba1\u6279\u4e0d\u901a\u8fc7");
        }
        finally {
            servletContext.removeAttribute(approveOrder);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/balanceApprovePass.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result balanceApprovePass(ApproveDto dto) {
        this.service.updateBalanceApprove(dto.getId(), this.getCurrentEmployee());
        this.orderApplyLocusService.saveOrderApplyLocus(dto.getId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.balancePass.getValue(), "\u8ba2\u5355\u8d22\u52a1\u5ba1\u6279\u901a\u8fc7");
        this.addAuditInfo(dto.getId(), "OrderApply", TCBJEnum.AuditState.balancePass.getValue(), dto.getRemark());
        return this.getSuccessResult(null);
    }

    private void addAuditInfo(String businessId, String BusinessType, String opinion, String remark) {
        Employee me = this.getCurrentEmployee();
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessId(businessId);
        auditInfo.setBusinessType(BusinessType);
        auditInfo.setOpinion(opinion);
        auditInfo.setRemark(remark);
        this.auditService.add(auditInfo);
    }

    @RequestMapping(value={"/balanceApproveNoPass.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result balanceApproveNoPass(ApproveDto dto) {
        OrderApply order = this.service.getOrderApply(dto.getId());
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateBalanceApproveNoPass(dto.getId());
        ActivityHandler.submit(order, TCBJEnum.AuditState.approvePass.getValue());
        this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.balanceNoPass.getValue(), "\u8ba2\u5355\u8d22\u52a1\u5ba1\u6279\u4e0d\u901a\u8fc7");
        this.addAuditInfo(dto.getId(), "OrderApply", TCBJEnum.AuditState.balanceNoPass.getValue(), dto.getRemark());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/sended.do"})
    public String sended(@RequestParam(value="id", required=true) String id, Model model) {
        model.addAttribute("sended", (Object)"true");
        model.addAttribute("orderId", (Object)id);
        return "order/orderDeliveryInformation.ftl";
    }

    @RequestMapping(value={"/saveDeliveryInformation.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result saveDeliveryInformation(@Valid @RequestBody OrderDeliveryInformation orderDeliveryInformation) {
        this.service.saveDeliveryInformation(orderDeliveryInformation);
        this.service.updateSended(orderDeliveryInformation.getOrderId());
        this.orderApplyLocusService.saveOrderApplyLocus(orderDeliveryInformation.getOrderId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.sended.getValue(), "\u8ba2\u5355\u5df2\u53d1\u8d27");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/sended.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result sended(ApproveDto dto) {
        OrderApply order = this.service.getOrderApply(dto.getId());
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateSended(dto.getId());
        this.orderApplyLocusService.saveOrderApplyLocus(order.getId(), this.getCurrentEmployee(), OrderApplyLocus.LocusType.sended.getValue(), "\u8ba2\u5355\u5df2\u53d1\u8d27");
        this.addAuditInfo(dto.getId(), "OrderApply", TCBJEnum.AuditState.sended.getValue(), dto.getRemark());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/ordersExportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@ModelAttribute(value="condition") OrderApplyCondition con, HttpServletRequest request, Model model, HttpServletResponse response) throws Exception {
        con.setPageno(1);
        con.setPageSize(9999);
        this.approves(con, model);
        List orderApplys = ((Page)model.asMap().get("orderApplys")).getList();
        this.service.loadingOrderApply(orderApplys);
        File dir = new File(String.valueOf(StringUtils.getUploadPath()) + "orderExcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.excels(orderApplys, dir.getPath(), String.valueOf(this.getCurrentEmployee().getCurrentPartner().getNo()) + "-" + System.currentTimeMillis() + ".xls", this.getCurrentEmployee(), response);
    }

    public void excels(List<OrderApply> orders, String path, String name, Employee em, HttpServletResponse response) throws IOException {
        File excelFile = new File(String.valueOf(path) + "\\" + name);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        FileUtils.copyFile((File)new File(String.valueOf(request.getServletContext().getRealPath("/")) + "resource/order/ordersNew.xls"), (File)excelFile);
        FileInputStream fileInputStream = null;
        HSSFWorkbook wb = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(excelFile.getPath());
                wb = new HSSFWorkbook((InputStream)fileInputStream);
                HSSFSheet sheet = wb.getSheetAt(0);
                ArrayList rowDatas = new ArrayList();
                for (OrderApply orderApply : orders) {
                    Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
                    for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
                        HashMap<Integer, String> rowData = new HashMap<Integer, String>();
                        rowData.put(0, DateUtils.formartDate2((Date)orderApply.getDt(), (String)"yyyy-MM-dd"));
                        rowData.put(1, orderApply.getNo());
                        rowData.put(6, customer.getApplyerCode());
                        rowData.put(7, customer.getApplyerName());
                        rowData.put(8, customer.getApplyerCode());
                        rowData.put(9, customer.getApplyerName());
                        rowData.put(15, orderApply.getShippingAddress());
                        rowData.put(16, orderApply.getContacts());
                        rowData.put(17, orderApply.getPhone());
                        rowData.put(19, orderApply.getSettlementModeName());
                        rowData.put(32, Cache.getProductNo(orderApplyItem.getProductId()));
                        rowData.put(33, Cache.getProductName(orderApplyItem.getProductId()));
                        rowData.put(34, orderApplyItem.getUnitName());
                        rowData.put(35, String.valueOf(orderApplyItem.getQuantity()));
                        rowData.put(39, String.valueOf(orderApplyItem.getPrice()));
                        rowData.put(40, String.valueOf(orderApplyItem.getPrice() * orderApplyItem.getQuantity()));
                        rowDatas.add(rowData);
                    }
                }
                int i = 0;
                while (i < rowDatas.size()) {
                    Map rowData = (Map)rowDatas.get(i);
                    HSSFRow row = sheet.createRow(i + 1);
                    for (Integer column : rowData.keySet()) {
                        HSSFCell cell = row.createCell(column.intValue());
                        cell.setCellValue((String)rowData.get(column));
                    }
                    ++i;
                }
                fileOutputStream = new FileOutputStream(excelFile.getPath());
                wb.write((OutputStream)fileOutputStream);
                ExcelUtil.download(excelFile.getPath(), response);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (wb != null) {
                    wb.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (wb != null) {
                wb.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    @RequestMapping(value={"/exportOrderSummaryExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportOrderSummaryExcel(@ModelAttribute(value="condition") OrderApplyCondition con, HttpServletRequest request, Model model, HttpServletResponse response) throws Exception {
        con.setPageno(1);
        con.setPageSize(9999);
        this.approves(con, model);
        List orderApplys = ((Page)model.asMap().get("orderApplys")).getList();
        this.exportOrderSummaryExcel(orderApplys, response);
    }

    public void exportOrderSummaryExcel(List<OrderApply> orders, HttpServletResponse response) throws Exception {
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("no", "\u8ba2\u5355\u7f16\u53f7");
        titleNameMap.put("dt", "\u8ba2\u5355\u65f6\u95f4");
        titleNameMap.put("billDate", "\u5f00\u5355\u65f6\u95f4");
        titleNameMap.put("applyerName", "\u5ba2\u6237\u540d\u79f0");
        titleNameMap.put("applyerNo", "\u52a9\u8bb0\u7801");
        titleNameMap.put("quantity", "\u603b\u6570\u91cf");
        titleNameMap.put("totalMoney", "\u603b\u91d1\u989d");
        titleNameMap.put("discountTotalMoney", "\u4ea7\u54c1\u6298\u8ba9");
        titleNameMap.put("giftDiscountTotalMoney", "\u8d60\u54c1\u6298\u8ba9");
        titleNameMap.put("remainMoney", "\u5e94\u6536\u91d1\u989d");
        titleNameMap.put("stateName", "\u72b6\u6001");
        titleNameMap.put("source", "\u6765\u6e90");
        titleNameMap.put("areaName", "\u6240\u5c5e\u533a\u57df");
        titleNameMap.put("lastUpdatorName", "\u63d0\u4ea4\u4eba");
        ArrayList listExcel = new ArrayList();
        for (OrderApply order : orders) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("no", order.getNo());
            OrderApplyLocus locus = this.orderApplyLocusService.getOrderApplyLocusByOrderId(order.getId(), TCBJEnum.AuditState.billing.getValue());
            if (Beans.isNotEmpty((Object)locus)) {
                itemMap.put("dt", DateUtils.formartDate((Date)locus.getHandleDt(), (String)"yyyy-MM-dd"));
            }
            itemMap.put("billDate", DateUtils.formartDate2((Date)order.getBillDate(), (String)"yyyy-MM-dd"));
            itemMap.put("applyerName", order.getApplyerName());
            itemMap.put("applyerNo", order.getApplyerNo());
            itemMap.put("quantity", order.getQuantity());
            itemMap.put("totalMoney", order.getTotalMoney());
            itemMap.put("discountTotalMoney", order.getDiscountMoney());
            itemMap.put("giftDiscountTotalMoney", order.getGiftDiscountMoney());
            itemMap.put("remainMoney", order.getRemainMoney());
            itemMap.put("stateName", order.getStateName_2());
            itemMap.put("source", order.getSource());
            itemMap.put("areaName", order.getAreaName());
            itemMap.put("lastUpdatorName", order.getLastUpdatorName());
            listExcel.add(itemMap);
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u8ba2\u5355\u6c47\u603b-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u8ba2\u5355\u6c47\u603b", ".xlsx", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"/exportOrderDetailExcelForPage.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String exportOrderDetailExcel(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        con.setPageno(1);
        con.setPageSize(9999);
        this.approves(con, model);
        List applys = ((Page)model.asMap().get("orderApplys")).getList();
        this.service.loadingOrderApplyItem(con, applys);
        ArrayList listExcel = new ArrayList();
        for (OrderApply order : applys) {
            HashMap<String, Object> itemMap;
            StringBuilder sb = new StringBuilder();
            ArrayList<String> args = new ArrayList<String>();
            sb.append("from OrderActivityProduct where orderApplyId = ? ");
            args.add(order.getId());
            if (Beans.isNotEmpty((Object)con.getProductId())) {
                sb.append(" and productId = ? ");
                args.add(con.getProductId());
            }
            List activityProducts = this.baseDao.findEntity(sb.toString(), args.toArray(), OrderActivityProduct.class);
            order.setActivityProducts(activityProducts);
            List<AuditInfo> auditInfos = this.auditService.find(order.getId());
            DecimalFormat df = new DecimalFormat("#.##");
            for (OrderApplyItem orderApplyItem : order.getOrderApplyItems()) {
                if ("1".equals(orderApplyItem.getActivityFlag())) continue;
                itemMap = new HashMap<String, Object>();
                itemMap.put("createDt", DateUtils.formartDate((Date)order.getCreateDt(), (String)"yyyy-MM-dd"));
                itemMap.put("dt", DateUtils.formartDate((Date)order.getDt(), (String)"yyyy-MM-dd"));
                itemMap.put("applyerName", order.getApplyerName());
                itemMap.put("no", order.getNo());
                itemMap.put("productNo", orderApplyItem.getNo());
                itemMap.put("productErpNo", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getExtCode());
                itemMap.put("productName", orderApplyItem.getProductName());
                itemMap.put("productBrand", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getBrandName());
                itemMap.put("spec", orderApplyItem.getSpec());
                itemMap.put("productSubType", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getSubTypeName());
                itemMap.put("productType", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getTypeName());
                itemMap.put("price", Beans.isNotEmpty((Object)orderApplyItem.getOfferPrice()) ? orderApplyItem.getOfferPrice() : 0.0);
                itemMap.put("quantity", orderApplyItem.getQuantity());
                itemMap.put("actQuantity", orderApplyItem.getActQuantity());
                itemMap.put("zhuhai", 0.0);
                itemMap.put("cainiao", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("totalPrice", df.format(MathUtils.mul((Double)((Double)itemMap.get("price")), (Double)orderApplyItem.getActQuantity())));
                itemMap.put("activityRebate", 0.0);
                itemMap.put("salesRebate", 0.0);
                itemMap.put("totalRebate", df.format(MathUtils.add((Double)((Double)itemMap.get("activityRebate")), (Double)((Double)itemMap.get("salesRebate")))));
                itemMap.put("rebatePrice", df.format(MathUtils.sub((Double)Double.valueOf((String)itemMap.get("totalPrice")), (Double)Double.valueOf((String)itemMap.get("totalRebate")))));
                itemMap.put("stateName", order.getStateName_2());
                itemMap.put("promotionStrategy", "");
                itemMap.put("auditRemark", Beans.isEmpty(auditInfos) ? "" : auditInfos.get(auditInfos.size() - 1).getRemark());
                itemMap.put("remark", order.getRemark());
                listExcel.add(itemMap);
            }
            for (OrderActivityProduct orderActivityProduct : order.getActivityProducts()) {
                if (orderActivityProduct.getQuantity() == 0.0) continue;
                itemMap = new HashMap();
                itemMap.put("createDt", DateUtils.formartDate((Date)order.getCreateDt(), (String)"yyyy-MM-dd"));
                itemMap.put("dt", DateUtils.formartDate((Date)order.getDt(), (String)"yyyy-MM-dd"));
                itemMap.put("applyerName", order.getApplyerName());
                itemMap.put("no", order.getNo());
                itemMap.put("productNo", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getNo());
                itemMap.put("productErpNo", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getExtCode());
                itemMap.put("productName", orderActivityProduct.getProductName());
                itemMap.put("productBrand", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getBrandName());
                itemMap.put("spec", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getSpec());
                itemMap.put("productSubType", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getSubTypeName());
                itemMap.put("productType", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getTypeName());
                itemMap.put("price", Beans.isNotEmpty((Object)orderActivityProduct.getOfferPrice()) ? orderActivityProduct.getOfferPrice() : 0.0);
                itemMap.put("quantity", orderActivityProduct.getQuantity());
                itemMap.put("actQuantity", orderActivityProduct.getQuantity());
                itemMap.put("zhuhai", 0.0);
                itemMap.put("cainiao", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("totalPrice", df.format(MathUtils.mul((Double)((Double)itemMap.get("price")), (Double)orderActivityProduct.getQuantity())));
                itemMap.put("activityRebate", df.format(MathUtils.mul((Double)((Double)itemMap.get("price") - orderActivityProduct.getPrice()), (Double)orderActivityProduct.getQuantity())));
                itemMap.put("salesRebate", 0.0);
                itemMap.put("totalRebate", df.format(MathUtils.add((Double)Double.valueOf((String)itemMap.get("activityRebate")), (Double)((Double)itemMap.get("salesRebate")))));
                itemMap.put("rebatePrice", df.format(MathUtils.sub((Double)Double.valueOf((String)itemMap.get("totalPrice")), (Double)Double.valueOf((String)itemMap.get("totalRebate")))));
                itemMap.put("stateName", order.getStateName_2());
                itemMap.put("promotionStrategy", orderActivityProduct.getActivityName());
                itemMap.put("auditRemark", Beans.isEmpty(auditInfos) ? "" : auditInfos.get(auditInfos.size() - 1).getRemark());
                itemMap.put("remark", order.getRemark());
                listExcel.add(itemMap);
            }
        }
        model.addAttribute("list", (Object)JSON.toJSONStringWithDateFormat(listExcel, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "order/orderDetails.ftl";
    }

    @RequestMapping(value={"/exportOrderDetailExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportOrderDetailExcel(@ModelAttribute(value="condition") OrderApplyCondition con, HttpServletRequest request, Model model, HttpServletResponse response) throws Exception {
        con.setPageno(1);
        con.setPageSize(9999);
        this.approves(con, model);
        List orderApplys = ((Page)model.asMap().get("orderApplys")).getList();
        this.service.loadingOrderApplyItem(con, orderApplys);
        this.exportOrderDetailExcel(con, orderApplys, response);
    }

    private void exportOrderDetailExcel(OrderApplyCondition con, List<OrderApply> orderApplys, HttpServletResponse response) throws Exception {
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("createDt", "\u8ba2\u5355\u65e5\u671f");
        titleNameMap.put("dt", "\u4e0b\u5355\u65e5\u671f");
        titleNameMap.put("applyerName", "\u7528\u6237\u5168\u79f0");
        titleNameMap.put("no", "\u8ba2\u5355\u53f7");
        titleNameMap.put("productNo", "\u7f16\u7801");
        titleNameMap.put("productErpNo", "ERP\u7f16\u7801");
        titleNameMap.put("productName", "\u5546\u54c1\u540d\u79f0");
        titleNameMap.put("productBrand", "\u54c1\u724c");
        titleNameMap.put("spec", "\u89c4\u683c");
        titleNameMap.put("productSubType", "\u54c1\u7c7b");
        titleNameMap.put("productType", "\u7c7b\u522b");
        titleNameMap.put("price", "\u4f9b\u8d27\u4ef7");
        titleNameMap.put("quantity", "\u8ba2\u8d2d\u6570\u91cf");
        titleNameMap.put("actQuantity", "\u5ba1\u6279\u6570\u91cf");
        titleNameMap.put("zhuhai", "\u73e0\u6d77\u53d1\u8d27\u6570\u91cf");
        titleNameMap.put("cainiao", "\u83dc\u9e1f\u53d1\u8d27\u6570\u91cf");
        titleNameMap.put("shangpin", "\u5c1a\u54c1\u53d1\u8d27\u6570\u91cf");
        titleNameMap.put("totalPrice", "\u6298\u6263\u524d\u91d1\u989d");
        titleNameMap.put("activityRebate", "\u4fc3\u9500\u6d3b\u52a8\u6298\u6263");
        titleNameMap.put("salesRebate", "\u9500\u552e\u8fd4\u5229\u6298\u6263");
        titleNameMap.put("totalRebate", "\u6298\u6263\u989d\u5408\u8ba1");
        titleNameMap.put("rebatePrice", "\u6298\u6263\u540e\u91d1\u989d");
        titleNameMap.put("stateName", "\u8ba2\u5355\u72b6\u6001");
        titleNameMap.put("promotionStrategy", "\u4fc3\u9500\u653f\u7b56");
        titleNameMap.put("auditRemark", "\u8ba2\u5355\u5ba1\u6838\u5907\u6ce8");
        titleNameMap.put("remark", "\u8ba2\u5355\u5907\u6ce8");
        ArrayList listExcel = new ArrayList();
        for (OrderApply order : orderApplys) {
            HashMap<String, Object> itemMap;
            StringBuilder sb = new StringBuilder();
            ArrayList<String> args = new ArrayList<String>();
            sb.append("from OrderActivityProduct where orderApplyId = ? ");
            args.add(order.getId());
            if (Beans.isNotEmpty((Object)con.getProductId())) {
                sb.append(" and productId = ? ");
                args.add(con.getProductId());
            }
            List activityProducts = this.baseDao.findEntity(sb.toString(), args.toArray(), OrderActivityProduct.class);
            order.setActivityProducts(activityProducts);
            List<AuditInfo> auditInfos = this.auditService.find(order.getId());
            DecimalFormat df = new DecimalFormat("#.##");
            for (OrderApplyItem orderApplyItem : order.getOrderApplyItems()) {
                if ("1".equals(orderApplyItem.getActivityFlag())) continue;
                itemMap = new HashMap<String, Object>();
                itemMap.put("createDt", DateUtils.formartDate((Date)order.getCreateDt(), (String)"yyyy-MM-dd"));
                itemMap.put("dt", DateUtils.formartDate((Date)order.getDt(), (String)"yyyy-MM-dd"));
                itemMap.put("applyerName", order.getApplyerName());
                itemMap.put("no", order.getNo());
                itemMap.put("productNo", orderApplyItem.getNo());
                itemMap.put("productErpNo", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getExtCode());
                itemMap.put("productName", orderApplyItem.getProductName());
                itemMap.put("productBrand", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getBrandName());
                itemMap.put("spec", orderApplyItem.getSpec());
                itemMap.put("productSubType", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getSubTypeName());
                itemMap.put("productType", orderApplyItem.getProduct() == null ? "" : orderApplyItem.getProduct().getTypeName());
                itemMap.put("price", Beans.isNotEmpty((Object)orderApplyItem.getOfferPrice()) ? orderApplyItem.getOfferPrice() : 0.0);
                itemMap.put("quantity", orderApplyItem.getQuantity());
                itemMap.put("actQuantity", orderApplyItem.getActQuantity());
                itemMap.put("zhuhai", 0.0);
                itemMap.put("cainiao", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("totalPrice", df.format(MathUtils.mul((Double)((Double)itemMap.get("price")), (Double)orderApplyItem.getActQuantity())));
                itemMap.put("activityRebate", 0.0);
                itemMap.put("salesRebate", 0.0);
                itemMap.put("totalRebate", df.format(MathUtils.add((Double)((Double)itemMap.get("activityRebate")), (Double)((Double)itemMap.get("salesRebate")))));
                itemMap.put("rebatePrice", df.format(MathUtils.sub((Double)Double.valueOf((String)itemMap.get("totalPrice")), (Double)Double.valueOf((String)itemMap.get("totalRebate")))));
                itemMap.put("stateName", order.getStateName_2());
                itemMap.put("promotionStrategy", "");
                itemMap.put("auditRemark", Beans.isEmpty(auditInfos) ? "" : auditInfos.get(auditInfos.size() - 1).getRemark());
                itemMap.put("remark", order.getRemark());
                listExcel.add(itemMap);
            }
            for (OrderActivityProduct orderActivityProduct : order.getActivityProducts()) {
                if (orderActivityProduct.getQuantity() == 0.0) continue;
                itemMap = new HashMap();
                itemMap.put("createDt", DateUtils.formartDate((Date)order.getCreateDt(), (String)"yyyy-MM-dd"));
                itemMap.put("dt", DateUtils.formartDate((Date)order.getDt(), (String)"yyyy-MM-dd"));
                itemMap.put("applyerName", order.getApplyerName());
                itemMap.put("no", order.getNo());
                itemMap.put("productNo", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getNo());
                itemMap.put("productErpNo", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getExtCode());
                itemMap.put("productName", orderActivityProduct.getProductName());
                itemMap.put("productBrand", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getBrandName());
                itemMap.put("spec", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getSpec());
                itemMap.put("productSubType", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getSubTypeName());
                itemMap.put("productType", orderActivityProduct.getProduct() == null ? "" : orderActivityProduct.getProduct().getTypeName());
                itemMap.put("price", Beans.isNotEmpty((Object)orderActivityProduct.getOfferPrice()) ? orderActivityProduct.getOfferPrice() : 0.0);
                itemMap.put("quantity", orderActivityProduct.getQuantity());
                itemMap.put("actQuantity", orderActivityProduct.getQuantity());
                itemMap.put("zhuhai", 0.0);
                itemMap.put("cainiao", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("shangpin", 0.0);
                itemMap.put("totalPrice", df.format(MathUtils.mul((Double)((Double)itemMap.get("price")), (Double)orderActivityProduct.getQuantity())));
                itemMap.put("activityRebate", df.format(MathUtils.mul((Double)((Double)itemMap.get("price") - orderActivityProduct.getPrice()), (Double)orderActivityProduct.getQuantity())));
                itemMap.put("salesRebate", 0.0);
                itemMap.put("totalRebate", df.format(MathUtils.add((Double)Double.valueOf((String)itemMap.get("activityRebate")), (Double)((Double)itemMap.get("salesRebate")))));
                itemMap.put("rebatePrice", df.format(MathUtils.sub((Double)Double.valueOf((String)itemMap.get("totalPrice")), (Double)Double.valueOf((String)itemMap.get("totalRebate")))));
                itemMap.put("stateName", order.getStateName_2());
                itemMap.put("promotionStrategy", orderActivityProduct.getActivityName());
                itemMap.put("auditRemark", Beans.isEmpty(auditInfos) ? "" : auditInfos.get(auditInfos.size() - 1).getRemark());
                itemMap.put("remark", order.getRemark());
                listExcel.add(itemMap);
            }
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u8ba2\u5355\u660e\u7ec6-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u8ba2\u5355\u660e\u7ec6", ".xlsx", titles, listExcel, pop, response);
    }

    @RequestMapping(value={"/approveNoAll.do"}, method={RequestMethod.POST})
    public String approveNoAll(@ModelAttribute(value="condition") OrderApplyCondition con, BindingResult errors, HttpServletRequest request, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setSupplierId(me.getCurrentPartner().getId());
        con.setCurrentPartnerId(me.getCurrentPartner().getId());
        if (StringUtils.isBlank(con.getState())) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
        } else if (con.getState().equals("dealing")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approve.getValue());
        } else if (con.getState().equals("dealed")) {
            con.getOrderStates().add(TCBJEnum.AuditState.approvePass.getValue());
        }
        con.setEmployeeId(me.getId());
        con.setRegionFilter(true);
        con = (OrderApplyCondition)this.wrapCondition(con, "applys");
        con.setPageSize(Integer.MAX_VALUE);
        con.setPageno(1);
        Page page = this.service.findOrderApplys(con, "order by T1.LASTUPDATE_DT desc");
        List orderApplys = page.getList();
        int i = 0;
        int j = 0;
        for (OrderApply apply : orderApplys) {
            if (TCBJEnum.AuditState.approve.getValue().equals(apply.getState())) {
                this.approveNoApply(apply, me);
                ++i;
                continue;
            }
            if (!TCBJEnum.AuditState.approvePass.getValue().equals(apply.getState())) continue;
            this.unApprove(apply, me);
            this.approveNoApply(apply, me);
            ++j;
        }
        model.addAttribute("rtn", (Object)("<script language=\"javascript\">alert('\u9a73\u56de\u6210\u529f\uff01\u5f85\u5ba1\u6279\u7533\u8bf7\u5355\uff1a" + i + "\u6761\uff0c\u5ba1\u6279\u901a\u8fc7\u7533\u8bf7\u5355\uff1a" + j + "\u6761\uff01');" + "window.location.href=base+'/orderapply/approves.do'</script>"));
        return "common/iframeRtn.ftl";
    }

    private void unApprove(OrderApply apply, Employee me) {
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), apply.getId()});
        this.intRebatemgService.unuse(apply.getId());
        this.giftIntRebatemgService.unuse(apply.getId());
        this.aplfineService.unuse(apply.getId());
        this.giftService.unuse(apply.getId());
        this.fGiftService.unuse(apply.getId());
        this.orderApplyLocusService.saveOrderApplyLocus(apply.getId(), me, OrderApplyLocus.LocusType.approveInvert.getValue(), "\u8ba2\u5355\u53cd\u5ba1\u6279");
    }

    private void approveNoApply(OrderApply apply, Employee me) {
        String orderState = apply.getState();
        apply.setState(TCBJEnum.AuditState.approveNoPass.getValue());
        ActivityHandler.submit(apply, orderState);
        this.service.updateOrderApplyState(apply.getId(), TCBJEnum.AuditState.approveNoPass.getValue(), me);
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessId(apply.getId());
        auditInfo.setBusinessType("OrderApply");
        auditInfo.setOpinion(TCBJEnum.AuditState.approveNoPass.getValue());
        auditInfo.setRemark(apply.getRemark());
        this.auditService.add(auditInfo);
        this.orderApplyLocusService.saveOrderApplyLocus(apply.getId(), me, OrderApplyLocus.LocusType.approveNoPass.getValue(), "\u8ba2\u5355\u5ba1\u6279\u4e0d\u901a\u8fc7");
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.POST})
    public void approve_do(String jsonStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        OrderApply orderApply = (OrderApply)JSON.parseObject((String)jsonStr, OrderApply.class);
        OrderApply apply = this.orderApplyService.getOrderApply(orderApply.getId());
        LinkedHashMap<String, String> titleNameMap = new LinkedHashMap<String, String>();
        titleNameMap.put("no", "\u8ba2\u5355\u7f16\u53f7");
        titleNameMap.put("dt", "\u4e0b\u5355\u65e5\u671f");
        titleNameMap.put("customerName", "\u5ba2\u6237\u5168\u79f0");
        titleNameMap.put("shippingAddress", "\u4e0b\u5355\u5730\u5740");
        titleNameMap.put("productNo", "\u7f16\u53f7");
        titleNameMap.put("productErpNo", "ERP");
        titleNameMap.put("barCode", "\u6761\u7801");
        titleNameMap.put("name", "\u5546\u54c1\u540d\u79f0");
        titleNameMap.put("spec", "\u89c4\u683c");
        titleNameMap.put("price", "\u96f6\u552e\u4ef7");
        titleNameMap.put("actPrice", "\u4f9b\u8d27\u4ef7");
        titleNameMap.put("quantity", "\u6570\u91cf");
        titleNameMap.put("totalPrice", "\u603b\u4ef7");
        titleNameMap.put("brand", "\u54c1\u724c");
        titleNameMap.put("type", "\u7c7b\u522b");
        titleNameMap.put("no1", "\u8ba2\u5355\u7f16\u53f7");
        titleNameMap.put("dt1", "\u4e0b\u5355\u65e5\u671f");
        titleNameMap.put("shippingAddress1", "\u4e0b\u5355\u5730\u5740");
        titleNameMap.put("customerName1", "\u5ba2\u6237\u5168\u79f0");
        titleNameMap.put("customerNo", "\u5ba2\u6237\u52a9\u8bb0\u7801");
        titleNameMap.put("clientAppNo", "\u5916\u56f4\u7cfb\u7edf\u7f16\u7801");
        ArrayList listExcel = new ArrayList();
        for (OrderApplyItem orderItem : orderApply.getOrderApplyItems()) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("no", orderApply.getNo());
            itemMap.put("dt", DateUtils.formartDate2((Date)apply.getDt(), (String)"yyyy-MM-dd"));
            itemMap.put("customerName", Beans.isEmpty((Object)apply.getApplyerName()) ? "" : apply.getApplyerName());
            itemMap.put("shippingAddress", Beans.isEmpty((Object)apply.getShippingAddress()) ? "" : apply.getShippingAddress());
            itemMap.put("productNo", orderItem.getNo());
            itemMap.put("productErpNo", orderItem.getProduct() == null ? "" : orderItem.getProduct().getExtCode());
            itemMap.put("barCode", orderItem.getProduct() == null ? "" : orderItem.getProduct().getBarCode());
            itemMap.put("name", orderItem.getProductName());
            itemMap.put("spec", orderItem.getSpec());
            itemMap.put("price", orderItem.getBasePrice());
            itemMap.put("actPrice", orderItem.getActPrice());
            itemMap.put("quantity", orderItem.getActQuantity());
            itemMap.put("totalPrice", orderItem.getMoney());
            itemMap.put("brand", orderItem.getProduct() == null ? "" : orderItem.getProduct().getBrandName());
            itemMap.put("type", orderItem.getProduct() == null ? "" : orderItem.getProduct().getSubTypeName());
            itemMap.put("no1", orderApply.getNo());
            itemMap.put("dt1", DateUtils.formartDate2((Date)apply.getDt(), (String)"yyyy-MM-dd"));
            itemMap.put("shippingAddress1", Beans.isEmpty((Object)apply.getShippingAddress()) ? "" : apply.getShippingAddress());
            itemMap.put("customerName1", Beans.isEmpty((Object)apply.getApplyerName()) ? "" : apply.getApplyerName());
            itemMap.put("customerNo", Beans.isEmpty((Object)apply.getApplyerNo()) ? "" : apply.getApplyerNo());
            itemMap.put("clientAppNo", Beans.isEmpty((Object)apply.getClientAppNo()) ? "" : apply.getClientAppNo());
            listExcel.add(itemMap);
        }
        String[] titles = new String[titleNameMap.size()];
        String[] pop = new String[titleNameMap.size()];
        int i = 0;
        for (Map.Entry e : titleNameMap.entrySet()) {
            titles[i] = (String)e.getValue();
            pop[i] = (String)e.getKey();
            ++i;
        }
        ExcelUtils.exportExcelNew("\u8ba2\u5355\u5ba1\u6279\u660e\u7ec6-" + apply.getApplyerNo() + "-" + apply.getApplyerName(), "\u8ba2\u5355\u5ba1\u6279\u660e\u7ec6", ".xlsx", titles, listExcel, pop, response);
    }

    public Map<String, String> getFrontGridColsSwithMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String jsonStr = Cache.getDesByVal("TCBJ_ORDER_GRID_COLS", StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(jsonStr)) {
            List conList = (List)Jsons.toBean((String)jsonStr, List.class);
            for (Map con : conList) {
                map.put((String)con.get("code"), (String)con.get("value"));
            }
        }
        return map;
    }
}

