/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.order.base.BaseApplyController;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.OneBarcodeUtil;
import com.tcbj.util.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.Code128Encoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.paint.BaseLineTextPainter;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.WidthCodedPainter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/orderapply"})
public class OrderApplyPrintController
extends BaseApplyController {
    @Autowired
    ScoreService scoreService;

    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u8ba2\u5355");
    }

    public void removeGiftProducts(OrderApply orderApply) {
        ArrayList<OrderApplyItem> items = new ArrayList<OrderApplyItem>();
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            if (!StringUtils.isEmpty(item.getIsScore()) && item.getIsScore().equals("Y")) continue;
            items.add(item);
        }
        orderApply.setOrderApplyItems(items);
    }

    @RequestMapping(value={"/print.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        String[] scoreOrderIds;
        OrderApply orderApply = this.loadOrderApply(id, model);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        this.removeGiftProducts(orderApply);
        List<OrderProduct> products = this.getProducts(orderApply);
        model.addAttribute("datas", (Object)JSON.toJSONString(products));
        this.typeByNumber(products);
        OrderProduct orderProduct = new OrderProduct();
        Collections.sort(products, orderProduct);
        model.addAttribute("orgName", (Object)Cache.getApplyer(this.getCurrentEmployee().getCurrentPartner().getOrganizationid()).getApplyerName());
        model.addAttribute("products", products);
        if (orderApply.getNo() != null) {
            String str = orderApply.getNo().split("[.]")[orderApply.getNo().split("[.]").length - 1];
            if (StringUtils.isEmpty(str)) {
                str = orderApply.getNo();
            }
            try {
                JBarcode localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
                localJBarcode.setEncoder((BarcodeEncoder)Code128Encoder.getInstance());
                localJBarcode.setPainter(WidthCodedPainter.getInstance());
                localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
                localJBarcode.setShowCheckDigit(false);
                BufferedImage localBufferedImage = localJBarcode.createBarcode(str);
                localBufferedImage = localJBarcode.createBarcode(str);
                String path = "onecode";
                File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                OneBarcodeUtil.saveToPNG((BufferedImage)localBufferedImage, (String)(String.valueOf(str) + ".png"), (String)(String.valueOf(dir.getPath()) + "/"));
                model.addAttribute("path", (Object)(String.valueOf(path) + "/" + str + ".png"));
            }
            catch (Exception localException) {
                localException.printStackTrace();
            }
        }
        if ((scoreOrderIds = orderApply.getExchangeOrderIdArray()) != null && scoreOrderIds.length > 0) {
            this.findExchangeOrders(orderApply, scoreOrderIds, model);
        }
        if (orderApply.getClientAppNo() != null) {
            String str = orderApply.getClientAppNo().split("[.]")[orderApply.getClientAppNo().split("[.]").length - 1];
            if (StringUtils.isEmpty(str)) {
                str = orderApply.getClientAppNo();
            }
            try {
                JBarcode localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
                localJBarcode.setEncoder((BarcodeEncoder)Code128Encoder.getInstance());
                localJBarcode.setPainter(WidthCodedPainter.getInstance());
                localJBarcode.setTextPainter(BaseLineTextPainter.getInstance());
                localJBarcode.setShowCheckDigit(false);
                BufferedImage localBufferedImage = localJBarcode.createBarcode(str);
                localBufferedImage = localJBarcode.createBarcode(str);
                String path = "onecode";
                File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                OneBarcodeUtil.saveToPNG((BufferedImage)localBufferedImage, (String)(String.valueOf(str) + ".png"), (String)(String.valueOf(dir.getPath()) + "/"));
                model.addAttribute("noPath", (Object)(String.valueOf(path) + "/" + str + ".png"));
            }
            catch (Exception localException) {
                localException.printStackTrace();
            }
        }
        return "order/print.ftl";
    }

    private void findExchangeOrders(OrderApply orderApply, String[] scoreOrderIds, Model model) {
        List<ExchangeDetail> details = this.scoreService.getDetailsQuantityByOrderIds(orderApply, scoreOrderIds);
        orderApply.setScoreDetail(details);
        orderApply.setTotalQuantity(orderApply.getTotalScoreQuantity() + orderApply.getQuantity());
    }

    private void typeByNumber(List<OrderProduct> products) {
        for (OrderProduct orderProduct : products) {
            if (orderProduct.getProductType().equals("PRODUCT")) {
                orderProduct.setProductType("1");
                continue;
            }
            if (orderProduct.getProductType().equals("GIFT")) {
                orderProduct.setProductType("2");
                continue;
            }
            if (orderProduct.getProductType().equals("MATERIAL")) {
                orderProduct.setProductType("3");
                continue;
            }
            orderProduct.setProductType("4");
        }
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET})
    public void exportExcel(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request, HttpServletResponse response) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        this.removeGiftProducts(orderApply);
        List<OrderProduct> products = this.getProducts(orderApply);
        this.typeByNumber(products);
        OrderProduct orderProduct = new OrderProduct();
        Collections.sort(products, orderProduct);
        File dir = new File(String.valueOf(request.getSession().getServletContext().getRealPath("/")) + "exportexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ExcelUtil.exportExcel(response, products, orderApply, String.valueOf(orderApply.getNo()) + ".xls");
    }
}

