/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.alibaba.fastjson.JSON;
import com.tcbj.common.config.ConfigFactory;
import com.tcbj.crm.aplfine.AplfineService;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.ProductCondition;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.common.WmsDao;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.OrderApplyLocus;
import com.tcbj.crm.entity.OrderDeliveryInformation;
import com.tcbj.crm.entity.OrderInOut;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.entity.Storage;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.fgift.FGiftFacadeService;
import com.tcbj.crm.gift.GiftService;
import com.tcbj.crm.intrebatemg.GiftIntRebatemgService;
import com.tcbj.crm.intrebatemg.IntRebatemgFacadeService;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.ActivityInfoService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.score.ScoreService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.ExchangeDetail;
import com.tcbj.crm.view.ExchangeOrder;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerArea;
import com.tcbj.crm.view.Product;
import com.tcbj.crm.view.ProductGiftView;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.hibernate.lob.SerializableClob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderApplyService")
public class OrderApplyService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private NewBaseDao newBaseDao;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    PartnerService partnerService;
    @Autowired
    protected IntRebatemgFacadeService intRebatemgService;
    @Autowired
    protected GiftIntRebatemgService giftIntRebatemgService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    AplfineService aplfineService;
    @Autowired
    protected GiftService giftService;
    @Autowired
    protected FGiftFacadeService fGiftService;
    @Autowired
    WmsDao wmsDao;
    @Autowired
    ActivityInfoService activityInfoService;
    @Autowired
    Cache cache;
    @Autowired
    StorageService storageService;
    @Autowired
    ScoreService scoreService;

    @PostConstruct
    public void init() {
    }

    public int[] getOrderStats(String employeeId, String partnerId) {
        String regions = this.personnelService.getFRegionsByUserId(employeeId);
        String hql = "select new OrderApply(o.id,o.applyerId,o.supplierId,o.nature,o.state) from OrderApply o where ( ";
        hql = String.valueOf(hql) + " (o.applyerId=?) or (o.supplierId=? and o.areaCode in(" + regions + ") ";
        hql = String.valueOf(hql) + " )  ";
        hql = String.valueOf(hql) + " and (o.state=? or o.state=? or o.state=?)) ";
        Object[] args = new Object[]{partnerId, partnerId, "0", "2", "2-0"};
        List applys = this.baseDao.findEntity(hql, args, OrderApply.class);
        int drafts = 0;
        int nopass = 0;
        int approves = 0;
        int rtn_drafts = 0;
        int rtn_nopass = 0;
        int rtn_approves = 0;
        for (OrderApply apply : applys) {
            if (apply.getApplyerId().equals(partnerId)) {
                if (apply.getNature().equals("1")) {
                    if (apply.getState().equals("0")) {
                        ++drafts;
                        continue;
                    }
                    if (!apply.getState().equals("2-0")) continue;
                    ++nopass;
                    continue;
                }
                if (!apply.getNature().equals("2")) continue;
                if (apply.getState().equals("0")) {
                    ++rtn_drafts;
                    continue;
                }
                if (!apply.getState().equals("2-0")) continue;
                ++rtn_nopass;
                continue;
            }
            if (!apply.getSupplierId().equals(partnerId)) continue;
            if (apply.getNature().equals("1")) {
                if (!apply.getState().equals("2")) continue;
                ++approves;
                continue;
            }
            if (!apply.getNature().equals("2") || !apply.getState().equals("2")) continue;
            ++rtn_approves;
        }
        int[] rtns = new int[]{drafts, nopass, approves, rtn_drafts, rtn_nopass, rtn_approves};
        return rtns;
    }

    public Double getContractOrdersMoney(String applyerId, String contractNo) {
        String sql = "select sum(apply.REBATE_END_MONEY),1 from \tCX_INDENT_Apply apply \twhere \tapply.dealer_id='" + applyerId + "' and " + "\tapply.PACT_NO='" + contractNo + "' and " + "\tapply.NATURE='1' and " + "\t( " + "\t\tapply.INDENT_FLAG='3' or " + "\t\tapply.INDENT_FLAG='4' or " + "\t\tapply.INDENT_FLAG='5' or " + "\t\tapply.INDENT_FLAG='6' " + "\t) " + "\tgroup by apply.dealer_id ";
        List list = this.baseDao.findBySql(sql);
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        Object[] val = (Object[])list.get(0);
        if (val[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)val[0]).doubleValue();
    }

    public Double getContractRtnOrdersFullyMoney(String applyerId, String contractNo, String extendId) {
        List list;
        String sql = "select sum(apply.RETURNED_MONEY-apply.RETUNS_OVERTOP_MONEY),1 from \tCX_INDENT_Apply apply \twhere \tapply.dealer_id='" + applyerId + "' and " + "\tapply.PACT_NO='" + contractNo + "' and " + "\tapply.NATURE='2' and " + "\t( " + "\t\tapply.INDENT_FLAG='2' or " + "\t\tapply.INDENT_FLAG='3' or " + "\t\tapply.INDENT_FLAG='4' or " + "\t\tapply.INDENT_FLAG='5' or " + "\t\tapply.INDENT_FLAG='6' " + "\t) ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + "\tand apply.row_id!='" + extendId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql = String.valueOf(sql) + "\tgroup by apply.dealer_id ")) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] val = (Object[])list.get(0);
        if (val[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)val[0]).doubleValue();
    }

    public Double getUsingOtherDiacount(String applyerId, String supplierId, String excludeId) {
        String sql = " select sum(apply.OTHER_REBATE_MONEY),1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        List list = this.baseDao.findBySql(sql);
        Double rtn = 0.0;
        if (list == null || list.size() == 0) {
            return rtn;
        }
        Object[] discount = (Object[])list.get(0);
        rtn = discount[0] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[0]).doubleValue());
        return rtn;
    }

    public Double[] getUsingDiacount(String applyerId, String supplierId, String excludeId) {
        String sql = " select sum(apply.REBATE_MONEY),sum(apply.GIFT_REBATE_MONEY),sum(apply.FULL_REBATE_MONEY),sum(apply.FULL_GIFT_REBATE_MONEY) from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        List list = this.baseDao.findBySql(sql);
        Double[] rtn = new Double[]{0.0, 0.0, 0.0, 0.0};
        if (list == null || list.size() == 0) {
            return rtn;
        }
        Object[] discount = (Object[])list.get(0);
        rtn[0] = discount[0] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[0]).doubleValue());
        rtn[1] = discount[1] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[1]).doubleValue());
        rtn[2] = discount[2] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[2]).doubleValue());
        rtn[3] = discount[3] == null ? Double.valueOf(0.0) : Double.valueOf(((BigDecimal)discount[3]).doubleValue());
        return rtn;
    }

    public Double getUsingPenalty(String applyerId, String supplierId, String excludeId) {
        List list;
        String sql = " select sum(apply.FINE_MONEY),1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] penalty = (Object[])list.get(0);
        if (penalty[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)penalty[0]).doubleValue();
    }

    public Double _getUsingFreeGiftMoney(String applyerId, String supplierId, String type, String excludeId) {
        List list;
        String statCol = "FREE_GIFT_MONEY";
        if (type != null && type.toLowerCase().equals("quantity")) {
            statCol = "FREE_GIFT";
        }
        String sql = " select sum(apply." + statCol + "),1 from " + "\tCX_INDENT_Apply apply " + "\twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] freeGiftMoney = (Object[])list.get(0);
        if (freeGiftMoney[0] == null) {
            return 0.0;
        }
        return ((BigDecimal)freeGiftMoney[0]).doubleValue();
    }

    public Double getUsingFreeGiftMoney(String applyerId, String supplierId, String type, String excludeId, Integer precision) {
        List list;
        String sql = " select  sum(       CASE WHEN (apply.FREE_GIFT_MONEY - apply.free_gift_order) < 0 then 0           else(apply.FREE_GIFT_MONEY - apply.free_gift_order) end       ) ,1 from \tCX_INDENT_Apply apply \twhere apply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and apply.indent_flag ='2'  ";
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " and ROW_ID!='" + excludeId + "' ";
        }
        if ((list = this.baseDao.findBySql(sql)) == null || list.size() == 0) {
            return 0.0;
        }
        Object[] freeGiftMoney = (Object[])list.get(0);
        if (freeGiftMoney[0] == null) {
            return 0.0;
        }
        return MathUtils.getPrecision((Double)((BigDecimal)freeGiftMoney[0]).doubleValue(), (Integer)precision);
    }

    public Map<String, Double> findProductApplyedQuantitys(String supplierId, String extendId) {
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.SUPPLIER_ID='" + supplierId + "' and " + "\tapply.NATURE='1' and ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + "\tapply.row_id!='" + extendId + "' and ";
        }
        sql = String.valueOf(sql) + "  (apply.INDENT_FLAG='2' or apply.INDENT_FLAG='3') group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findProductApplyedQuantitysForOrg(String supplierId, String extendId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select item.product_id, sum(item.ACT_QUANTITY)");
        sql.append(" from CX_INDENT_LINE             item,");
        sql.append(" CX_INDENT_Apply            apply");
        sql.append(" where item.INDENT_APPLY_ID = apply.ROW_ID");
        sql.append(" and apply.SUPPLIER_ID = '" + supplierId + "'");
        sql.append(" and apply.NATURE = '1'");
        sql.append(" and nvl(item.isscore, '0') != 'Y'");
        sql.append(" and (apply.INDENT_FLAG = '2' or apply.INDENT_FLAG = '3' or apply.INDENT_FLAG = '4' or apply.INDENT_FLAG = '4-1' ) ");
        if (StringUtils.isNotEmpty(extendId)) {
            sql.append(" and apply.row_id!='" + extendId + "' ");
        }
        sql.append(" group by item.product_id");
        List list = this.baseDao.findBySql(sql.toString());
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findRtnProductApplyedQuantitys(String applyerId, String extendId) {
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.DEALER_ID='" + applyerId + "' and " + "\tapply.NATURE='" + 2 + "' and ";
        if (StringUtils.isNotEmpty(extendId)) {
            sql = String.valueOf(sql) + " apply.row_id!='" + extendId + "' and ";
        }
        sql = String.valueOf(sql) + "  (apply.INDENT_FLAG='2' or apply.INDENT_FLAG='3' or apply.INDENT_FLAG='4') group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Map<String, Double> findProductApplyQuantitys(String applyerId, String supplierId, Date startDt, Date endDt, String excludeId) {
        if (startDt == null) {
            startDt = DateUtils.now();
        }
        String sql = " select item.product_id,sum(item.ACT_QUANTITY) from  \tCX_INDENT_LINE item,CX_INDENT_Apply apply\twhere\titem.INDENT_APPLY_ID=apply.ROW_ID and\tapply.NATURE='1' and \tapply.dealer_id='" + applyerId + "' and apply.SUPPLIER_ID='" + supplierId + "' and " + "\tapply.INDENT_DATE>=to_date('" + DateUtils.getDate((Date)startDt, (String)"yyyyMMdd") + "','yyyymmdd') and";
        if (endDt != null) {
            endDt = DateUtils.getDateAfter((Date)endDt, (int)1);
            sql = String.valueOf(sql) + "\tapply.indent_date<=to_date('" + DateUtils.getDate((Date)endDt, (String)"yyyyMMdd") + "','yyyymmdd') and";
        }
        if (StringUtils.isNotEmpty(excludeId)) {
            sql = String.valueOf(sql) + " apply.row_id!='" + excludeId + "' and ";
        }
        sql = String.valueOf(sql) + " ( apply.INDENT_FLAG!='0' and apply.INDENT_FLAG!='2-0' and apply.INDENT_FLAG!='9' ) and apply.indent_date is not null group by item.product_id";
        List list = this.baseDao.findBySql(sql);
        HashMap<String, Double> productQuantityMap = new HashMap<String, Double>();
        for (Object[] rowData : list) {
            String productId = (String)rowData[0];
            Double quantity = rowData[1] == null ? 0.0 : ((BigDecimal)rowData[1]).doubleValue();
            productQuantityMap.put(productId, quantity);
        }
        return productQuantityMap;
    }

    public Page findOrderApplys(OrderApplyCondition con, String orderby) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append("select distinct T1.* from (select o.* from CX_INDENT_APPLY o,CX_AWK_PARTNERLIST_VIEW p,SIEBEL.S_ORG_BU c  ");
        if (StringUtils.isNotEmpty(con.getProductNo()) || StringUtils.isNotEmpty(con.getBrand())) {
            HQL.append(",CX_INDENT_LINE i ");
            if (StringUtils.isNotEmpty(con.getBrand())) {
                HQL.append(",CX_AWK_PRODLIST_VIEW pr ");
            }
        }
        HQL.append(" where o.DEALER_ID=p.row_id and p.row_id = c.ORG_ID ");
        if (StringUtils.isNotEmpty(con.getProductNo()) || StringUtils.isNotEmpty(con.getBrand())) {
            HQL.append(" and o.row_id=i.INDENT_APPLY_ID ");
            if (StringUtils.isNotEmpty(con.getProductNo())) {
                HQL.append(" and i.PRODUCT_NO like ? ");
                args.add("%" + con.getProductNo().trim() + "%");
            }
            if (StringUtils.isNotEmpty(con.getBrand())) {
                HQL.append(" and pr.row_id = i.PRODUCT_ID ");
                HQL.append(" and pr.PROD_BRAND =  ? ");
                args.add(con.getBrand());
            }
        }
        if (StringUtils.isNotEmpty(con.getApplyerId())) {
            HQL.append(" and o.DEALER_ID = ? ");
            args.add(con.getApplyerId());
        }
        if (StringUtils.isNotEmpty(con.getNature())) {
            HQL.append(" and o.nature = ? ");
            args.add(con.getNature());
        }
        if (StringUtils.isNotEmpty(con.getSupplierId())) {
            HQL.append(" and o.supplier_Id = ? ");
            args.add(con.getSupplierId());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            HQL.append(" and o.INDENT_NUMBER like ? ");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getCreatorId())) {
            HQL.append(" and o.creator_Id = ? ");
            args.add(con.getCreatorId());
        }
        if (con.getCreateDtS() != null) {
            HQL.append(" and o.create_Dt >= ? ");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            HQL.append(" and o.create_Dt <= ? ");
            args.add(con.getCreateDtE());
        }
        if (con.getDtS() != null) {
            HQL.append(" and o.INDENT_DATE >= ? ");
            args.add(con.getDtS());
        }
        if (con.getDtE() != null) {
            HQL.append(" and o.INDENT_DATE <= ? ");
            args.add(DateUtils.getEndTime((Date)con.getDtE()));
        }
        if (con.isRegionFilter()) {
            String employeeId = con.getEmployeeId();
            String partnerIds = this.personnelService.getPartnerIds(employeeId);
            if (!"'1-2-3'".equals(partnerIds)) {
                HQL.append(" and p.row_id in ( ");
                HQL.append(partnerIds);
                HQL.append(" ) ");
            } else {
                String regions = this.personnelService.getFRegionsByUserId(employeeId);
                HQL.append(" and (c.X_REGION_ID in ( ");
                HQL.append(regions);
                HQL.append(") or c.X_DISTRICT_ID in ( ");
                HQL.append(regions);
                HQL.append(" ))");
                HQL.append(" and c.BU_ID  = ? ");
                args.add(con.getCurrentPartnerId());
            }
        }
        String areaCodes = null;
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            areaCodes = "'" + con.getAreaCode() + "'";
        } else if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            areaCodes = this.personnelService.getFRegionsById(con.getSupplierId(), con.getSaleChannelTypeCode(), con.getBigAreaCode());
        } else if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            areaCodes = this.personnelService.getFRegionsById(con.getSupplierId(), con.getSaleChannelTypeCode(), null);
        }
        if (StringUtils.isNotEmpty(areaCodes)) {
            HQL.append(" and o.REGION_ID in ( ");
            HQL.append(areaCodes);
            HQL.append(" ) ");
        }
        if (con.getQuantityS() != null) {
            HQL.append(" and o.COLLECT_NUMBER >= ?");
            args.add(con.getQuantityS());
        }
        if (con.getQuantityE() != null) {
            HQL.append(" and o.COLLECT_NUMBER <= ?");
            args.add(con.getQuantityE());
        }
        if (con.getMoneyS() != null) {
            HQL.append(" and o.AMOUNT_SUMMARY >= ?");
            args.add(con.getMoneyS());
        }
        if (con.getMoneyE() != null) {
            HQL.append(" and o.AMOUNT_SUMMARY <= ?");
            args.add(con.getMoneyE());
        }
        if (StringUtils.isNotEmpty(con.getContacts())) {
            HQL.append(" and o.ORDER_CONTACTS like ?");
            args.add("%" + con.getContacts().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getPurchaseNo())) {
            HQL.append(" and o.PURCHASE_NO like ?");
            args.add("%" + con.getPurchaseNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getApplyerName())) {
            HQL.append(" and p.name like ?");
            args.add("%" + con.getApplyerName().trim() + "%");
        }
        if (con.getOrderStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : con.getOrderStates()) {
                HQL.append(" o.INDENT_FLAG = ?");
                if (++i < con.getOrderStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(") ");
        }
        HQL.append(" and o.INDENT_FLAG!=?) T1 ");
        args.add(TCBJEnum.AuditState.del.getValue());
        HQL.append(" left join (select * from CX_INDENT_APPLY_LOCUS oa where oa.handle_Type = '5-1') t on T1.row_id = t.order_Id ");
        if (Beans.isNotEmpty((Object)con.getBillDtS())) {
            HQL.append(" where t.handle_Dt >= ? ");
            args.add(DateUtils.getStartTime((Date)con.getBillDtS()));
        }
        if (Beans.isNotEmpty((Object)con.getBillDtE())) {
            HQL.append(" and t.handle_Dt <= ? ");
            args.add(DateUtils.getEndTime((Date)con.getBillDtE()));
        }
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(orderby);
        }
        int pageSize = Constant.DEFAULT_ROWS;
        if (Beans.isNotEmpty((Object)con.getPageSize())) {
            pageSize = con.getPageSize();
        }
        Page page = this.newBaseDao.findPageBySql(HQL.toString(), args, con.getPageno(), pageSize, OrderApply.class);
        String sql = " select t.* " + HQL.substring(HQL.indexOf("*") + 1);
        Page tpage = this.newBaseDao.findPageBySql(sql, args, con.getPageno(), pageSize, OrderApplyLocus.class);
        List list = page.getList();
        List tlist = tpage.getList();
        HashMap<String, OrderApplyLocus> map = new HashMap<String, OrderApplyLocus>();
        for (OrderApplyLocus o : tlist) {
            if (!Beans.isNotEmpty((Object)o)) continue;
            map.put(o.getOrderId(), o);
        }
        for (OrderApply order : list) {
            if (!Beans.isNotEmpty(map.get(order.getId()))) continue;
            order.setBillDate(((OrderApplyLocus)map.get(order.getId())).getHandleDt());
        }
        page.setList(list);
        return page;
    }

    private OrderApplyLocus getBillingDate(String id, String value) {
        OrderApplyLocus order = (OrderApplyLocus)this.baseDao.findFirstEntity("from OrderApplyLocus where orderId = ? and handleType = ? order by handleDt DESC", new Object[]{id, value}, OrderApplyLocus.class);
        return order;
    }

    public List<OrderApplyItem> getOrderApplyItems(String orderApplyId) {
        String hql = "from OrderApplyItem where orderApplyId=?";
        Object[] args = new Object[]{orderApplyId};
        return this.baseDao.findEntity(hql, args, OrderApplyItem.class);
    }

    public OrderApply getOrderApply(String orderApplyId) {
        OrderApply orderApply = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderApplyId));
        orderApply.setOrderApplyItems(this.getOrderApplyItems(orderApplyId));
        orderApply.setActivitys(this.activityInfoService.getActivityByOrderApplyId(orderApplyId));
        orderApply.setActivityProducts(this.activityInfoService.getActivityProductByOIdAndAIds(orderApplyId, null));
        return orderApply;
    }

    public OrderApply getOrderApplyByNo(String orderApplyNo) {
        OrderApply orderApply = (OrderApply)this.baseDao.findFirstEntity(" from OrderApply where no = ? ", new Object[]{orderApplyNo}, OrderApply.class);
        if (Beans.isEmpty((Object)orderApply)) {
            return null;
        }
        orderApply.setOrderApplyItems(this.getOrderApplyItems(orderApply.getId()));
        orderApply.setActivitys(this.activityInfoService.getActivityByOrderApplyId(orderApply.getId()));
        orderApply.setActivityProducts(this.activityInfoService.getActivityProductByOIdAndAIds(orderApply.getId(), null));
        return orderApply;
    }

    public OrderApply getSimpleOrderApply(String orderApplyId) {
        OrderApply orderApply = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderApplyId));
        return orderApply;
    }

    public void updateOrderApplyState(String id, String state, Employee me) {
        String hql = "update OrderApply set state=? where id=?";
        Object[] args = new Object[]{state, id};
        this.baseDao.executeHQL(hql, args);
    }

    public void addOrderInOut(String id, Employee me) {
        OrderApply apply = this.getOrderApply(id);
        this.createOrderInOut(apply, me);
    }

    public void delOrderApply(String orderApplyId) {
        Object[] args = new Object[]{orderApplyId};
        String hql = "delete OrderApplyItem where orderApplyId=?";
        this.baseDao.executeHQL(hql, args);
        hql = "delete OrderApply where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public void cancelOrderApply(String orderApplyId, String[] exchangeOrderIds) {
        Object[] args = new Object[]{TCBJEnum.AuditState.del.getValue(), orderApplyId};
        String hql = "update OrderApply set state=?,exchangeOrderIds=null where id=?";
        this.baseDao.executeHQL(hql, args);
    }

    public boolean hasPushOrder(String supplierId, String applyerId) {
        return this.baseDao.exist(" from OrderApply o where o.applyerId = ? and o.supplierId = ? and  o.source = ? and o.state = '0'", new Object[]{applyerId, supplierId, "\u81ea\u52a8\u8865\u8d27"});
    }

    public boolean hasBind(String partnerId, String[] ids, String extendId) {
        String hql = " select new OrderApply(id,exchangeOrderIds) from OrderApply where (state=? or state=?) and applyerId=? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(TCBJEnum.AuditState.draft.getValue());
        args.add(TCBJEnum.AuditState.approve.getValue());
        args.add(partnerId);
        if (StringUtils.isNotEmpty(extendId)) {
            hql = String.valueOf(hql) + " and id!=? ";
            args.add(extendId);
        }
        List applys = this.baseDao.findEntity(hql, args.toArray(), OrderApply.class);
        for (OrderApply apply : applys) {
            String[] exchangeOrderIds = apply.getExchangeOrderIdArray();
            if (exchangeOrderIds == null) continue;
            String[] stringArray = exchangeOrderIds;
            int n = exchangeOrderIds.length;
            int n2 = 0;
            while (n2 < n) {
                String exchangeOrderId = stringArray[n2];
                String[] stringArray2 = ids;
                int n3 = ids.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id = stringArray2[n4];
                    if (id.equals(exchangeOrderId)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    public List<ExchangeOrder> filterHasBind(String partnerId, List<ExchangeOrder> orders, String extendId) {
        String hql = " select new OrderApply(id,exchangeOrderIds) from OrderApply where (state=? or state=? or state = ? ) and applyerId=? ";
        ArrayList<String> args = new ArrayList<String>();
        args.add(TCBJEnum.AuditState.draft.getValue());
        args.add(TCBJEnum.AuditState.approve.getValue());
        args.add(TCBJEnum.AuditState.approvePass.getValue());
        args.add(partnerId);
        if (StringUtils.isNotEmpty(extendId)) {
            hql = String.valueOf(hql) + " and id!=? ";
            args.add(extendId);
        }
        List applys = this.baseDao.findEntity(hql, args.toArray(), OrderApply.class);
        ArrayList<ExchangeOrder> newOrders = new ArrayList<ExchangeOrder>();
        for (ExchangeOrder order : orders) {
            boolean hasSubmit = false;
            for (OrderApply apply : applys) {
                String[] exchangeOrderIds = apply.getExchangeOrderIdArray();
                if (exchangeOrderIds == null) continue;
                String[] stringArray = exchangeOrderIds;
                int n = exchangeOrderIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id.equals(order.getId())) {
                        hasSubmit = true;
                    }
                    ++n2;
                }
            }
            if (hasSubmit) continue;
            newOrders.add(order);
        }
        return newOrders;
    }

    private void submitExchangeOrders(OrderApply orderApply) {
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.scoreService.submitExchangeOrder(id);
            ++n2;
        }
    }

    private void unApproveExchangeOrders(String orderId) {
        OrderApply orderApply = this.getSimpleOrderApply(orderId);
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.scoreService.unApproveExchangeOrder(id);
            ++n2;
        }
    }

    private void approveExchangeOrders(OrderApply orderApply) {
        String[] ids = orderApply.getExchangeOrderIdArray();
        if (ids == null) {
            return;
        }
        List<ExchangeDetail> exchangeDetails = this.scoreService.getExchangeDetailsByIds(ids);
        List<ProductGiftView> products = this.scoreService.getProducts(orderApply.getSupplierId());
        HashMap<String, ProductGiftView> productMap = new HashMap<String, ProductGiftView>();
        for (ProductGiftView product : products) {
            productMap.put(product.getId(), product);
        }
        ArrayList<OrderApplyItem> items = new ArrayList<OrderApplyItem>();
        for (ExchangeDetail detail : exchangeDetails) {
            ProductGiftView product = (ProductGiftView)productMap.get(detail.getProductId());
            if (product == null) continue;
            OrderApplyItem item = new OrderApplyItem();
            item.setActPrice(product.getPrice());
            item.setActQuantity(detail.getQuantity());
            item.setBasePrice(product.getPrice());
            item.setCreateDt(orderApply.getCreateDt());
            item.setCreatorId(orderApply.getCreatorId());
            item.setLastUpdateDt(orderApply.getLastUpdateDt());
            item.setLastUpdatorId(orderApply.getLastUpdatorId());
            item.setIsFree("Y");
            item.setIsScore("Y");
            item.setBasePoints(detail.getPoints() == null ? 0.0 : detail.getPoints());
            item.setMinUnit(1.0);
            item.setMoney(MathUtils.mul((Double)(product.getPrice() == null ? 0.0 : product.getPrice()), (Double)detail.getQuantity()));
            item.setNo(product.getNo());
            item.setOrderApplyId(orderApply.getId());
            item.setPrice(product.getPrice());
            item.setPriceFormula(null);
            item.setProductId(detail.getProductId());
            item.setQuantity(detail.getQuantity());
            item.setSpec(product.getSpec());
            item.setRemark(null);
            item.setUnitCode(product.getUnitCode());
            items.add(item);
        }
        this.baseDao.save(items);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty(id)) {
                this.scoreService.approveExchangeOrder(id);
            }
            ++n2;
        }
    }

    public void approveOrderApply(OrderApply orderApply, boolean triggerEAS, Integer precision) {
        OrderApply old = this.getSimpleOrderApply(orderApply.getId());
        old.setContacts(orderApply.getContacts());
        old.setPhone(orderApply.getPhone());
        old.setShippingAddress(orderApply.getShippingAddress());
        old.setExpectDate(orderApply.getExpectDate());
        old.setOrderContacts(orderApply.getOrderContacts());
        old.setOrderPhone(orderApply.getOrderPhone());
        old.setPurchaseNo(orderApply.getPurchaseNo());
        old.setPredictArriveDt(orderApply.getPredictArriveDt());
        old.setDeliveryLevelCode(orderApply.getDeliveryLevelCode());
        old.setOrderTypeCode(orderApply.getOrderTypeCode());
        old.setIsReport(orderApply.getIsReport());
        old.setTaxCode(orderApply.getTaxCode());
        old.setAreaCode(orderApply.getAreaCode());
        old.setSettlementModeCode(orderApply.getSettlementModeCode());
        old.setDeliveryCode(orderApply.getDeliveryCode());
        old.setIsCreditManaged(orderApply.getIsCreditManaged());
        old.setOverCreditRemark(orderApply.getOverCreditRemark());
        old.setQuantity(orderApply.getQuantity());
        old.setTotalMoney(orderApply.getTotalMoney());
        old.setRemainMoney(orderApply.getRemainMoney());
        old.setRetunsFullyMoney(orderApply.getRetunsFullyMoney());
        old.setRetunsOvertopMoney(orderApply.getRetunsOvertopMoney());
        old.setReturnedMoney(orderApply.getReturnedMoney());
        old.setDiscountTotalMoney(orderApply.getDiscountTotalMoney());
        old.setDiscountCanuseMoney(orderApply.getDiscountCanuseMoney());
        old.setDiscountMoney(orderApply.getDiscountMoney());
        old.setGiftDiscountTotalMoney(orderApply.getGiftDiscountTotalMoney());
        old.setGiftDiscountCanuseMoney(orderApply.getGiftDiscountCanuseMoney());
        old.setGiftDiscountMoney(orderApply.getGiftDiscountMoney());
        old.setFullDiscountTotalMoney(orderApply.getFullDiscountTotalMoney());
        old.setFullDiscountCanuseMoney(orderApply.getFullDiscountCanuseMoney());
        old.setFullDiscountMoney(orderApply.getFullDiscountMoney());
        old.setFullGiftDiscountCanuseMoney(orderApply.getFullGiftDiscountCanuseMoney());
        old.setFullGiftDiscountMoney(orderApply.getFullGiftDiscountMoney());
        old.setOtherDiscountTotalMoney(orderApply.getOtherDiscountTotalMoney());
        old.setOtherDiscountCanuseMoney(orderApply.getOtherDiscountCanuseMoney());
        old.setOtherDiscountMoney(orderApply.getOtherDiscountMoney());
        old.setFreeGift(orderApply.getFreeGift());
        old.setFreeGiftMoney(orderApply.getFreeGiftMoney());
        old.setFreeGiftOrder(orderApply.getFreeGiftOrder());
        old.setFreeGiftTotal(orderApply.getFreeGiftTotal());
        old.setFineTotalMoney(orderApply.getFineTotalMoney());
        old.setFineMoney(orderApply.getFineMoney());
        old.setFineOverMoney(orderApply.getFineOverMoney());
        old.setFreeMoney(orderApply.getFreeMoney());
        old.setApproverId(orderApply.getApproverId());
        old.setApproveDt(orderApply.getApproveDt());
        old.setActGiftQuantity(orderApply.getActGiftQuantity());
        orderApply.setDt(old.getDt());
        old.setAcctId(orderApply.getAcctId());
        this.updateOrderApplyItems(orderApply);
        this.activityInfoService.saveOrderActivityAndProduct(orderApply.getId(), orderApply.getActivitys(), orderApply.getActivityProducts());
        if (orderApply.getDiscountMoney() != null && orderApply.getDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getProductTotalMoney(), orderApply.getDiscountMoney(), old.getDt(), "PRODUCT");
        }
        if (orderApply.getGiftDiscountMoney() != null && orderApply.getGiftDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getGiftTotalMoney(), orderApply.getGiftDiscountMoney(), old.getDt(), "GIFT");
        }
        if (orderApply.getFullDiscountMoney() != null && orderApply.getFullDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getProductTotalMoney(), orderApply.getFullDiscountMoney(), old.getDt(), "FULL");
        }
        if (orderApply.getFullGiftDiscountMoney() != null && orderApply.getFullGiftDiscountMoney() > 0.0) {
            this.intRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getProductTotalMoney(), orderApply.getFullGiftDiscountMoney(), old.getDt(), "FULL");
        }
        if (orderApply.getOtherDiscountMoney() != null && orderApply.getOtherDiscountMoney() > 0.0) {
            this.giftIntRebatemgService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getGiftTotalMoney(), orderApply.getOtherDiscountMoney(), old.getDt());
        }
        if (orderApply.getFineMoney() != null && orderApply.getFineMoney() > 0.0) {
            this.aplfineService.use(orderApply.getId(), orderApply.getNo(), orderApply.getApplyerId(), orderApply.getSupplierId(), orderApply.getApproverId(), orderApply.getTotalMoney(), orderApply.getFineMoney(), old.getDt());
        }
        this.fGiftService.use(orderApply, orderApply.getFreeGift(), orderApply.getFreeGiftMoney(), precision);
        this.giftService.use(orderApply, orderApply.getActGiftQuantity());
        Partner supplier = this.partnerService.getPartner(orderApply.getSupplierId());
        if (supplier.isOrg() && StringUtils.isNotEmpty(old.getExchangeOrderIds())) {
            this.approveExchangeOrders(old);
        }
        OrderApply apply = this.getOrderApply(orderApply.getId());
        if (orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
            this.pushSaleOrder(apply, apply.getRemark());
        } else {
            this.pushReturnStock(apply);
        }
    }

    private void updateActivityProducts(OrderApply orderApply) {
        List<OrderActivityProduct> activityProducts = orderApply.getActivityProducts();
        List oap = this.baseDao.findEntity("from OrderActivityProduct where orderApplyId = ? ", new Object[]{orderApply.getId()}, OrderActivityProduct.class);
        if (Beans.isNotEmpty((Object)oap)) {
            for (OrderActivityProduct oa : activityProducts) {
                for (OrderActivityProduct o : oap) {
                    if (!o.getProductId().equals(oa.getProductId()) || !o.getActivityId().equals(oa.getActivityId())) continue;
                    o.setIsFree(oa.getIsFree());
                    o.setQuantity(oa.getQuantity());
                }
            }
        }
    }

    public void triggerEAS(String orderId) {
        Object[] objs = null;
        try {
            objs = this.baseDao.callExecute("cx_sale_order_iface_pub.CREATE_SO_TO_IFACE", new Object[]{orderId, "F"}, new Integer[]{12, 12});
        }
        catch (Exception e) {
            throw new AppException("3018", e.getMessage());
        }
        String code = (String)objs[0];
        String message = (String)objs[1];
        if ("E".equals(code)) {
            throw new AppException("3018", message);
        }
    }

    private void saveOrderApply(OrderApply orderApply) {
        this.baseDao.save((Object)orderApply);
        for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
            orderApplyItem.setOrderApplyId(orderApply.getId());
            orderApplyItem.setActPrice(orderApplyItem.getPrice());
            orderApplyItem.setActQuantity(orderApplyItem.getQuantity());
        }
        this.baseDao.save(orderApply.getOrderApplyItems());
    }

    public void updateOrderApply(OrderApply orderApply) {
        OrderApply old = this.getSimpleOrderApply(orderApply.getId());
        old.setContacts(orderApply.getContacts());
        old.setPhone(orderApply.getPhone());
        old.setShippingAddress(orderApply.getShippingAddress());
        old.setExpectDate(orderApply.getExpectDate());
        old.setOrderContacts(orderApply.getOrderContacts());
        old.setOrderPhone(orderApply.getOrderPhone());
        old.setPurchaseNo(orderApply.getPurchaseNo());
        old.setRemark(orderApply.getRemark());
        old.setQuantity(orderApply.getQuantity());
        old.setTotalMoney(orderApply.getTotalMoney());
        old.setSalesman(orderApply.getSalesman());
        old.setHarvestWarehouse(orderApply.getHarvestWarehouse());
        old.setDisApplyerId(orderApply.getDisApplyerId());
        old.setRelatedApplyerId(orderApply.getRelatedApplyerId());
        old.setDiscountTotalMoney(orderApply.getDiscountTotalMoney());
        old.setDiscountCanuseMoney(orderApply.getDiscountCanuseMoney());
        old.setDiscountMoney(orderApply.getDiscountMoney());
        old.setGiftDiscountTotalMoney(orderApply.getGiftDiscountTotalMoney());
        old.setGiftDiscountCanuseMoney(orderApply.getGiftDiscountCanuseMoney());
        old.setGiftDiscountMoney(orderApply.getGiftDiscountMoney());
        old.setFullDiscountTotalMoney(orderApply.getFullDiscountTotalMoney());
        old.setFullDiscountCanuseMoney(orderApply.getFullDiscountCanuseMoney());
        old.setFullDiscountMoney(orderApply.getFullDiscountMoney());
        old.setFullGiftDiscountCanuseMoney(orderApply.getFullGiftDiscountCanuseMoney());
        old.setFullGiftDiscountMoney(orderApply.getFullGiftDiscountMoney());
        old.setOtherDiscountTotalMoney(orderApply.getOtherDiscountTotalMoney());
        old.setOtherDiscountCanuseMoney(orderApply.getOtherDiscountCanuseMoney());
        old.setOtherDiscountMoney(orderApply.getOtherDiscountMoney());
        old.setFreeGift(orderApply.getFreeGift());
        old.setFreeGiftMoney(orderApply.getFreeGiftMoney());
        old.setFreeGiftOrder(orderApply.getFreeGiftOrder());
        old.setFreeGiftTotal(orderApply.getFreeGiftTotal());
        old.setRemainMoney(orderApply.getRemainMoney());
        old.setRetunsFullyMoney(orderApply.getRetunsFullyMoney());
        old.setRetunsOvertopMoney(orderApply.getRetunsOvertopMoney());
        old.setReturnedMoney(orderApply.getReturnedMoney());
        old.setFineTotalMoney(orderApply.getFineTotalMoney());
        old.setFineMoney(orderApply.getFineMoney());
        old.setFineOverMoney(orderApply.getFineOverMoney());
        old.setFreeMoney(orderApply.getFreeMoney());
        old.setLastUpdateDt(orderApply.getLastUpdateDt());
        old.setLastUpdatorId(orderApply.getLastUpdatorId());
        old.setProvince(orderApply.getProvince());
        old.setCity(orderApply.getCity());
        old.setCounty(orderApply.getCounty());
        old.setGiftQuantity(orderApply.getGiftQuantity());
        old.setActGiftQuantity(orderApply.getActGiftQuantity());
        old.setState(orderApply.getState());
        if (old.getDt() == null) {
            old.setDt(orderApply.getDt());
        }
        if (old.getNo() == null) {
            old.setNo(orderApply.getNo());
        }
    }

    private void updateOrderApplyItems(OrderApply orderApply) {
        List<OrderApplyItem> items = this.getOrderApplyItems(orderApply.getId());
        this.baseDao.deleteAll(items);
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.setId(UUIDUtils.getId());
            item.setOrderApplyId(orderApply.getId());
        }
        this.baseDao.save(orderApply.getOrderApplyItems());
    }

    public void saveOrUpdateOrderApply(OrderApply orderApply, boolean triggerEAS) {
        if (StringUtils.isEmpty(orderApply.getId())) {
            this.saveOrderApply(orderApply);
        } else {
            this.updateOrderApply(orderApply);
            this.updateOrderApplyItems(orderApply);
        }
        if (orderApply.getState().equals(TCBJEnum.AuditState.approve.getValue())) {
            this.submitExchangeOrders(orderApply);
        }
        this.activityInfoService.saveOrderActivityAndProduct(orderApply.getId(), orderApply.getActivitys(), orderApply.getActivityProducts());
    }

    public List<Product> findProducts(ProductCondition con) {
        StringBuffer HQL = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        HQL.append("from Product where 1=1 ");
        if (StringUtils.isNotEmpty(con.getName())) {
            HQL.append(" and name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        HQL.append(" order by createDt ");
        return this.baseDao.findEntity(HQL.toString(), args.toArray(), Product.class);
    }

    public void createOrderInOut(OrderApply apply, Employee me) {
        OrderInOut io = new OrderInOut();
        io.setId(UUIDUtils.getId());
        io.setOrderId(apply.getId());
        io.setNo("CKD00001");
        io.fillInitData(me);
        io.setState(TCBJEnum.SendOrReceiveState.sending.getValue());
        this.baseDao.save((Object)io);
        for (OrderApplyItem item : apply.getOrderApplyItems()) {
            OrderInOutItem oi = new OrderInOutItem();
            oi.setProductId(item.getProductId());
            oi.setOrderInOutId(io.getId());
            oi.setOrderItemId(item.getId());
            oi.setQuantity(item.getQuantity());
            oi.setRemark(apply.getRemark());
            oi.fillInitData(me);
            this.baseDao.save((Object)oi);
        }
    }

    @Transactional
    public void updateUnApprove(String orderId) {
        String unApprove = StringUtils.getConfigure("unApprove");
        "1".equals(unApprove);
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        if ("N".equals(rtn)) {
            throw new AppException("3019");
        }
        objs = this.baseDao.callExecute("cx_sale_order_iface_pub.reapprove_process_btn", new Object[]{orderId, "T"}, new Integer[]{12, 12});
        rtn = (String)objs[0];
        String msg = (String)objs[1];
        if ("E".equals(rtn)) {
            throw new AppException("3020", msg);
        }
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
        this.intRebatemgService.unuse(orderId);
        this.giftIntRebatemgService.unuse(orderId);
        this.aplfineService.unuse(orderId);
        this.giftService.unuse(orderId);
        this.fGiftService.unuse(orderId);
    }

    public boolean canApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        return "Y".equals(rtn);
    }

    public Page findOrderLogitics(OrderApplyCondition con) {
        String orderBy = "order by T1.LASTUPDATE_DT desc";
        Page page = this.findOrderApplys(con, orderBy);
        List orders = page.getList();
        if (Beans.isEmpty((Object)orders)) {
            return page;
        }
        ArrayList<String> orderIds = new ArrayList<String>();
        for (OrderApply order : orders) {
            orderIds.add(order.getNo());
        }
        List<Map<String, Object>> logitics = this.getLogitics(orderIds);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (OrderApply order : orders) {
            Map<String, Object> map = order.toLogiticsMap();
            for (Map<String, Object> m : logitics) {
                if (!m.get("EXTEND_C5").equals(map.get("no"))) continue;
                map.putAll(m);
            }
            result.add(map);
        }
        page.setList(result);
        return page;
    }

    private List<Map<String, Object>> getLogitics(List<String> orderIds) {
        if (Beans.isEmpty(orderIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        StringBuilder logiticsSql = new StringBuilder("select * from TCBJWMS.V_ORDER_STATUS a where a.EXTEND_C5 in (");
        int i = 0;
        while (i < orderIds.size()) {
            if (i == orderIds.size() - 1) {
                logiticsSql.append("?)");
            } else {
                logiticsSql.append("?,");
            }
            ++i;
        }
        List<Map<String, Object>> logiticsList = this.wmsDao.findBySql(logiticsSql.toString(), orderIds.toArray());
        return logiticsList;
    }

    public Map<String, Object> findLogiticsByOrderId(String id) {
        List<Map<String, Object>> logitics;
        OrderApply order = this.getOrderApply(id);
        Map<String, Object> map = order.toLogiticsMap();
        String[] ids = new String[]{order.getNo()};
        if (Beans.isNotEmpty((Object)ids) && !Beans.isEmpty(logitics = this.getLogitics(Arrays.asList(ids)))) {
            map.putAll(logitics.get(0));
        }
        map.put("currentState", this.getLogiticState(map));
        return map;
    }

    private String getLogiticState(Map<String, Object> map) {
        if (Beans.isNotEmpty((Object)map.get("SIGN_TIME"))) {
            return Constant.LogiticState.received.value;
        }
        if (Beans.isNotEmpty((Object)map.get("SHIP_TIME"))) {
            return Constant.LogiticState.send.value;
        }
        if (Beans.isNotEmpty((Object)map.get("DELIVER_START_TIME"))) {
            return Constant.LogiticState.picked.value;
        }
        if (Beans.isNotEmpty((Object)map.get("CREATE_TIME"))) {
            return Constant.LogiticState.finaced.value;
        }
        if (Beans.isNotEmpty((Object)map.get("approveDt"))) {
            return Constant.LogiticState.approve.value;
        }
        return Constant.LogiticState.submit.value;
    }

    public Map<String, Double> findProductApplyQuantitys(String applyerId, String supplierId, Map<String, String> map_dates, Date endDt, String excludeId) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (Map.Entry<String, String> entry : map_dates.entrySet()) {
            String dateStr = entry.getKey();
            String prodIds = entry.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append("select item.product_id, sum(item.ACT_QUANTITY)  ").append("     from CX_INDENT_LINE item, CX_INDENT_Apply apply").append("     where item.INDENT_APPLY_ID = apply.ROW_ID ").append("        and apply.NATURE = '1'").append("       and apply.dealer_id = '").append(applyerId).append("'").append("      and apply.SUPPLIER_ID = '").append(supplierId).append("'").append("       and apply.INDENT_DATE >=  to_date('").append(dateStr).append("', 'yyyymmdd') ");
            if (endDt != null) {
                endDt = DateUtils.getDateAfter((Date)endDt, (int)1);
                sb.append("\tand apply.indent_date<=to_date('" + DateUtils.getDate((Date)endDt, (String)"yyyyMMdd") + "','yyyymmdd')");
            }
            if (StringUtils.isNotEmpty(excludeId)) {
                sb.append("       and apply.row_id !='").append(excludeId).append("'");
            }
            sb.append("      and (apply.INDENT_FLAG!='0' and apply.INDENT_FLAG != '2-0' and apply.INDENT_FLAG != '9')").append(" and apply.indent_date is not null ").append(" and item.product_id in( ").append(prodIds).append(")").append(" group by item.product_id ");
            List list = this.baseDao.findBySql(sb.toString());
            for (Object[] objs : list) {
                String productId = (String)objs[0];
                Double quantity = objs[1] == null ? 0.0 : ((BigDecimal)objs[1]).doubleValue();
                map.put(productId, quantity);
            }
        }
        return map;
    }

    public void approveRtnOrderApply(OrderApply orderApply) {
        OrderApply old = this.getSimpleOrderApply(orderApply.getId());
        old.setContacts(orderApply.getContacts());
        old.setPhone(orderApply.getPhone());
        old.setShippingAddress(orderApply.getShippingAddress());
        old.setOrderContacts(orderApply.getOrderContacts());
        old.setOrderPhone(orderApply.getOrderPhone());
        old.setPurchaseNo(orderApply.getPurchaseNo());
        old.setPredictArriveDt(orderApply.getPredictArriveDt());
        old.setDeliveryLevelCode(orderApply.getDeliveryLevelCode());
        old.setOrderTypeCode(orderApply.getOrderTypeCode());
        old.setIsReport(orderApply.getIsReport());
        old.setTaxCode(orderApply.getTaxCode());
        old.setAreaCode(orderApply.getAreaCode());
        old.setSettlementModeCode(orderApply.getSettlementModeCode());
        old.setDeliveryCode(orderApply.getDeliveryCode());
        old.setIsCreditManaged(orderApply.getIsCreditManaged());
        old.setOverCreditRemark(orderApply.getOverCreditRemark());
        old.setState(orderApply.getState());
        old.setQuantity(orderApply.getQuantity());
        old.setTotalMoney(orderApply.getTotalMoney());
        old.setRemainMoney(orderApply.getRemainMoney());
        old.setRetunsFullyMoney(orderApply.getRetunsFullyMoney());
        old.setRetunsOvertopMoney(orderApply.getRetunsOvertopMoney());
        old.setReturnedMoney(orderApply.getReturnedMoney());
        old.setDiscountTotalMoney(orderApply.getDiscountTotalMoney());
        old.setDiscountCanuseMoney(orderApply.getDiscountCanuseMoney());
        old.setDiscountMoney(orderApply.getDiscountMoney());
        old.setGiftDiscountTotalMoney(orderApply.getGiftDiscountTotalMoney());
        old.setGiftDiscountCanuseMoney(orderApply.getGiftDiscountCanuseMoney());
        old.setGiftDiscountMoney(orderApply.getGiftDiscountMoney());
        old.setOtherDiscountTotalMoney(orderApply.getOtherDiscountTotalMoney());
        old.setOtherDiscountCanuseMoney(orderApply.getOtherDiscountCanuseMoney());
        old.setOtherDiscountMoney(orderApply.getOtherDiscountMoney());
        old.setFreeGift(orderApply.getFreeGift());
        old.setFreeGiftMoney(orderApply.getFreeGiftMoney());
        old.setFreeGiftOrder(orderApply.getFreeGiftOrder());
        old.setFreeGiftTotal(orderApply.getFreeGiftTotal());
        old.setFineTotalMoney(orderApply.getFineTotalMoney());
        old.setFineMoney(orderApply.getFineMoney());
        old.setFineOverMoney(orderApply.getFineOverMoney());
        old.setFreeMoney(orderApply.getFreeMoney());
        old.setApproverId(orderApply.getApproverId());
        old.setApproveDt(orderApply.getApproveDt());
        old.setActGiftQuantity(orderApply.getActGiftQuantity());
        old.setOaIfaceCode(orderApply.getOaIfaceCode());
        orderApply.setDt(old.getDt());
        old.setAcctId(orderApply.getAcctId());
        this.updateOrderApplyItems(orderApply);
        OrderApply apply = this.getOrderApply(orderApply.getId());
        if (orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue())) {
            this.pushSaleOrder(apply, apply.getRemark());
        } else {
            this.pushReturnStock(apply);
        }
    }

    public void updateBalanceApprove(String orderId, Employee me) {
        OrderApply order = this.getOrderApply(orderId);
        if (order == null) {
            throw new AppException("3061");
        }
        this.inventoryAdjustment(order.getOrderApplyItems(), me, "output");
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.balancePass.getValue(), orderId});
    }

    public void updateBalanceApproveNoPass(String orderId) {
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
        this.intRebatemgService.unuse(orderId);
        this.giftIntRebatemgService.unuse(orderId);
        this.aplfineService.unuse(orderId);
        this.giftService.unuse(orderId);
        this.fGiftService.unuse(orderId);
    }

    public void updateBillingApprove(String orderId, String ERPNumber) {
        this.baseDao.executeHQL(" update OrderApply set state = ?,ERPNumber = ?,billDate = ?  where id = ?", new Object[]{TCBJEnum.AuditState.billing.getValue(), ERPNumber, DateUtils.now(), orderId});
    }

    public void updateSended(String orderId) {
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.sended.getValue(), orderId});
    }

    public void unRtnApprove(String orderId) {
        Object[] objs = this.baseDao.callExecute("cx_sale_order_iface_pub.check_iface_reapprove", new Object[]{orderId}, new Integer[]{12});
        String rtn = (String)objs[0];
        if ("N".equals(rtn)) {
            throw new AppException("3019");
        }
        objs = this.baseDao.callExecute("cx_sale_order_iface_pub.reapprove_process_btn", new Object[]{orderId, "T"}, new Integer[]{12, 12});
        rtn = (String)objs[0];
        String msg = (String)objs[1];
        if ("E".equals(rtn)) {
            throw new AppException("3020", msg);
        }
        this.baseDao.executeHQL(" update OrderApply set state = ? where id = ?", new Object[]{TCBJEnum.AuditState.approve.getValue(), orderId});
    }

    public void loadingOrderApplyItem(OrderApplyCondition con, List<OrderApply> orderApplys) {
        if (Beans.isEmpty(orderApplys)) {
            return;
        }
        StringBuffer orderApplyIds = new StringBuffer();
        HashMap<String, OrderApply> orderApplyMap = new HashMap<String, OrderApply>();
        int i = 0;
        while (i < orderApplys.size()) {
            OrderApply orderApply = orderApplys.get(i);
            orderApplyIds.append("'" + orderApply.getId() + "'");
            if (i != orderApplys.size() - 1) {
                orderApplyIds.append(",");
            }
            orderApplyMap.put(orderApply.getId(), orderApply);
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        sb.append(" from OrderApplyItem where orderApplyId in (" + orderApplyIds + ")");
        if (Beans.isNotEmpty((Object)con.getProductId())) {
            sb.append(" and productId = ? ");
            args.add(con.getProductId());
        }
        List orderApplyItems = this.baseDao.findEntity(sb.toString(), args.toArray(), OrderApplyItem.class);
        for (OrderApplyItem orderApplyItem : orderApplyItems) {
            OrderApply orderApply = (OrderApply)orderApplyMap.get(orderApplyItem.getOrderApplyId());
            orderApply.getOrderApplyItems().add(orderApplyItem);
        }
    }

    public void saveDeliveryInformation(OrderDeliveryInformation orderDeliveryInformation) {
        this.baseDao.save((Object)orderDeliveryInformation);
    }

    public OrderDeliveryInformation queryOrderDeliveryInformation(String orderId) {
        return (OrderDeliveryInformation)this.baseDao.findFirstEntity("from OrderDeliveryInformation where orderId = ?", new Object[]{orderId}, OrderDeliveryInformation.class);
    }

    public Map<String, Double> findProductApplyQuantitys2(String applyerId, String supplierId, Date endDt, String excludeId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select c1.ksrq,c1.prodId,c1.partner_id from (");
        sb.append(" select distinct to_char(t1.START_DATE,'yyyymmdd') ksrq,t2.PRODUCT_NUMBER prodId, t2.dealer_name  partner_id ");
        sb.append(" from  CX_QY_ALLOT t1,CX_QY_ALLOT_ROW t2  ");
        sb.append(" where t2.QUANTIFY_ALLOT_ID=t1.row_id and (t1.allot_type='applyer' or t1.allot_type is null) ");
        sb.append(" and (t1.END_DATE is null  or to_char(t1.END_DATE,'yyyy-MM-dd')>'").append(DateUtils.formartDate((Date)DateUtils.now(), (String)"yyyy-MM-dd")).append(" ') ");
        sb.append(" and  t2.DEALER_NAME='").append(applyerId).append("'");
        sb.append(" union ");
        PartnerArea partnerArea = Cache.getPartnerAreaById(applyerId);
        sb.append("  select distinct to_char(t1.START_DATE, 'yyyymmdd') ksrq,t2.PRODUCT_NUMBER prodId,  t3.partner_id  partner_id ");
        sb.append(" from CX_QY_ALLOT t1, CX_QY_ALLOT_ROW t2, CX_PARTNERLIST_V t3 ");
        sb.append(" where t2.QUANTIFY_ALLOT_ID = t1.row_id and t1.allot_type = 'area' ");
        sb.append(" and t2.area_id = t3.region_id and t2.area_id='").append(partnerArea.getRegionId()).append("'");
        sb.append(" and (t1.END_DATE is null  or to_char(t1.END_DATE,'yyyy-MM-dd')>'").append(DateUtils.formartDate((Date)DateUtils.now(), (String)"yyyy-MM-dd")).append(" ') ");
        sb.append(" union ");
        sb.append("  select distinct to_char(t1.START_DATE, 'yyyymmdd') ksrq,t2.PRODUCT_NUMBER prodId, t3.partner_id partner_id  ");
        sb.append(" from CX_QY_ALLOT t1, CX_QY_ALLOT_ROW t2, CX_PARTNERLIST_V t3 ");
        sb.append(" where t2.QUANTIFY_ALLOT_ID = t1.row_id and t1.allot_type ='bigArea' ");
        sb.append(" and t2.bigarea_id = t3.district_id and t2.bigarea_id='").append(partnerArea.getDistrictId()).append("'");
        sb.append(" and (t1.END_DATE is null  or to_char(t1.END_DATE,'yyyy-MM-dd')>'").append(DateUtils.formartDate((Date)DateUtils.now(), (String)"yyyy-MM-dd")).append(" ') ");
        sb.append("  ) c1 group by c1.ksrq,c1.prodId,c1.partner_id ");
        List list = this.baseDao.findBySql(sb.toString());
        HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
        for (Object[] objects : list) {
            String dateStr = objects[0].toString();
            String prodId = objects[1].toString();
            String partnerId = objects[2].toString();
            ArrayList<String> partnerIdList = (ArrayList<String>)maps.get(String.valueOf(dateStr) + "|" + prodId);
            if (partnerIdList == null) {
                partnerIdList = new ArrayList<String>();
                maps.put(String.valueOf(dateStr) + "|" + prodId, partnerIdList);
            }
            partnerIdList.add(partnerId);
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : maps.keySet()) {
            String[] str = key.split("|");
            String dateStr = str[0];
            String prodId = str[1];
            String partnerIds = StringUtils.listToString((List)maps.get(key), ",");
            StringBuilder sql = new StringBuilder();
            sql.append("select item.product_id, sum(item.ACT_QUANTITY)  ");
            sql.append(" from CX_INDENT_LINE item, CX_INDENT_Apply apply");
            sql.append(" where item.INDENT_APPLY_ID = apply.ROW_ID and apply.NATURE = '1'");
            sql.append(" and apply.dealer_id in('").append(partnerIds).append("')");
            sql.append(" and apply.SUPPLIER_ID = '").append(supplierId).append("'");
            sql.append(" and apply.INDENT_DATE >=  to_date('").append(dateStr).append("', 'yyyymmdd') ");
            if (endDt != null) {
                endDt = DateUtils.getDateAfter((Date)endDt, (int)1);
                sql.append(" and apply.indent_date<=to_date('" + DateUtils.getDate((Date)endDt, (String)"yyyyMMdd") + "','yyyymmdd')");
            }
            if (StringUtils.isNotEmpty(excludeId)) {
                sql.append(" and apply.row_id !='").append(excludeId).append("'");
            }
            sql.append(" and (apply.INDENT_FLAG!='0' and apply.INDENT_FLAG != '2-0' and apply.INDENT_FLAG != '9')");
            sql.append(" and apply.indent_date is not null ");
            sql.append(" and item.product_id in ('").append(prodId).append("')");
            sql.append(" group by item.product_id ");
            List list2 = this.baseDao.findBySql(sql.toString());
            for (Object[] objs : list2) {
                String productId = (String)objs[0];
                Double quantity = objs[1] == null ? 0.0 : ((BigDecimal)objs[1]).doubleValue();
                map.put(productId, quantity);
            }
        }
        return map;
    }

    private String transferClobToString(Object obj) {
        if (String.class.isAssignableFrom(obj.getClass())) {
            return obj.toString();
        }
        return StringUtils.getClob((SerializableClob)obj);
    }

    public Map<String, Double> findLockQuantitys(String applyerId, Boolean isMutilEas) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        String ids = this.cache.getRelatedIds(applyerId);
        if (isMutilEas.booleanValue()) {
            String idsByExtCode;
            ids = idsByExtCode = this.cache.getExtCodeS(applyerId);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT T2.PRODUCT_ID ,SUM(T2.ACT_QUANTITY) FROM  ").append("  CX_INDENT_APPLY T1,  CX_INDENT_LINE T2 ").append("  WHERE T1.ROW_ID=T2.INDENT_APPLY_ID ").append(" AND T1.INDENT_FLAG IN ('2','3')  AND T1.NATURE=1 ").append("AND T1.DEALER_ID in (").append(ids).append(")").append("  GROUP BY T2.PRODUCT_ID  ");
        List list = this.baseDao.findBySql(sb.toString());
        for (Object[] objs : list) {
            String productId = (String)objs[0];
            Double quantity = objs[1] == null ? 0.0 : ((BigDecimal)objs[1]).doubleValue();
            map.put(productId, quantity);
        }
        return map;
    }

    public void approveNoAll(List<OrderApply> orderApplys) {
        for (OrderApply apply : orderApplys) {
            TCBJEnum.AuditState.approve.getValue().equals(apply.getState());
        }
    }

    public void inventoryAdjustment(List<OrderApplyItem> items, Employee me, String stockType) {
        if (Beans.isEmpty((Object)Cache.getDesByVal("TCBJ_INVENTORY_ADJUSTMENT", StringUtils.getOrgId()))) {
            return;
        }
        Storage storage = this.storageService.getStorage(me.getCurrentPartner().getId());
        String storagesId = storage == null ? "" : storage.getId();
        String orgId = ConfigFactory.get().get("prefix");
        HashMap<String, String> sendData = new HashMap<String, String>();
        ArrayList listData = new ArrayList();
        for (OrderApplyItem item : items) {
            Product product = Cache.getProduct(item.getProductId());
            if ("TCBJ".equals(product.getBrand())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("partnerCode", ConfigFactory.get().get("auto_partnerShortCode"));
            data.put("partnerOtherNum", ConfigFactory.get().get("auto_partnerLongCode"));
            data.put("quantity", item.getActQuantity());
            data.put("productId", item.getProductId());
            data.put("productCode", product.getNo());
            data.put("productOtherNum", product.getEasNo());
            data.put("stockType", "input".equals(stockType) ? "ddfh_add" : "ddkj_sub");
            data.put("orgId", orgId);
            data.put("brandId", item.getProduct().getBrand());
            data.put("warehouseId", storagesId);
            data.put("lastUpdateMan", me.getId());
            data.put("createMan", me.getId());
            data.put("lastUpdateDate", new Date());
            listData.add(data);
        }
        sendData.put("organization", StringUtils.getPrefix());
        HashMap listDataMap = new HashMap();
        listDataMap.put("listData", listData);
        sendData.put("jsonStr", JSON.toJSONString(listDataMap));
        EasRequestHelper.getInstance().sendBodyToESB(String.valueOf(StringUtils.getEasStock()) + "inventoryApi/selfAdjust", sendData);
    }

    public void runNobilling(Employee me, OrderApply orderApply) {
        this.inventoryAdjustment(orderApply.getOrderApplyItems(), me, "input");
        this.intRebatemgService.unuse(orderApply.getId());
        this.giftIntRebatemgService.unuse(orderApply.getId());
        this.aplfineService.unuse(orderApply.getId());
        this.giftService.unuse(orderApply.getId());
        this.fGiftService.unuse(orderApply.getId());
        orderApply.setState(TCBJEnum.AuditState.approve.getValue());
        ArrayList<String> aIds = new ArrayList<String>();
        for (OrderActivityInfo info : orderApply.getActivitys()) {
            aIds.add(info.getActivityId());
        }
        AbstractActivityProcessor.newfillTotalCountActivitys(orderApply, orderApply.getActivitys(), aIds);
        orderApply.setBilling("true");
        ActivityHandler.submit(orderApply, orderApply.getState());
        this.updateOrderApplyState(orderApply.getId(), TCBJEnum.AuditState.approveNoPass.getValue(), me);
    }

    public void loadingOrderApply(List<OrderApply> orderApplys) {
        if (Beans.isEmpty(orderApplys)) {
            return;
        }
        StringBuffer orderApplyIds = new StringBuffer();
        HashMap<String, OrderApply> orderApplyMap = new HashMap<String, OrderApply>();
        int i = 0;
        while (i < orderApplys.size()) {
            OrderApply orderApply = orderApplys.get(i);
            orderApplyIds.append("'" + orderApply.getId() + "'");
            if (i != orderApplys.size() - 1) {
                orderApplyIds.append(",");
            }
            orderApplyMap.put(orderApply.getId(), orderApply);
            ++i;
        }
        List orderApplyItems = this.baseDao.findEntity(" from OrderApplyItem where orderApplyId in (" + orderApplyIds + ")", OrderApplyItem.class);
        for (OrderApplyItem orderApplyItem : orderApplyItems) {
            OrderApply orderApply = (OrderApply)orderApplyMap.get(orderApplyItem.getOrderApplyId());
            orderApply.getOrderApplyItems().add(orderApplyItem);
        }
    }

    public void pushReturnStock(OrderApply order) {
        try {
            String url = Cache.getInterfaceConfig("TCBJ_ORDER_RTN_ADD");
            if (Beans.isEmpty((Object)url)) {
                return;
            }
            Disposition dis = Cache.getDispositionFirst("acctID_display");
            if (Beans.isEmpty((Object)dis) || Beans.isNotEmpty((Object)dis) && !"true".equals(dis.getVal())) {
                return;
            }
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("Creator", order.getCreatorId());
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            HashMap<String, String> fBillTypeID = new HashMap<String, String>();
            fBillTypeID.put("FNumber", "THTZD01_SYS");
            model.put("FBillTypeID", fBillTypeID);
            model.put("FOutSideNo", order.getNo());
            model.put("FHeadId", order.getId());
            model.put("FDate", DateUtils.formartDate2((Date)order.getDt(), (String)"yyyy-MM-dd"));
            model.put("FTicket", "1");
            HashMap<String, String> fRetcustId = new HashMap<String, String>();
            fRetcustId.put("FNumber", Cache.getPartnerById(order.getApplyerId()).getClientAppNo());
            model.put("FRetcustId", fRetcustId);
            model.put("FDescription", Beans.isEmpty((Object)order.getRemark()) ? "\u65e0" : order.getRemark());
            HashMap<String, String> fBrand = new HashMap<String, String>();
            fBrand.put("FNumber", Cache.getPartnerById(order.getApplyerId()).getFax());
            model.put("FBrand", fBrand);
            HashMap<String, String> fChannel = new HashMap<String, String>();
            fChannel.put("FNumber", Cache.getPartnerById(order.getApplyerId()).getSaleChannelTypeCode());
            model.put("FChannel", fChannel);
            model.put("FBillNo", order.getNo());
            model.put("FOrderContact", order.getOrderContacts());
            model.put("FContactPhone", order.getOrderPhone());
            ArrayList items = new ArrayList();
            for (OrderApplyItem item : order.getOrderApplyItems()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                HashMap<String, String> fMaterialId = new HashMap<String, String>();
                fMaterialId.put("FNumber", Cache.getProduct(item.getProductId()).getEasNo());
                map.put("FMaterialId", fMaterialId);
                HashMap<String, String> fStockId = new HashMap<String, String>();
                fStockId.put("FNumber", "WH_016");
                map.put("FSTOCKID", fStockId);
                map.put("FBatch", item.getBatchNum());
                map.put("FQty", item.getActQuantity());
                map.put("FPriceUnitQty", item.getQuantity());
                map.put("FTAXPRICE", item.getActPrice());
                items.add(map);
            }
            model.put("FEntity", items);
            data.put("Model", model);
            System.out.println(JSON.toJSONString(data));
            Map rtn = (Map)EasRequestHelper.getInstance().sendRequestData(url, data, order.getAcctId());
            if (Beans.isEmpty((Object)rtn)) {
                throw new AppException("2021");
            }
            Map result = (Map)rtn.get("Result");
            if (Beans.isEmpty((Object)result)) {
                throw new AppException("2021");
            }
            Map responseStatus = (Map)result.get("ResponseStatus");
            if (((Boolean)responseStatus.get("IsSuccess")).booleanValue()) {
                return;
            }
            List errors = (List)responseStatus.get("Errors");
            String messages = "";
            if (Beans.isNotEmpty((Object)errors)) {
                for (Map map : errors) {
                    messages = String.valueOf(messages) + map.get("Message");
                }
                throw new AppException("2023", messages);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("2023", e.getMessage());
        }
    }

    public void pushSaleOrder(OrderApply orderApply, String remark) {
        try {
            HashMap<String, String> fWarehouse;
            HashMap<String, String> fMaterialId;
            HashMap<String, Object> map;
            String url = Cache.getInterfaceConfig("TCBJ_ORDER_BUY_ADD");
            if (Beans.isEmpty((Object)url)) {
                return;
            }
            Disposition dis = Cache.getDispositionFirst("acctID_display");
            if (Beans.isEmpty((Object)dis) || Beans.isNotEmpty((Object)dis) && !"true".equals(dis.getVal())) {
                return;
            }
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put("Creator", orderApply.getCreatorId());
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            HashMap<String, String> fBillTypeID = new HashMap<String, String>();
            fBillTypeID.put("FNumber", "XSDD01_SYS");
            model.put("FBillTypeID", fBillTypeID);
            model.put("FOutSideNo", orderApply.getNo());
            model.put("FHeadId", orderApply.getId());
            model.put("FDate", DateUtils.formartDate2((Date)orderApply.getDt(), (String)"yyyy-MM-dd"));
            HashMap<String, String> fCustId = new HashMap<String, String>();
            fCustId.put("FNumber", Cache.getPartnerById(orderApply.getApplyerId()).getClientAppNo());
            model.put("FCustId", fCustId);
            model.put("FNote", Beans.isEmpty((Object)orderApply.getRemark()) ? "\u65e0" : orderApply.getRemark());
            model.put("FRemarks", Beans.isEmpty((Object)remark) ? "\u65e0" : remark);
            HashMap<String, String> f_kd_PP = new HashMap<String, String>();
            f_kd_PP.put("FNumber", Cache.getPartnerById(orderApply.getApplyerId()).getFax());
            model.put("F_kd_PP", f_kd_PP);
            HashMap<String, String> f_kd_QD = new HashMap<String, String>();
            f_kd_QD.put("FNumber", Cache.getPartnerById(orderApply.getApplyerId()).getTaxNo());
            model.put("F_kd_QD", f_kd_QD);
            HashMap<String, Integer> fSaleOrderFinance = new HashMap<String, Integer>();
            fSaleOrderFinance.put("FExchangeRate", 1);
            model.put("FSaleOrderFinance", fSaleOrderFinance);
            model.put("FProvince", orderApply.getProvince());
            model.put("FCity", orderApply.getCity());
            model.put("FTown", orderApply.getCounty());
            model.put("FAddress", orderApply.getShippingAddress());
            model.put("FConsignee", orderApply.getContacts());
            model.put("FPhone", orderApply.getPhone());
            model.put("FBillNo", orderApply.getNo());
            model.put("FOrderContact", orderApply.getOrderContacts());
            model.put("FContactPhone", orderApply.getOrderPhone());
            DecimalFormat df = new DecimalFormat("#.##");
            ArrayList items = new ArrayList();
            for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
                if ("1".equals(orderApplyItem.getActivityFlag()) || orderApplyItem.getActQuantity() == 0.0) continue;
                map = new HashMap<String, Object>();
                fMaterialId = new HashMap<String, String>();
                fMaterialId.put("FNumber", Cache.getProduct(orderApplyItem.getProductId()).getEasNo());
                map.put("FMaterialId", fMaterialId);
                fWarehouse = new HashMap<String, String>();
                fWarehouse.put("FNumber", "WH_016");
                map.put("FWarehouse", fWarehouse);
                map.put("FTAXPRICE", orderApplyItem.getOfferPrice());
                map.put("F_KD_XSHDZK", "0");
                map.put("F_KD_XSFLZK", df.format(orderApplyItem.getItemDiscountMoney() + orderApplyItem.getItemFullDiscountMoney()));
                map.put("FQty", orderApplyItem.getActQuantity());
                map.put("FPriceUnitQty", orderApplyItem.getQuantity());
                map.put("FOutSideEntryID", orderApplyItem.getId());
                map.put("FDiscountGoods", orderApplyItem.getActivityFlag());
                map.put("FRem", "");
                map.put("FitemDiscountMoney", df.format(orderApplyItem.getItemDiscountMoney()));
                map.put("FitemFullDiscountMoney", df.format(orderApplyItem.getItemFullDiscountMoney()));
                items.add(map);
            }
            for (OrderActivityProduct orderActivityProduct : orderApply.getActivityProducts()) {
                if (orderActivityProduct.getQuantity() == 0.0) continue;
                map = new HashMap();
                fMaterialId = new HashMap();
                fMaterialId.put("FNumber", Cache.getProduct(orderActivityProduct.getProductId()).getEasNo());
                map.put("FMaterialId", fMaterialId);
                fWarehouse = new HashMap();
                fWarehouse.put("FNumber", "WH_016");
                map.put("FWarehouse", fWarehouse);
                map.put("FTAXPRICE", orderActivityProduct.getOfferPrice());
                if ("3".equals(orderActivityProduct.getIsFree())) {
                    map.put("F_KD_XSHDZK", orderActivityProduct.getMoney());
                } else {
                    map.put("F_KD_XSHDZK", df.format(MathUtils.mul((Double)(orderActivityProduct.getOfferPrice() - orderActivityProduct.getPrice()), (Double)orderActivityProduct.getQuantity())));
                }
                map.put("F_KD_XSFLZK", df.format(orderActivityProduct.getItemDiscountMoney() + orderActivityProduct.getItemFullDiscountMoney()));
                map.put("FQty", orderActivityProduct.getQuantity());
                map.put("FPriceUnitQty", orderActivityProduct.getQuantity());
                map.put("FOutSideEntryID", orderActivityProduct.getId());
                map.put("FDiscountGoods", "1");
                map.put("FRem", orderActivityProduct.getActivityName());
                map.put("FitemDiscountMoney", df.format(orderActivityProduct.getItemDiscountMoney()));
                map.put("FitemFullDiscountMoney", df.format(orderActivityProduct.getItemFullDiscountMoney()));
                items.add(map);
            }
            model.put("FSaleOrderEntry", items);
            data.put("Model", model);
            System.out.println(JSON.toJSONString(data));
            Map map2 = (Map)EasRequestHelper.getInstance().sendRequestData(url, data, orderApply.getAcctId());
            if (Beans.isEmpty((Object)map2)) {
                throw new AppException("2021");
            }
            Map result = (Map)map2.get("Result");
            if (Beans.isEmpty((Object)result)) {
                throw new AppException("2021");
            }
            Map responseStatus = (Map)result.get("ResponseStatus");
            if (((Boolean)responseStatus.get("IsSuccess")).booleanValue()) {
                return;
            }
            List errors = (List)responseStatus.get("Errors");
            String messages = "";
            if (Beans.isNotEmpty((Object)errors)) {
                for (Map map22 : errors) {
                    messages = String.valueOf(messages) + map22.get("Message");
                }
                throw new AppException("2023", messages);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("2023", e.getMessage());
        }
    }

    public Map<String, Object> getOrderApplyFromK3(OrderApply orderApply, String url) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("CreateOrgId", "");
        data.put("Number", orderApply.getNo());
        data.put("id", "");
        Map returnObject = (Map)EasRequestHelper.getInstance().sendRequestData(url, data, orderApply.getAcctId());
        if (Beans.isEmpty((Object)returnObject)) {
            throw new AppException("2021");
        }
        Map result = (Map)((Map)returnObject.get("Result")).get("Result");
        return result;
    }
}

