/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.AbstractActivityProcessor;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.ActivityPlatformHelper;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaitApproveProcessor
extends AbstractActivityProcessor {
    @Override
    public void handleSubmit(OrderApply orderApply) {
        List<OrderActivityInfo> activitys = orderApply.getActivitys();
        List<OrderActivityProduct> activityProducts = orderApply.getActivityProducts();
        if (Beans.isNotEmpty(activitys)) {
            Map<String, List<PartnerActivityTrack>> trackMap = this.activityService.findPartnerActivityTrackMapByOrderId(orderApply.getId());
            HashMap<String, List<PartnerActivityTrack>> persistList = new HashMap<String, List<PartnerActivityTrack>>();
            for (OrderActivityInfo activity : activitys) {
                Map<String, Double> amountMap = this.calculateTrackChangeValue(activity, activityProducts);
                List<PartnerActivityTrack> tracks = trackMap.get(activity.getActivityId());
                if (Beans.isEmpty(tracks)) {
                    tracks = this.addPartnerActivityTrack(activity.getActivityId(), amountMap);
                    if (Beans.isNotEmpty(persistList.get("add"))) {
                        ((List)persistList.get("add")).addAll(tracks);
                    } else {
                        persistList.put("add", tracks);
                    }
                } else if (Beans.isNotEmpty(persistList.get("update"))) {
                    ((List)persistList.get("update")).addAll(tracks);
                } else {
                    persistList.put("update", tracks);
                }
                if (TCBJEnum.AuditState.approveNoPass.getValue().equals(orderApply.getState())) {
                    for (PartnerActivityTrack track : tracks) {
                        if (amountMap.containsKey(track.getAddType())) {
                            track.setChangeValue(amountMap.get(track.getAddType()));
                        }
                        if (Constant.ActivityTrackAddType.historyHold.value.equals(track.getAddType())) {
                            track.setState(Constant.ActivityTrackState.invalid.value);
                        } else {
                            if (!Constant.ActivityTrackAddType.prePayDel.value.equals(track.getAddType())) continue;
                            track.setState(Constant.ActivityTrackState.invalid.value);
                        }
                        track.setModifyDate(new Date());
                    }
                    continue;
                }
                for (PartnerActivityTrack track : tracks) {
                    if (amountMap.containsKey(track.getAddType())) {
                        track.setChangeValue(amountMap.get(track.getAddType()));
                    }
                    if (Constant.ActivityTrackAddType.prePayDel.value.equals(track.getAddType())) continue;
                    if (Constant.ActivityTrackAddType.historyHold.value.equals(track.getAddType())) {
                        track.setState(Constant.ActivityTrackState.invalid.value);
                    } else {
                        track.setState(Constant.ActivityTrackState.valid.value);
                    }
                    track.setModifyDate(new Date());
                }
            }
            this.activityService.saveAndUpdatePartnerTrack(persistList);
        }
    }

    private List<PartnerActivityTrack> addPartnerActivityTrack(String activityId, Map<String, Double> amountMap) {
        ArrayList<PartnerActivityTrack> list = new ArrayList<PartnerActivityTrack>();
        for (String key : amountMap.keySet()) {
            PartnerActivityTrack p = new PartnerActivityTrack();
            p.setActivityId(activityId);
            p.setPartnerId(Cache.getApplyer(this.orderApply.getApplyerId()).getApplyerCode());
            p.setOrderApplyId(this.orderApply.getId());
            p.setChangeValue(amountMap.get(key));
            p.setCreateDate(new Date());
            p.setModifyDate(new Date());
            p.setAddType(key);
            if (Constant.ActivityTrackAddType.historyHold.value.equals(key) || Constant.ActivityTrackAddType.prePayDel.value.equals(key)) {
                p.setState(Constant.ActivityTrackState.valid.value);
            } else {
                p.setState(Constant.ActivityTrackState.invalid.value);
            }
            list.add(p);
        }
        return list;
    }

    @Override
    public List<String> handleEdit() {
        return this.whetherToShowActivity();
    }

    @Override
    public Map<String, Object> initActivity() {
        List<OrderActivityProduct> items;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<OrderActivityInfo> activity = new ArrayList<OrderActivityInfo>();
        List<Object> aops = new ArrayList();
        Map<String, Object> activityInfo = ActivityPlatformHelper.getActivityFromPlatform(this.orderApply.getApplyerId());
        List productIds = (List)activityInfo.get("productIds");
        List cfr_ignored_0 = (List)activityInfo.get("activityInfo");
        List<OrderActivityInfo> orderApplyActivitys = this.orderApply.getActivitys();
        this.initActivityProduct(productIds);
        if (Beans.isNotEmpty((Object)activityInfo.get("activityInfo"))) {
            this.orderApply.setActivitys((List)activityInfo.get("activityInfo"));
            OrderApply o = new OrderApply();
            o.setApplyerId(this.orderApply.getApplyerId());
            o.setSupplierId(this.orderApply.getSupplierId());
            o.setActivitys((List)activityInfo.get("activityInfo"));
            items = new ArrayList<OrderActivityProduct>();
            for (OrderApplyItem item : this.orderApply.getOrderApplyItems()) {
                if ("1".equals(item.getActivityFlag())) continue;
                OrderProduct p = (OrderProduct)this.productMap.get(item.getNo());
                if (Beans.isNotEmpty((Object)p)) {
                    item.setPrice(p.getPrice());
                }
                items.add((OrderActivityProduct)((Object)item));
            }
            o.setOrderApplyItems(items);
            Map<String, Object> synProducts = ActivityHandler.getActivityProducts(o);
            activity = (List)synProducts.get("activityInfo");
            aops = (List)synProducts.get("activityProduct");
        }
        ArrayList<String> aIds = new ArrayList<String>();
        if (Beans.isNotEmpty(activity)) {
            if (Beans.isNotEmpty(orderApplyActivitys)) {
                for (OrderActivityInfo orderActivityInfo : orderApplyActivitys) {
                    for (OrderActivityInfo info : activity) {
                        if (!info.getActivityId().equals(orderActivityInfo.getActivityId())) continue;
                        info.setChooseFlag(orderActivityInfo.getChooseFlag());
                    }
                }
            }
            for (OrderActivityInfo info : activity) {
                aIds.add(info.getActivityId());
            }
            items = this.orderApply.getActivityProducts();
            aops = this.fillQuantityToProducts(items);
            if (TCBJEnum.AuditState.draft.getValue().equals(this.orderState) || TCBJEnum.AuditState.approve.getValue().equals(this.orderState) || TCBJEnum.AuditState.approveNoPass.getValue().equals(this.orderState)) {
                WaitApproveProcessor.newfillTotalCountActivitys(this.orderApply, activity, aIds);
            } else {
                WaitApproveProcessor.newfillTotalCountActivitysForView(this.orderApply, activity, aIds);
            }
        }
        result.put("activityIds", aIds);
        result.put("activitys", activity);
        result.put("activityItems", aops);
        return result;
    }

    @Override
    public List<String> handleView() {
        return this.handleEdit();
    }

    private Map<String, Double> calculateTrackChangeValue(OrderActivityInfo activity, List<OrderActivityProduct> activityProducts) {
        Double currentTotal = 0.0;
        Double currentCount = activity.getCurrentCount();
        Double hold = 0.0;
        Double prePayDel = 0.0;
        Double historyDel = 0.0;
        Double historyAdd = currentCount;
        for (OrderActivityProduct product : activityProducts) {
            if (!activity.getActivityId().equals(product.getActivityId())) continue;
            currentTotal = "mon".equals(activity.getUnit()) ? Double.valueOf(currentTotal + product.getMoney()) : Double.valueOf(currentTotal + product.getQuantity());
        }
        if (activity.getPrePayAmountLeft() > 0.0) {
            if (currentTotal <= activity.getPrePayAmountLeft()) {
                prePayDel = currentTotal;
            } else {
                Double left;
                prePayDel = activity.getPrePayAmountLeft();
                historyDel = left = Double.valueOf(currentTotal - activity.getPrePayAmountLeft());
                if (left > currentCount + activity.getTotal() && "1".equals(activity.getChooseFlag())) {
                    throw new AppException("0010", "\u4fc3\u9500\u6d3b\u52a8\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u914d\u989d");
                }
                if (left > currentCount) {
                    hold = left - currentCount;
                }
            }
        } else if (Beans.isNotEmpty((Object)this.orderApply.getBilling()) && "true".equals(this.orderApply.getBilling())) {
            historyAdd = 0.0;
            historyDel = 0.0;
        } else {
            if (currentTotal > currentCount + activity.getTotal() && "1".equals(activity.getChooseFlag())) {
                throw new AppException("0010", "\u4fc3\u9500\u6d3b\u52a8\u8d60\u54c1\u8ba2\u8d2d\u6570\u91cf\u8d85\u8fc7\u5f53\u524d\u53ef\u7528\u914d\u989d");
            }
            if (currentTotal - currentCount > 0.0) {
                hold = currentTotal - currentCount;
            }
            historyDel = currentTotal;
        }
        HashMap<String, Double> amountMap = new HashMap<String, Double>();
        amountMap.put(Constant.ActivityTrackAddType.historyAdd.value, historyAdd);
        amountMap.put(Constant.ActivityTrackAddType.historyDel.value, historyDel);
        amountMap.put(Constant.ActivityTrackAddType.historyHold.value, hold);
        amountMap.put(Constant.ActivityTrackAddType.prePayDel.value, prePayDel);
        return amountMap;
    }
}

