/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order.validate;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.OrderActivityProduct;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.ProductPartnerRule;
import com.tcbj.crm.order.validate.Validator;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.MathUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderRule3Validator
extends Validator {
    @Autowired
    private Cache cache;

    @Override
    protected void validate(Employee emp, String relatedIds, OrderApply order, List<IntRule> ruleList, Map<String, ProductPartnerRule> exclProduct, BaseDao baseDao) throws Exception {
        if (ruleList == null || ruleList.size() == 0) {
            return;
        }
        Double controllingValue = 0.0;
        for (IntRule intRule : ruleList) {
            if (!intRule.getLocusOfControl().equals("ORDER") || !intRule.getControlContent().equals("MON_AMT_HIGH")) continue;
            controllingValue = controllingValue + Double.parseDouble(intRule.getControllingValue());
        }
        Iterator<IntRule> it = ruleList.iterator();
        while (it.hasNext()) {
            IntRule rule = it.next();
            if (!rule.getLocusOfControl().equals("ORDER") || !rule.getControlContent().equals("MON_AMT_HIGH")) continue;
            it.remove();
            double total = 0.0;
            if (Beans.isEmpty(exclProduct)) {
                Object[] val;
                String ids = this.cache.getRelatedIds(emp.getCurrentPartner().getId());
                String sql = " select sum(apply.REBATE_END_MONEY),1 from \tCX_INDENT_Apply apply \twhere apply.DEALER_ID in(" + ids + ") and INDENT_DATE > ? and INDENT_DATE < ? " + "and apply.indent_flag!='0' and apply.indent_flag!='2-0'  and apply.indent_flag!='9' and apply.nature ='1'";
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                String month = sdf.format(new Date());
                String start = String.valueOf(month) + "-" + "01 00:00:00";
                String end = String.valueOf(month) + "-" + "31 23:59:59";
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List list = baseDao.findBySql(sql, new Object[]{sdf2.parse(start), sdf2.parse(end)});
                if (list != null && list.size() > 0 && (val = (Object[])list.get(0))[0] != null) {
                    total = ((BigDecimal)val[0]).doubleValue();
                }
            }
            if (Beans.isNotEmpty(exclProduct)) {
                StringBuffer hql = new StringBuffer();
                hql.append("from OrderApply where applyerId in(" + relatedIds + ") and dt > ? and dt < ? ");
                hql.append("and state!='0' and state!='2-0' and state!='9' and nature='1'");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                String month = sdf.format(new Date());
                String start = String.valueOf(month) + "-" + "01 00:00:00";
                String end = String.valueOf(month) + "-" + "31 23:59:59";
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                List orders = baseDao.findEntity(hql.toString(), new Object[]{sdf2.parse(start), sdf2.parse(end)}, OrderApply.class);
                for (OrderApply oa : orders) {
                    List orderApplyItems = baseDao.findEntity("from OrderApplyItem where orderApplyId = ? ", new Object[]{oa.getId()}, OrderApplyItem.class);
                    List activityProducts = baseDao.findEntity("from OrderActivityProduct where orderApplyId = ? ", new Object[]{oa.getId()}, OrderActivityProduct.class);
                    Iterator orderApplyItemsIterator = orderApplyItems.iterator();
                    while (orderApplyItemsIterator.hasNext()) {
                        OrderApplyItem orderApplyItem = (OrderApplyItem)orderApplyItemsIterator.next();
                        if (!Beans.isNotEmpty((Object)exclProduct.get(orderApplyItem.getProductId()))) continue;
                        orderApplyItemsIterator.remove();
                    }
                    Iterator orderActivityProductIterator = activityProducts.iterator();
                    while (orderActivityProductIterator.hasNext()) {
                        OrderActivityProduct orderActivityProduct = (OrderActivityProduct)orderActivityProductIterator.next();
                        if (!Beans.isNotEmpty((Object)exclProduct.get(orderActivityProduct.getProductId()))) continue;
                        orderActivityProductIterator.remove();
                    }
                    oa.setOrderApplyItems(orderApplyItems);
                    oa.setActivityProducts(activityProducts);
                    Customer customer = this._getCustomer(oa.getApplyerId(), oa.getSupplierId());
                    this.calculateOrderMoney(oa, customer.getPrecision());
                    total = MathUtils.add((Double)total, (Double)oa.getRemainMoney());
                }
            }
            Double currentTotalMoney = 0.0;
            if (Beans.isNotEmpty(exclProduct)) {
                Customer customer = this._getCustomer(order.getApplyerId(), order.getSupplierId());
                for (OrderApplyItem item : order.getOrderApplyItems()) {
                    if (Beans.isNotEmpty((Object)exclProduct.get(item.getProductId()))) continue;
                    currentTotalMoney = MathUtils.add((Double)currentTotalMoney, (Double)MathUtils.m2((Double)(item.getActPrice() * item.getActQuantity()), (int)customer.getPrecision()));
                }
                if (total + (currentTotalMoney = MathUtils.m2((Double)(currentTotalMoney - order.getDiscountMoney() - order.getGiftDiscountMoney() - order.getOtherDiscountMoney() - order.getFreeMoney() - order.getFreeGiftMoney()), (int)customer.getPrecision())) > controllingValue) {
                    Double rs = controllingValue - total;
                    BigDecimal b = new BigDecimal(rs);
                    rs = b.setScale(1, 4).doubleValue();
                    String ess = "\u5f53\u6708\u8ba2\u5355\u4e0a\u9650\u603b\u91d1\u989d:" + controllingValue + ",\u5f53\u524d\u8ba2\u5355\u91d1\u989d\u4e3a\uff1a" + currentTotalMoney + "\u4e0d\u80fd\u8d85\u8fc7\u5f53\u6708\u8ba2\u5355\u5269\u4f59\u4e0a\u9650\u91d1\u989d\uff1a" + rs + ",\u8282\u65e5\u7279\u6b8a\u89c4\u5219\u4ea7\u54c1\u91d1\u989d\uff1a" + (order.getTotalMoney() - currentTotalMoney) + "\u4e0d\u8ba1\u4e0a\u9650";
                    ess = String.valueOf(ess) + "<br/>\u5f53\u6708\u5df2\u4e0b\u8ba2\u5355\u603b\u91d1\u989d(\u4e0d\u5305\u542b\u8282\u65e5\u7279\u6b8a\u89c4\u5219\u4ea7\u54c1)\u4e3a\uff1a" + total;
                    throw new Exception(ess);
                }
                return;
            }
            try {
                if (!(total + order.getRemainMoney() > controllingValue)) continue;
                Double rs = Double.parseDouble(rule.getControllingValue()) - total;
                BigDecimal b = new BigDecimal(rs);
                rs = b.setScale(1, 4).doubleValue();
                String ess = "\u5f53\u524d\u8ba2\u5355\u91d1\u989d:" + order.getRemainMoney() + ",\u4e0d\u80fd\u8d85\u8fc7\u5f53\u6708\u8ba2\u5355\u5269\u4f59\u4e0a\u9650\u91d1\u989d:" + rs;
                ess = String.valueOf(ess) + "\u3010\u5f53\u6708\u8ba2\u5355\u4e0a\u9650\u603b\u91d1\u989d:" + controllingValue + ",\u5f53\u6708\u5df2\u4e0b\u8ba2\u5355\u603b\u91d1\u989d:" + total + "\u3011";
                throw new Exception(ess);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

