/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order.validate;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.ProductPartnerRule;
import com.tcbj.crm.order.validate.Validator;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.MathUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OrderRule6Validator
extends Validator {
    @Override
    protected void validate(Employee emp, String relatedIds, OrderApply order, List<IntRule> ruleList, Map<String, ProductPartnerRule> exclProduct, BaseDao baseDao) throws Exception {
        if (ruleList == null || ruleList.size() == 0) {
            return;
        }
        Map<String, Map<String, Object>> controllingScopesMap = this.mergeAlikeIntRule(ruleList);
        if (controllingScopesMap.size() == 0) {
            return;
        }
        for (String key : controllingScopesMap.keySet()) {
            Map<String, Object> map = controllingScopesMap.get(key);
            StringBuffer hql = new StringBuffer();
            ArrayList<Object> args = new ArrayList<Object>();
            hql.append("select oi from OrderApply o,OrderApplyItem oi where oi.orderApplyId = o.id and  (oi.isScore !='Y' or oi.isScore is null)");
            hql.append(" and o.applyerId in (" + relatedIds + ") ");
            hql.append(" and o.dt > ? and o.dt < ?");
            args.add(map.get("minStartDt"));
            args.add(map.get("maxEndDt"));
            hql.append(" and o.state != '0' and o.state !='2-0' and o.state !='9' and nature ='1'");
            List list = baseDao.findEntity(hql.toString(), args.toArray(), OrderApplyItem.class);
            for (OrderApplyItem item : list) {
                Product p = Cache.getProduct(item.getProductId());
                if (!key.contains(p.getOrderProdType())) continue;
                if (Beans.isEmpty((Object)exclProduct.get(p.getId()))) {
                    map.put("nowTotalValue", MathUtils.add((Double)((Double)map.get("nowTotalValue")), (Double)item.getMoney()));
                    continue;
                }
                map.put("extTotalValue", MathUtils.add((Double)((Double)map.get("extTotalValue")), (Double)item.getMoney()));
            }
            List<OrderApplyItem> items = order.getOrderApplyItems();
            for (OrderApplyItem item : items) {
                Product p = Cache.getProduct(item.getProductId());
                if (!key.contains(p.getOrderProdType())) continue;
                if (Beans.isEmpty((Object)exclProduct.get(p.getId()))) {
                    map.put("orderValue", MathUtils.add((Double)((Double)map.get("orderValue")), (Double)item.getMoney()));
                    continue;
                }
                map.put("extOrderValue", MathUtils.add((Double)((Double)map.get("extOrderValue")), (Double)item.getMoney()));
            }
            StringBuffer errorMsg = new StringBuffer();
            Double controllingValue = (Double)map.get("controllingValue");
            Double nowTotalValue = (Double)map.get("nowTotalValue");
            Double cfr_ignored_0 = (Double)map.get("extTotalValue");
            Double orderValue = (Double)map.get("orderValue");
            Double cfr_ignored_1 = (Double)map.get("extOrderValue");
            if (nowTotalValue + orderValue > controllingValue) {
                errorMsg.append("<br/>");
                errorMsg.append("\u5f53\u524d\u65f6\u95f4\u8303\u56f4" + DateUtils.formartDate((Date)((Date)map.get("minStartDt")), (String)"yyyy-MM-dd HH:mm:ss") + "\u81f3" + DateUtils.formartDate((Date)((Date)map.get("maxEndDt")), (String)"yyyy-MM-dd HH:mm:ss") + "<br/>");
                String controllingScopes = "";
                String[] stringArray = key.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        String controllingScope = stringArray[n2];
                        Constant.OrderProductType valueOf = null;
                        try {
                            valueOf = Constant.OrderProductType.valueOf(controllingScope);
                        }
                        catch (Exception exception) {
                            break block11;
                        }
                        controllingScopes = String.valueOf(controllingScopes) + valueOf.value + ",";
                    }
                    ++n2;
                }
                controllingScopes = controllingScopes.substring(0, controllingScopes.length() - 1);
                errorMsg.append("(" + controllingScopes + ")\u7684\u4e0a\u9650\u603b\u91d1\u989d\u4e3a\uff1a" + controllingValue);
                errorMsg.append(",\u4e0d\u80fd\u8d85\u51fa\u5f53\u524d\u65f6\u95f4\u8303\u56f4\u5269\u4f59\u4e0a\u9650\u91d1\u989d\uff1a" + MathUtils.sub((Double)controllingValue, (Double)nowTotalValue));
                errorMsg.append("<br/>\u5f53\u524d\u65f6\u95f4\u8303\u56f4\u5df2\u4e0b\u8ba2\u5355\u603b\u91d1\u989d\uff1a" + nowTotalValue);
                errorMsg.append("<br/>\u5f53\u524d(" + controllingScopes + ")\u8ba2\u5355\u4f7f\u7528\u503c\uff1a" + orderValue);
            }
            if (!StringUtils.isNotEmpty((String)errorMsg.toString())) continue;
            throw new Exception(errorMsg.toString());
        }
    }

    protected Map<String, Map<String, Object>> mergeAlikeIntRule(List<IntRule> ruleList) {
        HashMap<String, Map<String, Object>> controllingScopesMap = new HashMap<String, Map<String, Object>>();
        Iterator<IntRule> it = ruleList.iterator();
        while (it.hasNext()) {
            IntRule intRule = it.next();
            if (!intRule.getLocusOfControl().equals("ORDER") || !intRule.getControlContent().equals("TIME_AMT_HIGH")) continue;
            it.remove();
            String[] vals = intRule.getControllingValue().split(",");
            Date startDt = DateUtils.formDate((String)vals[0], (String)"yyyy-MM-dd");
            Date endDt = DateUtils.formDate((String)vals[1], (String)"yyyy-MM-dd");
            double controllingValue = Double.parseDouble(vals[2]);
            if (startDt.getTime() - DateUtils.now().getTime() > 0L || endDt.getTime() - DateUtils.now().getTime() < 0L) continue;
            String[] controllingScope = intRule.getControllingScope().split(",");
            String conformKey = null;
            for (String key : controllingScopesMap.keySet()) {
                int count = 0;
                if (key.split(",").length != controllingScope.length) continue;
                String[] stringArray = controllingScope;
                int n = controllingScope.length;
                int n2 = 0;
                while (n2 < n) {
                    String scope = stringArray[n2];
                    if (key.contains(scope)) {
                        ++count;
                    }
                    ++n2;
                }
                if (count != controllingScope.length) continue;
                conformKey = key;
                break;
            }
            if (conformKey == null) {
                HashMap<String, Comparable<Double>> newMap = new HashMap<String, Comparable<Double>>();
                newMap.put("controllingValue", Double.valueOf(controllingValue));
                newMap.put("nowTotalValue", Double.valueOf(0.0));
                newMap.put("extTotalValue", Double.valueOf(0.0));
                newMap.put("orderValue", Double.valueOf(0.0));
                newMap.put("extOrderValue", Double.valueOf(0.0));
                newMap.put("minStartDt", startDt);
                newMap.put("maxEndDt", endDt);
                controllingScopesMap.put(intRule.getControllingScope(), newMap);
                continue;
            }
            Map map = (Map)controllingScopesMap.get(conformKey);
            map.put("controllingValue", MathUtils.add((Double)controllingValue, (Double)Double.parseDouble(map.get("controllingValue").toString())));
            Date minStartDt = (Date)map.get("minStartDt");
            Date maxEndDt = (Date)map.get("maxEndDt");
            minStartDt = startDt.getTime() - minStartDt.getTime() < 0L ? startDt : minStartDt;
            maxEndDt = maxEndDt.getTime() - endDt.getTime() < 0L ? endDt : maxEndDt;
            map.put("minStartDt", minStartDt);
            map.put("maxEndDt", maxEndDt);
        }
        return controllingScopesMap;
    }
}

