/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.order.validate;

import com.tcbj.crm.entity.IntRule;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.ProductPartnerRule;
import com.tcbj.crm.order.validate.Validator;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SingleRule1Validator
extends Validator {
    @Autowired
    StockService stockService;

    @Override
    protected void validate(Employee emp, String relatedIds, OrderApply order, List<IntRule> ruleList, Map<String, ProductPartnerRule> exclProduct, BaseDao baseDao) throws Exception {
        if (ruleList == null || ruleList.size() == 0) {
            return;
        }
        Iterator<IntRule> it = ruleList.iterator();
        while (it.hasNext()) {
            IntRule rule = it.next();
            if (!rule.getLocusOfControl().equals("ITEM") || !rule.getControlContent().equals("ITEM_INV_AMOUNT")) continue;
            it.remove();
            List<OrderApplyItem> items = order.getOrderApplyItems();
            for (OrderApplyItem item : items) {
                if (!item.getProductId().equals(rule.getProductId())) continue;
                double svalue = this.stockService.getQuantityByPartner(emp.getCurrentPartner().getId(), item.getProductId());
                Product product = (Product)baseDao.get(Product.class, (Serializable)((Object)rule.getProductId()));
                svalue = product.getPrice() * svalue;
                try {
                    if (!(svalue > Double.parseDouble(rule.getControllingValue()))) continue;
                    throw new Exception(String.valueOf(item.getProductName()) + "\u4ea7\u54c1\u5e93\u5b58\u603b\u4ef7\u503c\u5df2\u7ecf\u8d85\u8fc7\u4e86" + rule.getControllingValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }
}

