/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.orderinout;

import com.tcbj.crm.common.SystemOrgService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderInOut;
import com.tcbj.crm.entity.OrderInOutItem;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.orderinout.Opt;
import com.tcbj.crm.orderinout.OrderInOutCondition;
import com.tcbj.crm.stock.StockService;
import com.tcbj.crm.stock.UpdateStockItem;
import com.tcbj.crm.util.EasRequestHelper;
import com.tcbj.crm.util.esb.EsbAnalyUtil;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.OrderInOutView;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Jsons;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderinoutService")
public class OrderInOutService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    StockService stockService;
    @Autowired
    PersonnelService personnelservice;
    @Autowired
    SystemOrgService systemOrgService;

    public Page findOrderOuts(String partnerId, OrderInOutCondition condition, String orderby) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" select v from OrderInOutView v,Partner p where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" and (");
        HQL.append(" (v.supplierId=? and v.nature=? and p.id=v.applyerId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.buy.getValue());
        HQL.append(" or ");
        HQL.append(" (v.applyerId=? and v.nature=? and p.id=v.supplierId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.rtn.getValue());
        HQL.append(" ) ");
        if (StringUtils.isNotEmpty(condition.getReceivePartnerName())) {
            HQL.append(" and p.name like ? ");
            args.add("%" + condition.getReceivePartnerName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            HQL.append(" and v.no like ? ");
            args.add("%" + condition.getNo().trim() + "%");
        }
        if (condition.getOrderDtS() != null) {
            HQL.append(" and v.dt >= ?");
            args.add(condition.getOrderDtS());
        }
        if (condition.getOrderDtE() != null) {
            HQL.append(" and v.dt <= ?");
            args.add(condition.getOrderDtE());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" v.state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(" " + orderby);
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public Page findOrderIns(String partnerId, OrderInOutCondition condition, String orderby) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" select v from OrderInOutView v,Partner p where 1=1 ");
        ArrayList<Object> args = new ArrayList<Object>();
        HQL.append(" and (");
        HQL.append(" (v.applyerId=? and v.nature=? and p.id=v.supplierId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.buy.getValue());
        HQL.append(" or ");
        HQL.append(" (v.supplierId=? and v.nature=? and p.id=v.applyerId )");
        args.add(partnerId);
        args.add(TCBJEnum.OrderNature.rtn.getValue());
        HQL.append(" ) ");
        if (StringUtils.isNotEmpty(condition.getSendPartnerName())) {
            HQL.append(" and p.name like ? ");
            args.add("%" + condition.getSendPartnerName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(condition.getNo())) {
            HQL.append(" and v.no like ? ");
            args.add("%" + condition.getNo().trim() + "%");
        }
        if (condition.getOrderDtS() != null) {
            HQL.append(" and v.dt >= ?");
            args.add(condition.getOrderDtS());
        }
        if (condition.getOrderDtE() != null) {
            HQL.append(" and v.dt <= ?");
            args.add(condition.getOrderDtE());
        }
        if (condition.getStates().size() > 0) {
            int i = 0;
            HQL.append(" and ( ");
            for (String state : condition.getStates()) {
                HQL.append(" v.state = ?");
                if (++i < condition.getStates().size()) {
                    HQL.append(" or ");
                }
                args.add(state);
            }
            HQL.append(" ) ");
        }
        if (StringUtils.isNotEmpty(orderby)) {
            HQL.append(" " + orderby);
        }
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, condition.getPageno().intValue());
    }

    public List<OrderInOutItem> getOrderInOutItems(String id) {
        String hql = "select o from OrderInOutItem o , Product p where o.productId = p.id and o.orderInOutId=? order by p.no ";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, OrderInOutItem.class);
    }

    public OrderInOutView get(String id) {
        OrderInOutView obj = (OrderInOutView)this.baseDao.get(OrderInOutView.class, (Serializable)((Object)id));
        return obj;
    }

    public void createOrderInOut(OrderInOut io) {
        this.baseDao.save((Object)io);
        for (OrderInOutItem item : io.getOrderInOutItems()) {
            item.setOrderInOutId(io.getId());
        }
        this.baseDao.save(io.getOrderInOutItems());
    }

    public void send(Employee me, Opt opt) {
        String hql = " update OrderInOut set outerId=?,outOperateDt=?,outDt=?,outRepositoryId=?, state=? where id=? ";
        Object[] args = new Object[]{opt.getOperatorId(), opt.getOperateDt(), opt.getDt(), opt.getRepositoryId(), TCBJEnum.SendOrReceiveState.sended.getValue(), opt.getId()};
        this.baseDao.executeHQL(hql, args);
        OrderInOut orderInout = (OrderInOut)this.baseDao.get(OrderInOut.class, (Serializable)((Object)opt.getId()));
        OrderApply order = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderInout.getOrderId()));
        List list = this.baseDao.findEntity(" from OrderInOutItem where orderInOutId = ?", (Object)opt.getId(), OrderInOutItem.class);
        ArrayList<UpdateStockItem> slist = new ArrayList<UpdateStockItem>();
        for (OrderInOutItem item : list) {
            UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), 0.0 - item.getQuantity());
            sitem.setSupplierId(order.getSupplierId());
            sitem.setApplyerId(order.getApplyerId());
            slist.add(sitem);
        }
        this.stockService.updateQuantity(me, order.getSupplierId(), opt.getRepositoryId(), opt.getId(), "\u53d1\u8d27", slist);
    }

    public void receive(Employee me, Opt opt) {
        String hql = " update OrderInOut set inerId=?,inOperateDt=?,inDt=?,inRepositoryId=?, state=? where id=? ";
        Object[] args = new Object[]{opt.getOperatorId(), opt.getOperateDt(), opt.getDt(), opt.getRepositoryId(), TCBJEnum.SendOrReceiveState.received.getValue(), opt.getId()};
        this.baseDao.executeHQL(hql, args);
        OrderInOut orderInout = (OrderInOut)this.baseDao.get(OrderInOut.class, (Serializable)((Object)opt.getId()));
        OrderApply order = (OrderApply)this.baseDao.get(OrderApply.class, (Serializable)((Object)orderInout.getOrderId()));
        List list = this.baseDao.findEntity(" from OrderInOutItem where orderInOutId = ?", (Object)opt.getId(), OrderInOutItem.class);
        ArrayList<UpdateStockItem> slist = new ArrayList<UpdateStockItem>();
        for (OrderInOutItem item : list) {
            UpdateStockItem sitem = new UpdateStockItem(item.getId(), item.getProductId(), item.getQuantity());
            sitem.setSupplierId(order.getSupplierId());
            sitem.setApplyerId(order.getApplyerId());
            slist.add(sitem);
        }
        this.stockService.updateQuantity(me, order.getSupplierId(), opt.getRepositoryId(), opt.getId(), "\u6536\u8d27", slist);
    }

    public void receiveNew(String no) {
        OrderApply orderApply = (OrderApply)this.baseDao.findFirstEntity(" from OrderApply where no = ? ", new Object[]{no}, OrderApply.class);
        if (orderApply != null) {
            orderApply.setState(TCBJEnum.SendOrReceiveState.received.getValue());
        }
    }

    public Map<String, Object> sWP(OrderInOutCondition condition, Employee me, String type) {
        StringBuffer where = new StringBuffer();
        LinkedHashMap<String, String> mapParams = new LinkedHashMap<String, String>();
        where.append(" where 1=:1 ");
        mapParams.put("1", "1");
        String orgId = "";
        List idList = new ArrayList();
        if (me != null) {
            EmployeePartner par = me.getCurrentPartner();
            orgId = par.getOrganizationid();
            if (!par.getId().equals(orgId)) {
                Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)par.getId()));
                if (partner != null) {
                    where.append(" and CUSTOMER_NUMBER=:CUSTOMER_NUMBER ");
                    mapParams.put("CUSTOMER_NUMBER", partner.getClientAppNo());
                }
            } else {
                String sb = this.personnelservice.getFRegionsByUserId(me.getId());
                StringBuffer hql = new StringBuffer();
                hql.append("select p.clientAppNo from Partner p,Customer c where p.id = c.applyerId and p.clientAppNo is not null");
                hql.append(" and (c.bigAreaCode in ( ").append(sb).append(") or c.areaCode in ( ").append(sb).append(" ))");
                List list = this.baseDao.findEntity(hql.toString(), Object.class);
                idList = (List)StringUtils.disList(list);
            }
        }
        where.append(" and DELIVERED_STATUS=:DELIVERED_STATUS ");
        mapParams.put("DELIVERED_STATUS", "\u5df2\u53d1\u51fa");
        if ("1".equals(type) || "2".equals(type)) {
            if (StringUtils.isNotEmpty(orgId)) {
                where.append(" and ORG_ID=:ORG_ID ");
                mapParams.put("ORG_ID", this.systemOrgService.getEasOrgIdByCrmOrgId(orgId));
            }
            if (StringUtils.isNotEmpty(condition.getReceivePartnerName())) {
                where.append(" and CUSTOMER_NAME like :CUSTOMER_NAME ");
                mapParams.put("CUSTOMER_NAME", "%" + condition.getReceivePartnerName() + "%");
            }
            if (condition.getOrderDtS() != null) {
                String dts = DateUtils.formartDate((Date)condition.getOrderDtS(), (String)"yyy-MM-dd");
                where.append(" and to_char(BIZDATE,'yyyy-mm-dd') >=:BIZDATE ");
                mapParams.put("BIZDATE", dts);
            }
            if (condition.getOrderDtE() != null) {
                String dte = DateUtils.formartDate((Date)condition.getOrderDtE(), (String)"yyy-MM-dd");
                where.append(" and to_char(BIZDATE,'yyyy-mm-dd') <=:BIZDATE2 ");
                mapParams.put("BIZDATE2", dte);
            }
            if (StringUtils.isNotEmpty(condition.getNo())) {
                where.append(" and CRM_ORDER_NUMBER like :CRM_ORDER_NUMBER ");
                mapParams.put("CRM_ORDER_NUMBER", "%" + condition.getNo() + "%");
            }
            if (idList.size() > 0) {
                String ids = StringUtils.listToString(idList, "','");
                where.append(" and CUSTOMER_NUMBER in('").append(ids).append("')");
            }
            where.append("order by BIZDATE desc");
        }
        if ("3".equals(type) && StringUtils.isNotEmpty(condition.getEsbId())) {
            where.append(" and ID =:ID ");
            mapParams.put("ID", condition.getEsbId());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("where", where.toString());
        map.put("mapParams", mapParams);
        return map;
    }

    public String sSql(String type) {
        StringBuffer sql = new StringBuffer();
        if ("1".equals(type)) {
            sql.append("FID \"id\",ORG_ID,CRM_ORDER_NUMBER \"no\",ORDER_TYPE \"nature\",BIZTYPENAME \"sendType\",");
            sql.append("to_char(TRANSACTION_DATE ,'yyyy-mm-dd HH:mm:ss') \"outDt\",CUSTOMER_NUMBER,");
            sql.append("to_char(BIZDATE,'yyyy-mm-dd HH:mm:ss') \"dt\",ADDRESS \"shippingAddress\",");
            sql.append("LINKMAN \"contacts\",LINKTELL \"phone\",CUSTOMER_NAME \"partnerName\",DELIVERED_STATUS");
        }
        if ("2".equals(type)) {
            sql.append("count(1) coun");
        }
        if ("3".equals(type)) {
            sql.append("ship_quantity \"quantity\",SHIP_SUBINV_CODE,DELIVERED_STATUS,to_char(SHIP_TRANSACTION_DATE,'yyyy-mm-dd HH:mm:ss'),SHIP_QUANTITY,");
            sql.append("ID \"id\",ITEM_NUMBER \"productId\",BATCH_NUM \"batchNum\",ISSCORE \"isscore\",SALE_PRICE \"salePrice\",");
            sql.append("to_char(PRODUCT_DATE,'yyyy-mm-dd HH:mm:ss') \"productCreatDate\",to_char(PRODUCT_END_DATE,'yyyy-mm-dd HH:mm:ss') \"productEndDate\",");
            sql.append("PIZHUN_WENHAO \"pizhunWenhao\",ITEM_JIXING \"itemJixing\",ITEM_SCSHANG \"itemScshang\",LIMS_URL \"limsUrl\"  ");
        }
        return sql.toString();
    }

    public Page findOrderOutsNew(Employee me, OrderInOutCondition condition, int pageno) {
        int pageSize = Constant.ESB_PAGE_ROWS;
        String url = String.valueOf(StringUtils.getEasStock()) + "querySaleIssueBill";
        String body = this.esbPost(url, this.sWP(condition, me, "1"), this.sSql("1"), pageno, pageSize);
        List orderList = (List)Jsons.toListBean((String)EsbAnalyUtil.getResults(body, null), OrderInOutView.class);
        for (OrderInOutView orderInOutView : orderList) {
            OrderApply orderApply = (OrderApply)this.baseDao.findFirstEntity(" from OrderApply where no = ? ", new Object[]{orderInOutView.getNo()}, OrderApply.class);
            if (orderApply != null) {
                orderInOutView.setState(orderApply.getState());
                continue;
            }
            orderInOutView.setState("");
        }
        String bodyCount = this.esbPost(url, this.sWP(condition, me, "2"), this.sSql("2"), 0, 0);
        int count = 0;
        if (bodyCount != null) {
            Map<String, Object> countMap = EsbAnalyUtil.getResult(bodyCount, null);
            count = Integer.parseInt(countMap.get("COUN").toString());
        }
        return new Page(orderList, pageno, pageSize, count);
    }

    public OrderInOutView findOrderById(OrderInOutCondition condition) {
        String url = String.valueOf(StringUtils.getEasStock()) + "querySaleIssueBill";
        String body = this.esbPost(url, this.sWP(condition, null, "1"), this.sSql("1"), 0, 0);
        Map<String, Object> OrderInOutView2 = EsbAnalyUtil.getResult(body, null);
        OrderInOutView order = new OrderInOutView();
        Beans.copy((Object)order, OrderInOutView2);
        OrderApply orderApply = (OrderApply)this.baseDao.findFirstEntity(" from OrderApply where no = ? ", new Object[]{order.getNo()}, OrderApply.class);
        if (orderApply != null) {
            order.setState(orderApply.getState());
            order.setOrderContacts(orderApply.getOrderContacts());
            order.setOrderPhone(orderApply.getOrderPhone());
        } else {
            order.setState("");
        }
        return order;
    }

    public List<OrderInOutItem> getOrderInOutItemsNew(OrderInOutCondition condition, OrderInOutView orderInOut) {
        String url = String.valueOf(StringUtils.getEasStock()) + "querySaleIssueBillEntry";
        String body = this.esbPost(url, this.sWP(condition, null, "3"), this.sSql("3"), 0, 0);
        List orderItemList = (List)Jsons.toListBean((String)EsbAnalyUtil.getResults(body, null), OrderInOutItem.class);
        Double quantity = 0.0;
        Double totalMoney = 0.0;
        for (OrderInOutItem order : orderItemList) {
            Product product = (Product)this.baseDao.findFirstEntity(" from Product where easNo = ? ", new Object[]{order.getProductId()}, Product.class);
            if (product == null) continue;
            order.setProductId(product.getId());
            order.setProductType(product.getOrderProdType());
            if (order.getSalePrice() != null && order.getQuantity() != null) {
                quantity = quantity + order.getQuantity();
                totalMoney = totalMoney + order.getQuantity() * order.getSalePrice();
            }
            order.setCreatDate(DateUtils.formartDate((Date)order.getProductCreatDate(), (String)"yyy-MM-dd"));
            order.setEndDate(DateUtils.formartDate((Date)order.getProductEndDate(), (String)"yyy-MM-dd"));
        }
        orderInOut.setQuantity(quantity);
        orderInOut.setTotalMoney(totalMoney);
        return orderItemList;
    }

    public String esbPost(String url, Map<String, Object> map, String sql, int pageno, int pageSize) {
        map.put("sql", sql);
        if (pageno != 0 && pageSize != 0) {
            map.put("currentPage", pageno);
            map.put("pageSize", pageSize);
        }
        LinkedHashMap fieldType = new LinkedHashMap();
        map.put("fieldType", fieldType);
        HashMap<String, String> rm = new HashMap<String, String>();
        rm.put("jsonStr", Jsons.toJson(map));
        try {
            return EasRequestHelper.getInstance().sendBody(url, rm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("2021");
        }
    }
}

