/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.orderrtn;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.AuditInfo;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.OrderApply;
import com.tcbj.crm.entity.OrderApplyItem;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PrAdjdetail;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.ActivityHandler;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.crm.order.OrderApplyController;
import com.tcbj.crm.order.OrderProduct;
import com.tcbj.crm.orderrtn.RtnOrderExcel;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.ExcelUtils;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@RequestMapping(value={"/rtnorderapply"})
public class RtnOrderApplyController
extends OrderApplyController {
    @Override
    @ModelAttribute
    public void initNames(Model model) {
        model.addAttribute("_title", (Object)"\u9000\u8d27");
    }

    @Override
    @RequestMapping(value={"/viewFromK3.do"}, method={RequestMethod.GET})
    public String viewFromK3(@RequestParam(value="id", required=true) String id, Model model) {
        Employee em = this.getCurrentEmployee();
        String url = Cache.getInterfaceConfig("TCBJ_ORDER_VIEW_RETURN");
        if (Beans.isEmpty((Object)url)) {
            model.addAttribute("rtn", (Object)"<script language=\"javascript\">alert('\u5bf9\u4e0d\u8d77\uff01\u60a8\u6ca1\u6709\u914d\u7f6e\u5916\u90e8\u67e5\u8be2\u63a5\u53e3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01');window.location.href=base+'/rtnorderapply/applys.do'</script>");
            return "common/iframeRtn.ftl";
        }
        try {
            OrderApply orderApply = this.service.getSimpleOrderApply(id);
            this.assertOrderExist(orderApply);
            Map<String, Object> order = this.service.getOrderApplyFromK3(orderApply, url);
            if (Beans.isEmpty(order)) {
                throw new AppException("2024");
            }
            String dt = String.valueOf(order.get("FCreateDate"));
            model.addAttribute("order", order);
            model.addAttribute("dt", (Object)DateUtils.autoFormatDate((String)dt, (String[])new String[]{"yyyy-MM-dd"}));
            model.addAttribute("supplierName", (Object)em.getCurrentPartner().getOrganization());
            return "orderrtn/viewFromK3.ftl";
        }
        catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("rtn", (Object)("<script language=\"javascript\">alert('" + e.getMessage() + "');" + "window.location.href=base+'/rtnorderapply/applys.do'</script>"));
            return "common/iframeRtn.ftl";
        }
    }

    @Override
    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=false) String id, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        List<OrderProduct> products = null;
        if (orderApply.isDraft()) {
            products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
            this.fillQuantityToProducts(orderApply, products);
            Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
            List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            this.calculateProductPrices(contract, products, details, customer.getPrecision());
            this.calculateOrderMoney(orderApply, products, customer.getPrecision());
            Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
            Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
            orderApply.setRetunsFullyMoney(contractFullyMoney);
            this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        } else {
            products = this.getProducts(orderApply);
        }
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        return "orderrtn/view.ftl";
    }

    @Override
    @RequestMapping(value={"/applys.do"})
    public String applys(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        con.setNature(TCBJEnum.OrderNature.rtn.getValue());
        super.applys(con, model);
        return "orderrtn/applys.ftl";
    }

    @Override
    @RequestMapping(value={"/approves.do"})
    public String approves(@ModelAttribute(value="condition") OrderApplyCondition con, Model model) {
        con.setNature(TCBJEnum.OrderNature.rtn.getValue());
        super.approves(con, model);
        return "orderrtn/approves.ftl";
    }

    @Override
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        orderApply.setNature(TCBJEnum.OrderNature.rtn.getValue());
        orderApply.setApplyerId(me.getCurrentPartner().getId());
        this.assertOrderBelongMyPartner(orderApply, me);
        this.fillSupplierInOrderApply(orderApply, request);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        if (contract != null && StringUtils.isEmpty(orderApply.getContractNo())) {
            orderApply.setContractNo(contract.getPactNo());
        }
        List<PactMain> contracts = this.getPactMains(orderApply.getApplyerId(), orderApply.getSupplierId());
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        model.addAttribute("addresses", (Object)JSON.toJSONString(customer.getAddresses()));
        if (orderApply.isNew()) {
            orderApply.bindEditData(customer, me);
        }
        orderApply.bindCannotEditData(customer, me);
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        this.fillQuantityToProducts(orderApply, products);
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(contract, products, details, customer.getPrecision());
        this.calculateRtnProductStocks(products, orderApply.getApplyerId(), null);
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        List<AuditInfo> auditInfos = this.auditService.find(orderApply.getId());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("auditInfos", auditInfos);
        model.addAttribute("contracts", (Object)JSON.toJSONString(contracts));
        model.addAttribute("contractTotalMoney", (Object)contractTotalMoney);
        model.addAttribute("contractFullyMoney", (Object)contractFullyMoney);
        model.addAttribute("customer", (Object)customer);
        return "orderrtn/apply.ftl";
    }

    @RequestMapping(value={"/getContractMoney.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result getContractMoney(String id, String applyerId, String supplierId, String contractNo, Model model) {
        Double contractTotalMoney = this.calculateContractOrdersMoney(applyerId, contractNo);
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(applyerId, contractNo, id);
        Double[] contractMoney = new Double[]{contractTotalMoney, contractFullyMoney};
        return this.getSuccessResult(contractMoney);
    }

    @Override
    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody OrderApply orderApply, BindingResult errors, HttpServletRequest request, Model model) {
        orderApply.setNature(TCBJEnum.OrderNature.rtn.getValue());
        Employee me = this.getCurrentEmployee();
        orderApply.fillInitData(me);
        this.assertOrderBelongMyPartner(orderApply, me);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        orderApply.bindCannotEditData(customer, me);
        if (StringUtils.isEmpty(orderApply.getSalesman()) || orderApply.getSalesman().trim().toLowerCase().equals("null")) {
            orderApply.setSalesman(customer.getCityManagerId());
        }
        OrderApply oldOrderApply = null;
        if (StringUtils.isNotEmpty(orderApply.getId())) {
            oldOrderApply = this.service.getSimpleOrderApply(orderApply.getId());
            this.assertOrderExist(oldOrderApply);
            this.assertOrderBelongMyPartner(oldOrderApply, me);
            if (!oldOrderApply.isDraft()) {
                orderApply.setState(oldOrderApply.getState());
                orderApply.setNo(oldOrderApply.getNo());
                orderApply.setDt(oldOrderApply.getDt());
            }
        }
        Partner applyer = this.assertOrderApplyerIsEffective(orderApply.getApplyerId());
        this.assertOrderSupplierIsEffective(orderApply.getSupplierId());
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        if (oldOrderApply == null || !oldOrderApply.isApprovedNotPass()) {
            this.assertOrderProduct(orderApply, products);
        }
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.assertProductPrices(orderApply, contract, products, details, customer.getPrecision());
        this.calculateOrderMoney(orderApply, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        if (orderApply.isToApprove() && StringUtils.isEmpty(orderApply.getNo())) {
            String type = orderApply.getNature().equals(TCBJEnum.OrderNature.buy.getValue()) ? "01" : "02";
            orderApply.setNo(this.orderNoService.maxNo(applyer.getNo(), type));
            orderApply.setDt(DateUtils.now());
            orderApply.setContractNo(contract.getPactNo());
        }
        for (OrderApplyItem item : orderApply.getOrderApplyItems()) {
            item.fillInitData(me);
        }
        this.service.saveOrUpdateOrderApply(orderApply, false);
        if (orderApply.isToApprove()) {
            this.service.updateOrderApplyState(orderApply.getId(), TCBJEnum.AuditState.approve.getValue(), me);
        }
        if (orderApply.isToAudit() || orderApply.isToApprove()) {
            AuditInfo auditInfo = new AuditInfo(orderApply.getId(), "OrderApply", orderApply.getState(), orderApply.getRemark(), me.getId(), DateUtils.now());
            this.auditService.add(auditInfo);
        }
        return this.getSuccessResult(null);
    }

    @Override
    @RequestMapping(value={"/approve.do"}, method={RequestMethod.GET})
    public String approve(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        OrderApply orderApply = this.loadOrderApply(id, model);
        this.assertOrderBelongMySupplier(orderApply, me);
        Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        int days = customer.getTransportOnlineCode() == null ? 3 : customer.getTransportOnlineCode().intValue();
        orderApply.setPredictArriveDt(DateUtils.getDateAfter((Date)orderApply.getDt(), (int)days));
        List<OrderProduct> products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
        this.fillQuantityToProducts(orderApply, products);
        PactMain priceContract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        PactMain contract = this.getPactMain(orderApply.getSupplierId(), orderApply.getContractNo());
        List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        this.calculateProductPrices(priceContract, products, details, customer.getPrecision());
        this.calculateRtnProductStocks(products, orderApply.getApplyerId(), orderApply.getId());
        this.calculateOrderMoney(orderApply, products, customer.getPrecision());
        Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
        Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
        this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("contractTotalMoney", (Object)contractTotalMoney);
        model.addAttribute("contractFullyMoney", (Object)contractFullyMoney);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("orgId", (Object)me.getCurrentPartner().getOrganizationid());
        Disposition dis = Cache.getDispositionFirst("acctID_display");
        if (Beans.isNotEmpty((Object)dis) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        return "orderrtn/approve.ftl";
    }

    @Override
    @RequestMapping(value={"/approve.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result approve_do(@Valid @RequestBody OrderApply order, BindingResult errors, HttpServletRequest request, Model model) {
        order.setNature(TCBJEnum.OrderNature.rtn.getValue());
        Employee me = this.getCurrentEmployee();
        OrderApply oldOrderApply = this.service.getSimpleOrderApply(order.getId());
        this.assertOrderExist(oldOrderApply);
        this.assertOrderCanApprove(oldOrderApply);
        if (!order.isPass()) {
            this.service.updateOrderApplyState(order.getId(), TCBJEnum.AuditState.cspapproveNoPass.getValue(), me);
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setCreateDt(DateUtils.now());
            auditInfo.setCreatorId(me.getId());
            auditInfo.setBusinessId(order.getId());
            auditInfo.setBusinessType("OrderApply");
            auditInfo.setOpinion(TCBJEnum.AuditState.cspapproveNoPass.getValue());
            auditInfo.setRemark(order.getRemark());
            this.auditService.add(auditInfo);
            return this.getSuccessResult(null);
        }
        this.assertApplyerIsValid(order.getApplyerId());
        order.setApproverId(me.getId());
        order.setApproveDt(DateUtils.now());
        order.setState(TCBJEnum.AuditState.cspapprove.getValue());
        this.stockService.getStorageQuantityByPartner(order.getSupplierId());
        Date regularDt = order.getDt() == null ? DateUtils.now() : order.getDt();
        Customer customer = this._getCustomer(order.getApplyerId(), order.getSupplierId());
        if (StringUtils.isEmpty(order.getSalesman()) || order.getSalesman().trim().toLowerCase().equals("null")) {
            order.setSalesman(customer.getCityManagerId());
        }
        PactMain contract = this.getPactMain(order.getApplyerId(), order.getSupplierId(), regularDt);
        this.assertContractIsExsit(contract);
        this.assertOrderSupplierIsEffective(order.getSupplierId());
        this.calculateOrderMoney(order, customer.getPrecision());
        for (OrderApplyItem item : order.getOrderApplyItems()) {
            item.fillInitData(me);
        }
        this.service.approveRtnOrderApply(order);
        if (order.isPass()) {
            this.service.triggerEAS(order.getId());
        }
        AuditInfo auditInfo = new AuditInfo(order.getId(), "OrderApply", order.getState(), order.getRemark(), me.getId(), DateUtils.now());
        auditInfo.setCreateDt(DateUtils.now());
        auditInfo.setCreatorId(me.getId());
        auditInfo.setBusinessId(order.getId());
        auditInfo.setBusinessType("OrderApply");
        auditInfo.setOpinion(TCBJEnum.AuditState.cspapprove.getValue());
        auditInfo.setRemark(order.getRemark());
        this.auditService.add(auditInfo);
        return this.getSuccessResult(null);
    }

    @Override
    @RequestMapping(value={"/del.do"})
    public String del(@RequestParam(value="id", required=false) String id, Model model) {
        super.del(id, model);
        return "redirect:applys.do?conscope=session";
    }

    @RequestMapping(value={"/export.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@RequestParam(value="id", required=false) String id, String code, HttpServletResponse response, Model model) {
        try {
            OrderApply orderApply = this.loadOrderApply(id, model);
            Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
            PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            List<OrderProduct> products = null;
            if (orderApply.isDraft() && "-1".equals(code)) {
                products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
                this.fillQuantityToProducts(orderApply, products);
                Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
                List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
                this.calculateProductPrices(contract, products, details, customer.getPrecision());
                this.calculateOrderMoney(orderApply, products, customer.getPrecision());
                Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
                Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
                orderApply.setRetunsFullyMoney(contractFullyMoney);
                this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
            } else {
                products = this.getProducts(orderApply);
            }
            List<RtnOrderExcel> excels = this.converExcel(products);
            String[] titles = new String[]{"\u4ea7\u54c1\u7f16\u53f7", "\u4ea7\u54c1\u540d\u79f0", "\u4ea7\u54c1\u89c4\u683c", "\u5355\u4f4d", "\u5305\u88c5\u6570", "\u9000\u8d27\u5355\u4ef7", "\u5e01\u79cd", "\u9000\u8d27\u6570\u91cf", "\u91d1\u989d", "\u6279\u6b21\u53f7"};
            String fileName = orderApply.getNo() == null ? "csp\u8349\u7a3f\u4ef6" : orderApply.getNo();
            ExcelUtils.exportExcel("\u9000\u8d27\u5355" + fileName + "-" + DateUtils.formartDate2((Date)new Date(), (String)"yyyy-MM-dd HH:mm:SS"), "\u9000\u8d27\u660e\u7ec6", titles, excels, response);
        }
        catch (Exception e) {
            throw new AppException("\u8ba2\u5355\u9000\u8d27\u5bfc\u51faexcel\u51fa\u73b0\u5f02\u5e38!", (Object)e);
        }
    }

    private List<RtnOrderExcel> converExcel(List<OrderProduct> products) {
        ArrayList<RtnOrderExcel> rtnProducts = new ArrayList<RtnOrderExcel>();
        if (products != null && products.size() > 0) {
            for (OrderProduct product : products) {
                if (!"PRODUCT".equals(product.getProductType())) continue;
                RtnOrderExcel rtnExcel = new RtnOrderExcel();
                rtnExcel.setProductno(product.getNo());
                rtnExcel.setProductName(product.getName());
                rtnExcel.setProductSpec(product.getSpec());
                rtnExcel.setUnitName(product.getUnitName());
                rtnExcel.setPackQty(product.getMinUnit());
                rtnExcel.setRtnPrice(product.getPrice());
                rtnExcel.setCurrencyName("\u5143");
                rtnExcel.setRtnQty(product.getActQuantity());
                rtnExcel.setAmount(product.getMoney());
                rtnExcel.setBatchNum(product.getBatchNum());
                rtnProducts.add(rtnExcel);
            }
        }
        return rtnProducts;
    }

    @RequestMapping(value={"/rtnView.do"}, method={RequestMethod.GET})
    public String rtnView(@RequestParam(value="id", required=false) String id, String code, Model model) {
        OrderApply orderApply = this.loadOrderApply(id, model);
        Date regularDt = orderApply.getDt() == null ? DateUtils.now() : orderApply.getDt();
        PactMain contract = this.getPactMain(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
        List<OrderProduct> products = null;
        if (orderApply.isDraft() && "-1".equals(code)) {
            products = this.getProducts(orderApply.getApplyerId(), orderApply.getSupplierId(), false);
            this.fillQuantityToProducts(orderApply, products);
            Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
            List<PrAdjdetail> details = this.priceAdjustService.getList(orderApply.getApplyerId(), orderApply.getSupplierId(), regularDt);
            this.calculateProductPrices(contract, products, details, customer.getPrecision());
            this.calculateOrderMoney(orderApply, products, customer.getPrecision());
            Double contractTotalMoney = this.calculateContractOrdersMoney(orderApply.getApplyerId(), orderApply.getContractNo());
            Double contractFullyMoney = this.calculateContractRtnOrdersFullyMoney(orderApply.getApplyerId(), orderApply.getContractNo(), orderApply.getId());
            orderApply.setRetunsFullyMoney(contractFullyMoney);
            this.calculateRtnOrderMoney(orderApply, contract, contractTotalMoney, contractFullyMoney, customer.getPrecision());
        } else {
            products = this.getProducts(orderApply);
        }
        model.addAttribute("products", (Object)JSON.toJSONString(products));
        model.addAttribute("contract", (Object)contract);
        model.addAttribute("auditInfos", this.auditService.find(id));
        return "orderrtn/view.ftl";
    }

    @Override
    @RequestMapping(value={"/balanceApprove.do"})
    public String balanceApprove(@RequestParam(value="id", required=false) String id, Model model) {
        model.addAttribute("balanceApprove", (Object)"true");
        return "forward:/rtnorderapply/view.do";
    }

    @RequestMapping(value={"/balanceApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result balanceApprove(@RequestParam(value="id", required=false) String id) {
        OrderApply order = this.service.getOrderApply(id);
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateBalanceApprove(id, this.getCurrentEmployee());
        return this.getSuccessResult(null);
    }

    @Override
    @RequestMapping(value={"/unApprove.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result unApprove_do(@RequestParam(value="id", required=false) String id, HttpServletRequest request, Model model) {
        OrderApply order = this.service.getOrderApply(id);
        this.getCurrentEmployee();
        if (order == null) {
            throw new AppException("3061");
        }
        this.service.updateUnApprove(id);
        ActivityHandler.submit(order, order.getState());
        return this.getSuccessResult(null);
    }

    @Override
    @RequestMapping(value={"/ordersExportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@ModelAttribute(value="condition") OrderApplyCondition con, HttpServletRequest request, Model model, HttpServletResponse response) throws Exception {
        con.setPageno(1);
        con.setPageSize(9999);
        this.approves(con, model);
        List orderApplys = ((Page)model.asMap().get("orderApplys")).getList();
        this.service.loadingOrderApply(orderApplys);
        File dir = new File(String.valueOf(StringUtils.getUploadPath()) + "orderExcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.excels(orderApplys, dir.getPath(), String.valueOf(this.getCurrentEmployee().getCurrentPartner().getNo()) + "-" + System.currentTimeMillis() + ".xls", this.getCurrentEmployee(), response);
    }

    @Override
    public void excels(List<OrderApply> orders, String path, String name, Employee em, HttpServletResponse response) throws IOException {
        File excelFile = new File(String.valueOf(path) + "\\" + name);
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        FileUtils.copyFile((File)new File(String.valueOf(request.getServletContext().getRealPath("/")) + "resource/orderrtn/ordersNew.xls"), (File)excelFile);
        FileInputStream fileInputStream = null;
        HSSFWorkbook wb = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(excelFile.getPath());
                wb = new HSSFWorkbook((InputStream)fileInputStream);
                HSSFSheet sheet = wb.getSheetAt(0);
                ArrayList rowDatas = new ArrayList();
                for (OrderApply orderApply : orders) {
                    Customer customer = this._getCustomer(orderApply.getApplyerId(), orderApply.getSupplierId());
                    for (OrderApplyItem orderApplyItem : orderApply.getOrderApplyItems()) {
                        HashMap<Integer, String> rowData = new HashMap<Integer, String>();
                        rowData.put(0, DateUtils.formartDate2((Date)orderApply.getDt(), (String)"yyyy-MM-dd"));
                        rowData.put(1, orderApply.getNo());
                        rowData.put(6, customer.getApplyerCode());
                        rowData.put(7, customer.getApplyerName());
                        rowData.put(8, customer.getApplyerCode());
                        rowData.put(9, customer.getApplyerName());
                        rowData.put(15, orderApply.getShippingAddress());
                        rowData.put(16, orderApply.getContacts());
                        rowData.put(17, orderApply.getPhone());
                        rowData.put(19, orderApply.getSettlementModeName());
                        rowData.put(32, Cache.getProductNo(orderApplyItem.getProductId()));
                        rowData.put(33, Cache.getProductName(orderApplyItem.getProductId()));
                        rowData.put(34, orderApplyItem.getUnitName());
                        rowData.put(35, String.valueOf(orderApplyItem.getActQuantity()));
                        rowData.put(39, String.valueOf(orderApplyItem.getPrice()));
                        rowData.put(40, String.valueOf(orderApplyItem.getPrice() * orderApplyItem.getQuantity()));
                        rowDatas.add(rowData);
                    }
                }
                int i = 0;
                while (i < rowDatas.size()) {
                    Map rowData = (Map)rowDatas.get(i);
                    HSSFRow row = sheet.createRow(i + 1);
                    for (Integer column : rowData.keySet()) {
                        HSSFCell cell = row.createCell(column.intValue());
                        cell.setCellValue((String)rowData.get(column));
                    }
                    ++i;
                }
                fileOutputStream = new FileOutputStream(excelFile.getPath());
                wb.write((OutputStream)fileOutputStream);
                ExcelUtil.download(excelFile.getPath(), response);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (wb != null) {
                    wb.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (wb != null) {
                wb.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

