/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.org;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.client.ClientCondition;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.org.OrgService;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.util.Page;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/org"})
public class OrgController
extends BaseController {
    @Autowired
    OrgService orgService;
    @Autowired
    ShopService shopService;
    @Autowired
    ClientService clientService;
    @Autowired
    PersonnelService personnelservice;

    @RequestMapping(value={"/ajaxGetChildNode.do"})
    public void ajaxGetChildNode(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        Employee em = this.getCurrentEmployee();
        try {
            String result = this.orgService.getChildNodeTree(id, em.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    @RequestMapping(value={"orgTree.do"}, method={RequestMethod.GET})
    public String tree(Model model) throws Exception {
        Employee e = this.getCurrentEmployee();
        Partner pt = this.personnelservice.getById(e.getCurrentPartner().getId());
        String tree = this.orgService.getOrgTree(pt);
        String orgId = e.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("tree", (Object)tree);
        return "org/orgTree.ftl";
    }

    @RequestMapping(value={"list.do"})
    public String getList(String orgId, ClientCondition con, ShopCondition shopCon, String code, String name, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @RequestParam(value="level", required=false) String level, Model model) {
        con.setPartnerId("");
        Employee e = this.getCurrentEmployee();
        if (level == null) {
            shopCon.setName(name);
            shopCon.setShopNumber(code);
            shopCon.setShopType(orgId);
            shopCon.setParentDealerId(e.getCurrentPartner().getId());
            Page shpPage = this.shopService.getShops(shopCon, pageno);
            model.addAttribute("shpPage", (Object)shpPage);
        } else {
            if (orgId == null || orgId.equals(e.getCurrentPartner().getId())) {
                con.setPartnerId(e.getCurrentPartner().getId());
            } else if (level.equals("2")) {
                con.setBigAreaCode(orgId);
                con.setPartnerId(e.getCurrentPartner().getId());
            } else if (level.equals("3")) {
                con.setAreaId(orgId);
                con.setPartnerId(e.getCurrentPartner().getId());
            } else {
                con.setPartnerId(orgId);
            }
            con.setApplyerCode(code);
            con.setName(name);
            con.setArea(false);
            Page page = this.clientService.findPartnerApplys(con, pageno);
            model.addAttribute("page", (Object)page);
        }
        model.addAttribute("name", (Object)name);
        model.addAttribute("code", (Object)code);
        return "org/list.ftl";
    }

    @RequestMapping(value={"view.do"})
    public String getView(@RequestParam(value="orgId", required=false) String orgId, String id, Model model) {
        Customer cm = this.clientService.getCustomer(id);
        model.addAttribute("cm", (Object)cm);
        return "org/view.ftl";
    }
}

