/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.pactMain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.client.PartnerShopService;
import com.tcbj.crm.entity.PactActivit;
import com.tcbj.crm.entity.PactBrand;
import com.tcbj.crm.entity.PactChannel;
import com.tcbj.crm.entity.PactExpense;
import com.tcbj.crm.entity.PactMain;
import com.tcbj.crm.entity.PactMbo;
import com.tcbj.crm.entity.PactResourc;
import com.tcbj.crm.entity.UpdateRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.pactMain.PactMainCondition;
import com.tcbj.crm.pactMain.PactMainService;
import com.tcbj.crm.updaterecord.UpdateRecordService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.PartnerShop;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pactMain"})
public class PactMainController
extends BaseController {
    @Autowired
    PactMainService pactmainservice;
    @Autowired
    ClientService clientService;
    @Autowired
    PartnerShopService partnerShopService;
    @Autowired
    UpdateRecordService updateRecordService;

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(Model model, HttpServletRequest request) throws Exception {
        Employee e = this.getCurrentEmployee();
        model.addAttribute("pname", (Object)e);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String date = sdf.format(new Date());
        model.addAttribute("sDate", (Object)(String.valueOf(date) + "-01-01"));
        model.addAttribute("eDate", (Object)(String.valueOf(date) + "-12-31"));
        return "pactmain/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody PactMain pactmain, String so, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.validataPactNo(pactmain.getPactNo(), e.getCurrentPartner().getId(), null);
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), null);
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        pactmain.fillInitData(e);
        if ("save".equals(so)) {
            pactmain.setPactState("1");
        } else {
            pactmain.setPactState("0");
        }
        this.pactmainservice.save(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "save".equals(so) ? "ADDANDSUBMIT" : "ADD", "");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPost(@Valid @RequestBody PactMain pactmain, String so, BindingResult errors, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.validataPactNo(pactmain.getPactNo(), e.getCurrentPartner().getId(), pactmain.getId());
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), pactmain.getId());
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        if ("save".equals(so)) {
            pactmain.setPactState("1");
        } else {
            pactmain.setPactState("0");
        }
        pactmain.fillInitData(e);
        this.pactmainservice.update(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "save".equals(so) ? "UPDATEANDSUBMIT" : "UPDATE", "");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editBo.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editBo(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactMbo(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u5408\u540c\u76ee\u6807");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactResourc.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactResourc(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactResourc(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u5408\u540c\u6295\u5165\u8d44\u6e90");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactChannel.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactChannel(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactChannel(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u6e20\u9053\u652f\u6301-\u9884\u7b97\u8d39\u7528\u7ba1\u7406");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactActivit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactActivit(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactActivit(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u5408\u540c\u6d3b\u52a8\u8ba1\u5212\u7ba1\u7406");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPactExpense.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactExpense(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactExpense(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u5408\u540c\u8d39\u7528\u6295\u5165\u9884\u7b97\u53ca\u5206\u62c5\u6bd4\u4f8b\u7ba1\u7406");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/list.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String list(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PactMainCondition condition, Model model, HttpServletRequest request) {
        Employee e = this.getCurrentEmployee();
        condition.setFirstParty(e.getCurrentPartner().getId());
        condition.setUserId(e.getId());
        model.addAttribute("page", (Object)this.pactmainservice.getList(pageno, condition));
        model.addAttribute("condition", (Object)condition);
        return "pactmain/list.ftl";
    }

    @RequestMapping(value={"/edit.do"}, method={RequestMethod.GET})
    public String editGet(String id, Model model, HttpServletRequest request) {
        if (id == null || "".equals(id)) {
            return "common/error.ftl";
        }
        Employee e = this.getCurrentEmployee();
        model.addAttribute("pname", (Object)e);
        PactMain pactmain = this.pactmainservice.get(id);
        List<PactResourc> pactResourcs = this.pactmainservice.getPactResourc(id);
        List<PactChannel> pactChannel = this.pactmainservice.getPactChannel(id);
        List<PactMbo> pactMbo = this.pactmainservice.getPactMbo(id);
        List<PactActivit> pactActivit = this.pactmainservice.getPactActivit(id);
        List<PactExpense> pactExpense = this.pactmainservice.getPactExpense(id);
        List<PactBrand> pactBrand = this.pactmainservice.getPactBrand(id);
        PartnerShop partnerShop = this.partnerShopService.get(pactmain.getApplyerId());
        model.addAttribute("RowGridData1", (Object)JSON.toJSONString(pactMbo));
        model.addAttribute("RowGridData2", (Object)JSON.toJSONString(pactResourcs));
        model.addAttribute("RowGridData3", (Object)JSON.toJSONString(pactChannel));
        model.addAttribute("RowGridData4", (Object)JSON.toJSONString(pactActivit));
        model.addAttribute("RowGridData5", (Object)JSON.toJSONStringWithDateFormat(pactExpense, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("RowGridData6", (Object)JSON.toJSONStringWithDateFormat(pactBrand, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("customer", (Object)this.clientService.getCustomerAlone(e.getCurrentPartner().getId(), pactmain.getApplyerId()));
        model.addAttribute("master", (Object)pactmain);
        model.addAttribute("partner", (Object)partnerShop);
        return "pactmain/edit.ftl";
    }

    @RequestMapping(value={"/delete.do"}, method={RequestMethod.GET})
    public String deleteGet(String id, Model model, HttpServletRequest request) {
        this.pactmainservice.delete(id);
        return "redirect:/pactMain/list.do";
    }

    @RequestMapping(value={"/getPartner.do"}, method={RequestMethod.POST})
    public void getPartner(String id, HttpServletResponse response) throws Exception {
        Employee me = this.getCurrentEmployee();
        PartnerShop partnerShop = this.partnerShopService.get(id);
        Customer customer = this.clientService.getCustomerAlone(me.getCurrentPartner().getId(), id);
        JSONObject rootNode = new JSONObject();
        rootNode.put("countyCode", (Object)partnerShop.getCountyName());
        rootNode.put("cityCode", (Object)partnerShop.getCityName());
        rootNode.put("provinceCode", (Object)partnerShop.getProvinceName());
        rootNode.put("saleChannelTypeCode", (Object)partnerShop.getSaleChannelTypeName());
        rootNode.put("bigAreaName", (Object)customer.getBigAreaName());
        rootNode.put("areaName", (Object)customer.getAreaName());
        rootNode.put("bigAreaManagerName", (Object)customer.getBigAreaManagerName());
        rootNode.put("areaManagerName", (Object)customer.getAreaManagerName());
        rootNode.put("applyerCode", (Object)customer.getApplyerCode());
        rootNode.put("saleChannelTypeCode", (Object)customer.getPartnerChnlTypeName());
        rootNode.put("cityManagerName", (Object)customer.getCityManagerName());
        response.getWriter().write(rootNode.toString());
    }

    @RequestMapping(value={"/submit.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result submit(String id, String status) {
        Employee e = this.getCurrentEmployee();
        PactMain pactmain = this.pactmainservice.get(id);
        this.pactmainservice.validataDate(pactmain.getStartDate(), pactmain.getEndDate(), pactmain.getApplyerId(), e.getCurrentPartner().getId(), pactmain.getId());
        boolean flag = pactmain.getStartDate().before(pactmain.getEndDate());
        if (!flag) {
            throw new AppException("1103");
        }
        this.pactmainservice.updateStatus(id, "1", e.getId());
        this.saveUpdateRecord(id, "SUBMIT", "");
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String del(String id, String status) {
        Employee e = this.getCurrentEmployee();
        this.pactmainservice.updateStatus(id, status, e.getId());
        this.saveUpdateRecord(id, "DISCARD", "");
        return "redirect:/pactMain/list.do";
    }

    @RequestMapping(value={"/look.do"}, method={RequestMethod.GET})
    public String look(String id, Model model) {
        Employee e = this.getCurrentEmployee();
        PactMain pactmain = this.pactmainservice.get(id);
        PartnerShop partnerShop = this.partnerShopService.get(pactmain.getApplyerId());
        model.addAttribute("customer", (Object)this.clientService.getCustomerAlone(e.getCurrentPartner().getId(), pactmain.getApplyerId()));
        model.addAttribute("master", (Object)pactmain);
        model.addAttribute("partner", (Object)partnerShop);
        List<PactResourc> pactResourcs = this.pactmainservice.getPactResourc(id);
        List<PactChannel> pactChannel = this.pactmainservice.getPactChannel(id);
        List<PactMbo> pactMbo = this.pactmainservice.getPactMbo(id);
        List<PactActivit> pactActivit = this.pactmainservice.getPactActivit(id);
        List<PactExpense> pactExpense = this.pactmainservice.getPactExpense(id);
        List<PactBrand> pactBrand = this.pactmainservice.getPactBrand(id);
        model.addAttribute("RowGridData1", (Object)JSON.toJSONString(pactMbo));
        model.addAttribute("RowGridData2", (Object)JSON.toJSONString(pactResourcs));
        model.addAttribute("RowGridData3", (Object)JSON.toJSONString(pactChannel));
        model.addAttribute("RowGridData4", (Object)JSON.toJSONString(pactActivit));
        model.addAttribute("RowGridData5", (Object)JSON.toJSONStringWithDateFormat(pactExpense, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("RowGridData6", (Object)JSON.toJSONStringWithDateFormat(pactBrand, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "pactmain/look.ftl";
    }

    public void saveUpdateRecord(String id, String type, String remark) {
        Employee e = this.getCurrentEmployee();
        PactMain pactmain = this.pactmainservice.get(id);
        HashMap<String, String> map = new HashMap<String, String>();
        PartnerShop partnerShop = this.partnerShopService.get(pactmain.getApplyerId());
        Customer customer = this.clientService.getCustomerAlone(e.getCurrentPartner().getId(), pactmain.getApplyerId());
        map.put("customer", JSON.toJSONString((Object)customer));
        map.put("master", JSON.toJSONString((Object)pactmain));
        map.put("partner", JSON.toJSONString((Object)partnerShop));
        List<PactResourc> pactResourcs = this.pactmainservice.getPactResourc(id);
        List<PactChannel> pactChannel = this.pactmainservice.getPactChannel(id);
        List<PactMbo> pactMbo = this.pactmainservice.getPactMbo(id);
        List<PactActivit> pactActivit = this.pactmainservice.getPactActivit(id);
        List<PactExpense> pactExpense = this.pactmainservice.getPactExpense(id);
        List<PactBrand> pactBrand = this.pactmainservice.getPactBrand(id);
        map.put("RowGridData1", JSON.toJSONString(pactMbo));
        map.put("RowGridData2", JSON.toJSONString(pactResourcs));
        map.put("RowGridData3", JSON.toJSONString(pactChannel));
        map.put("RowGridData4", JSON.toJSONString(pactActivit));
        map.put("RowGridData5", JSON.toJSONStringWithDateFormat(pactExpense, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        map.put("RowGridData6", JSON.toJSONStringWithDateFormat(pactBrand, (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        UpdateRecord updateRecord = new UpdateRecord();
        updateRecord.fillInitData(e);
        updateRecord.setOperationCode("pactMain");
        updateRecord.setDataMainId(id);
        updateRecord.setOperationType(type);
        updateRecord.setRemark(remark);
        updateRecord.setOperationData(JSON.toJSONString(map));
        this.updateRecordService.save(updateRecord);
    }

    @RequestMapping(value={"/updateRecordList.do"}, method={RequestMethod.GET})
    public String updateRecordList(String id, Model model) {
        List<UpdateRecord> updateRecords = this.updateRecordService.getByCodeAndId("pactMain", id, this.getCurrentEmployee());
        model.addAttribute("updateRecords", updateRecords);
        return "pactmain/updateRecordList.ftl";
    }

    @RequestMapping(value={"/lookUpdateRecord.do"}, method={RequestMethod.GET})
    public String lookUpdateRecord(String id, Model model) {
        UpdateRecord ur = this.updateRecordService.get(id);
        String jsonData = ur.getOperationData();
        Map map = (Map)JSON.parseObject((String)jsonData, Map.class);
        Customer customer = (Customer)JSON.parseObject((String)((String)map.get("customer")), Customer.class);
        PactMain pactmain = (PactMain)JSON.parseObject((String)((String)map.get("master")), PactMain.class);
        PartnerShop partnerShop = (PartnerShop)JSON.parseObject((String)((String)map.get("partner")), PartnerShop.class);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("master", (Object)pactmain);
        model.addAttribute("partner", (Object)partnerShop);
        model.addAttribute("RowGridData1", map.get("RowGridData1"));
        model.addAttribute("RowGridData2", map.get("RowGridData2"));
        model.addAttribute("RowGridData3", map.get("RowGridData3"));
        model.addAttribute("RowGridData4", map.get("RowGridData4"));
        model.addAttribute("RowGridData5", map.get("RowGridData5"));
        model.addAttribute("RowGridData6", map.get("RowGridData6"));
        return "pactmain/look.ftl";
    }

    @RequestMapping(value={"/editPactBrand.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editPactBrand(@Valid @RequestBody PactMain pactmain, Model model, HttpServletRequest request) {
        this.pactmainservice.updatePactBrand(pactmain);
        this.saveUpdateRecord(pactmain.getId(), "UPDATE", "\u4ec5\u4fee\u6539\u591a\u54c1\u724c\u5408\u540c\u6263\u7387");
        return this.getSuccessResult(null);
    }
}

