/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.dataSynchro.DataSynchroHandleService;
import com.tcbj.crm.entity.Disposition;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerContactRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.product.ProductService;
import com.tcbj.crm.shop.ShopCondition;
import com.tcbj.crm.siebel.service.PartnerSiebelService;
import com.tcbj.crm.storage.StorageService;
import com.tcbj.crm.upload.IUploadFile;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.crm.view.Product;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.ExcelUtil;
import com.tcbj.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/partner"})
public class PartnerController
extends BaseController {
    @Autowired
    PartnerService service;
    @Autowired
    ClientService clientService;
    @Autowired
    StorageService storageService;
    @Autowired
    Cache cache;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    ChannelTypeService channelTypeService;
    @Autowired
    DataSynchroHandleService dataSynchroHandle;
    @Autowired
    ProductService productService;
    static Map<String, String> errorMapForPartner = new LinkedHashMap<String, String>();

    @RequestMapping(value={"/applys.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        if (con == null) {
            con = new PartnerCondition();
        }
        Page Partners = null;
        con.setPartnerId(me.getCurrentPartner().getId());
        if ("person".equals(con.getType())) {
            con.setEmployeeId(me.getId());
            Partners = this.service.findPartnerApplys(con, pageno);
        } else {
            con.setEmployeeId(me.getId());
            Partners = this.service.findPartnerApplyCompanys(con, pageno);
        }
        model.addAttribute("partners", (Object)Partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/applys.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(@RequestParam(value="id", required=false) String id, Model model) {
        Disposition dis;
        Employee me = this.getCurrentEmployee();
        String orgId = me.getCurrentPartner().getId();
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        PartnerRecord partner = null;
        if (StringUtils.isEmpty(id)) {
            partner = new PartnerRecord();
            partner.setParentPartnerId(me.getCurrentPartner().getId());
            partner.initialize();
        } else {
            partner = this.service.getPartnerRecord(id);
        }
        boolean isOrg = partnerMy.isOrg();
        if (isOrg) {
            partner.setNo(StringUtils.delPrefix(partner.getNo()));
            model.addAttribute("isOrg", (Object)"true");
            model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        } else {
            model.addAttribute("isOrg", (Object)"false");
            partner.setNo(this.orderNoService.updateNo("100001", false));
        }
        if (StringUtils.isNotEmpty(partner.getClientAppNo())) {
            partner.setClientAppNo(partner.getClientAppNo().trim());
        }
        if (Beans.isNotEmpty((Object)(dis = Cache.getDispositionFirst("channel_display"))) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        model.addAttribute("product", (Object)new Product());
        model.addAttribute("orgId", (Object)orgId);
        partner.fillInitData(me);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/apply.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.setNo(partner.getNo().trim());
        if (StringUtils.isNotEmpty(partner.getClientAppNo())) {
            partner.setClientAppNo(partner.getClientAppNo().trim());
        }
        String partnerId = me.getCurrentPartner().getOrganizationid();
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        boolean isOrg = partnerMy.isOrg();
        if (isOrg) {
            partner.setNo(StringUtils.addPrefix(partner.getNo()));
        } else {
            partner.setNo(this.orderNoService.updateNo("100001", true));
        }
        if (StringUtils.isEmpty(partner.getId())) {
            this.validateName(partnerId, partner.getName(), null);
            this.validateNo(partnerId, partner.getNo(), null);
            this.validateClientAppNoOnly(partnerId, partner.getClientAppNo(), null, partner.getPartnerLevelCode());
        } else {
            this.validateName(partnerId, partner.getName(), partner.getId());
            this.validateNo(partnerId, partner.getNo(), partner.getId());
            this.validateClientAppNoOnly(partnerId, partner.getClientAppNo(), partner.getId(), partner.getPartnerLevelCode());
        }
        partner.fillInitData(me);
        partner.setApplyType(TCBJEnum.ApplyType.add.getValue());
        if (!TCBJEnum.ApplyState.audit.getValue().equals(partner.getApplyState())) {
            partner.setApplyState(TCBJEnum.ApplyState.draft.getValue());
        }
        if (StringUtils.isEmpty(partner.getId())) {
            this.service.add(partner, me);
        } else {
            this.service.update(partner, me);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/del"})
    public String del(String id, Model model) {
        this.service.del(id);
        return this.redirect("/partner/applys.do?type=person");
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = this.service.getPartnerRecord(id);
        String orgId = me.getCurrentPartner().getId();
        Disposition dis = Cache.getDispositionFirst("channel_display");
        if (Beans.isNotEmpty((Object)dis) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/look.ftl";
    }

    @RequestMapping(value={"/audits.do"})
    public String audits(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        if (!"dealing".equals(con.getAuditType()) && !"dealed".equals(con.getAuditType())) {
            throw new AppException("2003");
        }
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        Page audits = this.service.findPartnerAudits(con, pageno);
        model.addAttribute("audits", (Object)audits);
        return "partner/audits.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = this.service.getPartnerRecord(id);
        String orgId = me.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("me", (Object)me);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(@Valid @RequestBody Partner partner, Model model) {
        if (!partner.getApplyState().equals(TCBJEnum.ApplyState.pass.getValue()) && !partner.getApplyState().equals(TCBJEnum.ApplyState.notpass.getValue())) {
            partner.setApplyState(TCBJEnum.ApplyState.notpass.getValue());
        }
        Employee me = this.getCurrentEmployee();
        PartnerRecord partnerRecord = this.service.audit(partner.getId(), partner.getApplyState(), me, partner.getOpinion());
        if (Beans.isNotEmpty((Object)partnerRecord) && Beans.isNotEmpty((Object)partnerRecord.getSiebelId())) {
            this.dataSynchroHandle.saveThread(partnerRecord, Constant.CspDataSynchro.partner_audit.value, me);
        }
        if (partner.getApplyState().equals("2")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PartnerController.this.cache.initPartners();
                    PartnerController.this.cache.initCustomers();
                }
            }).start();
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.GET})
    public String edit(String id, Model model) {
        Disposition dis;
        Employee me = this.getCurrentEmployee();
        Partner partnerMy = this.service.getSimplePartner(me.getCurrentPartner().getId());
        boolean isOrg = partnerMy.isOrg();
        if (isOrg) {
            model.addAttribute("isOrg", (Object)"true");
        } else {
            model.addAttribute("isOrg", (Object)"false");
        }
        Partner partner = this.service.getPartner(id);
        Customer customer = this.clientService.getCustomer(partner.getParentPartnerId(), id);
        if (customer == null) {
            customer = new Customer();
        }
        model.addAttribute("customer", (Object)customer);
        if (StringUtils.isNotEmpty(partner.getClientAppNo())) {
            partner.setClientAppNo(partner.getClientAppNo().trim());
        }
        if (Beans.isNotEmpty((Object)(dis = Cache.getDispositionFirst("channel_display"))) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        String orgId = me.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(customer.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("partner", (Object)partner);
        return "partner/edit.ftl";
    }

    @RequestMapping(value={"/editPartner.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result edit_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        partner.setNo(partner.getNo().trim());
        if (StringUtils.isNotEmpty(partner.getClientAppNo())) {
            partner.setClientAppNo(partner.getClientAppNo().trim());
        }
        String partnerId = me.getCurrentPartner().getOrganizationid();
        this.validateName(partnerId, partner.getName(), partner.getId());
        this.validateNo(partnerId, partner.getNo(), partner.getId());
        this.validateClientAppNo(partnerId, partner.getClientAppNo(), partner.getId(), partner.getPartnerLevelCode());
        partner.fillInitData(me);
        partner.setApplyType(TCBJEnum.ApplyType.edit.getValue());
        partner.setApplyState(TCBJEnum.ApplyState.pass.getValue());
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setSiebelId(address.getId());
            address.fillInitData(me);
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.setSiebelId(contact.getId());
            contact.fillInitData(me);
        }
        List<PartnerContactRecord> partnerContactRecords = partner.getContacts();
        String[] stringArray = partner.getDelIds().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contactId = stringArray[n2];
            if (!StringUtils.isEmpty(contactId)) {
                PartnerContactRecord partnerContactRecord = new PartnerContactRecord();
                PartnerContact partnerContact = this.service.getPartnerContact(contactId);
                try {
                    BeanUtils.copyProperties((Object)partnerContactRecord, (Object)partnerContact);
                }
                catch (Exception exception) {
                    throw new AppException("2002");
                }
                partnerContactRecord.setIsContact("N");
                partnerContactRecord.fillInitData(me);
                partnerContactRecords.add(partnerContactRecord);
            }
            ++n2;
        }
        String siebelId = this.service.updatePartner(partner, me);
        if (StringUtils.isNotEmpty(siebelId)) {
            this.dataSynchroHandle.saveThread(partner, Constant.CspDataSynchro.partner_audit.value, me);
        }
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/viewself.do"}, method={RequestMethod.GET})
    public String viewself(Model model) {
        Employee me = this.getCurrentEmployee();
        String parPartnerId = me.getCurrentPartner().getParPartnerId();
        parPartnerId = StringUtils.isEmpty(parPartnerId) ? me.getCurrentPartner().getId() : parPartnerId;
        Customer customer = this.clientService.getCustomer(parPartnerId, me.getCurrentPartner().getId());
        model.addAttribute("customer", (Object)customer);
        Partner partner = this.service.getPartner(me.getCurrentPartner().getId());
        String orgId = me.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/viewself.ftl";
    }

    @RequestMapping(value={"/editself.do"}, method={RequestMethod.GET})
    public String editSelf(Model model) {
        String partnerId = this.getCurrentEmployee().getCurrentPartner().getId();
        Partner partner = this.service.getPartner(partnerId);
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("partner", (Object)partner);
        return "partner/editself.ftl";
    }

    @RequestMapping(value={"/editself.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result editSelf_do(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        Employee me = this.getCurrentEmployee();
        String partnerId = me.getCurrentPartner().getId();
        Partner old = this.service.getPartner(partnerId);
        PartnerRecord newPartner = new PartnerRecord();
        try {
            BeanUtils.copyProperties((Object)newPartner, (Object)old);
        }
        catch (Exception exception) {
            throw new AppException("2002");
        }
        newPartner.setSiebelId(newPartner.getId());
        newPartner.setId(null);
        newPartner.fillInitData(me);
        newPartner.setParentPartnerId(old.getParentPartnerId());
        newPartner.setFax(partner.getFax());
        newPartner.setPhone(partner.getPhone());
        newPartner.setAddress(partner.getAddress());
        newPartner.setIsReport(partner.getIsReport());
        newPartner.setContacts(partner.getContacts());
        newPartner.setApplyType(TCBJEnum.ApplyType.edit.getValue());
        newPartner.setApplyState(TCBJEnum.ApplyState.pass.getValue());
        for (PartnerContactRecord contact : newPartner.getContacts()) {
            contact.fillInitData(me);
        }
        List<PartnerContactRecord> partnerContactRecords = partner.getContacts();
        String[] stringArray = partner.getDelIds().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contactId = stringArray[n2];
            if (!StringUtils.isEmpty(contactId)) {
                PartnerContactRecord partnerContactRecord = new PartnerContactRecord();
                PartnerContact partnerContact = this.service.getPartnerContact(contactId);
                if (partnerContact != null) {
                    try {
                        BeanUtils.copyProperties((Object)partnerContactRecord, (Object)partnerContact);
                    }
                    catch (Exception exception) {
                        throw new AppException("2002");
                    }
                    partnerContactRecord.setIsContact("N");
                    partnerContactRecord.fillInitData(me);
                    partnerContactRecords.add(partnerContactRecord);
                }
            }
            ++n2;
        }
        this.service.updateMyPartner(newPartner);
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/findPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findPartners(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        Page partners = this.service.findPartners(con, pageno, null);
        model.addAttribute("partners", (Object)partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/finds.ftl";
    }

    @RequestMapping(value={"/viewPartner.do"}, method={RequestMethod.GET})
    public String viewPartner(@RequestParam(value="id", required=true) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        Partner partner = this.service.getPartner(id);
        model.addAttribute("partner", (Object)partner);
        Customer customer = this.clientService.getCustomer(partner.getParentPartnerId(), id);
        if (customer == null) {
            customer = new Customer();
        }
        model.addAttribute("customer", (Object)customer);
        Disposition dis = Cache.getDispositionFirst("channel_display");
        if (Beans.isNotEmpty((Object)dis) && "true".equals(dis.getVal())) {
            model.addAttribute("display", (Object)"true");
        } else {
            model.addAttribute("display", (Object)"false");
        }
        String orgId = me.getCurrentPartner().getId();
        model.addAttribute("orgId", (Object)orgId);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(customer.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("hideaudit", (Object)"true");
        return "partner/view.ftl";
    }

    @RequestMapping(value={"/findNextPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findNextPartners(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getOrganizationid());
        con.setEmployeeId(me.getId());
        if (StringUtils.isEmpty(con.getFormSign())) {
            model.addAttribute("condition", (Object)con);
            return "partner/nextFinds.ftl";
        }
        Page partners = this.service.findPartners(con, pageno, "next");
        model.addAttribute("partners", (Object)partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/nextFinds.ftl";
    }

    @RequestMapping(value={"/findRecords.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String findRecords(String id, @RequestParam(value="pageno", required=false, defaultValue="1") int pageno, Model model) {
        Page partners = this.service.findPartnerRecords(id, pageno);
        model.addAttribute("partners", (Object)partners);
        return "partner/records.ftl";
    }

    @RequestMapping(value={"partnerTree.do"})
    public String tree(Model model) throws JSONException {
        Employee e = this.getCurrentEmployee();
        Partner p = this.service.getPartner(e.getCurrentPartner().getId());
        String tree = this.service.partnerTree(p);
        model.addAttribute("isMultipleChoice", (Object)"false");
        model.addAttribute("tree", (Object)tree);
        return "partner/partnerTree.ftl";
    }

    @RequestMapping(value={"/ajaxGetChild.do"})
    public void ajaxGetChildNode1(String id, HttpServletResponse response) throws JSONException, UnsupportedEncodingException {
        try {
            Employee e = this.getCurrentEmployee();
            String result = this.service.getChildTree(id, e.getCurrentPartner().getId());
            response.getWriter().write(result);
        }
        catch (Exception exception) {}
    }

    private void validateNo(String partnerId, String no, String id) {
        boolean isPartnerRecord = this.service.isPartnerRecord(partnerId, no, id);
        boolean isPartner = this.service.isPartnerNo(partnerId, no, id);
        if (isPartnerRecord && isPartner) {
            throw new AppException("2003");
        }
    }

    private void validateRelatedDelear(String partnerId) {
        Customer customer = Cache.getApplyer(partnerId);
        if (customer.getRelatedDelearId() != null) {
            throw new AppException("9401");
        }
    }

    private void validateNo(String no, String id) {
        boolean isPartnerRecord = this.service.isPartnerRecord(no, id);
        boolean isPartner = this.service.isPartnerNo(no, id);
        if (isPartnerRecord && isPartner) {
            throw new AppException("2003");
        }
    }

    private void validateName(String partnerId, String name, String id) {
        boolean isPartnerRecordName = this.service.isPartnerRecordName(partnerId, name, id);
        boolean isPartnerName = this.service.isPartnerName(partnerId, name, id);
        if (isPartnerRecordName && isPartnerName) {
            throw new AppException("2006");
        }
    }

    private void validateClientAppNo(String partnerId, String clientAppNo, String id, String partnerLevelCode) {
        boolean isPartnerRecordClientAppNo = this.service.isPartnerRecordClientAppNo(partnerId, clientAppNo, id, partnerLevelCode);
        boolean isPartnerClientAppNo = this.service.isPartnerClientAppNo(partnerId, clientAppNo, id, partnerLevelCode);
        if (isPartnerRecordClientAppNo && isPartnerClientAppNo) {
            throw new AppException("2007");
        }
    }

    private void validateClientAppNoOnly(String partnerId, String clientAppNo, String id, String partnerLevelCode) {
        boolean isPartnerRecordClientAppNo = this.service.isPartnerRecordClientAppNo(partnerId, clientAppNo, id, partnerLevelCode);
        if (isPartnerRecordClientAppNo) {
            throw new AppException("2007");
        }
    }

    @RequestMapping(value={"/selectSubPartners.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public String selectSubPartners(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, @ModelAttribute(value="condition") PartnerCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        Page partners = this.service.findSubPartners(con, me, pageno);
        model.addAttribute("partners", (Object)partners);
        model.addAttribute("me", (Object)me);
        model.addAttribute("condition", (Object)con);
        return "partner/subPartners.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.GET})
    public String addGet(@RequestParam(value="id", required=false) String id, Model model) {
        Employee me = this.getCurrentEmployee();
        PartnerRecord partner = null;
        if (StringUtils.isEmpty(id)) {
            partner = new PartnerRecord();
            partner.initialize();
        } else {
            partner = this.service.getPartnerRecord(id);
        }
        partner.setNo(StringUtils.delPrefix(partner.getNo()));
        partner.fillInitData(me);
        model.addAttribute("prefix", (Object)StringUtils.getPrefix());
        model.addAttribute("orgId", (Object)StringUtils.getOrgId());
        model.addAttribute("partner", (Object)partner);
        model.addAttribute("addresses", (Object)JSON.toJSONStringWithDateFormat(partner.getAddresses(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        model.addAttribute("contacts", (Object)JSON.toJSONStringWithDateFormat(partner.getContacts(), (String)"yyyy-MM-dd", (SerializerFeature[])new SerializerFeature[0]));
        return "partner/add.ftl";
    }

    @RequestMapping(value={"/add.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result addPost(@Valid @RequestBody PartnerRecord partnerRecord, Model model) {
        Employee me = this.getCurrentEmployee();
        String partnerId = me.getCurrentPartner().getOrganizationid();
        partnerRecord.setNo(StringUtils.addPrefix(partnerRecord.getNo()));
        if (StringUtils.isNotEmpty(partnerRecord.getClientAppNo())) {
            partnerRecord.setClientAppNo(partnerRecord.getClientAppNo().trim());
        }
        if (!StringUtils.isEmpty(partnerRecord.getRelatedDelearId())) {
            this.validateRelatedDelear(partnerRecord.getRelatedDelearId());
        }
        this.validateName(me.getCurrentPartner().getOrganizationid(), partnerRecord.getName(), null);
        this.validateNo(partnerRecord.getNo(), null);
        this.validateClientAppNo(partnerId, partnerRecord.getClientAppNo(), null, partnerRecord.getPartnerLevelCode());
        Partner partnerMy = this.service.getSimplePartner(partnerRecord.getParentPartnerId());
        partnerRecord.setMasterOuId(partnerMy.getMasterOuId());
        for (PartnerAddressRecord address : partnerRecord.getAddresses()) {
            address.fillInitData(me);
        }
        for (PartnerContactRecord contact : partnerRecord.getContacts()) {
            contact.fillInitData(me);
        }
        partnerRecord.fillInitData(me);
        String siebelId = this.service.addSiebel(partnerRecord, me);
        if (StringUtils.isNotEmpty(siebelId)) {
            this.dataSynchroHandle.saveThread(partnerRecord, Constant.CspDataSynchro.partner_audit.value, me);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                PartnerController.this.cache.initPartners();
                PartnerController.this.cache.initCustomers();
            }
        };
        t.start();
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/exportExcel.do"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportExcel(@ModelAttribute(value="condition") PartnerCondition con, HttpServletResponse response) {
        Employee me = this.getCurrentEmployee();
        con.setPartnerId(me.getCurrentPartner().getId());
        con.setEmployeeId(me.getId());
        List<Object> partnersAndCustomers = this.service.findPartnersAndCustomers(con);
        File dir = new File(String.valueOf(StringUtils.getUploadPath()) + "partnerexcel");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PartnerController.excels(partnersAndCustomers, dir.getPath(), String.valueOf(me.getCurrentPartner().getNo()) + "-" + DateUtils.getCurrentDate((String)"yyyyMMdd") + ".xls", response);
    }

    public static boolean excels(List<Object> list, String path, String name, HttpServletResponse response) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(name);
        HSSFRow row = sheet.createRow(0);
        String[] names = new String[]{"\u7ecf\u9500\u5546\u540d\u79f0", "\u7b80\u79f0", "\u52a9\u8bb0\u7801\u7f16\u53f7", "\u4e0a\u7ea7\u7ecf\u9500\u5546", "\u7ecf\u9500\u5546\u7b49\u7ea7", "\u7ec4\u7ec7\u5206\u7c7b", "\u6e20\u9053\u7c7b\u578b", "\u5927\u533a", "\u533a\u57df", "\u5927\u533a\u7ecf\u7406", "\u533a\u57df\u7ecf\u7406", "\u5916\u56f4\u7cfb\u7edf\u7f16\u53f7", "\u57ce\u5e02\u7ecf\u7406", "\u5e02\u573a\u4ee3\u8868", "\u5173\u8054\u4ea4\u6613\u7ecf\u9500\u5546", "\u7701\u4efd", "\u57ce\u5e02", "\u53bf\uff08\u533a\uff09", "\u4fe1\u7528\u7b49\u7ea7", "\u662f\u5426\u4fe1\u7528\u7ba1\u7406", "\u8d22\u52a1\u7ed3\u7b97\u65b9\u5f0f", "\u5e01\u79cd", "\u5f00\u59cb\u65e5\u671f", "\u7ed3\u675f\u65e5\u671f", "\u8d2d\u9500\u6a21\u5f0f", "\u7a0e\u52a1\u767b\u8bb0\u53f7", "\u7eb3\u7a0e\u767b\u8bb0\u53f7", "\u9500\u552e\u7a0e\u7801", "\u8ba2\u5355\u7c7b\u578b", "\u9000\u8d27\u8ba2\u5355\u7c7b\u578b", "\u662f\u5426\u4e0b\u5355\u63a7\u5236\u5355\u54c1\u6570\u91cf", "\u53d1\u8d27\u4f18\u5148\u7ea7", "\u662f\u5426\u8ba2\u5355\u51bb\u7ed3", "\u662f\u5426\u53d1\u8d27\u51bb\u7ed3", "\u5f00\u7968\u7c7b\u578b", "\u662f\u5426\u5f00\u7968\u51bb\u7ed3", "\u662f\u5426\u968f\u6279\u62a5\u544a", "\u662f\u5426\u663e\u793a\u7ec4\u7ec7\u5e93\u5b58\u91cf", "\u8fd0\u8f93\u5728\u9014\u671f", "\u4ea4\u8d27\u65b9\u5f0f", "\u7ecf\u9500\u5546\u8865\u8d27\u7cfb\u6570", "\u662f\u5426\u8865\u8d27\u8ba1\u7b97", "\u5e93\u5b58\u63a5\u6536\u65b9\u5f0f", "\u8d60\u54c1\u63a7\u5236\u65b9\u5f0f", "\u662f\u5426\u9000\u8d27\u51b2\u51cf\u8d60\u54c1\u4f59\u989d", "\u8d60\u54c1\u53ca\u7269\u6599\u662f\u5426\u6700\u5c0f\u5305\u88c5\u6570\u63a7\u5236", "\u662f\u5426\u65e0\u8d27\u53ef\u8ba2\u8d2d", "\u4ef7\u683c\u5c0f\u6570\u4f4d", "\u4ea7\u54c1\u662f\u5426\u5305\u88c5\u500d\u6570\u63a7\u5236", "\u56fa\u5b9a\u7535\u8bdd", "\u56fa\u5b9a\u4f20\u771f", "\u529e\u516c\u5730\u5740"};
        int i = 0;
        while (i < names.length) {
            row.createCell(i).setCellValue(names[i]);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            row = sheet.createRow(i + 1);
            Object[] obj = (Object[])list.get(i);
            Partner p = (Partner)obj[0];
            Customer c = (Customer)obj[1];
            String[] vals = new String[]{p.getName(), p.getShortName(), p.getNo(), p.getParentPartnerName(), p.getPartnerLevelName(), p.getOrgTypeName(), p.getSaleChannelTypeName(), c.getBigAreaName(), c.getAreaName(), c.getBigAreaManagerName(), c.getAreaManagerName(), p.getClientAppNo(), c.getCityManagerName(), c.getMarketManagerName(), c.getRelatedDelearName(), p.getProvinceName(), p.getCityName(), p.getCountyName(), c.getCreditLevelName(), c.getIsCreditManagedName(), c.getSettlementModeName(), c.getCurrencyName(), Beans.isEmpty((Object)c.getStartdate()) ? "" : DateUtils.formartDate((Date)c.getStartdate(), (String)"yyyy-MM-dd"), Beans.isEmpty((Object)c.getEnddate()) ? "" : DateUtils.formartDate((Date)c.getEnddate(), (String)"yyyy-MM-dd"), c.getPurchaseSaleName(), p.getTaxNo(), p.getTaxRegistNo(), c.getSaleTaxName(), c.getOrderTypeName(), c.getRtnOrderTypeName(), p.getIsStockReceivedName(), c.getDeliveryLevelName(), c.getIsOrderFreezedName(), c.getIsDeliveryFreezedName(), c.getInvoiceTypeName(), c.getIsInvoiceFreezedName(), p.getIsReportName(), c.getIsStockShowName(), Beans.isNotEmpty((Object)c.getTransportOnlineCode()) ? c.getTransportOnlineCode().toString() : "", c.getDeliveryCodeName(), Beans.isNotEmpty((Object)c.getAdditionalRatio()) ? c.getAdditionalRatio().toString() : "", c.getIsAdditionalCalName(), c.getStockReceiveTypeName(), c.getGiftCtrlModeName(), c.gettHCJGiftBalanceName(), c.getZxbzsFlgName(), c.getNothingCanOrderFlgName(), c.getPriceDecimalDigitsName(), c.getPackCtrlFlgName(), p.getPhone(), p.getFax(), p.getAddress()};
            int j = 0;
            while (j < vals.length) {
                row.createCell(j).setCellValue(vals[j]);
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream fout = new FileOutputStream(String.valueOf(path) + "\\" + name);
            wb.write((OutputStream)fout);
            ExcelUtil.download(String.valueOf(path) + "\\" + name, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @RequestMapping(value={"partnerImportExcel.do"}, method={RequestMethod.GET})
    public String toPartnerExcel(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("con", (Object)con);
        return "partner/partnerImportExcel.ftl";
    }

    @RequestMapping(value={"partnerAddressImportExcel.do"}, method={RequestMethod.GET})
    public String toPartnerAddressExcel(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("con", (Object)con);
        return "partner/partnerAddressImportExcel.ftl";
    }

    @RequestMapping(value={"/partnerImportExcel.do"}, method={RequestMethod.POST})
    public String partnerBatchadd(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "partnerImport");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<PartnerRecord> list = new ArrayList<PartnerRecord>();
        ArrayList<AdjustStockUtil> msglist = new ArrayList();
        msglist = this.service.ReadPartnerByExcel(url, em, list);
        return this.excelReturn(con, list, msglist, filelist, model);
    }

    @RequestMapping(value={"/partnerAddressImportExcel.do"}, method={RequestMethod.POST})
    public String partnerAddressBatchadd(ShopCondition con, Model model, HttpServletRequest request) throws Exception {
        Employee em = this.getCurrentEmployee();
        List<IUploadFile> filelist = this.uploadFile(request, "partnerAddressImport");
        String url = "";
        if (filelist.size() > 0) {
            url = filelist.get(0).getRealPath();
        }
        ArrayList<PartnerAddressRecord> list = new ArrayList<PartnerAddressRecord>();
        ArrayList<AdjustStockUtil> msglist = new ArrayList();
        msglist = this.service.ReadPartnerAddressByExcel(url, em, list);
        return this.excelAddressReturn(con, list, msglist, filelist, model);
    }

    @RequestMapping(value={"/showError.do"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Result showError(Model model) throws Exception {
        model.addAttribute("errorMap", errorMapForPartner);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer("");
        Set<String> keys = errorMapForPartner.keySet();
        for (String key : keys) {
            sb.append("\u4e0a\u4f20\u65f6\u95f4\uff1a");
            sb.append(sdf.format(new Date(Long.valueOf(key))));
            sb.append("\u6267\u884c\u7ed3\u679c\uff1a");
            sb.append(errorMapForPartner.get(key));
        }
        return this.getSuccessResult(sb.toString());
    }

    private String excelReturn(ShopCondition con, final List<PartnerRecord> list, List<AdjustStockUtil> msglist, List<IUploadFile> filelist, Model model) {
        final Employee me = this.getCurrentEmployee();
        String rtn = null;
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (list.size() < 1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        Set<String> keys = errorMapForPartner.keySet();
        for (String key : keys) {
            errorMapForPartner.remove(key);
        }
        final String id = String.valueOf(System.currentTimeMillis());
        Thread t = new Thread(){

            @Override
            public void run() {
                String rtnStr = "";
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PartnerSiebelService ss = new PartnerSiebelService();
                    PartnerRecord pr = (PartnerRecord)iterator.next();
                    String siebelId = ss.addOrUpdatePartnerToSiebel(pr, 0);
                    if (Beans.isNotEmpty((Object)siebelId)) {
                        pr.setSiebelId(siebelId);
                        PartnerController.this.service.add(pr, me);
                        continue;
                    }
                    rtnStr = pr.getNo();
                }
                if (rtnStr != null && "".equals(rtnStr)) {
                    errorMapForPartner.put(id, "\u6267\u884c\u5b8c\u6210");
                } else {
                    errorMapForPartner.put(id, rtnStr);
                }
                PartnerController.this.cache.initPartners();
                PartnerController.this.cache.initCustomers();
            }
        };
        errorMapForPartner.put(id, "\u6267\u884c\u4e2d");
        t.start();
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }

    private String excelAddressReturn(ShopCondition con, List<PartnerAddressRecord> list, List<AdjustStockUtil> msglist, List<IUploadFile> filelist, Model model) {
        Employee me = this.getCurrentEmployee();
        String rtn = null;
        if (list.size() < 1) {
            rtn = JSON.toJSONString((Object)this.getErrorResult(String.valueOf(filelist.get(0).getName()) + " \u8be5\u6587\u4ef6\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6"));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        if (msglist.size() > 0) {
            rtn = JSON.toJSONString((Object)this.getSuccessResult(JSON.toJSONString(msglist)));
            model.addAttribute("rtn", (Object)rtn);
            return "common/iframeRtn.ftl";
        }
        Set<String> keys = errorMapForPartner.keySet();
        for (String key : keys) {
            errorMapForPartner.remove(key);
        }
        final String id = String.valueOf(System.currentTimeMillis());
        final ArrayList<PartnerRecord> partners = new ArrayList<PartnerRecord>();
        for (PartnerAddressRecord par : list) {
            ArrayList<PartnerAddressRecord> pars = new ArrayList<PartnerAddressRecord>();
            pars.add(par);
            this.service.addAddress(pars, par.getPartnerId(), me);
            PartnerRecord pr = this.service.getPartnerRecord(par.getPartnerId());
            partners.add(pr);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                String rtnStr = PartnerController.this.service.partnerAddressToSiebelBatchAdd(partners);
                if (rtnStr != null && "".equals(rtnStr)) {
                    errorMapForPartner.put(id, "\u6267\u884c\u5b8c\u6210");
                } else {
                    errorMapForPartner.put(id, rtnStr);
                }
                PartnerController.this.cache.initPartners();
                PartnerController.this.cache.initCustomers();
            }
        };
        errorMapForPartner.put(id, "\u6267\u884c\u4e2d");
        t.start();
        rtn = JSON.toJSONString((Object)this.getSuccessResult(null));
        model.addAttribute("rtn", (Object)rtn);
        return "common/iframeRtn.ftl";
    }
}

