/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partner;

import com.tcbj.crm.adjuststock.AdjustStockUtil;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.cache.ImportDataValidateService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.PartnerAddressRecord;
import com.tcbj.crm.entity.PartnerContactRecord;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.partner.PartnerCondition;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.siebel.service.PartnerSiebelService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.DictionaryItem;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.PartnerAddress;
import com.tcbj.crm.view.PartnerContact;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.Excels;
import com.tcbj.util.StringUtils;
import com.tcbj.util.UUIDUtils;
import com.tcbj.util.ValidataUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="partnerService")
public class PartnerService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private PersonnelService personnelService;
    @Autowired
    private ShopService shopSerivce;
    @Autowired
    ImportDataValidateService validateService;

    @PostConstruct
    public void init() {
    }

    public List<EmployeePartner> findEmployeePartners(String employeeId) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from EmployeePartner where personId=? and type='Partner'");
        args.add(employeeId);
        return this.baseDao.findEntity(hql.toString(), args.toArray(), EmployeePartner.class);
    }

    public Page findPartners(PartnerCondition con, int pageno, String from) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        if ("next".equals(from)) {
            hql.append("select p from Partner p,Customer c where 1=1");
            hql.append(" and p.id = c.applyerId and p.parentPartnerId is not null and c.supplierId  != ? ");
        } else {
            hql.append("from Partner p,Customer c where ");
            hql.append(" (c.bigAreaCode in ( ");
            hql.append(sb);
            hql.append(") or c.areaCode in ( ");
            hql.append(sb);
            hql.append(" ))");
            hql.append(" and p.id = c.applyerId and c.supplierId  = ? ");
        }
        args.add(con.getPartnerId());
        hql.append(" and p.masterOuId = ? ");
        args.add(StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and c.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql.append(" and c.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql.append(" and c.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql.append(" and c.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql.append(" and c.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql.append(" order by p.createDt desc");
        Page page = new Page();
        ArrayList<Partner> list = new ArrayList<Partner>();
        if ("next".equals(from)) {
            List lists = this.baseDao.findEntity(hql.toString(), args.toArray());
            for (Object object : lists) {
                Partner _1pPartner;
                Partner partner = (Partner)object;
                if (StringUtils.isEmpty(partner.getParentPartnerId()) || (_1pPartner = this.getTopPartner(partner.getParentPartnerId())) == null) continue;
                Customer customer = null;
                customer = Cache.getCustomer(String.valueOf(con.getPartnerId()) + "-" + _1pPartner.getId());
                if (customer == null) continue;
                if (sb.contains(customer.getBigAreaCode())) {
                    list.add(partner);
                    continue;
                }
                if (!StringUtils.isNotEmpty(customer.getAreaCode()) || !sb.contains(customer.getAreaCode())) continue;
                list.add(partner);
            }
        } else {
            page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
            List obgs = page.getList();
            for (Object[] objects : obgs) {
                list.add((Partner)objects[0]);
            }
        }
        page.setList(list);
        return page;
    }

    private Partner getTopPartner(String partnerId) {
        Partner partnerOrg1 = Cache.getPartner(partnerId);
        if (partnerOrg1 == null || partnerOrg1.isOrg()) {
            return null;
        }
        Partner partnerOrg2 = Cache.getPartner(partnerOrg1.getParentPartnerId());
        if (partnerOrg2.isOrg()) {
            return partnerOrg1;
        }
        Partner partner3 = Cache.getPartner(partnerOrg2.getParentPartnerId());
        if (partner3.isOrg()) {
            return partnerOrg2;
        }
        Partner partner4 = Cache.getPartner(partner3.getParentPartnerId());
        if (partner4.isOrg()) {
            return partner3;
        }
        Partner partner5 = Cache.getPartner(partner4.getParentPartnerId());
        if (partner5.isOrg()) {
            return partner4;
        }
        return null;
    }

    public Page findPartnerRecords(String siebelId, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PartnerRecord where siebelId=?");
        args.add(siebelId);
        hql.append(" order by createDt desc ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplys(PartnerCondition con, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql.append("from PartnerRecord where applyType <> '2' and parentPartnerId=?");
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getEmployeeId())) {
            hql.append(" and creatorId = ?");
            args.add(con.getEmployeeId());
        }
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql.append(" and createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql.append(" and createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql.append(" and applyState = ?");
            args.add(con.getApplyState());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql.append(" and saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql.append(" and areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql.append(" and bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql.append(" and cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql.append(" and marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql.append(" order by lastUpdateDt desc,applyState ");
        return this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public Page findPartnerApplyCompanys(PartnerCondition con, int pageno) {
        StringBuffer hql2 = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql2.append("select p.id from PartnerRecord p ,ContactRegion c ,Region r where ((p.bigAreaCode = c.regionId and c.userId = ?) or (p.areaCode = c.regionId and c.userId = ?)) and p.applyType <> '2' ");
        args.add(con.getEmployeeId());
        args.add(con.getEmployeeId());
        hql2.append(" and c.regionId = r.id ");
        hql2.append(" and c.startDate <= ? and nvl(c.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql2.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql2.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql2.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql2.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql2.append(" and p.applyState = ?");
            args.add(con.getApplyState());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql2.append(" and p.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql2.append(" and p.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql2.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql2.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql2.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql2.append(" and p.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql2.append(" and p.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql2.append(" and p.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql2.append(" and p.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql2.append(" order by p.lastUpdateDt desc,p.applyState ");
        List idlist = this.baseDao.findEntity(hql2.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object element : idlist) {
            set.add((String)element);
        }
        if (set.size() > 0) {
            Object element;
            String pf = " ";
            element = set.iterator();
            while (element.hasNext()) {
                String cfr_ignored_0 = (String)element.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql = " from PartnerRecord p where p.id in ( " + pf + ")";
            Page page = this.baseDao.search(hql, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    public Page findPartnerAudits(PartnerCondition con, int pageno) {
        StringBuffer hql2 = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        hql2.append("select p.id from PartnerRecord p ,ContactRegion c ,Region r where ((p.bigAreaCode = c.regionId and c.userId = ?) or (p.areaCode = c.regionId and c.userId = ?)) and p.applyType <> '2' ");
        args.add(con.getEmployeeId());
        args.add(con.getEmployeeId());
        hql2.append(" and c.regionId = r.id ");
        hql2.append(" and c.startDate <= ? and nvl(c.endDate,?) >= ? ");
        args.add(DateUtils.now());
        args.add(DateUtils.getEndTime());
        args.add(DateUtils.now());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql2.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql2.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql2.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql2.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getApplyState())) {
            hql2.append(" and p.applyState = ?");
            args.add(con.getApplyState());
        }
        if ("dealing".equals(con.getAuditType())) {
            hql2.append(" and p.applyState = ?");
            args.add(TCBJEnum.ApplyState.audit.getValue());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql2.append(" and p.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql2.append(" and p.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql2.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql2.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql2.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql2.append(" and p.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql2.append(" and p.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql2.append(" and p.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql2.append(" and p.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        if ("dealed".equals(con.getAuditType())) {
            hql2.append(" and (p.applyState = ? or p.applyState=?)");
            args.add(TCBJEnum.ApplyState.pass.getValue());
            args.add(TCBJEnum.ApplyState.notpass.getValue());
        }
        hql2.append(" order by p.lastUpdateDt desc,p.applyState ");
        List idlist = this.baseDao.findEntity(hql2.toString(), args.toArray(), Object.class);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object element : idlist) {
            set.add((String)element);
        }
        if (set.size() > 0) {
            Object element;
            String pf = " ";
            element = set.iterator();
            while (element.hasNext()) {
                String cfr_ignored_0 = (String)element.next();
                pf = String.valueOf(pf) + "?,";
            }
            pf = pf.substring(0, pf.length() - 1);
            String hql = " from PartnerRecord p where p.id in ( " + pf + ")";
            Page page = this.baseDao.search(hql, set.toArray(), Constant.DEFAULT_ROWS, pageno);
            return page;
        }
        return new Page(new ArrayList(), 1, Constant.DEFAULT_ROWS, 0);
    }

    private List<PartnerAddressRecord> getAddresses(String id) {
        String hql = "from PartnerAddressRecord where partnerId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerAddressRecord.class);
    }

    private List<PartnerContactRecord> getContacts(String id) {
        String hql = "from PartnerContactRecord where partnerId=?";
        Object[] args = new Object[]{id};
        return this.baseDao.findEntity(hql, args, PartnerContactRecord.class);
    }

    public PartnerRecord getPartnerRecord(String id) {
        PartnerRecord apply = (PartnerRecord)this.baseDao.get(PartnerRecord.class, (Serializable)((Object)id));
        apply.setAddresses(this.getAddresses(id));
        apply.setContacts(this.getContacts(id));
        return apply;
    }

    public void add(PartnerRecord partner, Employee me) {
        partner.setId(UUIDUtils.getId());
        this.baseDao.save((Object)partner);
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.fillInitData(me);
            contact.setId(UUIDUtils.getId());
            contact.setPartnerId(partner.getId());
        }
        this.addAddress(partner.getAddresses(), partner.getId(), me);
        this.baseDao.save(partner.getContacts());
    }

    public void addAddress(List<PartnerAddressRecord> partnerAddressRecords, String partnerId, Employee me) {
        for (PartnerAddressRecord address : partnerAddressRecords) {
            address.fillInitData(me);
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partnerId);
        }
        this.baseDao.save(partnerAddressRecords);
    }

    public void add(PartnerRecord partner, String sourceSystem) {
        partner.setId(UUIDUtils.getId());
        this.baseDao.save((Object)partner);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partner.getId());
        }
        if (Beans.isNotEmpty((Object)partner.getSiebelId())) {
            this.sendContact(partner.getSiebelId(), partner);
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.setId(UUIDUtils.getId());
            contact.setPartnerId(partner.getId());
        }
        this.baseDao.save(partner.getAddresses());
        this.baseDao.save(partner.getContacts());
    }

    public void update(PartnerRecord partner, Employee me) {
        Object[] args = new Object[]{partner.getId()};
        this.baseDao.update((Object)partner);
        this.baseDao.executeHQL("delete PartnerAddressRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerContactRecord where partnerId=?", args);
        for (PartnerAddressRecord address : partner.getAddresses()) {
            address.fillInitData(me);
            address.setId(UUIDUtils.getId());
            address.setPartnerId(partner.getId());
        }
        for (PartnerContactRecord contact : partner.getContacts()) {
            contact.fillInitData(me);
            contact.setId(UUIDUtils.getId());
            contact.setPartnerId(partner.getId());
        }
        this.baseDao.save(partner.getAddresses());
        this.baseDao.save(partner.getContacts());
    }

    public PartnerRecord audit(String id, String applyState, Employee me, String opinion) {
        String siebelId = null;
        PartnerRecord partnerRecord = null;
        if (applyState.equals("2")) {
            PartnerSiebelService ss = new PartnerSiebelService();
            partnerRecord = this.getPartnerRecord(id);
            partnerRecord.setMasterOuId(me.getCurrentPartner().getOrganizationid());
            siebelId = ss.addOrUpdatePartnerToSiebel(partnerRecord, 0);
            partnerRecord.setSiebelId(siebelId);
            String hql = "update PartnerRecord set applyState=?,opinion=?,auditorId=?,auditDt=?,siebelId=? where id=?";
            Object[] args = new Object[]{applyState, opinion, me.getId(), DateUtils.now(), siebelId, id};
            this.baseDao.executeHQL(hql, args);
        } else {
            String hql = "update PartnerRecord set applyState=?,opinion=?,auditorId=?,auditDt=? where id=?";
            Object[] args = new Object[]{applyState, opinion, me.getId(), DateUtils.now(), id};
            this.baseDao.executeHQL(hql, args);
        }
        this.sendContact(siebelId, partnerRecord);
        return partnerRecord;
    }

    public String addSiebel(PartnerRecord partnerRecord, Employee me) {
        PartnerSiebelService ss = new PartnerSiebelService();
        partnerRecord.setApplyType(ShopEnum.ApplyType.add.getValue());
        partnerRecord.setApplyState(TCBJEnum.ApplyState.pass.getValue());
        String siebelId = ss.addOrUpdatePartnerToSiebel(partnerRecord, 0);
        partnerRecord.setSiebelId(siebelId);
        this.add(partnerRecord, "CSP");
        return siebelId;
    }

    public void updateMyPartner(PartnerRecord partner) {
        PartnerSiebelService ss = new PartnerSiebelService();
        ss.updatePartPartnerToSiebel(partner);
    }

    public String updatePartner(PartnerRecord partner, Employee me) {
        partner.setSiebelId(partner.getId());
        this.add(partner, me);
        PartnerSiebelService ss = new PartnerSiebelService();
        String siebelId = ss.addOrUpdatePartnerToSiebel(partner, 1);
        this.sendContact(siebelId, partner);
        return siebelId;
    }

    public int[] getSketchCount(String userId, String suplierId) {
        String sb = this.personnelService.getFRegionsByUserId(userId);
        String hql1 = "from PartnerRecord where parentPartnerId=? and applyState='0'";
        Object[] args1 = new Object[]{suplierId};
        hql1 = String.valueOf(hql1) + " and (areaCode in(" + sb + ") or bigAreaCode in (" + sb + "))";
        List list1 = this.baseDao.findEntity(hql1, args1, PartnerRecord.class);
        String hql2 = "from PartnerRecord where parentPartnerId=? and applyState='1'";
        Object[] args2 = new Object[]{suplierId};
        hql2 = String.valueOf(hql2) + " and (areaCode in(" + sb + ") or bigAreaCode in (" + sb + "))";
        List list2 = this.baseDao.findEntity(hql2, args2, PartnerRecord.class);
        int[] counts = new int[]{list1.size(), list2.size()};
        return counts;
    }

    public PartnerContact getPartnerContact(String id) {
        return (PartnerContact)this.baseDao.findFirstEntity("from PartnerContact where id = ?", new Object[]{id}, PartnerContact.class);
    }

    public List<PartnerContact> getPartnerContacts(String partnerId) {
        return this.baseDao.findEntity(" from PartnerContact where partnerId=? and isContact='Y' ", new Object[]{partnerId}, PartnerContact.class);
    }

    public Partner getPartner(String id) {
        Partner partner = (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
        String hql = "from PartnerContact where partnerId=? and isContact='Y'";
        String hql1 = "from PartnerAddress where partnerId=?";
        Object[] args = new Object[]{id};
        partner.setContacts(this.baseDao.findEntity(hql, args, PartnerContact.class));
        partner.setAddresses(this.baseDao.findEntity(hql1, args, PartnerAddress.class));
        return partner;
    }

    public Partner getSimplePartner(String id) {
        return (Partner)this.baseDao.get(Partner.class, (Serializable)((Object)id));
    }

    public void del(String id) {
        PartnerRecord partner = (PartnerRecord)this.baseDao.get(PartnerRecord.class, (Serializable)((Object)id));
        if (!partner.getApplyState().equals(TCBJEnum.ApplyState.draft.getValue())) {
            throw new AppException("2001");
        }
        Object[] args = new Object[]{partner.getId()};
        this.baseDao.executeHQL("delete PartnerAddressRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerContactRecord where partnerId=?", args);
        this.baseDao.executeHQL("delete PartnerRecord where id=?", args);
    }

    public String partnerTree(Partner p) throws JSONException {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject node = new JSONObject();
        node.put("id", (Object)p.getId());
        node.put("pId", (Object)p.getParentPartnerId());
        node.put("name", (Object)p.getName());
        node.put("open", (Object)"true");
        node.put("nocheck", (Object)"true");
        node.put("iconSkin", (Object)"root");
        node.put("isParent", (Object)"true");
        nodes.put((Object)node);
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public String getChildTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Partner p where p.parentPartnerId = ? ", new Object[]{id}, Partner.class);
        for (Partner pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentPartnerId());
            node2.put("name", (Object)pn.getName());
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public Partner getCodeByPartner(String code, String supplierId) {
        Object[] args = new Object[]{code, supplierId};
        return (Partner)this.baseDao.findFirstEntity("from Partner where parentPartnerId = ? and no =? ", args, Partner.class);
    }

    public List<Partner> getOrgByPartner(String orgId) {
        Object[] args = new Object[]{orgId};
        return this.baseDao.findEntity(" select distinct(p) from Partner p where p.masterOuId = ? ", args, Partner.class);
    }

    public boolean isPartner(String code, String supplierId) {
        return !StringUtils.isNotNull(this.getCodeByPartner(code, supplierId));
    }

    public boolean isPartnerRecord(String no, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where no = ? ";
        args.add(no);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerRecord(String partnerId, String no, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where no = ? and parentPartnerId = ? ";
        args.add(no);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerNo(String partnerId, String no, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where no = ? and masterOuId = ? ";
        args.add(no);
        args.add(partnerId);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public boolean isPartnerNo(String no, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where no = ? and masterOuId = ? ";
        args.add(no);
        args.add(StringUtils.getOrgId());
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public boolean isPartnerRecordClientAppNo(String partnerId, String clientAppNo, String id, String partnerLevelCode) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where clientAppNo = ? and parentPartnerId = ? and partnerLevelCode = ? ";
        args.add(clientAppNo);
        args.add(partnerId);
        args.add(partnerLevelCode);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerClientAppNo(String partnerId, String clientAppNo, String id, String partnerLevelCode) {
        Customer partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Customer where extCode = ? and supplierId = ? and partnerLevelCode = ? ";
        args.add(clientAppNo);
        args.add(partnerId);
        args.add(partnerLevelCode);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and PARTNERID != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Customer)this.baseDao.findFirstEntity(hql, args.toArray(), Customer.class));
    }

    public boolean isPartnerRecordName(String partnerId, String name, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where parentPartnerId = ? and name = ? ";
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerName(String partnerId, String name, String id) {
        Partner partner;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Partner where masterOuId = ? and name = ? ";
        args.add(partnerId);
        args.add(name);
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partner = (Partner)this.baseDao.findFirstEntity(hql, args.toArray(), Partner.class));
    }

    public Page findSubPartners(PartnerCondition con, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from Partner p where p.masterOuId = ?  ");
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        hql.append(" order by p.no");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        return page;
    }

    public Map<String, String> findSubPartnersMap(Employee me) {
        String hql = "select new Partner(p.id,p.name,p.no) from Partner p where p.masterOuId = ? ";
        List list = this.baseDao.findEntity(hql, new Object[]{me.getCurrentPartner().getOrganizationid()}, Partner.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Partner p : list) {
            map.put(p.getNo(), p.getId());
        }
        return map;
    }

    public Partner getPartnerByEasNo(String easno) {
        return (Partner)this.baseDao.findFirstEntity("from Partner where clientAppNo = '" + easno + "' and masterOuId = ? ", new Object[]{StringUtils.getOrgId()}, Partner.class);
    }

    public Partner getPartnerByPartnerNo(String no, String parentPartnerId) {
        return (Partner)this.baseDao.findFirstEntity("from Partner where no = '" + no + "' and parentPartnerId ='" + parentPartnerId + "' ", Partner.class);
    }

    public PartnerRecord getFirstPartnerByNo(String no) {
        return (PartnerRecord)this.baseDao.findFirstEntity("from PartnerRecord where no ='" + no + "' order by createDt desc ", PartnerRecord.class);
    }

    public Partner getPartnerByNo(String no) {
        return (Partner)this.baseDao.findFirstEntity("from Partner where no ='" + no + "' order by createDt desc ", Partner.class);
    }

    public void sendContact(String siebelId, PartnerRecord partnerRecord) {
        String key;
        List listContact = this.baseDao.findEntity("from PartnerContact p where p.partnerId = ?  and isContact='Y' ", new Object[]{siebelId}, PartnerContact.class);
        HashMap<String, PartnerContact> mapContact = new HashMap<String, PartnerContact>();
        for (PartnerContact partnerContact : listContact) {
            key = String.valueOf(partnerContact.getContactName()) + "__" + partnerContact.getMobile();
            if (!Beans.isNotEmpty((Object)key)) continue;
            mapContact.put(key, partnerContact);
        }
        if (Beans.isNotEmpty((Object)partnerRecord)) {
            for (PartnerContactRecord contact : partnerRecord.getContacts()) {
                key = String.valueOf(contact.getContactName()) + "__" + contact.getMobile();
                if (!Beans.isNotEmpty(mapContact.get(key))) continue;
                contact.setSiebelId(((PartnerContact)mapContact.get(key)).getId());
            }
        }
    }

    public List<Object> findPartnersAndCustomers(PartnerCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<Object> args = new ArrayList<Object>();
        String sb = this.personnelService.getFRegionsByUserId(con.getEmployeeId());
        hql.append("from Partner p,Customer c where ");
        hql.append(" (c.bigAreaCode in ( ");
        hql.append(sb);
        hql.append(") or c.areaCode in ( ");
        hql.append(sb);
        hql.append(" ))");
        hql.append(" and p.id = c.applyerId and c.supplierId  = ? ");
        args.add(con.getPartnerId());
        if (StringUtils.isNotEmpty(con.getName())) {
            hql.append(" and p.name like ?");
            args.add("%" + con.getName().trim() + "%");
        }
        if (con.getCreateDtS() != null) {
            hql.append(" and p.createDt >= ?");
            args.add(con.getCreateDtS());
        }
        if (con.getCreateDtE() != null) {
            hql.append(" and p.createDt <= ?");
            args.add(con.getCreateDtE());
        }
        if (StringUtils.isNotEmpty(con.getNo())) {
            hql.append(" and p.no like ?");
            args.add("%" + con.getNo().trim() + "%");
        }
        if (StringUtils.isNotEmpty(con.getSaleChannelTypeCode())) {
            hql.append(" and p.saleChannelTypeCode = ?");
            args.add(con.getSaleChannelTypeCode());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaCode())) {
            hql.append(" and c.bigAreaCode = ?");
            args.add(con.getBigAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaCode())) {
            hql.append(" and c.areaCode = ?");
            args.add(con.getAreaCode());
        }
        if (StringUtils.isNotEmpty(con.getProvinceCode())) {
            hql.append(" and p.provinceCode = ?");
            args.add(con.getProvinceCode());
        }
        if (StringUtils.isNotEmpty(con.getCityCode())) {
            hql.append(" and p.cityCode = ?");
            args.add(con.getCityCode());
        }
        if (StringUtils.isNotEmpty(con.getAreaManagerId())) {
            hql.append(" and c.areaManagerId = ?");
            args.add(con.getAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getBigAreaManagerId())) {
            hql.append(" and c.bigAreaManagerId = ?");
            args.add(con.getBigAreaManagerId());
        }
        if (StringUtils.isNotEmpty(con.getCityManagerId())) {
            hql.append(" and c.cityManagerId = ?");
            args.add(con.getCityManagerId());
        }
        if (StringUtils.isNotEmpty(con.getMarketManagerId())) {
            hql.append(" and c.marketManagerId = ?");
            args.add(con.getMarketManagerId());
        }
        hql.append(" order by p.createDt desc");
        List list = this.baseDao.findEntity(hql.toString(), args.toArray());
        return list;
    }

    public List<AdjustStockUtil> ReadPartnerByExcel(String filePath, Employee me, List<PartnerRecord> list) {
        List datas;
        ArrayList<AdjustStockUtil> megs;
        block59: {
            megs = new ArrayList<AdjustStockUtil>();
            String[] headers = new String[]{"name", "shortName", "no", "saleChannel", "channel", "bigAreaCode", "areaCode", "bigAreaManagerId", "areaManagerId", "clientAppNo", "cityManagerId", "marketManagerId", "relatedDelearId", "provinceCode", "cityCode", "countyCode"};
            datas = Excels.readExcel((String)filePath, (InputStream)new FileInputStream(filePath), (String[])headers);
            if (!Beans.isEmpty((Object)datas)) break block59;
            return null;
        }
        try {
            Map<String, String> partnerMap = this.findSubPartnersMap(me);
            Map<String, String> saleManMap = this.personnelService.getByOrgMapJustName(me.getCurrentPartner().getOrganizationid());
            Map<String, String> regionMap = this.validateService.getRegionMap(me);
            Map<String, String> areaMap = this.validateService.getAreaMap(me);
            Map<String, String> provinceTypeMap = this.validateService.getItenMap("STATE_ABBREV");
            Map<String, String> cityTypeMap = this.validateService.getItenMap("TCBJ_CITY");
            Map<String, String> countyTypeMap = this.validateService.getItenMap("COUNTY");
            Map<String, String> saleChennelMap = this.validateService.getItenMap("TCBJ_PARTNER_LEVEL");
            Map<String, String> brandMap = this.validateService.getItenMap("TCBJ_PRODUCT_BRAND");
            String message = null;
            String result = null;
            int j = 1;
            for (Map data : datas) {
                PartnerRecord partner = new PartnerRecord();
                partner.initialize();
                partner.fillInitData(me);
                partner.setStartDt(DateUtils.now());
                partner.setParentPartnerId(me.getCurrentPartner().getId());
                partner.setMasterOuId(me.getCurrentPartner().getOrganizationid());
                partner.setApplyType(ShopEnum.ApplyType.add.getValue());
                partner.setApplyState(TCBJEnum.ApplyState.pass.getValue());
                result = null;
                message = ValidataUtils.validataMap(data.get("bigAreaCode"), regionMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5927\u533a \uff1a" + message + ";";
                } else {
                    partner.setBigAreaCode(regionMap.get(data.get("bigAreaCode")));
                }
                message = ValidataUtils.validataMap(data.get("areaCode"), areaMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u533a\u57df \uff1a" + message + ";";
                } else {
                    partner.setAreaCode(areaMap.get(data.get("areaCode")));
                }
                if (Beans.isNotEmpty(data.get("bigAreaManagerId"))) {
                    message = ValidataUtils.validataMap(data.get("bigAreaManagerId"), saleManMap);
                    if (message != null) {
                        result = String.valueOf(result == null ? "" : result) + " \u5927\u533a\u7ecf\u7406 \uff1a" + message + ";";
                    } else {
                        partner.setBigAreaManagerId(saleManMap.get(data.get("bigAreaManagerId")));
                    }
                }
                if (Beans.isNotEmpty(data.get("areaManagerId"))) {
                    message = ValidataUtils.validataMap(data.get("areaManagerId"), saleManMap);
                    if (message != null) {
                        result = String.valueOf(result == null ? "" : result) + " \u533a\u57df\u7ecf\u7406 \uff1a" + message + ";";
                    } else {
                        partner.setAreaManagerId(saleManMap.get(data.get("areaManagerId")));
                    }
                }
                if (Beans.isNotEmpty(data.get("cityManagerId"))) {
                    message = ValidataUtils.validataMap(data.get("cityManagerId"), saleManMap);
                    if (message != null) {
                        result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02\u7ecf\u7406 \uff1a" + message + ";";
                    } else {
                        partner.setCityManagerId(saleManMap.get(data.get("cityManagerId")));
                    }
                }
                if ((message = ValidataUtils.validataMap(data.get("saleChannel"), brandMap)) != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7ecf\u8425\u4e3b\u54c1\u724c \uff1a" + message + ";";
                } else {
                    partner.setFax(brandMap.get(data.get("saleChannel")));
                }
                message = ValidataUtils.validateMapOrNull(data.get("relatedDelearId"), partnerMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5173\u8054\u4ea4\u6613\u7ecf\u9500\u5546 \uff1a" + message + ";";
                } else {
                    partner.setRelatedDelearId(partnerMap.get(data.get("relatedDelearId")));
                }
                if (Beans.isEmpty(data.get("channel"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    String saleChannelTypeCode = this.getchannelTypeCodeByName(data.get("channel").toString(), me);
                    if (Beans.isEmpty((Object)saleChannelTypeCode)) {
                        result = String.valueOf(result == null ? "" : result) + "\u6e20\u9053\u540d\u79f0\u6709\u8bef";
                    } else {
                        partner.setSaleChannelTypeCode(saleChannelTypeCode);
                    }
                }
                String provinceId = StringUtils.objToStr(data.get("province"));
                String cityId = StringUtils.objToStr(data.get("city"));
                String countyId = StringUtils.objToStr(data.get("area"));
                DictionaryItem province = null;
                DictionaryItem city = null;
                DictionaryItem county = null;
                message = ValidataUtils.validataMap(data.get("provinceCode"), provinceTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + message + ";";
                } else {
                    province = Cache.getItem("STATE_ABBREV", provinceTypeMap.get(provinceId));
                    partner.setProvinceCode(provinceTypeMap.get(data.get("provinceCode")));
                }
                message = ValidataUtils.validataMap(data.get("cityCode"), cityTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + message + ";";
                } else {
                    city = Cache.getItem("TCBJ_CITY", cityTypeMap.get(cityId));
                    partner.setCityCode(cityTypeMap.get(data.get("cityCode")));
                }
                message = ValidataUtils.validateMapOrNull(data.get("countyCode"), countyTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u53bf\u57ce \uff1a" + message + ";";
                } else if (Beans.isNotEmpty(data.get("countyCode"))) {
                    county = Cache.getItem("COUNTY", countyTypeMap.get(countyId));
                    partner.setCountyCode(countyTypeMap.get(data.get("countyCode")));
                }
                if (city != null && province != null && !city.getParName().equals(province.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + provinceId + "\u4e0e\u57ce\u5e02" + cityId + "\u4e0d\u5339\u914d;";
                } else if (county != null && city != null && !county.getParName().equals(city.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + cityId + "\u4e0e\u53bf\u57ce" + countyId + "\u4e0d\u5339\u914d;";
                }
                message = ValidataUtils.validateMapOrNull(data.get("marketManagerId"), saleManMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5e02\u573a\u4ee3\u8868 \uff1a" + message + ";";
                } else {
                    partner.setMarketManagerId(saleManMap.get(data.get("marketManagerId")));
                }
                if (Beans.isNotEmpty(data.get("clientAppNo"))) {
                    if (this.isPartnerRecordClientAppNo(data.get("clientAppNo").toString(), saleChennelMap.get(data.get("saleChannel")), null) && this.isPartnerClientAppNo(data.get("clientAppNo").toString(), saleChennelMap.get(data.get("saleChannel")), null)) {
                        result = String.valueOf(result == null ? "" : result) + "\u5916\u56f4\u7f16\u53f7+\u9500\u552e\u6e20\u9053\u6709\u91cd\u590d;";
                    } else {
                        partner.setClientAppNo(data.get("clientAppNo").toString());
                    }
                }
                if (Beans.isEmpty(data.get("no"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u52a9\u8bb0\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;";
                } else if (this.isPartnerRecord(data.get("no").toString(), null) && this.isPartnerNo(data.get("no").toString(), null)) {
                    result = String.valueOf(result == null ? "" : result) + "\u5df2\u7ecf\u5b58\u5728\u7684\u52a9\u8bb0\u7f16\u7801;";
                } else {
                    partner.setNo(data.get("no").toString());
                }
                if (Beans.isEmpty(data.get("name"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;";
                } else if (this.isPartnerRecordName(me.getCurrentPartner().getOrganizationid(), data.get("name").toString(), null) && this.isPartnerName(me.getCurrentPartner().getOrganizationid(), data.get("name").toString(), null)) {
                    result = String.valueOf(result == null ? "" : result) + "\u5df2\u7ecf\u5b58\u5728\u7684\u7ecf\u9500\u5546\u540d\u79f0;";
                } else {
                    partner.setName(data.get("name").toString());
                }
                if (Beans.isNotEmpty(data.get("shortName"))) {
                    partner.setShortName(data.get("shortName").toString());
                } else {
                    result = String.valueOf(result == null ? "" : result) + "\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a;";
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                list.add(partner);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
            ArrayList<String> dupNo = new ArrayList<String>();
            ArrayList<String> dupName = new ArrayList<String>();
            ArrayList<String> dupClientNo = new ArrayList<String>();
            for (PartnerRecord partner : list) {
                if (dupNo.contains(partner.getNo())) {
                    megs.add(new AdjustStockUtil("\u52a9\u8bb0\u7f16\u7801\uff1a" + partner.getNo() + "\u6709\u91cd\u590d;"));
                } else {
                    dupNo.add(partner.getNo());
                }
                if (dupName.contains(partner.getName())) {
                    megs.add(new AdjustStockUtil("\u7ecf\u9500\u5546\u540d\u79f0\uff1a" + partner.getName() + "\u6709\u91cd\u590d;"));
                } else {
                    dupName.add(partner.getName());
                }
                if (!Beans.isNotEmpty((Object)partner.getClientAppNo())) continue;
                if (dupClientNo.contains(partner.getClientAppNo())) {
                    megs.add(new AdjustStockUtil("\u5916\u56f4\u7cfb\u7edf\u7f16\u53f7\uff1a" + partner.getClientAppNo() + "\u6709\u91cd\u590d;"));
                    continue;
                }
                dupClientNo.add(partner.getClientAppNo());
            }
            if (megs.size() > 0) {
                return megs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public List<AdjustStockUtil> ReadPartnerAddressByExcel(String filePath, Employee me, List<PartnerAddressRecord> list) {
        List datas;
        ArrayList<AdjustStockUtil> megs;
        block40: {
            megs = new ArrayList<AdjustStockUtil>();
            String[] headers = new String[]{"name", "no", "addressTypeCode", "provinceCode", "cityCode", "countyCode", "address", "cityManagerId", "contactCode", "contactPhone", "startDt", "endDt", "zip", "receiveTimeCode"};
            datas = Excels.readExcel((String)filePath, (InputStream)new FileInputStream(filePath), (String[])headers);
            if (!Beans.isEmpty((Object)datas)) break block40;
            return null;
        }
        try {
            Map<String, String> saleManMap = this.personnelService.getByOrgMapJustName(me.getCurrentPartner().getOrganizationid());
            Map<String, String> addressTypeMap = this.validateService.getItenMap("ADDR_TYPE");
            Map<String, String> provinceTypeMap = this.validateService.getItenMap("STATE_ABBREV");
            Map<String, String> cityTypeMap = this.validateService.getItenMap("TCBJ_CITY");
            Map<String, String> countyTypeMap = this.validateService.getItenMap("COUNTY");
            Map<String, String> receiveTimeMap = this.validateService.getItenMap("TCBJ_RECEIVE_DATE_TYPE");
            String message = null;
            String result = null;
            int j = 1;
            for (Map data : datas) {
                PartnerAddressRecord partner = new PartnerAddressRecord();
                partner.fillInitData(me);
                result = null;
                if (Beans.isEmpty(data.get("name"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u7ecf\u9500\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setName(data.get("name").toString());
                }
                if (Beans.isEmpty(data.get("no"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u52a9\u8bb0\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;";
                } else if (this.isPartnerRecord(data.get("no").toString(), null) || this.isPartnerNo(data.get("no").toString(), null)) {
                    PartnerRecord p = this.getFirstPartnerByNo(data.get("no").toString());
                    partner.setPartnerId(p.getId());
                } else {
                    result = String.valueOf(result == null ? "" : result) + "\u4e0d\u5b58\u5728\u7684\u52a9\u8bb0\u7f16\u7801;";
                }
                message = ValidataUtils.validataMap(data.get("addressTypeCode"), addressTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u5730\u5740\u7c7b\u578b \uff1a" + message + ";";
                } else {
                    partner.setAddressTypeCode(addressTypeMap.get(data.get("addressTypeCode")));
                }
                if (Beans.isEmpty(data.get("address"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u52a9\u8bb0\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setAddress(data.get("address").toString());
                }
                message = ValidataUtils.validataMap(data.get("cityManagerId"), saleManMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02\u7ecf\u7406 \uff1a" + message + ";";
                } else {
                    partner.setCityManagerId(saleManMap.get(data.get("cityManagerId")));
                }
                if (Beans.isEmpty(data.get("contactCode"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u9ed8\u8ba4\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setContactCode(data.get("contactCode").toString());
                }
                if (Beans.isEmpty(data.get("contactPhone"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setContactPhone(data.get("contactPhone").toString());
                }
                if (Beans.isEmpty(data.get("startDt"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setStartDt(DateUtils.autoFormatDate((String)data.get("startDt").toString(), (String[])new String[]{"yyyy-MM-dd"}));
                }
                if (Beans.isNotEmpty(data.get("endDt"))) {
                    partner.setEndDt(DateUtils.autoFormatDate((String)data.get("endDt").toString(), (String[])new String[]{"yyyy-MM-dd"}));
                }
                if (Beans.isEmpty(data.get("zip"))) {
                    result = String.valueOf(result == null ? "" : result) + "\u9884\u8ba1\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a;";
                } else {
                    partner.setZip(data.get("zip").toString());
                }
                message = ValidataUtils.validataMap(data.get("receiveTimeCode"), receiveTimeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u6536\u8d27\u65f6\u95f4 \uff1a" + message + ";";
                } else {
                    partner.setReceiveTimeCode(receiveTimeMap.get(data.get("receiveTimeCode")));
                }
                String provinceId = StringUtils.objToStr(data.get("province"));
                String cityId = StringUtils.objToStr(data.get("city"));
                String countyId = StringUtils.objToStr(data.get("area"));
                DictionaryItem province = null;
                DictionaryItem city = null;
                DictionaryItem county = null;
                message = ValidataUtils.validataMap(data.get("provinceCode"), provinceTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + message + ";";
                } else {
                    province = Cache.getItem("STATE_ABBREV", provinceTypeMap.get(provinceId));
                    partner.setProvinceCode(provinceTypeMap.get(data.get("provinceCode")));
                }
                message = ValidataUtils.validataMap(data.get("cityCode"), cityTypeMap);
                if (message != null) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + message + ";";
                } else {
                    city = Cache.getItem("TCBJ_CITY", cityTypeMap.get(cityId));
                    partner.setCityCode(cityTypeMap.get(data.get("cityCode")));
                }
                if (Beans.isNotEmpty(data.get("countyCode"))) {
                    message = ValidataUtils.validateMapOrNull(data.get("countyCode"), countyTypeMap);
                    if (message != null) {
                        result = String.valueOf(result == null ? "" : result) + " \u53bf\u57ce \uff1a" + message + ";";
                    } else if (Beans.isNotEmpty(data.get("countyCode"))) {
                        county = Cache.getItem("COUNTY", countyTypeMap.get(countyId));
                        partner.setCountyCode(countyTypeMap.get(data.get("countyCode")));
                    }
                }
                if (city != null && province != null && !city.getParName().equals(province.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u7701\u4efd \uff1a" + provinceId + "\u4e0e\u57ce\u5e02" + cityId + "\u4e0d\u5339\u914d;";
                } else if (county != null && city != null && !county.getParName().equals(city.getName())) {
                    result = String.valueOf(result == null ? "" : result) + " \u57ce\u5e02 \uff1a" + cityId + "\u4e0e\u53bf\u57ce" + countyId + "\u4e0d\u5339\u914d;";
                }
                if (result != null) {
                    megs.add(new AdjustStockUtil("\u7b2c" + (j + 1) + "\u884c:" + result));
                }
                list.add(partner);
                ++j;
            }
            if (megs.size() > 0) {
                return megs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return megs;
    }

    public String getchannelTypeCodeByName(String channelname, Employee me) {
        ChannelType ct = (ChannelType)this.baseDao.findFirstEntity("from ChannelType p where p.name = ? and partnerId = ? ", new Object[]{channelname, me.getCurrentPartner().getId()}, ChannelType.class);
        if (Beans.isEmpty((Object)ct)) {
            return null;
        }
        String channelid = ct.getId();
        return channelid;
    }

    public boolean isPartnerRecordClientAppNo(String clientAppNo, String partnerLevelCode, String id) {
        PartnerRecord partnerRecord;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from PartnerRecord where clientAppNo = ? ";
        args.add(clientAppNo);
        if (StringUtils.isNotEmpty(partnerLevelCode)) {
            hql = String.valueOf(hql) + " and partnerLevelCode = ?";
            args.add(partnerLevelCode);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and id != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(partnerRecord = (PartnerRecord)this.baseDao.findFirstEntity(hql, args.toArray(), PartnerRecord.class));
    }

    public boolean isPartnerClientAppNo(String clientAppNo, String partnerLevelCode, String id) {
        Customer customer;
        ArrayList<String> args = new ArrayList<String>();
        String hql = "from Customer where extCode = ? ";
        args.add(clientAppNo);
        if (StringUtils.isNotEmpty(partnerLevelCode)) {
            hql = String.valueOf(hql) + " and partnerLevelCode = ?";
            args.add(partnerLevelCode);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + " and PARTNERID != ?";
            args.add(id);
        }
        return StringUtils.isNotNull(customer = (Customer)this.baseDao.findFirstEntity(hql, args.toArray(), Customer.class));
    }

    public void savePartnerBatch(List<PartnerRecord> list, Employee me) {
        for (PartnerRecord pr : list) {
            this.add(pr, "CSP");
        }
    }

    public void savePartnerAddressBatch(List<PartnerAddressRecord> list, Employee me) {
        Iterator<PartnerAddressRecord> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public String partnerToSiebelBatchAdd(List<PartnerRecord> list) {
        PartnerSiebelService ss = new PartnerSiebelService();
        String msg = ss.batchAddToSiebel(list, 0);
        return msg;
    }

    public String partnerAddressToSiebelBatchAdd(List<PartnerRecord> list) {
        PartnerSiebelService ss = new PartnerSiebelService();
        StringBuffer sb = new StringBuffer("");
        for (PartnerRecord pr : list) {
            String siebelId = ss.addOrUpdatePartnerToSiebel(pr, 1);
            if (!Beans.isEmpty((Object)siebelId)) continue;
            sb.append(pr.getNo());
        }
        return sb.toString();
    }

    public PartnerRecord getPartnerRecordBySiebelId(String id) {
        PartnerRecord pr = (PartnerRecord)this.baseDao.findFirstEntity(" from PartnerRecord p where p.siebelId = '" + id + "' order by lastUpdateDt desc ", PartnerRecord.class);
        return pr;
    }
}

