/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partneractivity;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.order.ActivityInfoService;
import com.tcbj.crm.order.OrderApplyCondition;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Excels;
import com.tcbj.util.Jsons;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/partnerActivity"})
public class PartnerActivityController
extends BaseController {
    @Autowired
    ActivityInfoService activityInfoService;

    @RequestMapping(value={"/list.do"})
    public String list(OrderApplyCondition condition, Model model) {
        Page p = null;
        p = this.activityInfoService.queryPartnerActivity(condition);
        model.addAttribute("partnerActivitys", (Object)p);
        model.addAttribute("condition", (Object)condition);
        return "partneractivity/listPartnerActivitys.ftl";
    }

    @RequestMapping(value={"/toUpload.do"})
    public String toUpload(Model model) {
        return "partneractivity/uploadExcel.ftl";
    }

    @RequestMapping(value={"/upload.do"}, method={RequestMethod.POST}, headers={"Accept=application/json,application/xml"})
    public String upload(@RequestParam(value="file", required=true) MultipartFile file, Model model) throws IOException {
        Map<Object, Object> errorMsg = new HashMap();
        if (Beans.isNotEmpty((Object)file)) {
            try {
                List result = Excels.readExcel((String)file.getOriginalFilename(), (InputStream)file.getInputStream(), (String[])new String[]{"partnerId", "activityId", "initValue"});
                errorMsg = this.activityInfoService.addPartnerActivity(result);
            }
            catch (IOException iOException) {
                throw new AppException("\u89e3\u6790excel\u51fa\u9519");
            }
        }
        model.addAttribute("rtn", (Object)Jsons.toJson((Object)this.getSuccessResult(errorMsg)));
        return "common/iframeRtn.ftl";
    }

    @RequestMapping(value={"/updateInitValue.do"}, method={RequestMethod.GET})
    public String updateInitValue(String id, HttpServletRequest request) {
        Map<String, Object> map = this.activityInfoService.get(id);
        request.setAttribute("partnerActivity", map);
        return "partneractivity/updateInitValue.ftl";
    }

    @RequestMapping(value={"/updateInitValue.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result updateInitValue(String id, String initValue) {
        this.activityInfoService.updateInitValue(id, initValue);
        return this.getSuccessResult(null);
    }
}

