/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partneractivityInfo;

import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.common.NewBaseDao;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.ManualAddHistoryTrack;
import com.tcbj.crm.entity.OrderActivityInfo;
import com.tcbj.crm.entity.PartnerActivityTrack;
import com.tcbj.crm.order.ActivityInfoService;
import com.tcbj.crm.partneractivityInfo.PartnerActInfoCondition;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import com.tcbj.util.DateUtils;
import com.tcbj.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="partnerActInfoService")
public class PartnerActInfoService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private NewBaseDao newBaseDao;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    ActivityInfoService activityInfoService;

    public Page getPartActInfoPage(PartnerActInfoCondition con, String orderby, int pageno, HttpServletRequest request, int all) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        sql.append("select track.activity_id \"activityId\",  track.partner_id  \"partnerId\",track.prePayDel \"prePayDel\", track.historyAdd \"totalGain\",").append(" track.historyDel \"totalUse\",track.hold \"hold\", track.createDate \"createDate\",nvl(b.initvalue,0) \"initValue\", b.partner_name \"partnerName\" ").append(" from  (select a.activity_id,a.partner_id,").append(" (select nvl(sum(c.change_value), 0) from cx_partner_activity_track c where c.activity_id = a.activity_id and c.partner_id = a.partner_id and c.addtype = '2' and c.state = '1') prePayDel,").append(" (select nvl(sum(d.change_value), 0)  from cx_partner_activity_track d where d.activity_id = a.activity_id  and d.partner_id = a.partner_id and d.addtype = '3' and d.state = '1') historyAdd,").append(" (select nvl(sum(e.change_value), 0)  from cx_partner_activity_track e where e.activity_id = a.activity_id and e.partner_id = a.partner_id and e.addtype = '4' and e.state = '1') historyDel,").append(" (select nvl(sum(f.change_value), 0) from cx_partner_activity_track f where f.activity_id = a.activity_id and f.partner_id = a.partner_id and f.addtype = '5' and f.state = '1') hold,").append(" max(a.createdate) createDate,").append(" max(a.modifydate) modifyDate").append(" from cx_partner_activity_track a group by a.activity_id, a.partner_id) track").append(" left join cx_indent_partner_activity b on track.activity_id = b.activity_id and track.partner_id = b.partner_id");
        if (con.getRegionFilter().booleanValue()) {
            sql.append(" ,CX_PARTNERLIST_V p where p.partner_num = track.partner_id ");
            String employeeId = con.getEmployeeId();
            String partnerIds = this.personnelService.getPartnerIds(employeeId);
            String regions = this.personnelService.getFRegionsByUserId(employeeId);
            if (!"'1-2-3'".equals(partnerIds)) {
                sql.append(" and p.PARTNER_ID in ( ");
                sql.append(partnerIds);
                sql.append(" ) ");
            } else {
                sql.append(" and p.REGION_ID in ( ");
                sql.append(regions);
                sql.append(" ) ");
            }
        } else {
            sql.append(" where 1=1 ");
        }
        if (StringUtils.isNotEmpty(con.getActCode())) {
            sql.append(" and track.activity_id like '%" + con.getActCode().trim() + "%' ");
        }
        if (StringUtils.isNotEmpty(con.getPartner_name())) {
            sql.append(" and b.partner_name like '%" + con.getPartner_name().trim() + "%' ");
        }
        if (con.getCreate_dates() != null) {
            sql.append(" and track.createDate >= ?");
            args.add(con.getCreate_dates());
        }
        if (con.getCreate_datese() != null) {
            Date afterday = DateUtils.getDateAfter((Date)con.getCreate_datese(), (int)1);
            sql.append(" and track.createDate <= ?");
            args.add(afterday);
        }
        if (all == 0) {
            String Partner_id = null;
            if (StringUtils.isNotEmpty(con.getPartner_id())) {
                Partner_id = "'" + con.getPartner_id() + "'";
                sql.append(" and track.partner_id in ( ");
                sql.append(Partner_id);
                sql.append(" ) ");
            }
        }
        if (all == 1 && StringUtils.isNotEmpty(con.getPartner_id())) {
            sql.append(" and track.partner_id like ?");
            args.add("%" + con.getPartner_id().trim() + "%");
        }
        sql.append(" order by track.modifyDate desc ");
        Page p = this.newBaseDao.findPageBySql(sql.toString(), args, con.getPageno(), Constant.DEFAULT_ROWS);
        if (Beans.isNotEmpty((Object)p.getList())) {
            List result = p.getList();
            for (Map map : result) {
                String returnFlag;
                Double initValue = Double.valueOf(map.get("initValue").toString());
                Double prePayLeft = initValue - Double.valueOf(map.get("prePayDel").toString());
                Double historyTotal = Double.valueOf(map.get("totalGain").toString()) - Double.valueOf(map.get("totalUse").toString()) - Double.valueOf(map.get("hold").toString());
                String string = (initValue = Double.valueOf(initValue < 0.0 ? 0.0 - initValue : initValue)) == 0.0 ? "-" : (prePayLeft > 0.0 ? "\u5426" : (returnFlag = historyTotal >= initValue ? "\u662f" : "\u5426"));
                historyTotal = prePayLeft > 0.0 ? historyTotal : (historyTotal < initValue ? historyTotal : historyTotal - initValue);
                map.put("prePayLeft", prePayLeft);
                map.put("returnFlag", returnFlag);
                map.put("totalCount", historyTotal);
                if (!Beans.isEmpty(map.get("partnerName"))) continue;
                map.put("partnerName", Cache.getPartnerByNo(map.get("partnerId").toString()).getName());
            }
        }
        return p;
    }

    public Page getActivityInfo(String id, String applyeId, int pageno, PartnerActInfoCondition con, HttpServletRequest request) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("select distinct o,i from OrderActivityInfo o,OrderApply i  ");
        HQL.append(" where o.orderApplyId = i.id");
        HQL.append(" and o.activityId = '" + id + "'");
        HQL.append(" and i.applyerId = '" + applyeId + "'");
        HQL.append(" and i.state in ( '2','3','4','5','6' ) ");
        Page apply = this.baseDao.search(HQL.toString(), null, Constant.DEFAULT_ROWS, con.getPageno().intValue());
        return apply;
    }

    public OrderActivityInfo getActivityInfosingle(String id) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("select distinct o from OrderActivityInfo o ");
        HQL.append(" where o.activityId = '" + id + "'");
        OrderActivityInfo c = (OrderActivityInfo)this.baseDao.findFirstEntity(HQL.toString(), OrderActivityInfo.class);
        return c;
    }

    public Page getActivityProduct(String id, String actid) {
        StringBuffer HQL = new StringBuffer();
        HQL.append("select distinct o from OrderActivityProduct o ");
        HQL.append(" where o.orderApplyId = '" + id + "'");
        HQL.append(" and o.activityId = '" + actid + "'");
        Page product = this.baseDao.search(HQL.toString(), null, Constant.DEFAULT_ROWS, 1);
        return product;
    }

    public void saveManualAddHistoryTrack(ManualAddHistoryTrack track) {
        track.setCreateDate(new Date());
        track.setOrgId(StringUtils.getOrgId());
        PartnerActivityTrack pTrack = new PartnerActivityTrack();
        Beans.copy((Object)pTrack, (Object)track);
        pTrack.setAddType(Constant.ActivityTrackAddType.historyAdd.value);
        pTrack.setState(Constant.ActivityTrackState.valid.value);
        pTrack.setModifyDate(new Date());
        pTrack.setOrderApplyId("");
        this.baseDao.save((Object)pTrack);
        this.baseDao.save((Object)track);
    }

    public Page listManualAdd(PartnerActInfoCondition con) {
        StringBuilder sb = new StringBuilder();
        sb.append(" from ManualAddHistoryTrack track where orgId=? ");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(StringUtils.getOrgId());
        if (Beans.isNotEmpty((Object)con.getActCode())) {
            sb.append(" and track.activityId= ? ");
            args.add(con.getActCode());
        }
        if (Beans.isNotEmpty((Object)con.getPartner_id())) {
            sb.append(" and track.partnerId = ? ");
            args.add(con.getPartner_id());
        }
        sb.append(" order by track.createDate desc");
        return this.newBaseDao.findPageByHql(sb.toString(), args, con.getPageno(), 10);
    }
}

