/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.partnershop;

import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.cache.Cache;
import com.tcbj.crm.channelType.ChannelTypeService;
import com.tcbj.crm.client.ClientService;
import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.common.TCBJEnum;
import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.PartnerRecord;
import com.tcbj.crm.entity.Region;
import com.tcbj.crm.entity.Shop;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.partner.PartnerService;
import com.tcbj.crm.region.RegionService;
import com.tcbj.crm.shop.ShopEnum;
import com.tcbj.crm.shop.ShopService;
import com.tcbj.crm.view.Customer;
import com.tcbj.crm.view.Employee;
import com.tcbj.crm.view.EmployeePartner;
import com.tcbj.crm.view.Partner;
import com.tcbj.crm.view.ShopView;
import com.tcbj.util.CyptoUtils;
import com.tcbj.util.DateUtils;
import com.tcbj.util.SessionUtils;
import com.tcbj.util.StringUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@RequestMapping(value={"/_dsstocspshop"})
public class PartnerShopController
extends BaseController {
    @Autowired
    PartnerService partnerService;
    @Autowired
    OrderNoService orderNoService;
    @Autowired
    Cache cache;
    @Autowired
    ChannelTypeService channelTypeService;
    @Autowired
    RegionService regionService;
    @Autowired
    ShopService shopService;
    @Autowired
    ClientService clientService;

    @RequestMapping(value={"/shopApply.do"}, method={RequestMethod.GET})
    public String shopApply(@RequestParam(value="partnerNo", required=true) String partnerNo, @RequestParam(value="shopNo", required=false) String shopNo, HttpServletRequest request, Model model) {
        Partner partner = this.login(partnerNo, model, request);
        if (StringUtils.isNotEmpty(shopNo)) {
            ShopView shopView = this.shopService.getCodeByShop(CyptoUtils.decode((String)"Tcbj_Dss", (String)shopNo).trim(), partner.getId());
            if (shopView == null) {
                throw new AppException("8007");
            }
            Shop firstShop = this.shopService.getFirstShopByShopNo(CyptoUtils.decode((String)"Tcbj_Dss", (String)shopNo).trim(), partner.getId());
            if (firstShop != null && !ShopEnum.ApproveState.pass.getValue().equals(firstShop.getApproveState())) {
                throw new AppException("8007");
            }
            shopView.setApplyType(TCBJEnum.ApplyType.edit.getValue());
            shopView.setApproveState(ShopEnum.ApproveState.audit.getValue());
            model.addAttribute("shop", (Object)shopView);
        } else {
            Shop shop = new Shop();
            shop.initialize();
            shop.setApplyType(TCBJEnum.ApplyType.add.getValue());
            shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
            Employee employee = new Employee();
            employee.setId(partner.getId());
            shop.fillInitData(null, employee);
            model.addAttribute("shop", (Object)shop);
        }
        model.addAttribute("currentPartner", (Object)partner);
        model.addAttribute("date", (Object)DateUtils.now());
        return "partnershop/shopAdd.ftl";
    }

    @RequestMapping(value={"/shopApply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody Shop shop, BindingResult errors, HttpServletRequest request) {
        this.validatePartner();
        Partner currentPatner = this.getCurrentPartner();
        String orgId = currentPatner.getMasterOuId();
        Employee me = new Employee();
        EmployeePartner employeePartner = new EmployeePartner();
        employeePartner.setId(currentPatner.getId());
        me.setId(currentPatner.getId());
        me.setCurrentPartner(employeePartner);
        boolean flag2 = this.shopService.validateCilentNo(me, shop);
        if (!flag2) {
            throw new AppException("8006", shop.getOuterClientNo());
        }
        shop.fillInitData(null, me);
        shop.setIsMenberShop("N");
        shop.setIsReceiveAllot("Y");
        shop.setTerminalLevel("level1");
        if (TCBJEnum.ApplyType.edit.getValue().equals(shop.getApplyType())) {
            boolean flag = this.shopService.validateShopName(me, shop);
            if (!flag) {
                throw new AppException("8005", shop.getShopName());
            }
            shop.setApplyType(TCBJEnum.ApplyType.edit.getValue());
            shop.setSiebelShopId(shop.getId());
        } else {
            Customer customer = this.clientService.getCustomer(orgId, currentPatner.getId());
            if (customer != null && StringUtils.isNotEmpty(customer.getBigAreaCode())) {
                shop.setBigAreaId(customer.getBigAreaCode());
                if (!StringUtils.isNotEmpty(customer.getAreaCode())) {
                    throw new AppException("0010", "[" + currentPatner.getName() + "]\u533a\u57df\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
                }
            } else {
                throw new AppException("0010", "[" + currentPatner.getName() + "]\u5927\u533a\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            }
            shop.setAreaId(customer.getAreaCode());
            boolean flag = this.shopService.validateShopName(me, shop);
            if (!flag) {
                throw new AppException("8005", shop.getShopName());
            }
            if (shop.getShopNumber() == null) {
                shop.setShopNumber(this.orderNoService.saveBalanceShopNo("200001", true));
            }
            shop.setApplyType(TCBJEnum.ApplyType.add.getValue());
        }
        this.shopService.add(shop, me, "DSS");
        return this.getSuccessResult(null);
    }

    private void validateName(String partnerId, String name, String id) {
        boolean isPartnerRecordName = this.partnerService.isPartnerRecordName(partnerId, name, id);
        boolean isPartnerName = this.partnerService.isPartnerName(partnerId, name, id);
        if (isPartnerRecordName && isPartnerName) {
            throw new AppException("2006");
        }
    }

    private void validateNo(String no, String id) {
        boolean isPartnerRecord = this.partnerService.isPartnerRecord(no, id);
        boolean isPartner = this.partnerService.isPartnerNo(no, id);
        if (isPartnerRecord && isPartner) {
            throw new AppException("2003");
        }
    }

    private Partner getCurrentPartner() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return SessionUtils.getPartner(request);
    }

    private void validatePartner() {
        if (this.getCurrentPartner() == null) {
            throw new AppException("8001");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/partnerApply.do"}, method={RequestMethod.GET})
    public String partnerApply(@RequestParam(value="partnerNo", required=true) String partnerNo, @RequestParam(value="no", required=false) String no, HttpServletRequest request, Model model) throws IOException, Exception {
        Partner currentPartner = this.login(partnerNo, model, request);
        if (StringUtils.isEmpty(no)) {
            PartnerRecord partner = new PartnerRecord();
            partner.setApplyType(TCBJEnum.ApplyType.add.getValue());
            List<ChannelType> channelTypes = this.channelTypeService.getChannelTypes(currentPartner.getId());
            if (channelTypes == null || channelTypes.size() <= 0) throw new AppException("0010", "[" + currentPartner.getName() + "]\u9500\u552e\u6e20\u9053\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            partner.setSaleChannelTypeCode(channelTypes.get(0).getId());
            List<Region> bigRegions = this.regionService.getParentAreas(channelTypes.get(0).getId(), null);
            if (bigRegions == null || bigRegions.size() <= 0) throw new AppException("0010", "[" + currentPartner.getName() + "]\u5927\u533a\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            partner.setBigAreaCode(bigRegions.get(0).getId());
            List<Region> areas = this.regionService.getParentAreas(bigRegions.get(0).getId(), null);
            if (areas == null || areas.size() <= 0) {
                throw new AppException("0010", "[" + currentPartner.getName() + "]\u533a\u57df\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            }
            partner.setAreaCode(areas.get(0).getId());
            model.addAttribute("partner", (Object)partner);
            return "partnershop/partnerAdd.ftl";
        } else {
            Partner partnerV = this.partnerService.getPartnerByPartnerNo(CyptoUtils.decode((String)"Tcbj_Dss", (String)no).trim(), currentPartner.getId());
            if (partnerV == null) {
                throw new AppException("0010", "\u8be5\u7ecf\u9500\u5546\u4e0d\u5b58\u5728!");
            }
            PartnerRecord partnerRecord = this.partnerService.getFirstPartnerByNo(CyptoUtils.decode((String)"Tcbj_Dss", (String)no).trim());
            if (partnerRecord != null && !TCBJEnum.ApplyState.pass.getValue().equals(partnerRecord.getApplyState())) {
                throw new AppException("0010", "\u8be5\u7ecf\u9500\u5546\u4e0d\u662f\u5ba1\u6279\u901a\u8fc7\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
            }
            partnerV.setApplyType(TCBJEnum.ApplyType.edit.getValue());
            model.addAttribute("partner", (Object)partnerV);
        }
        return "partnershop/partnerAdd.ftl";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result partnerApply(@Valid @RequestBody PartnerRecord partner, BindingResult errors, HttpServletRequest request) {
        this.validatePartner();
        Partner currentPatner = this.getCurrentPartner();
        String orgId = currentPatner.getMasterOuId();
        partner.setNo(partner.getNo().trim());
        if (StringUtils.isEmpty(partner.getId())) {
            this.validateName(orgId, partner.getName(), null);
            partner.initialize();
            partner.setNo(this.orderNoService.updatePartnerNo(partner.getPartnerType(), true));
            this.validateClientAppNo(partner.getClientAppNo(), partner.getPartnerLevelCode(), null);
            if (!TCBJEnum.ApplyState.audit.getValue().equals(partner.getApplyState())) {
                partner.setApplyState(TCBJEnum.ApplyState.draft.getValue());
            }
        } else {
            this.validateName(orgId, partner.getName(), partner.getId());
            this.validateNo(partner.getNo(), partner.getId());
            this.validateClientAppNo(partner.getClientAppNo(), partner.getPartnerLevelCode(), partner.getId());
        }
        partner.setCreateDt(DateUtils.now());
        partner.setCreatorId(currentPatner.getId());
        partner.setLastUpdateDt(DateUtils.now());
        partner.setLastUpdatorId(currentPatner.getId());
        partner.setParentPartnerId(currentPatner.getId());
        this.partnerService.add(partner, "DSS");
        return this.getSuccessResult(null);
    }

    private Partner login(String partnerNo, Model model, HttpServletRequest request) {
        Partner partner = null;
        if (StringUtils.isEmpty(partnerNo)) {
            throw new AppException("8001");
        }
        partner = this.partnerService.getPartnerByEasNo(CyptoUtils.decode((String)"Tcbj_Dss", (String)partnerNo).trim());
        if (partner == null) {
            throw new AppException("8001");
        }
        SessionUtils.setPartner(request, partner);
        model.addAttribute("currentPartner", (Object)partner);
        return partner;
    }

    private void validateClientAppNo(String clientAppNo, String partnerLevelCode, String id) {
        boolean isPartnerRecordClientAppNo = this.partnerService.isPartnerRecordClientAppNo(clientAppNo, partnerLevelCode, id, null);
        boolean isPartnerClientAppNo = this.partnerService.isPartnerClientAppNo(clientAppNo, partnerLevelCode, id, null);
        if (isPartnerRecordClientAppNo && isPartnerClientAppNo) {
            throw new AppException("2007");
        }
    }
}

