/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.position;

import com.tcbj.crm.entity.ChannelType;
import com.tcbj.crm.entity.Position;
import com.tcbj.crm.position.PositionCondition;
import com.tcbj.crm.view.Partner;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Constant;
import com.tcbj.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cxpostmainService")
public class PositionService {
    @Autowired
    BaseDao baseDao;

    public Position get(String id) {
        return (Position)this.baseDao.get(Position.class, (Serializable)((Object)id));
    }

    public void save(Position obj) {
        this.baseDao.save((Object)obj);
    }

    public Page getList(int pageno, PositionCondition condition, String orgId, String parentId) {
        StringBuffer HQL = new StringBuffer();
        HQL.append(" from Position o where 1=1");
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(condition.getPostName())) {
            HQL.append(" and o.postName like ? ");
            args.add("%" + condition.getPostName() + "%");
        }
        if (StringUtils.isNotEmpty(orgId)) {
            HQL.append(" and o.orgId = ? ");
            args.add(orgId);
        }
        if (StringUtils.isNotEmpty(parentId)) {
            HQL.append(" and o.parentId = ? ");
            args.add(parentId);
        }
        HQL.append("order by o.createDt desc ");
        return this.baseDao.search(HQL.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
    }

    public void update(Position obj) {
        this.baseDao.update((Object)obj);
    }

    public void delete(String id) {
        this.baseDao.deleteById(Position.class, (Serializable)((Object)id));
    }

    public String getChildNodeTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Position p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by createDt desc ", new Object[]{id, orgId, new Date(), new Date()}, Position.class);
        for (Position pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getPostName());
            node2.put("url", (Object)"/position/list");
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String getOrgTree(String orgId, Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)p.getParentPartnerId());
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u804c\u4f4d\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by created ", new Object[]{p.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)p.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("url", (Object)"/position/list");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public boolean isName(String name, String treeId, String id) throws Exception {
        List list;
        boolean isexist = false;
        String hql = "from Position a where 1=1";
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty(name)) {
            hql = String.valueOf(hql) + "and a.postName = ?";
            args.add(name);
        }
        if (StringUtils.isNotEmpty(treeId)) {
            hql = String.valueOf(hql) + "and a.orgId = ?";
            args.add(treeId);
        }
        if (StringUtils.isNotEmpty(id)) {
            hql = String.valueOf(hql) + "and a.id != ?";
            args.add(id);
        }
        if ((list = this.baseDao.findEntity(hql, args.toArray(), Position.class)).size() > 0) {
            isexist = true;
        }
        return isexist;
    }

    public String getChildTree(String id, String orgId) throws JSONException {
        JSONArray nodes = new JSONArray();
        List pts = this.baseDao.findEntity("from Position p where p.parentId = ? and p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by createDt ", new Object[]{id, orgId, new Date(), new Date()}, Position.class);
        for (Position pn : pts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)pn.getId());
            node2.put("pId", (Object)pn.getParentId());
            node2.put("name", (Object)pn.getPostName());
            node2.put("isParent", (Object)"true");
            nodes.put((Object)node2);
        }
        return nodes.toString();
    }

    public String posTree(Partner p) throws Exception {
        String str = "";
        JSONArray nodes = new JSONArray();
        JSONObject rootNode = new JSONObject();
        rootNode.put("id", (Object)p.getId());
        rootNode.put("pId", (Object)"1");
        rootNode.put("name", (Object)(String.valueOf(p.getName()) + "\u804c\u4f4d\u6811"));
        rootNode.put("open", (Object)"true");
        rootNode.put("nocheck", (Object)"true");
        rootNode.put("iconSkin", (Object)"root");
        rootNode.put("isParent", (Object)"true");
        nodes.put((Object)rootNode);
        List dts = this.baseDao.findEntity("from ChannelType c where c.partnerId = ? and c.startDt < ? and (c.endDt > ? or c.endDt is null) order by created ", new Object[]{p.getId(), new Date(), new Date()}, ChannelType.class);
        for (ChannelType dt : dts) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)dt.getId());
            node2.put("pId", (Object)p.getId());
            node2.put("name", (Object)dt.getName());
            node2.put("isParent", (Object)"true");
            node2.put("iconSkin", (Object)"start");
            node2.put("nocheck", (Object)"true");
            nodes.put((Object)node2);
        }
        if (nodes.length() > 0) {
            str = nodes.toString();
        }
        return str;
    }

    public List<Position> getPositions(String partnerId) {
        String hql = "from Position p where p.orgId = ? and startDate < ? and (endDate > ? or endDate is null) order by created ";
        return this.baseDao.findEntity(hql, new Object[]{partnerId, new Date(), new Date()}, Position.class);
    }
}

