/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAddition;

import com.alibaba.fastjson.JSON;
import com.tcbj.crm.base.BaseController;
import com.tcbj.crm.base.Result;
import com.tcbj.crm.entity.PredictAdditionApply;
import com.tcbj.crm.entity.PredictAdditionApplyItem;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.exception.AppException;
import com.tcbj.crm.predictAddition.PredictAdditionApplyCondition;
import com.tcbj.crm.predictAddition.PredictAdditionService;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/predictAddition"})
public class PredictAdditionController
extends BaseController {
    @Autowired
    PredictAdditionService service;
    @Autowired
    PredictApplyService predictApplyService;

    @RequestMapping(value={"/applys.do"})
    public String applys(@RequestParam(value="pageno", required=false, defaultValue="1") int pageno, PredictAdditionApplyCondition con, Model model) {
        Page page = this.service.findPredictAdditionApply(con, this.getCurrentEmployee(), pageno);
        model.addAttribute("condition", (Object)con);
        model.addAttribute("page", (Object)page);
        return "predictAddition/list.ftl";
    }

    @RequestMapping(value={"/view.do"}, method={RequestMethod.GET})
    public String view(String id, Model model) {
        PredictAdditionApply predictAdditionApply = this.getPredictAdditionApplyAndItem(id, this.getCurrentEmployee());
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(predictAdditionApply.getConfigId());
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictAdditionApply", (Object)predictAdditionApply);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(predictAdditionApply.getPredictAdditionApplyItems()));
        return "predictAddition/view.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.GET})
    public String audit(String id, Model model) {
        PredictAdditionApply predictAdditionApply = this.service.getPredictAdditionApplyById(id);
        predictAdditionApply.setPredictAdditionApplyItems(this.service.approvePredictAdditionApplyItems(predictAdditionApply.getId(), predictAdditionApply.getConfigId(), this.getCurrentEmployee()));
        PredictConfig predictConfig = this.predictApplyService.getPredictConfigById(predictAdditionApply.getConfigId());
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictAdditionApply", (Object)predictAdditionApply);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(predictAdditionApply.getPredictAdditionApplyItems()));
        return "predictAddition/audit.ftl";
    }

    @RequestMapping(value={"/audit.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result audit_do(@Valid @RequestBody PredictAdditionApplyCondition predictAdditionApply) {
        if (!Constant.PredictAdditionApplyState.approvePass.value.equals(predictAdditionApply.getAuditOpinion()) && !Constant.PredictAdditionApplyState.approveNoPass.value.equals(predictAdditionApply.getAuditOpinion())) {
            throw new AppException("0010", "\u8bf7\u63d0\u4ea4\u6b63\u786e\u7684\u5ba1\u6279\u610f\u89c1\uff01");
        }
        this.service.approvePredictAdditionApply(predictAdditionApply, this.getCurrentEmployee());
        return this.getSuccessResult(null);
    }

    @RequestMapping(value={"/cancel.do"}, method={RequestMethod.GET})
    public String cancel_do(String id) {
        Employee em = this.getCurrentEmployee();
        this.service.updatePredictAdditionApply(id, em);
        return "redirect:/predictAddition/applys.do";
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.GET})
    public String apply(String id, Model model) {
        PredictAdditionApply predictAdditionApply = new PredictAdditionApply();
        PredictConfig predictConfig = new PredictConfig();
        String pageType = "add";
        if (StringUtils.isNotEmpty((String)id)) {
            predictAdditionApply = this.getPredictAdditionApplyAndItem(id, this.getCurrentEmployee());
            predictConfig = this.predictApplyService.getPredictConfigById(predictAdditionApply.getConfigId());
            pageType = "edit";
        }
        model.addAttribute("pageType", (Object)pageType);
        model.addAttribute("predictConfig", (Object)predictConfig);
        model.addAttribute("predictAdditionApply", (Object)predictAdditionApply);
        model.addAttribute("predictApplyItemJson", (Object)JSON.toJSONString(predictAdditionApply.getPredictAdditionApplyItems()));
        return "predictAddition/apply.ftl";
    }

    @RequestMapping(value={"/selectPredictConfig.do"}, method={RequestMethod.GET})
    public String selectPredictConfigView(Model model) {
        return "predictAddition/selectPredictConfigs.ftl";
    }

    @RequestMapping(value={"/selectPredictConfigDatas.do"}, method={RequestMethod.GET}, headers={"Accept=application/json,application/xml"})
    @ResponseBody
    public List<PredictConfig> selectPredictConfigDatas(@ModelAttribute(value="prductCondition") PredictConfigCondition con, Model model) {
        Employee me = this.getCurrentEmployee();
        return this.service.getAdditionPredictConfig(con, me);
    }

    @RequestMapping(value={"/getPredictApplyItem.do"})
    @ResponseBody
    public Result getPredictApplyItem(String configId) {
        List<PredictAdditionApplyItem> predictApplyItems = this.service.getPredictAdditionItemByPredictConfig(configId, this.getCurrentEmployee());
        return this.getSuccessResult(predictApplyItems);
    }

    @RequestMapping(value={"/apply.do"}, method={RequestMethod.POST})
    @ResponseBody
    public Result apply_do(@Valid @RequestBody PredictAdditionApply predictAdditionApply) {
        this.service.saveOrUpdatePredictAdditionApply_NEW(predictAdditionApply, this.getCurrentEmployee());
        return this.getSuccessResult(null);
    }

    protected PredictAdditionApply getPredictAdditionApplyAndItem(String id, Employee me) {
        PredictAdditionApply predictAdditionApply = this.service.getPredictAdditionApplyById(id);
        if (Beans.isNotEmpty((Object)predictAdditionApply)) {
            List<PredictAdditionApplyItem> predictAdditionApplyItems = this.service.getPredictAdditionApplyItemsByApplyId(id);
            predictAdditionApply.setPredictAdditionApplyItems(predictAdditionApplyItems);
        }
        return predictAdditionApply;
    }
}

