/*
 * Decompiled with CFR 0.152.
 */
package com.tcbj.crm.predictAddition;

import com.tcbj.crm.common.OrderNoService;
import com.tcbj.crm.employee.PersonnelService;
import com.tcbj.crm.entity.PredictAdditionApply;
import com.tcbj.crm.entity.PredictAdditionApplyItem;
import com.tcbj.crm.entity.PredictConfig;
import com.tcbj.crm.entity.PredictConfigCustomerRegion;
import com.tcbj.crm.entity.PredictConfigProduct;
import com.tcbj.crm.entity.ProductionPlan;
import com.tcbj.crm.predictAddition.PredictAdditionApplyCondition;
import com.tcbj.crm.predictAddition.PredictAdditionApplyItemCondition;
import com.tcbj.crm.predictAddition.PredictConfigCustomerRegionCondition;
import com.tcbj.crm.predictApply.PredictApplyService;
import com.tcbj.crm.predictConfig.PredictConfigCondition;
import com.tcbj.crm.view.Employee;
import com.tcbj.framework.dao.BaseDao;
import com.tcbj.framework.util.Page;
import com.tcbj.util.Beans;
import com.tcbj.util.Constant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="predictAdditionService")
public class PredictAdditionService {
    @Autowired
    BaseDao baseDao;
    @Autowired
    PredictApplyService predictApplyService;
    @Autowired
    PersonnelService personnelService;
    @Autowired
    OrderNoService orderNoService;

    public Page findPredictAdditionApply(PredictAdditionApplyCondition con, Employee me, int pageno) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from PredictAdditionApply paa, PredictConfig pc where paa.configId = pc.id and  paa.orgId = ? ");
        args.add(me.getCurrentPartner().getOrganizationid());
        if (Beans.isNotEmpty((Object)con.getApplyNo())) {
            hql.append(" and paa.applyNo like ? ");
            args.add("%" + con.getApplyNo() + "%");
        }
        if (Beans.isNotEmpty((Object)con.getState())) {
            hql.append(" and paa.state = ? ");
            args.add(con.getState());
        }
        hql.append(" and exists(select 1 from PredictConfigCustomerRegion pccr where pccr.configId = pc.id ");
        String sb = this.personnelService.getFRegionsByUserId(me.getId());
        hql.append(" and pccr.businessId in(" + sb + "))");
        hql.append(" order by paa.createDt desc ");
        Page page = this.baseDao.search(hql.toString(), args.toArray(), Constant.DEFAULT_ROWS, pageno);
        ArrayList<PredictAdditionApply> predictAdditionApplies = new ArrayList<PredictAdditionApply>();
        for (Object object : page.getList()) {
            Object[] obj = (Object[])object;
            PredictAdditionApply apply = (PredictAdditionApply)obj[0];
            PredictConfig predictConfig = (PredictConfig)obj[1];
            apply.setPredictConfig(predictConfig);
            predictAdditionApplies.add(apply);
        }
        page.setList(predictAdditionApplies);
        return page;
    }

    public List<PredictConfig> getAdditionPredictConfig(PredictConfigCondition con, Employee me) {
        con.setStartDate(new Date());
        con.setEndDate(new Date());
        con.setPredictType("B");
        con.setState("2");
        List list = this.predictApplyService.findPredictConfig(con, me, List.class);
        ArrayList<PredictConfig> newlist = new ArrayList<PredictConfig>();
        for (PredictConfig pc : list) {
            String s = " from ProductionPlan p where instr(p.configId, ?) > 0 and p.orgId = ? ";
            ArrayList<String> args = new ArrayList<String>();
            args.add(pc.getId());
            args.add(me.getCurrentPartner().getOrganizationid());
            List plans = this.baseDao.findEntity(s, args.toArray(), ProductionPlan.class);
            if (!Beans.isEmpty((Object)plans) && plans.size() != 0) continue;
            newlist.add(pc);
        }
        return newlist;
    }

    public PredictAdditionApply getPredictAdditionApplyById(String id) {
        PredictAdditionApply predictAdditionApply = (PredictAdditionApply)this.baseDao.get(PredictAdditionApply.class, (Serializable)((Object)id));
        return predictAdditionApply;
    }

    public PredictAdditionApply getPredictAdditionApplyByConfigId(String configId) {
        return (PredictAdditionApply)this.baseDao.findFirstEntity(" from PredictAdditionApply where configId = ? ", new Object[]{configId}, PredictAdditionApply.class);
    }

    public List<PredictAdditionApplyItem> queryPredictAdditionApplyItems(PredictAdditionApplyItemCondition con) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append("from PredictAdditionApplyItem paai where 1=1 ");
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getConfigId())) {
            hql.append(" and paai.configId = ? ");
            args.add(con.getConfigId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getApplyId())) {
            hql.append(" and paai.applyId = ? ");
            args.add(con.getApplyId());
        }
        if (com.tcbj.util.StringUtils.isNotEmpty(con.getRegionId())) {
            hql.append(" and paai.regionId = ? ");
            args.add(con.getRegionId());
        }
        if (Beans.isNotEmpty((Object)con.getEmployee())) {
            hql.append(" and paai.regionId in ( ");
            String sb = this.personnelService.getFRegionsByUserId(con.getEmployee().getId());
            hql.append(sb);
            hql.append(" ) ");
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PredictAdditionApplyItem.class);
    }

    public List<PredictAdditionApplyItem> approvePredictAdditionApplyItems(String applyId, String configId, Employee me) {
        List<PredictAdditionApplyItem> predictAdditionApplyItems = this.predictConfigToPredictAdditionApplyItem(configId, me);
        List<PredictAdditionApplyItem> items = this.getPredictAdditionApplyItemsByApplyId(applyId);
        this.applyItemSubAdditionQuantity(predictAdditionApplyItems, items);
        return predictAdditionApplyItems;
    }

    public List<PredictAdditionApplyItem> getPredictAdditionApplyItemsByApplyId(String applyId) {
        PredictAdditionApplyItemCondition condition = new PredictAdditionApplyItemCondition();
        condition.setApplyId(applyId);
        return this.queryPredictAdditionApplyItems(condition);
    }

    public List<PredictAdditionApplyItem> getPredictAdditionApplyItemsByApplyerIdAndConfigId(Employee me, String applyId, String configId) {
        PredictAdditionApplyItemCondition condition = new PredictAdditionApplyItemCondition();
        condition.setApplyId(applyId);
        condition.setConfigId(configId);
        condition.setEmployee(me);
        return this.queryPredictAdditionApplyItems(condition);
    }

    public List<PredictAdditionApplyItem> getPredictAdditionApplyItemsByApplyerIdAndConfigId(String applyId, String configId) {
        return this.getPredictAdditionApplyItemsByApplyerIdAndConfigId(null, applyId, configId);
    }

    public List<PredictAdditionApplyItem> getPredictAdditionApplyItemsByConfigId(String configId) {
        PredictAdditionApplyItemCondition condition = new PredictAdditionApplyItemCondition();
        condition.setConfigId(configId);
        return this.queryPredictAdditionApplyItems(condition);
    }

    public List<PredictConfigCustomerRegion> findPredictConfigCustomerRegion(PredictConfigCustomerRegionCondition con, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        hql.append(" from PredictConfigCustomerRegion where orgId = ? ");
        args.add(me.getCurrentPartner().getOrganizationid());
        if (StringUtils.isNotEmpty((String)con.getConfigId())) {
            hql.append(" and configId = ? ");
            args.add(con.getConfigId());
        }
        if ("B".equals(con.getPredictType())) {
            String sb = this.personnelService.getFRegionsByUserId(me.getId());
            hql.append(" and businessId in (");
            hql.append(sb);
            hql.append(" ) ");
        }
        return this.baseDao.findEntity(hql.toString(), args.toArray(), PredictConfigCustomerRegion.class);
    }

    public List<PredictConfigCustomerRegion> getAdditionPredictConfigCustomerRegionByConfigId(String configId, Employee me) {
        PredictConfigCustomerRegionCondition con = new PredictConfigCustomerRegionCondition();
        con.setConfigId(configId);
        con.setPredictType("B");
        return this.findPredictConfigCustomerRegion(con, me);
    }

    public List<PredictAdditionApplyItem> predictConfigToPredictAdditionApplyItem(String configId, Employee me) {
        StringBuffer hql = new StringBuffer();
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<PredictAdditionApplyItem> predictAdditionApplyItems = new ArrayList<PredictAdditionApplyItem>();
        hql.append(" from PredictConfigCustomerRegion pccr, PredictConfigProduct pcp where pccr.configId = ? and pcp.configId = ? and pccr.orgId = ? ");
        args.add(configId);
        args.add(configId);
        args.add(me.getCurrentPartner().getOrganizationid());
        String sb = this.personnelService.getFRegionsByUserId(me.getId());
        hql.append(" and pccr.businessId in (");
        hql.append(sb);
        hql.append(" ) ");
        List items = this.baseDao.findEntity(hql.toString(), args.toArray(), Object[].class);
        for (Object[] obj : items) {
            PredictConfigCustomerRegion pccr = (PredictConfigCustomerRegion)obj[0];
            PredictConfigProduct pcp = (PredictConfigProduct)obj[1];
            PredictAdditionApplyItem predictAdditionApplyItem = new PredictAdditionApplyItem();
            predictAdditionApplyItem.setProductId(pcp.getProductId());
            predictAdditionApplyItem.setRegionId(pccr.getBusinessId());
            predictAdditionApplyItem.setConfigId(configId);
            predictAdditionApplyItems.add(predictAdditionApplyItem);
        }
        return predictAdditionApplyItems;
    }

    public List<PredictAdditionApplyItem> getPredictAdditionItemByPredictConfig(String configId, Employee me) {
        List<PredictAdditionApplyItem> predictAdditionApplyItems = this.predictConfigToPredictAdditionApplyItem(configId, me);
        return predictAdditionApplyItems;
    }

    public void applyItemSubAdditionQuantity(List<PredictAdditionApplyItem> predictAdditionApplyItems, List<PredictAdditionApplyItem> items) {
        HashMap<String, PredictAdditionApplyItem> itemMap = new HashMap<String, PredictAdditionApplyItem>();
        for (PredictAdditionApplyItem item : predictAdditionApplyItems) {
            itemMap.put(String.valueOf(item.getRegionId()) + "|" + item.getProductId(), item);
        }
        for (PredictAdditionApplyItem applyItem : items) {
            PredictAdditionApplyItem predictApplyItemDto = (PredictAdditionApplyItem)itemMap.get(String.valueOf(applyItem.getRegionId()) + "|" + applyItem.getProductId());
            if (predictApplyItemDto == null) continue;
            Double additionQuantity = predictApplyItemDto.getAdditionQuantity();
            if (predictApplyItemDto.getAdditionQuantity() != null || applyItem.getAdditionQuantity() != null) {
                additionQuantity = predictApplyItemDto.getAdditionQuantity() == null ? 0.0 : predictApplyItemDto.getAdditionQuantity();
                additionQuantity = additionQuantity + applyItem.getAdditionQuantity();
            }
            predictApplyItemDto.setAdditionQuantity(additionQuantity);
        }
    }

    public void saveOrUpdatePredictAdditionApply(String predictConfigId, PredictAdditionApply predictAdditionApplys, Employee me) {
        List<PredictAdditionApplyItem> applyItems = this.getPredictAdditionApplyItemsByConfigId(predictConfigId);
        HashMap<String, PredictAdditionApplyItem> itemMap = new HashMap<String, PredictAdditionApplyItem>();
        for (PredictAdditionApplyItem item : applyItems) {
            itemMap.put(String.valueOf(item.getRegionId()) + "|" + item.getProductId(), item);
        }
        ArrayList<PredictAdditionApplyItem> dellPredictAdditionApplyItem = new ArrayList<PredictAdditionApplyItem>();
        for (PredictAdditionApplyItem item : predictAdditionApplys.getPredictAdditionApplyItems()) {
            PredictAdditionApplyItem applyItem = (PredictAdditionApplyItem)itemMap.get(String.valueOf(item.getRegionId()) + "|" + item.getProductId());
            if (applyItem == null) continue;
            dellPredictAdditionApplyItem.add(applyItem);
        }
        PredictAdditionApply apply = this.getPredictAdditionApplyByConfigId(predictConfigId);
        if (Beans.isEmpty((Object)apply)) {
            apply.fillInitData(me);
            apply.setApplyNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "PAA"));
            apply.setOrgId(me.getCurrentPartner().getOrganizationid());
            apply.setState(Constant.PredictAdditionApplyState.waitApprove.value);
            apply.setConfigId(predictConfigId);
            this.baseDao.save((Object)apply);
        } else {
            apply.updateLastData(me);
            apply.setState("1");
            apply.setRegion(predictAdditionApplys.getRegion());
            apply.setProductType(predictAdditionApplys.getProductType());
            apply.setDealTime(predictAdditionApplys.getDealTime());
            apply.setApplyReason(predictAdditionApplys.getApplyReason());
            if (Beans.isNotEmpty((Object)predictAdditionApplys.getFlowId())) {
                apply.setFlowId(predictAdditionApplys.getFlowId());
            }
            this.baseDao.update((Object)apply);
        }
        for (PredictAdditionApplyItem item : dellPredictAdditionApplyItem) {
            this.baseDao.executeHQL("delete PredictAdditionApplyItem where id = ? ", new Object[]{item.getId()});
        }
        for (PredictAdditionApplyItem item : predictAdditionApplys.getPredictAdditionApplyItems()) {
            item.fillInitData(me);
            item.setOrgId(me.getCurrentPartner().getOrganizationid());
            item.setApplyId(apply.getId());
            item.setConfigId(predictConfigId);
        }
        this.baseDao.save(predictAdditionApplys.getPredictAdditionApplyItems());
    }

    public void saveOrUpdatePredictAdditionApply_NEW(PredictAdditionApply predictAdditionApply, Employee me) {
        PredictAdditionApply apply = predictAdditionApply;
        if (Beans.isEmpty((Object)apply.getId())) {
            apply.fillInitData(me);
            apply.setApplyNo(this.orderNoService.maxNo(me.getCurrentPartner().getNo(), "PAA"));
            apply.setOrgId(me.getCurrentPartner().getOrganizationid());
            apply.setState(Constant.PredictAdditionApplyState.waitApprove.value);
            this.baseDao.save((Object)apply);
        } else {
            apply = this.getPredictAdditionApplyById(predictAdditionApply.getId());
            apply.updateLastData(me);
            apply.setState("1");
            apply.setRegion(predictAdditionApply.getRegion());
            apply.setProductType(predictAdditionApply.getProductType());
            apply.setDealTime(predictAdditionApply.getDealTime());
            apply.setApplyReason(predictAdditionApply.getApplyReason());
            if (Beans.isNotEmpty((Object)predictAdditionApply.getFlowId())) {
                apply.setFlowId(predictAdditionApply.getFlowId());
            }
            this.baseDao.update((Object)apply);
        }
        this.baseDao.executeHQL("delete PredictAdditionApplyItem where applyId = ? ", new Object[]{apply.getId()});
        for (PredictAdditionApplyItem item : predictAdditionApply.getPredictAdditionApplyItems()) {
            item.fillInitData(me);
            item.setOrgId(me.getCurrentPartner().getOrganizationid());
            item.setApplyId(apply.getId());
            item.setConfigId(apply.getConfigId());
        }
        this.baseDao.save(predictAdditionApply.getPredictAdditionApplyItems());
    }

    public void approvePredictAdditionApply(PredictAdditionApplyCondition predictAdditionApply, Employee me) {
        this.saveOrUpdatePredictAdditionApply_NEW(predictAdditionApply, me);
        PredictAdditionApply predictApply = this.getPredictAdditionApplyById(predictAdditionApply.getId());
        predictApply.setState(predictAdditionApply.getAuditOpinion());
        this.baseDao.update((Object)predictApply);
    }

    public void updatePredictAdditionApply(String id, Employee em) {
        PredictAdditionApply pa = this.getPredictAdditionApplyById(id);
        pa.setState(Constant.PredictAdditionApplyState.cancel.value);
        this.baseDao.update((Object)pa);
    }
}

